<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking - FaLang content elements 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class translationBookitsubjectFilter extends translationFilter
{
    var $filterName = 'bookitsubject';

    function __construct($contentElement)
    {
        $importer = JPATH_ADMINISTRATOR . '/components/com_booking/helpers/importer.php';
        if (file_exists($importer)) {
            include_once ($importer);
            AImporter::defines();
            AImporter::helper('booking', 'tree', 'html');
            AImporter::table('subject');
        } else {
            $mainframe = JFactory::getApplication();
            /* @var $mainframe JAdministrator */
            $mainframe->enqueueMessage('Booking component propably not installed', 'notice');
        }
        $this->filterNullValue = 0;
        $this->filterType = $this->filterName;
        $this->filterField = $contentElement->getFilter($this->filterName);
        parent::__construct($contentElement);
    }

    function _createfilterHTML()
    {
        if (class_exists('BookingHelper') && $this->filterField) {
            JFactory::getLanguage()->load('com_booking');
            $filter['position'] = 'top';
            $filter['title'] = JText::_('OBJECTS_FILTER');
            $filter['html'] = BookingHelper::getSubjectSelectBox($this->filter_value, $this->filterName . '_filter_value', true);
            $filter['html'] = str_replace(array('&lt;sup&gt;', '&lt;/sup&gt;'), '', $filter['html']);
            return $filter;
        }
        return '';
    }
}