<?php

/**
 * Adapter to handle a compatibility beetwean a different Joomla versions.
 * 
 * @package		ARTIO Booking
 * @subpackage  helpers 
 * @copyright	Copyright (C) 2016 ARTIO LTD Co. All rights reserved.
 * @author 		ARTIO LTD Co, http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class JHTMLTabsAdapter {

    /**
     * Begin a tabs group.
     * 
     * @param String $group tabs group unique ID
     * @param String $active default active tab
     * @return String HTML
     */
    public static function groupBegin($group, $active) {
        if (version_compare(JVERSION, '3.0.0', '>=')) {
            return JHtml::_('bootstrap.startTabSet', $group, array('active' => $active));
        }
        return JHtml::_('tabs.start', $group);
    }

    /**
     * Begin a tab.
     * 
     * @param String $group tabs group unique ID
     * @param String $id tab unique ID
     * @param String $title tab title
     * @return String HTML
     */
    public static function tabBegin($group, $id, $title) {
        if (version_compare(JVERSION, '3.0.0', '>=')) {
            return JHtml::_('bootstrap.addTab', $group, $id, $title);
        }
        return JHtml::_('tabs.panel', $title, $id);
    }

    /**
     * End current tab.
     * 
     * @return String HTML
     */
    public static function tabEnd() {
        if (version_compare(JVERSION, '3.0.0', '>=')) {
            return JHtml::_('bootstrap.endTab');
        }
        return '';
    }

    /**
     * End current tabs group.
     * 
     * @return String HTML
     */
    public static function groupEnd() {
        if (version_compare(JVERSION, '3.0.0', '>=')) {
            echo JHtml::_('bootstrap.endTabSet');
        }
        return JHtml::_('tabs.end');
    }

}
