<?php

/**
 * Defined component routes
 *
 * @version		$Id$
 * @package		ARTIO JoomLIB
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class ARoute
{

    /**
     * URL root prefix
     *
     * @return string URL fragment
     */
    public static function root()
    {
        $Itemid = '';
        if (IS_SITE) {
        	$Itemid = JRequest::getInt('Itemid');
        	if (!$Itemid){
            	$mainframe = JFactory::getApplication();
            	/* @var $mainframe JApplication */
            	$menu = $mainframe->getMenu();
            	/* @var $menu JMenuSite */
            	$active = $menu->getActive();
            	if (is_object($active)) {
                	$Itemid = '&Itemid=' . $active->id;
            	} else {
            		$Itemid = '';
            	}
        	} else {
        		$Itemid = '&Itemid=' . $Itemid;
        	}
        }
        return 'index.php?option=' . OPTION . $Itemid;
    }

    /**
     * Get route to browse list items.
     *
     * @param string $controller items controller name
     * @param boolean $element add params to open element window
     * @return string URL
     */
    public static function browse($controller, $element = false, $extra = '')
    {
        return ARoute::root() . ARoute::controller($controller) . ($element ? ARoute::element() : '') . $extra;
    }

    /**
     * URL to edit item
     *
     * @param string $controller item scontroller name
     * @param $id item ID
     * @return string URL
     */
    public static function edit($controller, $id = null, $customParams = array())
    {
        return ARoute::root() . ARoute::controller($controller) . ARoute::task('edit') . ARoute::id($id) . ARoute::customUrl($customParams, false);
    }

    /**
     * URL to view detail item
     *
     * @param string $controller item scontroller name
     * @param $id item ID
     * @return string URL
     */
    public static function detail($controller, $id = null, $customParams = array())
    {
        return ARoute::root() . ARoute::controller($controller) . ARoute::task('detail') . ARoute::id($id) . ARoute::customUrl($customParams, false);
    }

    /**
     * URL to view frontend page.
     *
     * @param string $view
     * @param mixed $id
     * @param string $alias entity title alias
     * @param array $customParams next custome URL parameters
     * @return string URL
     */
    public static function view($view, $id = null, $alias = null, $customParams = array())
    {
        return ARoute::root() . '&view=' . $view . ARoute::simpleId($id, $alias) . ARoute::customUrl($customParams, false);
    }

    /**
     * URL to view with concrete layotu.
     *
     * @param string $view
     * @param string $layout
     * @return string URL
     */
    public static function view2layout($view, $layout)
    {
    	return ARoute::root() . ($view ? '&view=' . $view : '') . '&layout=' . $layout;
    }

    /**
     * URL part with controller param
     *
     * @param string $name controller name
     * @return string URL fragment
     */
    public static function controller($name)
    {
        return '&controller=' . $name;
    }

    /**
     * URL part with task param
     *
     * @param string $task task name
     * @return string URL fragment
     */
    public static function task($task)
    {
        return '&task=' . $task;
    }

    /**
     * URL part with id param like array
     *
     * @param string $id id value
     * @return string URL fragment
     */
    public static function id($id)
    {
        return $id ? '&cid[]=' . $id : '';
    }

    /**
     * URL part with id param
     *
     * @param string $id id value
     * @param string $alias entity title alias
     * @return string URL fragment
     */
    public static function simpleId($id, $alias)
    {
        if ($id) {
            return '&id=' . $id . ($alias ? (':' . $alias) : '');
        }
        return '';
    }

    /**
     * Add params for open element window.
     */
    public static function element()
    {
        return '&task=element&tmpl=component';
    }

    /**
     * Get user edit route to standard Joomla! users component.
     *
     * @param int $id user ID
     * @return String URL
     */
    public static function editUser($id = null)
    {
        if (IS_ADMIN) {
            return 'index.php?option=com_users&task=user.edit&id=' . $id;
        }
        return JRoute::_('index.php?option=com_users&view=profile');
    }

    /**
     * Get login use route.
     *
     * @return String URL
     */
    public static function loginUser()
    {
        return JRoute::_('index.php?option=com_users&view=login&return='.base64_encode(JURI::current()));
    }

    /**
     * Get logout user route.
     *
     * @return String URL
     */
    public static function logoutUser()
    {
        return JRoute::_('index.php?option=com_users&task=user.logout&' . JSession::getFormToken() . '=1');
    }

    /**
     * Create custom URL from given params.
     *
     * @param array $params where key is param name and value param value
     * @param boolean add live site URL root
     * @return string URL
     */
    public static function customUrl($params, $root = true)
    {
        $url = $root ? ARoute::root() : '';
        foreach ($params as $param => $value) {
            if (is_array($value)) {
                $count = count($value);
                for ($i = 0; $i < $count; $i ++) {
                    $url .= '&' . $param . '[]=' . $value[$i];
                }
            } else {
                $url .= '&' . $param . '=' . $value;
            }

        }
        return $url;
    }

    public static function config()
    {
        return JURI::root() . 'administrator/index.php?option=com_config&controller=component&component=' . OPTION . '&path=';
    }

    /**
     * URL to view with layout specified.
     *
     * @param string $view
     * @param string $layout
     * @return string URL
     */
    public static function viewlayout($view, $layout)
    {
        return ARoute::root() . '&view=' . $view . '&layout=' . $layout;
    }

    /**
     * Convert special HTML chars.
     *
     * @param string $url
     * @return string
     */
    public static function convertUrl($url)
    {
        return str_replace('&amp;', '&', $url);
    }

    /**
     * Get URL to save payment result
     *
     * @param string $type payment method type alias
     */
    public static function payment($type, $id, $paid)
    {
        return ARoute::root() . ARoute::controller(CONTROLLER_RESERVATION) . ARoute::task('payment') . '&type=' . $type . '&paid=' . $paid . '&cid[]=' . $id . '&hash=' . md5(session_id());
    }

    /**
     * Safe URL by replacing some chars by htmlentities.
     *
     * @param string $url
     * @return string
     */
    public static function safeURL($url)
    {
    	return str_replace('&', '&amp;', $url);
    }

    public static function quickBookBackLink()
    {
		$active = JFactory::getApplication()->getMenu()->getItem(JRequest::getInt('Itemid'));
    	if (is_object($active)) {
    		$juri = JURI::getInstance($active->link);
    		if ($juri->getVar('option') == 'com_booking' && $juri->getVar('view') == 'quickbook')
    			return $active->link . '&Itemid=' . $active->id;
    	}
    	return null;
    }

    /**
     * Redirect after reservation making.
     *
     * @param int $id reservation ID
     * @param int $page custom type of redirect
     * @return string no XHTML URL
     */
    public static function redirectionAfterReservation($id, $page = null)
    {
    	switch(($page !== null ? $page : AFactory::getConfig()->redirectionAfterReservation)) {

            case REDIRECTION_AFTER_RESERVATION_THANKYOU_PAGE:
            default:
                $route = 'index.php?view=reservation&cid[]=' . $id;
                if (JFactory::getUser()->guest) {
                    // Guest reservation, load secret key
                    $modelReservation = new BookingModelReservation();
                    $reservation = $modelReservation->setId($id)->getObject();
                    $route .= '&secret=' . urlencode($reservation->secret);
                }
                $route .= '&random=' . time();
                $link = 'index.php?option=com_booking&view=reservations&layout=customer';
                break;

            case REDIRECTION_AFTER_RESERVATION_LATEST_SUBJECT:
                $route = JFactory::getApplication()->getUserState('com_booking.object.last');
                break;

            case REDIRECTION_AFTER_RESERVATION_SUBJECT_LIST:
                $link = 'index.php?option=com_booking&view=subjects';
                break;

            case REDIRECTION_AFTER_RESERVATION_RESERVATION_LIST:
                if (JFactory::getUser()->guest) {
                    $route = JFactory::getApplication()->getUserState('com_booking.object.last');
                } else {
                    $link = 'index.php?option=com_booking&view=reservations&layout=customer';
                }
                break;

            case REDIRECTION_AFTER_RESERVATION_HOMEPAGE:
                $home = JFactory::getApplication()->getMenu()->getDefault();
                $route = $home ? 'index.php?Itemid=' . $home->id : '/';
                break;

            case REDIRECTION_AFTER_RESERVATION_MENU_ITEM:
                $route =  'index.php?Itemid=' . AFactory::getConfig()->redirectionAfterReservationMenuItem;
                break;

            case REDIRECTION_AFTER_RESERVATION_CUSTOM_URL:
                $route = AFactory::getConfig()->redirectionAfterReservationCustomUrl;
                break;
        }

        if (!empty($link)) {
            $item = JFactory::getApplication()->getMenu()->getItems(array('link'), array($link), true);
            if ($item) {
                if (empty($route)) {
                    $route = 'index.php?Itemid=' . $item->id;
                } else {
                    $route .= '&Itemid=' . $item->id;
                }
            } elseif (empty($route)) {
                $route = $link;
            }
        }

        return JRoute::_($route, false);
    }

    /**
     * Redirect from reservation detail.
     *
     * @param int $page custom redirect type
     * @return string XHTML URL
     */
    public static function redirectionBackReservation($page = null)
    {
        switch(($page !== null ? $page : AFactory::getConfig()->redirectionBackReservation)) {

    		case REDIRECTION_BACK_RESERVATION_LATEST_SUBJECT:
    			$route = JFactory::getApplication()->getUserState('com_booking.object.last');
    			break;

    		case REDIRECTION_BACK_RESERVATION_SUBJECT_LIST:
    			$link = 'index.php?option=com_booking&view=subjects';
    			break;

    		case REDIRECTION_BACK_RESERVATION_RESERVATION_LIST:
            default:
                if (JFactory::getUser()->guest) {
                    $route = JFactory::getApplication()->getUserState('com_booking.object.last');
                } else {
                    $link = 'index.php?option=com_booking&view=reservations&layout=customer';
                }
                break;

    		case REDIRECTION_BACK_RESERVATION_HOMEPAGE:
    		    $home = JFactory::getApplication()->getMenu()->getDefault();
    			$route = $home ? 'index.php?Itemid=' . $home->id : JUri::root();
    			break;

            case REDIRECTION_BACK_RESERVATION_MENU_ITEM:
                $route =  'index.php?Itemid=' . AFactory::getConfig()->redirectionBackReservationMenuItem;
                break;

            case REDIRECTION_BACK_RESERVATION_CUSTOM_URL:
                $route = AFactory::getConfig()->redirectionBackReservationCustomUrl;
                break;
    	}

        if (!empty($link)) {
            $item = JFactory::getApplication()->getMenu()->getItems(array('link'), array($link), true);
            $route = $item ? 'index.php?Itemid=' . $item->id : $link;
        }

    	return JRoute::_($route);
    }

    public static function _($link) {
	if (($item = JFactory::getApplication()->getMenu()->getItems(array('link'), array($link), true))) {
		$link = 'index.php?Itemid=' . $item->id;
	} elseif (($active = JFactory::getApplication()->getMenu()->getActive())) {
		$link .= '&Itemid=' . $active->id;
	}
	return JRoute::_($link);
    }
}

?>
