<?php

/**
 * @package     ARTIO Booking
 * @subpackage  models
 * @copyright   Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author      ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class BookingModelDiscount extends JModelLegacy {

    public $count;
    public $per;
    public $type;
    public $unit;
    public $value;

    public function __construct($config = array()) {
        $this->setProperties($config);
        parent::__construct($config);

        $this->count = (int)$this->count;
        $this->per = (int)$this->per;
        $this->type = (int)$this->type;
        $this->unit = (int)$this->unit;
        $this->value = (float)$this->value;
    }

    public function isAvailable($units, $capacity) {
        return ($this->unit == DISCOUNT_TO_UNIT && $units >= $this->count) || ($this->unit == DISCOUNT_TO_QUANTITY && $capacity >= $this->count);
    }

    public function isValueType() {
        return $this->type == DISCOUNT_TYPE_VALUE;
    }

    public function isPercentType() {
        return $this->type == DISCOUNT_TYPE_PERCENT;
    }

    public function isPerUnit() {
        return $this->per == DISCOUNT_PER_UNIT;
    }

    public function isPerReservation() {
        return $this->per == DISCOUNT_PER_RESERVATION;
    }

    public function getDiscount($value) {
        if ($this->isValueType()) {
            return $this->value;
        } else {
            return $this->getPercentage($value);
        }
    }

    public function getPercentage($value) {
        return $value / 100 * $this->value;
    }
}