<?php

/**
 * @package        ARTIO Booking
 * @subpackage        views
 * @copyright        Copyright (C) 2014 ARTIO s.r.o.. All rights reserved.
 * @author            ARTIO s.r.o., http://www.artio.net
 * @license        GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link            http://www.artio.net Official website
 */
defined('_JEXEC') or die;

class BookingViewOverview extends JViewLegacy
{

    /**
     * Item parents which children have hourly reservation type.
     * @var array
     */
    public $hourlyParents;

    public $navigator;

    /**
     * Current parent.
     * @var stdClass
     */
    public $current;

    /**
     * Current parent children.
     * @var array
     */
    public $children;

    /**
     * Schedule of hourly overview
     * @var array
     */
    public $hourlySchedule = array();

    /**
     * Schedule of monthly overview
     * @var JDate[]
     */
    public $dailySchedule = array();
    public $firstDay = '';
    public $lastDay = '';

    /**
     * Reserved reservations for current day and current family.
     * @var array
     */
    public $hourlyReservations = array();
    public $dailyReservations = array();

    public $params;
    public $config;

    /**
     * Update view via Ajax.
     * @var boolean
     */
    public $ajax;

    /**
     * Main page header.
     * @var string
     */
    public $h1;

    /**
     * Main page CSS class.
     * @var string
     */
    public $css;

    /**
     * Show single week, otherwise show single day.
     * @var boolean
     */
    public $singleWeek;
    public $singleDay;
    public $singleMonth;
    public $currentWeek;
    /**
     * @var JDate
     */
    public $currentWeekDate;
    public $headerDateFormat;
    public $columnDateFormat;

    public $dayRoute;
    public $weekRoute;
    public $monthRoute;
    public $currentRoute;

    /**
     * Days of current week.
     * @var array
     */
    public $weekSchedule;

    public function display($tpl = null)
    {
        $app = JFactory::getApplication();

        $this->params = $this->get('Params');

        $this->singleWeek = $this->getLayout() == 'week';
        $this->singleDay = $this->getLayout() == 'day';
        $this->singleMonth = $this->getLayout() == 'month';
        $this->currentWeek = $this->getLayout() == 'current';

        $this->getModel()->setState('week', $this->singleWeek);
        $this->current = $this->get('HourlyCurrent');
        $this->hourlyParents = $this->get('HourlyParents');
        $this->navigator = $this->get('DayNavigator');
        $this->children = $this->get('Children');

        if ($this->singleMonth) {
            $this->dailySchedule = $this->get('DailySchedule');
            $this->firstDay = reset($this->dailySchedule)->format('Y-m-d');
            $this->lastDay = end($this->dailySchedule)->format('Y-m-d');
            $this->dailyReservations = $this->get('DailyReservations');
        } elseif ($this->currentWeek) {
            $this->dailySchedule = $this->get('CurrentSchedule');
            $this->firstDay = reset($this->dailySchedule)->format('Y-m-d');
            $this->lastDay = end($this->dailySchedule)->format('Y-m-d');
            $this->dailyReservations = $this->get('CurrentReservations');
            $this->currentWeekDate = $this->get('CurrentWeekDate');
            $this->headerDateFormat = $this->params->get('header_date_format', 'D d M Y');
            $this->columnDateFormat = $this->params->get('column_date_format', 'l j');
        } else {
            $this->hourlySchedule = $this->get('HourlySchedule');
            $this->hourlyReservations = $this->get('HourlyReservations');
        }

        $this->config = AFactory::getConfig();

        if ($this->params->get('show_page_heading', 1)) {
            $active = $app->getMenu()->getActive();
            $this->h1 = $this->params->get('page_heading', ($active ? $active->title : JText::_('RESERVATIONS_OVERVIEW')));
        }
        $this->css = $this->params->get('pageclass_sfx');

        if ($this->singleWeek) {
            $this->weekSchedule = $this->get('WeekSchedule');
        }

        AImporter::css('overview');
        AImporter::js('overview');
        ISJ3 ? JHtml::_('bootstrap.tooltip') : JHtml::_('behavior.tooltip', '.hasTooltip');

        $this->ajax = $app->input->get('ajax');

        $juri = JURI::getInstance();
        $juri->setVar('layout', 'day');
        $this->dayRoute = $this->getRoute('day');
        $juri->setVar('layout', 'week');
        $this->weekRoute = $this->getRoute('week');
        $juri->setVar('layout', 'month');
        $this->monthRoute = $this->getRoute('month');
        $juri->setVar('layout', 'current');
        $this->currentRoute = $this->getRoute('current');

        parent::display($tpl);

        if ($this->ajax) {
            die();
        }
    }

    /**
     * Get route to this view layout.
     *
     * @param string $layout
     * @return string
     * @throws Exception
     */
    public function getRoute($layout) {
        $route = 'index.php?option=com_booking&view=overview&layout=' . $layout;
        $item = JFactory::getApplication()->getMenu()->getItems(array('link'), array($route), true);
        if ($item) {
            $route = 'index.php?Itemid=' . $item->id;
        } else {
            $route .= '&Itemid=' . JRequest::getInt('Itemid');
        }
        $route .= '#bookingOverview';
        return JRoute::_($route);
    }

    public function getToolTip($reservation) {
        return JHtml::tooltipText(BookingHelper::formatName($reservation). ' ' . implode(' ', $reservation->supplements), ($this->config->showNoteInCalendar ? JString::trim($reservation->message . ' ' . $reservation->note) : ''));
    }

    public function getLabel($reservation) {
        return BookingHelper::formatName($reservation) . ' ' . implode(' ', $reservation->supplements);
    }
}
