<?php

/**
 * @package     ARTIO Booking
 * @subpackage  views
 * @copyright   Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author      ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die();

AImporter::css('general');

class BookingViewPeriod extends JViewLegacy
{
    /**
     * @var JDate[]
     */
    protected $period = array();

    /**
     * @var JDate[]
     */
    protected $conflict = array();
    /**
     * @var JDate
     */
    protected $begin;
    /**
     * @var JDate
     */
    protected $end;
    /**
     * @var int
     */
    protected $month;
    /**
     * @var int
     */
    protected $week;
    /**
     * @var BookingConfig
     */
    protected $config;

    public function __construct(array $config)
    {
        parent::__construct($config);
        $this->period = isset($config['period']) ? $config['period'] : array();
        $this->conflict = isset($config['conflict']) ? $config['conflict'] : array();
        $this->config = AFactory::getConfig();
    }

    public function display($tpl = null, $return = false)
    {
        if (empty($this->period)) {
            $this->getModel()->setState('id', JRequest::getInt('id'));
            $this->period = $this->getModel()->getPeriod();
        }

        $this->period = array_map('JFactory::getDate', $this->period);
        $this->conflict = array_map('JFactory::getDate', $this->conflict);

        $this->begin = clone reset($this->period);
        $this->begin->setDate($this->begin->format('Y'), $this->begin->format('m'), 1);

        $this->end = clone end($this->period);
        $this->end->setDate($this->end->format('Y'), $this->end->format('m'), $this->end->format('t'));

        $this->month = $this->begin->format('m');
        $this->week = $this->begin->format('W');

        return $return ? $this->loadTemplate($tpl) : parent::display($tpl);
    }

    protected function hasNextPeriodDay()
    {
        return $this->end->format('Y-m-d') > $this->begin->format('Y-m-d');
    }

    protected function nextPeriodDay()
    {
        $this->begin->modify('+ 1 day');
    }

    protected function hasNextPeriodMonth()
    {
        if ($this->begin->format('m') != $this->month) {
            $this->month = $this->begin->format('m');
            return true;
        }
        return false;
    }

    protected function hasNextPeriodWeek()
    {
        return ($this->begin->format('N') == 7 && $this->config->firstDaySunday) || ($this->begin->format('N') == 1 && !$this->config->firstDaySunday);
    }

    protected function showPeriodDay()
    {
        return $this->begin->format('j');
    }

    protected function showPeriodMonth()
    {
        return $this->begin->format('F Y');
    }

    protected function isPeriod()
    {
        return $this->is($this->period);
    }

    protected function isConflict()
    {
        return $this->is($this->conflict);
    }

    protected function is($items)
    {
        foreach ($items as $item) {
            if ($this->begin->format('Y-m-d') == $item->format('Y-m-d')) {
                return true;
            }
        }
        return false;
    }
}