<?php

/**
 * @version        $Id$
 * @package        ARTIO Booking
 * @subpackage    views
 * @copyright        Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author            ARTIO s.r.o., http://www.artio.net
 * @license        GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link            http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSubject */

?>
<?php if ($this->subject->standard_occupancy_max > 1 || $this->subject->extra_occupancy_max > 1) { ?>

    <?php $minQty = max(array_filter(array($this->subject->capacity_limit_min, $this->subject->minimum_capacity, 1))) ?>

    <?php foreach (range(1, $this->subject->total_capacity) as $i) { ?>
        <?php $latestOCCType = reset($this->occupancyTypes)->type ?>

        <div class="occupancy" id="capacity<?php echo $i ?>occupancy"<?php if ($i > $minQty) { ?> style="height: 0px; overflow: hidden;"<?php } ?>>
            <fieldset>
                <legend><?php echo $latestOCCType == 0 ? JText::sprintf('QUANTITY_STANDARD_OCCUPANCY', $i, $this->template->name) : JText::sprintf('QUANTITY_EXTRA_OCCUPANCY', $i) ?></legend>

                <?php foreach ($this->occupancyTypes as $occType) { ?>

                <?php if ($occType->type == 1 && $latestOCCType == 0) { ?>
            </fieldset>
            <fieldset>
                <legend><?php echo JText::sprintf('QUANTITY_EXTRA_OCCUPANCY', $i, $this->template->name) ?></legend>
                <?php } ?>

                <select name="occupancy[<?php echo $i - 1 ?>][<?php echo $occType->id ?>]" id="capacity<?php echo $i ?>occupancy<?php echo $occType->id ?>" onchange="Calendars.showTotal();" class="input-mini">

                    <?php if ($occType->emptyOption) { ?>
                        <option value="0" selected="selected">-</option>
                    <?php } ?>

                    <?php echo JHtml::_('select.options', array_combine(range($occType->min, $occType->max), range($occType->min, $occType->max))) ?>
                </select>

                <label for="capacity<?php echo $i ?>occupancy<?php echo $occType->id ?>"><?php echo $occType->title ?></label>

                <?php $latestOCCType = $occType->type ?>
                <?php } ?>
            </fieldset>
        </div>
    <?php } ?>
<?php } ?>