<?php 

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

// migrate configuration from booking storage into joomla storage
$db = JFactory::getDbo();
$query = $db->getQuery(true)->select('`key`, `value`')->from('#__booking_config'); // load old configuration
$config = array();

foreach ($db->setQuery($query)->loadObjectList() as $row) { // convert into format array(key => value)
	if ($row->key === 'taxrates') { // tax rate list
		$taxrates = @unserialize($row->value); // old format aka array(array(title,value),array(title,value)...)
		$row->value = array();
		if (is_array($taxrates))
			foreach ($taxrates as $taxrate)
				if (is_array($taxrate))
					$row->value = array_merge($row->value, $taxrate); // new format array(title,value,title,value...)
	}
	$config[$row->key] = $row->value;
}

$registry = new JRegistry();
$registry->loadArray($config);
$registry->set('asset_id', 'com_booking');

// save into standard storage in registry format
$query = $db->getQuery(true)->update('#__extensions')->set('params = ' . $db->quote($registry->__toString()))->where("element = 'com_booking'"); 
$this->_addSQL($query->__toString());

// install new payment methods Cash and Cheque
$installer = new JInstaller();

$installer->install(JPath::clean(dirname(dirname(__FILE__)) . '/admin/extensions/payment_methods/cash'));
$installer->install(JPath::clean(dirname(dirname(__FILE__)) . '/admin/extensions/payment_methods/cheque'));

$this->_addSQL("INSERT INTO `#__booking_payment` (`title`, `alias`, `checked_out`, `checked_out_time`) VALUES ('Cash',   'cash',   0, '0000-00-00 00:00:00')");
$this->_addSQL("INSERT INTO `#__booking_payment` (`title`, `alias`, `checked_out`, `checked_out_time`) VALUES ('Cheque', 'cheque', 0, '0000-00-00 00:00:00')");
$this->_addSQL("INSERT INTO `#__booking_payment` (`title`, `alias`, `checked_out`, `checked_out_time`) VALUES ('Payu',   'payu',   0, '0000-00-00 00:00:00')");

$this->_addSQL("CREATE TABLE IF NOT EXISTS `#__booking_notification` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`title` varchar(100) NOT NULL,
`event` varchar(30) NOT NULL,
`template` int(11) NOT NULL,
`prereserved` tinyint(1) NOT NULL,
`reserved` tinyint(1) NOT NULL,
`cancelled` tinyint(1) NOT NULL,
`unpaid` tinyint(1) NOT NULL,
`deposit` tinyint(1) NOT NULL,
`paid` tinyint(1) NOT NULL,
`days` int(11) NOT NULL,
`weeks` int(11) NOT NULL,
`hours` int(11) NOT NULL,
`minutes` int(11) NOT NULL,
`checked_out` int(11) NOT NULL,
`checked_out_time` int(11) NOT NULL,
PRIMARY KEY (`id`),
KEY `checked_out` (`checked_out`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8");

$this->_addSQL("CREATE TABLE IF NOT EXISTS `#__booking_notification_queue` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`reservation_item_id` int(11) NOT NULL,
`notification_id` int(11) NOT NULL,
`email_subject` varchar(100) NOT NULL,
`email_body` text NOT NULL,
`email_receiver` varchar(100) NOT NULL,
`email_mode` tinyint(1) NOT NULL,
`status` tinyint(1) NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8");

$this->_addSQL('ALTER TABLE `#__booking_reservation_items` ADD `google_calendar_id` VARCHAR(255) NOT NULL');
$this->_addSQL('ALTER TABLE `#__booking_subject` ADD `google_calendar` VARCHAR(255) NOT NULL');
$this->_addSQL('ALTER TABLE `#__booking_email` ADD `usage` TINYINT( 1 ) NOT NULL , ADD `sms` TEXT NOT NULL');
$this->_addSQL('ALTER TABLE `#__booking_notification_queue` ADD `usage` INT NOT NULL , ADD `sms_phone` VARCHAR( 20 ) NOT NULL , ADD `sms_text` TEXT NOT NULL');

// google calendar
$this->_addSQL("
	CREATE TABLE IF NOT EXISTS `#__booking_google_calendar` (
		`id` varchar(255) NOT NULL,
		`title` varchar(255) NOT NULL,
		`modified` datetime NOT NULL
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;
");

// occupancy 
$this->_addSQL("
	ALTER TABLE #__booking_price 
		ADD price_standard_occupancy_multiply	TINYINT(1) NOT NULL DEFAULT 1, 
		ADD price_extra_occupancy_multiply		TINYINT(1) NOT NULL DEFAULT 0,
		ADD deposit_standard_occupancy_multiply TINYINT(1) NOT NULL DEFAULT 1,
		ADD deposit_extra_occupancy_multiply    TINYINT(1) NOT NULL DEFAULT 0,
		ADD occupancy_price_modifier			TEXT NOT NULL,
		DROP adult_occupancy_price,
		DROP child_occupancy_price
");

$this->_addSQL("
	ALTER TABLE #__booking_reservation_items
		ADD occupancy							TEXT NOT NULL,
		DROP adult_occupancy,
  		DROP child_occupancy
");

$this->_addSQL("
	ALTER TABLE #__booking_subject
		ADD standard_occupancy_max				INT(11) NOT NULL DEFAULT 0,
		ADD standard_occupancy_min				INT(11) NOT NULL DEFAULT 0,
		ADD extra_occupancy_max 				INT(11) NOT NULL DEFAULT 0,
		ADD extra_occupancy_min    				INT(11) NOT NULL DEFAULT 0,
		DROP max_adult_occupancy,
		DROP max_child_occupancy
");

$this->_addSQL("
	CREATE TABLE IF NOT EXISTS #__booking_occupancy_type (
		id int(11) NOT NULL AUTO_INCREMENT,
		`subject` int(11) NOT NULL,
		title varchar(100) NOT NULL,
		`type` tinyint(1) NOT NULL,
		PRIMARY KEY (id),
		KEY subject_id (`subject`)
	) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
");		

$this->_addSQL("ALTER TABLE #__booking_payment ADD pay TINYINT(1) NOT NULL DEFAULT 1");

$this->_addSQL("DELETE FROM #__menu WHERE link = 'index.php?option=com_booking&view=config'");

// supplement surcharge
$this->_addSQL('ALTER TABLE #__booking_supplement ADD surcharge_value FLOAT NOT NULL DEFAULT 0');
$this->_addSQL('ALTER TABLE #__booking_supplement ADD surcharge_label VARCHAR(255) NOT NULL');

$this->_addSQL('ALTER TABLE #__booking_reservation_supplement ADD surcharge_value FLOAT NOT NULL DEFAULT 0');
$this->_addSQL('ALTER TABLE #__booking_reservation_supplement ADD surcharge_label VARCHAR(255) NOT NULL');
