<?php 

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

$db = JFactory::getDbo();

$rules = json_decode($db->setQuery('SELECT rules FROM #__assets WHERE name = ' . $db->quote('com_booking'))->loadResult());

$old = 'booking.configuration.manage';
$new = 'core.admin';

if (!empty($rules->$old)) {
    $rules->$new = $rules->$old;
    unset($rules->$old);
}

$this->_addSQL('UPDATE #__assets SET rules = ' . $db->quote(json_encode($rules)) . ' WHERE name = ' . $db->quote('com_booking'));

// book parent with one subitem
$this->_addSQL("ALTER TABLE #__booking_reservation_items 
                ADD sub_subject INT(11) NOT NULL DEFAULT '0',
                ADD sub_subject_title VARCHAR(255) NOT NULL");

// manage closing days
$this->_addSQL("ALTER TABLE #__booking_closingday
                ADD created DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  				ADD created_by INT(11) NOT NULL DEFAULT '0',
  				ADD modified DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
  				ADD modified_by INT(11) NOT NULL DEFAULT '0'");

