<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.filesystem.folder');

if(!defined('DS')){
	define('DS',DIRECTORY_SEPARATOR);
}

include_once(dirname(__FILE__) . DS . 'helper.php');

/* Update component admin */

$target = 'administrator' . DS . 'components' . DS . 'com_booking';
$source = 'admin';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update component manifest */

$source = '';
BookitReinstall::addFilesOp($this, $target, $source, false);

/* Update component site */

$target = 'components' . DS . 'com_booking';
$source = 'site';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update site language */

$target = 'language';
$source = 'language' . DS . 'site';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update admin language */

$target = 'administrator' . DS . 'language';
$source = 'language' . DS . 'admin';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update JoomFISH */

$target = 'administrator' . DS . 'components' . DS . 'com_joomfish' . DS . 'contentelements';
$source = 'admin' . DS . 'joomfish';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update FaLang */

$target = 'administrator' . DS . 'components' . DS . 'com_falang' . DS . 'contentelements';
$source = 'admin' . DS . 'falang';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update module */

$target = 'modules' . DS . 'mod_booking_customer_info';
$source = 'admin' . DS . 'extensions' . DS . 'mod_booking_customer_info';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update module language */

$target = 'language';
$source = 'admin' . DS . 'extensions' . DS . 'mod_booking_customer_info' . DS . 'language';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update search module */

$target = 'modules' . DS . 'mod_booking_search';
$source = 'admin' . DS . 'extensions' . DS . 'mod_booking_search';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update search module language */

$target = 'language';
$source = 'admin' . DS . 'extensions' . DS . 'mod_booking_search' . DS . 'language';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update items module */

$target = 'modules' . DS . 'mod_booking_items';
$source = 'admin' . DS . 'extensions' . DS . 'mod_booking_items';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update items module language */

$target = 'language';
$source = 'admin' . DS . 'extensions' . DS . 'mod_booking_items' . DS . 'language';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update check availability module */

$target = 'modules' . DS . 'mod_booking_check_availability';
$source = 'admin' . DS . 'extensions' . DS . 'mod_booking_check_availability';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update check availability module language */

$target = 'language';
$source = 'admin' . DS . 'extensions' . DS . 'mod_booking_check_availability' . DS . 'language';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update search plugin */

$target = 'plugins' . DS . 'search' . DS . 'booking';
$source = 'admin' . DS . 'extensions' . DS . 'plg_search_booking';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update search plugin language */

$target = 'language';
$source = 'admin' . DS . 'extensions' . DS . 'plg_search_booking' . DS . 'language';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update ccideal plugin */

$target = 'plugins' . DS . 'cciDEALPlatformCustomPayment' . DS . 'bookingccideal';
$source = 'admin' . DS . 'extensions' . DS . 'plg_ccidealplatformcustompayment_bookingccideal';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update user plugin */

$target = 'plugins' . DS . 'user' . DS . 'booking';
$source = 'admin' . DS . 'extensions' . DS . 'plg_user_booking';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update user plugin language */

$target = 'language';
$source = 'admin' . DS . 'extensions' . DS . 'plg_user_booking' . DS . 'language';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update expiration plugin */

$target = 'plugins' . DS . 'booking' . DS . 'expiration';
$source = 'admin' . DS . 'extensions' . DS . 'plg_booking_expiration';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update booking payment install plugins */

$target = 'plugins' . DS . 'extension' . DS . 'bookingpayment';
$source = 'admin' . DS . 'extensions' . DS . 'plg_extension_bookingpayment';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update payment plugins */

$target = 'plugins' . DS . 'bookingpayment';
$source = 'admin' . DS . 'extensions' . DS . 'payment_methods';
BookitReinstall::addFilesOp($this, $target, $source);

/* Update payment plugins language */

$base = '/admin/extensions/payment_methods';
if (JFolder::exists(dirname(__FILE__) . '/..' . $base)) {
    $payments = JFolder::files(dirname(__FILE__) . '/..' . $base, '\.ini$', true, true);
    foreach ($payments as $payment) {
        $name = basename($payment);
        $type = basename(dirname($payment));
        $lang = substr($name, 0, 5);
        $target = '/administrator/language/' . $lang . '/' . $name;
        $source = $base . '/' . $type . '/' . $name;
        $this->_addFileOp($target, 'upgrade', $source);
    }
}