<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage 	models
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.model');

class BookingModelArticles extends JModel
{

	public function populateState()
	{
		$app = JFactory::getApplication();
		$this->setState('filter.search', $app->getUserStateFromRequest('com_booking.articles.filter.search', 'filter_search'));
		$this->setState('list.limitstart', $app->getUserStateFromRequest('com_booking.articles.filter.limitstart', 'limitstart', 0, 'int'));
		$this->setState('list.limit', $app->getUserStateFromRequest('com_booking.articles.filter.limit', 'limit', 5, 'int'));
		$this->setState('list.ordering', $app->getUserStateFromRequest('com_booking.articles.filter.order', 'filter_order', 'id'));
		$this->setState('list.direction', $app->getUserStateFromRequest('com_booking.articles.filter.order.dir', 'filter_order_Dir', 'asc'));
	}

	public function getItems()
	{
		$this->populateState();
		
		$query = 'SELECT e.id, e.title, e.checked_out, e.checked_out_time, u.name AS editor 
					FROM #__booking_article AS e
					LEFT JOIN #__users AS u ON u.id = e.checked_out ';

		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = $this->_db->quote('%' . JString::strtolower($search) . '%');
			$query .= " WHERE (LOWER(e.title) LIKE $search OR LOWER(e.text) LIKE $search) ";				
		}

		$query .= ' ORDER BY ' . $this->getState('list.ordering') . ' ' . $this->getState('list.direction');
		
		$this->_db->setQuery($query);
		return $this->_db->loadObjectList();
	}
	
	public function getTotal()
	{
		$query = 'SELECT COUNT(*)
					FROM #__booking_article AS e ';
	
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = $this->_db->quote('%' . JString::strtolower($search) . '%');
			$query .= " (LOWER(e.title) LIKE $search OR LOWER(e.text) LIKE $search) ";
		}
	
		$this->_db->setQuery($query);
		return $this->_db->loadResult();
	}
	
	public function getPagination()
	{
		jimport('joomla.html.pagination');
		$pagination = new JPagination($this->getTotal(), $this->getState('list.limitstart'), $this->getState('list.limit'));
		return $pagination;
	}
}