<?php

/**
 * Config model. Support for database operations.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  models
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

//import needed Joomla! libraries
jimport('joomla.application.component.model');
//import needed JoomLIB helpers
AImporter::helper('model');
AImporter::helper('artio-update');

class BookingModelConfig extends AModel
{

	/**
	 * Store component configuration into database.
	 * In Joomla 1.5.x is used table jos_components in Joomla 1.6.x table jos_extensions.
	 * In both is used column params.
	 * 
	 * @return boolean true/false if query success/unsuccess
	 */
    function store($data)
    {
    	$data['params']['taxrates'] = array();
    	
    	if (!empty($data['taxratetitle']))
    		foreach ($data['taxratetitle'] as $i => $title)
    			$data['params']['taxrates'][$i] = array($title, $data['taxratevalue'][$i]);
    	
    	$data['params']['taxrates'] = serialize($data['params']['taxrates']);
    	
        $ret = true;
        foreach($data['params'] as $key=>$value)
        {
        	$this->_db->setQuery('INSERT INTO `#__booking_config` (`key`, `value`) VALUES (' . $this->_db->Quote($key) . ', ' . $this->_db->Quote($value) . ') ON DUPLICATE KEY UPDATE `value` = ' . $this->_db->Quote($value));
        	$ret = $this->_db->query();
        }
        
        return $ret;
    }

    /**
     * Set all Joomla Super administrators as Booking administrators.
     * 
     * @return void
     */
    function setAdmins()
    {
        $this->_db->setQuery('SELECT `id` FROM `#__users` WHERE `usertype` = \'' . JUSER_SUPER_ADMINISTRATOR . '\'');
        $model = new BookingModelAdmin();
        $model->setAsAdmin($this->_db->loadResultArray());
    }
}

?>