<?php

/**
 * Component administration control panel template 
 * with buttons to open main parts of component.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHTML::_('behavior.tooltip');	

/* @var $this BookingViewBooking */

JToolBarHelper::title(JText::_(COMPONENT_NAME).": ".JText::_('Control Panel'), 'bookit');
BookingHelper::setSubmenu(0);

$data = JApplicationHelper::parseXMLInstallFile(MANIFEST);

jimport('joomla.html.pane');
$tabs = JPane::getInstance('Tabs');
/* @var $tabs JPaneTabs */
?>
<div>
	<div class="col" style="width: 65%">
   		<div id="cpanel" class="icons">
   		<?php 
		    echo $tabs->startPane('booking');
 			echo $tabs->startPanel(JText::_('Reservation Management'), 'reservation-management');
  			echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_RESERVATIONS)), 'reservation', JText::_('Reservations'), true);
   			echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_CUSTOMERS)), 'customer', JText::_('Customers'), true); 
   		?>
  			<div class="clr"></div>
   		<?php 
	   		echo $tabs->startPanel(JText::_('Bookable Items'), 'bookable-items');
	   		echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_SUBJECTS)), 'object', JText::_('Bookable Items'), true);
	   		echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_TEMPLATES)), 'template', JText::_('Item Templates'), true);
	  		echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_ADMINS)), 'cbadmins', JText::_('Managers'), true);
	   		echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_CLOSINGDAYS)), 'closingday', JText::_('Closing Days'), true);
	   	?>
	   		<div class="clr"></div>
   		<?php
	   		echo $tabs->startPanel(JText::_('Configuration'), 'configuration');
	   		echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_CONFIG)), 'configuration', JText::_('Configuration'), true);
	   			   		echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_EMAILS)), 'email', JText::_('Email Templates'), true);
	   		echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_ARTICLES)), 'article', JText::_('Terms Articles'), true);
	   		echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_LOCATIONS)), 'location', JText::_('Locations'), true);
	   		echo AHtml::getCPanelButton(JRoute::_(ARoute::view(VIEW_UPGRADE)), 'upgrade', JText::_('Check Updates'), true);
	   	?>
   			<div class="clr"></div>
   		<?php echo $tabs->startPanel(JText::_('Help and Support'), 'help-support'); ?>
   			<!-- Documentation -->
   			<?php echo AHtml::getCPanelButton($this->info['documentation'], 'documentation', JText::_('Documentation'), true, array('target' => '_blank'), JText::_('Documentation desc')); ?>
	        
	        <!-- Changelog -->
	        <?php echo AHtml::getCPanelButton(JRoute::_(ARoute::view2layout(null, 'changelog')), 'changelog', JText::_('Changelog'), true, array(), JText::_('Changelog desc')); ?>
	        
	        <!-- FAQs -->
	        <?php echo AHtml::getCPanelButton($this->info['faq'], 'faq', JText::_('Faq'), true, array('target' => '_blank'), JText::_('Faq desc')); ?>
	        
	        <!-- Tutorial Videos -->
	        <?php echo AHtml::getCPanelButton($this->info['video'], 'video', JText::_('Tutorial Videos'), true, array('target' => '_blank'), JText::_('Tutorial Videos desc')); ?>
	        
	        <!-- Support Forums -->
	        <?php echo AHtml::getCPanelButton($this->info['forum'], 'forum', JText::_('Support Forums'), true, array('target' => '_blank'), JText::_('Support Forums desc')); ?>
	        
	        <!-- Paid Support -->
	        <?php echo AHtml::getCPanelButton($this->info['paidsupport'], 'support', JText::_('Paid Support'), true, array('target' => '_blank'), JText::_('Paid Support desc')); ?>
	        
	        <div class="clr"></div>
			<?php echo $tabs->endPanel(); ?>
			
			<?php echo $tabs->endPane(); ?>
   		</div>
		<form action="index.php" method="post" name="adminForm" id="adminForm">
        <fieldset class="form-horizontal">
		    <legend class="titlePage"><?php echo JText::_('Actual Reservations'); ?></legend>
			<div id="editcell">
				
				<table class="adminlist table table-striped" cellspacing="1">
					<thead>
						<tr>
							<th width="1%" nowrap="nowrap">
								<?php echo JHTML::_('grid.sort', 'Res. #', 'id', $this->lists['order_Dir'], $this->lists['order']); ?>
							</th>
							<th>
								<?php echo JHTML::_('grid.sort', 'Customer', 'surname', $this->lists['order_Dir'], $this->lists['order']); ?>
							</th>
							<th>
								<?php echo JHTML::_('grid.sort', 'Item', 'items-subject_title', $this->lists['order_Dir'], $this->lists['order']); ?>
							</th>
							<th width="1%" colspan="2">
								<?php echo JHTML::_('grid.sort', 'From', 'from', $this->lists['order_Dir'], $this->lists['order']); ?>
							</th>
							<th width="1%" colspan="2">
								<?php echo JHTML::_('grid.sort', 'To', 'from', $this->lists['order_Dir'], $this->lists['order']); ?>
							</th>
							<th width="1%" nowrap="nowrap">
				        		<?php echo JHTML::_('grid.sort', 'Price', 'reservationFullPrice', $this->lists['order_Dir'], $this->lists['order']); ?>
							</th>
							<th width="1%">
					        	<?php echo JHTML::_('grid.sort', 'Payment Status', 'paid', $this->lists['order_Dir'], $this->lists['order']); ?>
							</th>
							<th width="1%">
					        	<?php echo JHTML::_('grid.sort', 'Reservation Status', 'state', $this->lists['order_Dir'], $this->lists['order']); ?>
							</th>
						</tr>
					</thead>
					<tfoot>
	    				<tr>
	    					<td colspan="10">
	    				    	<?php echo $this->pagination->getListFooter(); ?>
	    					</td>
	    				</tr>
					</tfoot>
					<tbody>
						<?php if (count($this->items) == 0) { ?>
							<tr>
							    <td></td>
								<td colspan="10" class="emptyListInfo"><?php echo JText::_('No pending reservations'); ?></td>
							</tr>
						<?php } ?>
						<?php 
							foreach ($this->items as $i => $reservation) {							
								foreach ($this->reservedItems[$reservation->id] as $j => $reservedItem) {
								
							?>
							<tr class="row<?php echo $i % 2; ?>">
								<?php if ($j == 0){ ?>
					    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>">
					    			<a href="<?php echo JRoute::_(ARoute::detail(CONTROLLER_RESERVATION, $reservation->id)); ?>" title="<?php echo $this->escape(JText::_('Show Reservation')); ?>::<?php echo $this->escape($reservation->id); ?>" class="hasTip">
					    				<?php echo $reservation->id; ?>
					    			</a>
					    		</td>
								<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>">
									<?php if ($reservation->customer) { ?>
					    				<a href="<?php echo JRoute::_(ARoute::detail(CONTROLLER_CUSTOMER, $reservation->customer)); ?>" title="<?php echo $this->escape(JText::_('Show Customer')); ?>::<?php echo $this->escape(BookingHelper::formatName($reservation)); ?>" class="hasTip">
					    					<?php echo BookingHelper::formatName($reservation); ?>
					    				</a>
					    			<?php } else { ?>
					    				<span title="<?php echo $this->escape(JText::_('Unregistered Customer')); ?>">
					    					<?php echo BookingHelper::formatName($reservation); ?>
					    				</span>
					    			<?php } ?>
					    		</td>
					    		<?php } ?>
					    		<td>
					    			<a href="<?php echo JRoute::_(ARoute::edit(CONTROLLER_SUBJECT, $reservedItem->subject)); ?>" title="<?php echo $this->escape(JText::_('Show Item')); ?>::<?php echo $this->escape($reservedItem->subject_title); ?>" class="hasTip">
					    				<?php echo $reservedItem->subject_title; ?>
					    			</a>
					    		</td>
					    		<td nowrap="nowrap" align="center" width="1%"><?php echo AHtml::date($reservedItem->from, ADATE_FORMAT_NORMAL); ?></td>
				    			<td nowrap="nowrap" align="center" width="1%"><?php echo AHtml::date($reservedItem->from, ATIME_FORMAT_SHORT); ?></td>
				    			<td nowrap="nowrap" align="center" width="1%"><?php echo AHtml::date($reservedItem->to, ADATE_FORMAT_NORMAL); ?></td>
				    			<td nowrap="nowrap" align="center" width="1%"><?php echo AHtml::date($reservedItem->to, ATIME_FORMAT_SHORT); ?></td>
					    		<?php if ($j==0){ ?>
					    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" nowrap="nowrap" align="right"><?php echo BookingHelper::displayPrice($reservation->reservationFullPrice); ?></td>
					    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>">
					    			<?php echo AHtml::renderReservationPaymentStateIcon($reservation);?>
					    		</td>
					    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>">
					    			<?php echo AHtml::renderReservationStateIcon($reservation);?>
					    		</td>
					    		<?php } ?>
					    	</tr>
					    	<?php } ?>
						<?php } ?>
					</tbody>
				</table>
			</div>
			<input type="hidden" name="option" value="<?php echo OPTION; ?>"/>
			<input type="hidden" name="task" value=""/>
			<input type="hidden" name="reset" value="0"/>
			<input type="hidden" name="boxchecked" value="0"/>
			<input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>"/>
			<input type="hidden" name="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>"/>
			<input type="hidden" name="help_controller" value="<?php echo CONTROLLER_RESERVATION; ?>"/>
			<?php echo JHTML::_('form.token'); ?>
		</fieldset>
		</form>
	</div>			
	<div class="col width-35" style="width: 35%">
		<fieldset class="adminform">
			<legend>ARTIO Booking</legend>
			<table class="adminlist table table-striped">
				
				<tr>
					<th></th>
					<td>
						<p class="buy"><?php echo JText::_('This is <strong>free version</strong> with objects count <strong>limited to 2</strong>'); ?></b></p>
		      		.	<a class="aIconBuy" target="_blank" href="http://www.artio.net/e-shop/bookit" title=""><?php echo JText::_('Buy full version'); ?></a>
					</td>
				</tr>
				
		   		<tr>
					<th></th>
					<td>
		      			<a href="http://www.artio.net" target="_blank">
		          			<img src="<?php echo IMAGES; ?>logo-150.png" align="middle" alt="<?php echo COMPONENT_NAME; ?>" style="border: none; margin: 8px;" />
		        		</a>
					</td>
				</tr>
		   		<tr>
		      		<th width="120"></th>
		      		<td><a href="http://www.artio.net/joomla-extensions/booking-and-reservation" target="_blank">ARTIO Booking</a></td>
		   		</tr>	
		   		<tr>
		      		<th><?php echo JText::_('Version'); ?>:</th>
		      		<td><?php echo $data['version']; ?></td>
		   		</tr>
		   		<tr>
		      		<th><?php echo JText::_('Date'); ?>:</th>
		      		<td><?php echo JHTML::date(isset($data['creationdate']) ? $data['creationdate'] : $data['creationDate'], ADATE_FORMAT_NORMAL); ?></td>
		   		</tr>
		   		<tr>
		      		<th valign="top"><?php echo JText::_('Copyright'); ?>:</th>
		      		<td><?php echo $data['copyright']; ?></td>
		   		</tr>
		   		<tr>
		      		<th><?php echo JText::_('Author'); ?>:</th>
		      		<td><a href="<?php echo $data['authorUrl']; ?>" target="_blank"><?php echo $data['author']; ?></a>,
		      		<a href="mailto:<?php echo $data['authorEmail']; ?>"><?php echo $data['authorEmail']; ?></a></td>
		   		</tr>
		   		<tr>
		      		<th valign="top"><?php echo JText::_('Description'); ?></th>
		      		<td><?php echo JText::_('BOOKING DESCRIPTION'); ?></td>
		   		</tr>
		   		<tr>
		      		<th><?php echo JText::_('License'); ?>:</th>
		      		<td><a href="http://www.gnu.org/copyleft/gpl.html" target="_blank" title="">GNU/GPL</a></td>
		   		</tr>
			</table>
		</fieldset>
	</div>
	<div class="clr"></div>
</div>