<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	views
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

JHTML::_('behavior.tooltip');

?>

<form action="<?php echo JRoute::_('index.php?option=com_booking&view=closingdays'); ?>" method="post" name="adminForm" id="adminForm">
	<fieldset id="filter-bar">
			<label for="filter_search"><?php echo JText::_('Filter'); ?></label> 
			<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" />
			<button type="submit">
				<?php echo JText::_('OK'); ?>
			</button>
			<button type="button" onclick="$('filter_search').value='';this.form.submit();">
				<?php echo JText::_('Reset'); ?>
			</button>
	</fieldset>
	<div class="clr"></div>
	<table class="adminlist">
		<thead>
			<tr>
				<th width="1%">
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($this->items); ?>)" />
				</th>
				<th>
					<?php echo JHtml::_('grid.sort', 'Title', 'c.title', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
				<th width="1%" nowrap="nowrap">
					<?php echo JHtml::_('grid.sort', 'Date Up', 'c.date_up', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
				<th width="1%" nowrap="nowrap">
					<?php echo JHtml::_('grid.sort', 'Date Down', 'c.date_down', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
				<th width="1%" nowrap="nowrap">
					<?php echo JHtml::_('grid.sort', 'Time Up', 'c.time_up', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
				<th width="1%" nowrap="nowrap">
					<?php echo JHtml::_('grid.sort', 'Time Down', 'c.time_down', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
				<th width="1%" class="nowrap">
					<?php echo JHtml::_('grid.sort', 'ID', 'c.id', $this->escape($this->state->get('list.direction')), $this->escape($this->state->get('list.ordering'))); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="7">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
			<?php foreach ($this->items as $i => $item) { ?>
				<tr class="row<?php echo $i % 2; ?>">
					<td class="center">
						<?php echo JHTML::_('grid.checkedout', $item, $i); ?>
					</td>
					<td>
						<a href="<?php echo JRoute::_('index.php?option=com_booking&controller=closingday&task=edit&id='.$item->id);?>">
							<?php echo $this->escape($item->title); ?></a>
					</td>
					<td><?php echo AHtml::date($item->date_up, ADATE_FORMAT_NORMAL); ?></td>
					<td><?php echo AHtml::date($item->date_down, ADATE_FORMAT_NORMAL); ?></td>
					<td><?php echo AHtml::date($item->time_up, ATIME_FORMAT, null, true, true); ?></td>
					<td><?php echo AHtml::date($item->time_down, ATIME_FORMAT, null, true, true); ?></td>
					<td class="center">
						<?php echo (int) $item->id; ?>
					</td>
				</tr>
			<?php } ?>
		</tbody>
	</table>
	<div>
		<input type="hidden" name="controller" value="closingday" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $this->escape($this->state->get('list.ordering')); ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $this->escape($this->state->get('list.direction')); ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>