<?php
defined('_JEXEC') or die('Restricted access');

/**
 * Subject-details edit form template
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

$mask = $this->escape(JText::_('New template name'));
ADocument::addScriptPropertyDeclaration('TemplateNameMask', $mask);

?>
<div class="width-100">
	<fieldset class="adminform">
    	<legend><?php echo JText::_('Item'); ?></legend>
    	<div class="col width-50">
    		<table class="admintable width-100">
    			<tr>
    				<td class="key"><label for="title"><?php echo JText::_('Title'); ?><span class="star"> *</span></label></td>
    				<td><input class="inputbox required" style="width: 100%" type="text" name="title" id="title" value="<?php echo $this->subject->title; ?>" size="60" /></td>
    			</tr>
    			<tr>
    				<td class="key">
    					<label for="alias" class="hasTip" title="<?php echo $this->escape(JText::_('Alias')) . '::' . $this->escape(JText::_('Alias info')); ?>"><?php echo JText::_('Alias'); ?></label>
    				</td>
    				<td><input class="inputbox" style="width: 100%" type="text" name="alias" id="alias" value="<?php echo $this->subject->alias; ?>" size="60" /></td>
    			</tr>
    			<tr>
    				<td class="key"><label><?php echo JText::_('Template'); ?><span class="star"> *</span></label></td>
    				<td>
        				<table class="admintable" id="templateName" style="width: 100%"<?php echo $this->subject->newTemplate ? ' style="display: none"' : ''; ?>>
        					<tr>
        						<td valign="top">
        				            <a href="<?php echo JRoute::_(ARoute::edit(CONTROLLER_TEMPLATE, $this->subject->template)); ?>" title=""><?php echo $this->template->name; ?></a>
        				    	</td>
        				    	<td align="right">
									<?php 
										JToolBar::getInstance('template')->appendButton('Link', 'move', 'Change', 'javascript:EditSubject.openChangeTemplate()');
										JToolBar::getInstance('template')->appendButton('Link', 'new', 'New', 'javascript:EditSubject.openSaveAsNewTemplate()');
										if ($this->subject->template) {
											JToolBar::getInstance('template')->appendButton('Link', 'edit', 'Rename', 'javascript:EditSubject.openRenameTemplate()');		
											JToolBar::getInstance('template')->appendButton('Link', 'delete', 'Delete', 'javascript:EditSubject.openDeleteTemplate()');
										}
										echo JToolBar::getInstance('template')->render();
									?>
        				    	</td>
    						</tr>
    					</table>
						<fieldset class="adminform" id="saveAsNewTemplate" style="display: <?php echo $this->subject->newTemplate ? 'inline' : 'none'; ?>">
							<legend><?php echo JText::_('Save as new template'); ?></legend>
    				    	<input class="text_area" type="text" name="new_template_name" id="new_template_name" size="50" maxlength="255" value="<?php echo $mask; ?>" onclick="EditSubject.setTemplateNameContent()"/>
    				    	<div class="clr"></div>
    				    	<p class="tmpInfo"><?php echo JText::_('Save as new template info'); ?></p>
    				    	<?php 
    				    		if ($this->subject->id || $this->templateHelper->haveTemplates()) {
									JToolBar::getInstance('saveasnewtemplate')->appendButton('ALink', 'cancel', 'Cancel', 'EditSubject.closeSaveAsNewTemplate()');
									echo JToolBar::getInstance('saveasnewtemplate')->render();
        				    	} 
        				    ?>
    				    </fieldset>
    				    <fieldset class="adminform" id="renameTemplate" style="display: none">
							<legend><?php echo JText::_('Rename template'); ?></legend>
    				    	<input class="text_area" type="text" name="template_rename" id="template_rename" size="50" maxlength="255" value="<?php echo $this->template->name; ?>"/>
    				    	<div class="clr"></div>
    				    	<p class="tmpInfo"><?php echo JText::_('Rename template info'); ?></p>
    				    	<?php 
								JToolBar::getInstance('renametemplate')->appendButton('ALink', 'cancel', 'Cancel', 'EditSubject.closeRenameTemplate()');
								echo JToolBar::getInstance('renametemplate')->render();
							?>
    				    </fieldset>
    				    <fieldset class="adminform" id="changeTemplate" style="display: none;">
    				    	<legend><?php echo JText::_('Change template'); ?></legend>
    				    	<?php echo $this->templateHelper->getSelectBox('template', 'select template', $this->template->id, false); ?>
        				   	<?php 
        				   		JToolBar::getInstance('changetemplate')->appendButton('ALink', 'move', 'Change', 'EditSubject.changeTemplate()');
        				   		JToolBar::getInstance('changetemplate')->appendButton('ALink', 'cancel', 'Cancel', 'EditSubject.closeChangeTemplate()');
        				   		echo JToolBar::getInstance('changetemplate')->render();
        				   	?>
        				   	<div class="clr"></div>
        				   	<p class="tmpInfo"><?php echo JText::_('Change template info'); ?></p>
    				    </fieldset>
    				    <fieldset class="adminform" id="deleteTemplate" style="display: none;">
    				    	<legend><?php echo JText::_('Delete template'); ?></legend>
        				    <?php 
        				   		JToolBar::getInstance('deletetemplate')->appendButton('ALink', 'delete', 'Delete', 'EditSubject.deleteTemplate()');
        				   		JToolBar::getInstance('deletetemplate')->appendButton('ALink', 'cancel', 'Cancel', 'EditSubject.closeDeleteTemplate()');
        				   		echo JToolBar::getInstance('deletetemplate')->render();
        				   	?>
        				    <div class="clr"></div>
        				    <p class="tmpInfo"><?php echo JText::_('Delete template info'); ?></p>
    				    </fieldset>
    				</td>
    			</tr>
    			<tr>
    				<td class="key">
    					<label for="parent" class="hasTip" title="<?php echo $this->escape(JText::_('Parent')) . '::' . $this->escape(JText::_('Parent info')); ?>"><?php echo JText::_('Parent'); ?><span class="star"> *</span></label>
    				</td>
    				<td><?php echo BookingHelper::getParentsSubjectSelectBox($this->subject->parent, $this->subject->id); ?></td>
    			</tr>
    			<tr>
    				<td class="key"><label>ID</label></td>
    				<td><?php echo $this->subject->id; ?></td>
    			</tr>
    			<tr>
    				<td colspan="2">
    					<label><?php echo JText::_('Description'); ?></label>
    				</td>
    			</tr>
    			<tr>
    				<td colspan="2">
    					<?php echo JFactory::getEditor()->display('text', $this->subject->text, '100%', 1, 1, 1); ?>
    				</td>
    			</tr>
    			<tr>
    				<td class="key">
    					<label class="hasTip" title="<?php echo $this->escape(JText::_('Files')) . '::' . $this->escape(JText::_('These files will be sent to customer along with reservatin e-mail. Remember to enable reservation e-mails to customer in configuration.')); ?>"><?php echo JText::_('Files'); ?></label>
    				</td>
    				<td>
    					<table>
    					<?php AImporter::tpl('files', $this->_layout, 'files'); ?>
    					</table>
    				</td>
    			</tr>
    		</table>	
    	</div>
    	<div class="col width-45" style="padding-left: 17px">
    		<table class="admintable width-100">
    			<tr>
    				<td class="key"><label><?php echo JText::_('Published'); ?></label></td>
    				<td>
    					<input type="radio" name="state" id="state0" value="<?php echo SUBJECT_STATE_UNPUBLISHED; ?>" class="inputRadio" <?php if (! ISJ16) { ?>  style="float: none" <?php } if ($this->subject->state == SUBJECT_STATE_UNPUBLISHED) { ?> checked="checked" <?php } ?> />
    					<label for="state0"><?php echo jtext::_('JNO'); ?></label>  
    					<input type="radio" name="state" id="state1" value="<?php echo SUBJECT_STATE_PUBLISHED; ?>" class="inputRadio" <?php if (! ISJ16) { ?>  style="float: none" <?php } if ($this->subject->state == SUBJECT_STATE_PUBLISHED) { ?> checked="checked" <?php } ?> />
    					<label for="state1"><?php echo JText::_('JYES'); ?></label>
    				</td>
    			</tr>
    			<tr>
    				<td class="key"><label for="publishUp"><?php echo JText::_('Publish up'); ?></label></td>
    				<td>
    					<?php 
    						if (! ($publishUp = JString::trim($this->subject->publish_up)) && ! $this->subject->id)
    							$publishUp = AHtml::date('now', ADATE_FORMAT_LONG);
    						echo AHtml::getCalendar($publishUp, 'publish_up', 'publishUp', ADATE_FORMAT_LONG, ADATE_FORMAT_LONG_CAL); 
    					?>
    				</td>
    			</tr>
    			<tr>
					<td class="key">
						<label for="publishDown" class="hasTip" title="<?php echo $this->escape(JText::_('Publish interval')) . '::' . $this->escape(JText::_('Publish interval info')); ?>"><?php echo JText::_('Publish down'); ?></label>
					</td>
    				<td><?php echo AHtml::getCalendar($this->subject->publish_down, 'publish_down', 'publishDown', ADATE_FORMAT_LONG, ADATE_FORMAT_LONG_CAL); ?></td>    				
    			</tr>
    			<tr>
    				<td class="key">
    					<label for="total_capacity" class="hasTip" title="<?php echo $this->escape(JText::_('Total capacity')) . '::' . $this->escape(JText::_('Total capacity info')); ?>"><?php echo JText::_('Total capacity'); ?><span class="star"> *</span></label>
    				</td>
    				<td>
    					<input class="number required" onkeyup="ACommon.toInt(this)" type="text" name="total_capacity" id="total_capacity" size="5" maxlength="10" value="<?php echo $this->subject->total_capacity; ?>" />
    					<input type="checkbox" class="inputCheckbox" name="display_capacity" id="display_capacity" value="1" <?php if ($this->subject->display_capacity) { ?>checked="checked"<?php } ?> />
    					<label class="hasTip" for="display_capacity" title="<?php echo $this->escape(($title = JText::_('Display capacity'))) . '::' . $this->escape(JText::_('Display capacity info')); ?>"><?php echo $title; ?></label>
    				</td>
    			</tr>
    			<tr>
    				<td class="key">
    				<label for="minimum_capacity" class="hasTip" title="<?php echo $this->escape(JText::_('Minimum capacity')).'::'.$this->escape(JText::_('Minimum capacity info')); ?>"><?php echo JText::_('Minimum capacity'); ?></label></td>
    				<td><input class="number" onkeyup="ACommon.toInt(this)" type="text" name="minimum_capacity" id="minimum_capacity" size="5" maxlength="10" value="<?php echo $this->subject->minimum_capacity; ?>" /></td>
    			</tr>
    			<tr>
    				<td class="key">
    					<label for="ordering" class="hasTip" title="<?php echo $this->escape(JText::_('Ordering')) . '::' . $this->escape(JText::_('Ordering info')); ?>"><?php echo JText::_('Ordering'); ?></label>
    				</td>
    				<td><?php echo BookingHelper::getSubjectOrderingSelectBox($this->subject); ?></td>    				
    			</tr>
    			<tr>
    				<td class="key">
    					<label for="access" class="hasTip" title="<?php echo $this->escape(JText::_('Access')) . '::' . $this->escape(JText::_('Access info')); ?>"><?php echo JText::_('Access'); ?></label>
    				</td>
    				<td>
    					<?php
							if (ISJ16)
    							echo JHTML::_('access.level', 'access', $this->subject->access, '', false);
    						else
    							echo JHTML::_('list.accesslevel', $this->subject); 
    					?>
    				</td>    				
    			</tr>
    			<tr>
    				<td class="key">
    					<label class="hasTip" title="<?php echo $this->escape(JText::_('Hits')) . '::' . $this->escape(JText::_('Hits info')); ?>"><?php echo JText::_('Hits'); ?></label>
    				</td>
    				<td>
    					<input class="text_area" type="text" name="hits_disabled" id="hits_disabled" size="5" disabled="disabled" value="<?php echo $this->subject->hits; ?>" />
    					<button id="hits_disabled_btn" onclick="return EditSubject.resetHits();"><?php echo JText::_('Reset'); ?></button>
    				</td>
    			</tr>    			
				<tr>
					<td class="key">
    					<label class="hasTip" title="<?php echo $this->escape(JText::_('Meta keywords')) . '::' . $this->escape(JText::_('Meta keywords info')); ?>"><?php echo JText::_('Meta keywords'); ?></label>
    				</td>
    				<td><textarea rows="2" cols="50" class="fullwidth" name="keywords" id="keywords"><?php echo $this->subject->keywords; ?></textarea></td>
				</tr>
				<tr>
					<td class="key">
    					<label class="hasTip" title="<?php echo $this->escape(JText::_('Meta description')) . '::' . $this->escape(JText::_('Meta description info')); ?>"><?php echo JText::_('Meta description'); ?></label>
    				</td>
    				<td><textarea rows="5" cols="50" class="fullwidth" name="description" id="description"><?php echo $this->subject->description; ?></textarea></td>
				</tr>
    		</table>
    	</div>
    	<div class="clr"></div>
    </fieldset>
    <fieldset class="adminform">
		<legend><?php echo JText::_('Gallery'); ?></legend>
    	<?php AImporter::tpl('images', $this->_layout, 'images'); ?>
    </fieldset>
</div>   