/**
 * @version $Id$
 * @package ARTIO Booking
 * @subpackage assets
 * @copyright Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author ARTIO s.r.o., http://www.artio.net
 * @license GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link http://www.artio.net Official website
 */

var Calendars = {
	multi : false, // multiple reservations
	item_id : 0,
	operation : 0, // next operation check in/out
	checkIn : '', // last set check in value
	checkOut : '', // last set check out value 
	firstDay : '', 
	lastDay : '',
	dayLength : 86400,
	dateBegin : 0,
	dateEnd : 0,
	view : '',
	select : false,
	boxes : new Array(),
	onlyOnePrice : false,
	min: 0, // Minimum reservation limit allowed in reservation type
	max: 0, // Maxinum reservation limit allowed in reservation type
	fix: 0, // Fixed limit length
	currentYear : '', currentMonth : '', nextYear : '',	nextMonth : '',	calendarType : '',
	init : function(multi) {
		this.multi = multi;
		var form = this.getForm();
		this.operation = parseInt(form.operation.value);
		switch (this.operation) {
		default:
		case CheckOpIn:
			this.setOperation(CheckOpIn);
			break;
		case CheckOpOut:
			this.setOperation(CheckOpOut);
			break;
		}
		
		var items = document.getElements('input[name^=boxIds]');
		
		for (var i = 0; i < items.length; i++) {
			var boxIds = items[i];
			if (boxIds.value != '') {
				var boxes = boxIds.value.split(','); //in form are ids with time offset, not idShorts for HTML
				this.checkIn = this.getBoxShortId(boxes[0]);
				this.checkOut = this.getBoxShortId(boxes[boxes.length - 1]);
				var checkInBox = this.getBox(this.checkIn);
				var checkOutBox = this.getBox(this.checkOut);
				if (checkInBox && checkOutBox) {
					// save limit length constrictions from first box as integer value
					this.min = parseInt(checkInBox.min);
					this.max = parseInt(checkInBox.max);
					this.fix = parseInt(checkInBox.fix);
					var interval1 = this.getBoxInterval(checkInBox);
					var interval2 = this.getBoxInterval(checkOutBox);
					this.checkBoxLimit(interval1, interval2);
					if (this.fix > 1) // nove check out box for fixed interval
						var checkOutBox = this.getBox(this.getMoveOnBox(checkInBox, this.fix - 1));
					this.setBookFrom(checkInBox.fromDate, checkInBox.fromDisplay);
					this.setBookTo(checkOutBox.toDate, checkOutBox.toDisplay);
				}
			}
		}
	},
	/**
	 * Event after calendar box clicking.
	 * Control interval validity and higlighted engaged boxes in calendar.
	 * @param id box ID
	 * @returns {Boolean}
	 */
	setCheckBox : function(id) {
		// box in calendar clicked by user
		var box = this.getBox(id);
		Calendars.item_id = box.item_id;
		$$('#objectid').set('value',box.object);
		switch (this.operation) {
		default:
		case CheckOpIn:
			var interval = this.getBoxInterval(box);
			if (box.rtype == '2' && box.fixFrom != 'any' && box.fixFrom != box.dayWeek) { // box isn't start day of fixed from interval
				switch(box.fixFrom) {
					case 'mon': return this.setCheckInfo(LGFixFromMon, 'error');
					case 'tue': return this.setCheckInfo(LGFixFromTue, 'error');
					case 'wed': return this.setCheckInfo(LGFixFromWed, 'error');
					case 'thu': return this.setCheckInfo(LGFixFromThu, 'error');
					case 'fri': return this.setCheckInfo(LGFixFromFri, 'error');
					case 'sat': return this.setCheckInfo(LGFixFromSat, 'error');
					case 'sun': return this.setCheckInfo(LGFixFromSun, 'error');
				}
			}
			if (!this.testBoxLimit(interval[0]+interval[1], interval[2], interval[3],
					box.boxes)) {
				this.setCheckInfo(LGNoContinuousInterval, 'error');
				return false;
			}
			this.checkIn = this.getBoxId(interval);
			this.checkOut = this.getBoxId(interval, true);
			var checkInBox = this.getBox(this.checkIn);
			var checkOutBox = this.getBox(this.checkOut);
			this.setBookFrom(checkInBox.fromDate, checkInBox.fromDisplay);
			if (checkOutBox != undefined)
				this.setBookTo(checkOutBox.toDate, checkOutBox.toDisplay);
			else if (this.calendarType == 'monthly') { // check out is over - shift to next month
				this.checkBoxLimit(interval, interval);				
				return this.monthNavigation(this.nextMonth, this.nextYear);
			}
			this.checkBoxLimit(interval, interval);
			// save limit length constrictions from first box as integer value
			this.min = parseInt(checkInBox.min);
			this.max = parseInt(checkInBox.max);
			this.fix = parseInt(checkInBox.fix);
			if (this.fix > 1){
				// fixed limit check in/out limit by one click 
				this.setOperation(CheckOpIn);
				// fixed limit is stronger then min/max limit, both are ignored
				this.min = this.max = this.fix;
			} else
				// without fixed limit customer has to select check out
				this.setOperation(CheckOpOut);
			break;
		case CheckOpOut:
			var interval1 = this.getBoxInterval(this.getBox(this.checkIn));
			var interval2 = this.getBoxInterval(box);
			if (this.checkIn == '')
				this.setCheckInfo(LGSelectCheckIn, 'error');
			else if (this.onlyOnePrice && (interval1[1] != interval2[1] || interval1[0] != interval2[0])) //not same price (if set), or not same rtype
				this.setCheckInfo(LGSelectRealInterval, 'error');
			else if (!this.testBoxLimit(interval1[0]+interval1[1], interval1[2],
					interval2[3], box.boxes))
				this.setCheckInfo(LGNoContinuousInterval, 'error');
			else {
				this.checkOut = this.getBoxId(interval2, true);
				var lastBox = this.getBox(this.checkOut);
				this.setBookTo(lastBox.toDate, lastBox.toDisplay);
				this.checkBoxLimit(interval1, interval2);
				this.setOperation(CheckOpNext);
				if (! this.isInLimit()) {
					this.resetCheckOut();
					this.setOperation(CheckOpOut, false);
					this.checkBoxLimit(interval1, interval1);
				}
			}
			return false;
		}
	},
	getBoxInterval : function(box) { //returns: 0: res type, 1: res price, 2: starting id2, 3: ending id2
		var parts = box.idShort.match(/^(box-\d+-)(\d+-)(\d+)$/); 
		return new Array(parts[1], parts[2], parts[3], box.boxes == '0' ? parts[3]
				: (parseInt(parts[3]) + parseInt(box.boxes) - 1));
	},
	/**
	 * Move on box for given value. 
	 * @param object box to move
	 * @param int value of moving
	 * @return box
	 */
	getMoveOnBox : function(box, move) {
		var parts = box.idShort.match(/^(box-\d+-\d+-)(\d+)$/);
		return parts[1] + (parts[2].toInt() + move.toInt()).toString();
	},
	getBoxId : function(interval, useSecond) { //gets box id of interval
		return interval[0]+interval[1] + (useSecond == true ? interval[3] : interval[2]);
	},
	getDayNum : function(id) {
		return parseInt(id.replace('day', ''));
	},
	getBoxNum : function(id) {
		return parseInt(id.replace('box', ''));
	},
	getDay : function(i) {
		return document.getElementById('day' + i);
	},
	getBox : function(id) {
		for ( var i = 0; i < this.boxes.length; i++)
			if (this.boxes[i] && this.boxes[i].idShort == id)
				return this.boxes[i];
	},
	getBoxShortId: function (id) {
		for ( var i = 0; i < this.boxes.length; i++)
			if (this.boxes[i] && this.boxes[i].id == id)
				return this.boxes[i].idShort;
	},
	setBookFrom : function(value, display) {
		if (!this.multi) { // with multiple reservations we do not show check in/out dialog
			var form = this.getForm();
			form.iFrom.value = display;
		}
	},
	setBookTo : function(value, display) {
		if (!this.multi) { // with multiple reservations we do not show check in/out dialog
			var form = this.getForm();
			form.iTo.value = display;
		}
	},
	testLimit : function(start, stop) {
		for ( var i = start; i <= stop; i += this.dayLength) {
			var day = this.getDay(i);
			if (!day) {
				return false;
			}
		}
		return true;
	},
	checkLimit : function(start, stop) {
		for ( var i = this.firstDay; i <= this.lastDay; i += this.dayLength) {
			var day = this.getDay(i);
			if (day) {
				day.className = ((i >= start) && (i <= stop)) ? 'day actual selected'
						: 'day actual';
			}
		}
	},
	testBoxLimit : function(prefix, from, to, boxes) { //test if interval is continuous and boxes fits
		for ( var i = from; i <= to; i++) {
			if (this.onlyOnePrice) { // allowed only one price timeline 
				if (!$(prefix.concat(i))) return false; // next book isn't the same price as previous
			}
		}
		var diff = (parseInt(to) - parseInt(from) + 1) / parseInt(boxes);
		return Math.round(diff) == diff;
	},
	
	/**
	 * Highlight selected reservation interval in calendar and store in the form.
	 * @param from
	 * @param to
	 */
	checkBoxLimit : function(from, to) {
		var boxIds = new Array();
		var begin = end = -1;
		for (var i = 0; i < this.boxes.length; i++) { // process all boxes in calendar
			if (this.boxes[i]) { // some box can be disabled
				var box = $(this.boxes[i].idShort);
				if (!this.multi) { 
					box.className = this.cleanSelected(box.className); // first unselect everything (do not with multiple reservations)
					box.selected = false;
				}
				if (from != null && to != null) { // search boxes available for selected interval
					var interval = this.getBoxInterval(this.boxes[i]);
					if (interval[1] == from[1] && interval[2] == from[2])
						begin = i; // begin box of selected interval is in the same price and reservation type as box
					if (interval[1] == to[1] && interval[2] == to[3])
						end = i; // end box of selected interval is in the same price and reservation type as box
				}
			}
		}
		var price = false;
		if (from != null && to != null) {
			if (from[1] == to[1])
				var price = from[1].toInt(); // selected interval covers one price
		}
		var rtype = false;
		
		if (end == -1) // selected interval has length 1 => end box is the same as begin
			end = begin;
		var item_id = 0;
		for (var i = begin; i <= end; i++) { // process boxes in selected interval
			if (this.boxes[i]) {
				if(!rtype)
					rtype = this.boxes[i].rtypeId.toInt(); //set rtype for first time
				var box = $(this.boxes[i].idShort);
				if (this.boxes[i].priceId.toInt() == price || (price == false && rtype == this.boxes[i].rtypeId.toInt())) { // box is in selected price or selected reservation type 
					if (this.multi && box.selected) {
						box.className = this.cleanSelected(box.className); // unhighlight (select) box
						box.selected = false;
					} else {
						box.className = this.addSelected(box.className); // highlight (select) box
						box.selected = true;
					}
					boxIds.push(this.boxes[i].id);
					item_id = this.boxes[i].item_id;
				}
			}
		}
		
		var form = this.getForm();
		
		if (this.multi) { // with multiple reservations try to concat different selected fragment together
			
			document.getElements('input[name^=boxIds]').each(function(e) { // reset form to join intervals again
				e.dispose();
			});
			
			document.getElements('input[name^=subject]').each(function(e) { // reset form to join intervals again
				e.dispose();
			});
			
			var selected = new Array();
			for (var i = 0; i < this.boxes.length; i++) // process again all boxes in calendar to group all selected
				if (this.boxes[i] && $(this.boxes[i].idShort).selected)
					selected.push(i);
			
			var boxIdsNumber = 0;
			
			while (selected.length > 0) { // process until every selected boxes are grouped
				
				boxIds = new Array(); // start new group
				boxIds.push(selected[0]);
				latest = this.boxes[selected[0]]
				selected.erase(selected[0]); // first item is grouped
				
				for (var i = 0; i < selected.length; i++) { // check if some of remaining process includes current group
					
					box = this.boxes[selected[i]];
					
					var sameGroup = true; // with multiple pricing mode do not check the group
					if (this.onlyOnePrice)
						sameGroup = box.priceId == latest.priceId && box.rtypeId == latest.rtypeId; // next box is in the same group
					
					if (sameGroup && (latest.toEnd - box.toEnd) == 1) { // next box continues without break in the same group
						boxIds.push(selected[i]);
						latest = box;
					}
				}
				
				if (boxIds.length) {
					// control allowed fixed limit 
					if (this.boxes[boxIds[0]].fix != 0 && boxIds.length != this.boxes[boxIds[0]].fix)
						this.setCheckInfo(LGFixedLimitError.replace('%s', this.boxes[boxIds[0]].fix), 'error');
					// control minimum allowed limit
					else if (this.boxes[boxIds[0]].min != 0 && boxIds.length < this.boxes[boxIds[0]].min)
						this.setCheckInfo(LGMinimumLimitUnderflow.replace('%s', this.boxes[boxIds[0]].min), 'error');
					// control maximum allowed limit
					else if (this.boxes[boxIds[0]].max != 0 && boxIds.length > this.boxes[boxIds[0]].max)
						this.setCheckInfo(LGMaximumLimitOverflow.replace('%s', this.boxes[boxIds[0]].max), 'error');
					else { // is in limit register reservation item
						$(form).adopt(new Element('input', {'type': 'hidden', 'name': 'subject[' + (boxIdsNumber) + ']', 'value': this.boxes[boxIds[0]].item_id}));
						var hBoxIds = new Array(); // data for hidden form field
						for (var i = 0; i < boxIds.length; i++) // group is complete - prepare to write into the form
							hBoxIds[i] = this.boxes[boxIds[i]].id; // get native box id
						$(form).adopt(new Element('input', {'type': 'hidden', 'name': 'boxIds[' + (boxIdsNumber ++) + ']', 'value': hBoxIds.join(',')}));
					}
					for (var i = 0; i < boxIds.length; i++)
						selected.erase(boxIds[i]); // erase grouped to avoid duplicity 
				}
			}
			
		} else {
			document.getElements('input[name^=boxIds]')[0].value = boxIds.join(','); // store selected boxes in the form
			document.getElements('input[name^=subject]')[0].value = item_id;
		}
		Calendars.showTotal();
	},
	
	/**
	 * Send whole reservation form to the server through AJAX to ge total price. 
	 */
	showTotal : function() {
		var form = $(this.getForm()).clone(); // copy of reservation form
		// remove navigation parameters
		$(form.task).dispose(); 
		$(form.controller).dispose();
		$(form.Itemid).dispose();
		new Request({
		    url: juri + 'index.php?option=com_booking&controller=reservation&task=gettotal',
		    method: 'post',
		    data: $(form).toQueryString(),
		    onSuccess: function(responseText) {
		    	$('total').set('text', responseText); // show total price on page
		    },
		}).send();
	},
	
	setOperation : function(operation, msg) {
		if (!this.multi) { // with multiple reservations we do not show check in/out dialog
			var selectCheckInDay = document.getElementById('selectCheckInDay');
			var selectCheckOutDay = document.getElementById('selectCheckOutDay');
			var className1 = 'checkButton checkButtonActive';
			var className2 = 'checkButton checkButtonUnactive';
			this.operation = operation;
			var form = this.getForm();
			form.operation.value = operation;
			switch (this.operation) {
			case CheckOpIn:
			case CheckOpNext:
				selectCheckInDay.className = className1;
				selectCheckOutDay.className = className2;
				var checkInfo = this.operation == CheckOpIn ? LGSelectCheckIn
						: LGSelectCheckNext;
				break;
			case CheckOpOut:
				selectCheckInDay.className = className2;
				selectCheckOutDay.className = className1;
				var checkInfo = LGSelectCheckOut;
				break;
			}
			if (msg != false)
				this.setCheckInfo(checkInfo, 'message');
		}
	},
	setCheckInfo : function(value, type) {
		var checkInfo = document.getElementById('checkInfo');
		checkInfo.innerHTML = value;
		switch (type) {
		case 'message':
			checkInfo.className = 'checkInfo checkInfoMessage';
			break;
		case 'notice':
			checkInfo.className = 'checkInfo checkInfoNotice';
			break;
		case 'error':
			checkInfo.className = 'checkInfo checkInfoError';
			break;
		}
	},
	setRType : function(value) {
		/*
		 * var form = this.getForm(); form.rtype.value = value;
		 */
	},
	getForm : function() {
		var form = document.bookSetting;
		return form;
	},
	monthNavigation : function(month, year) {
		if (year == undefined) {
			var parts = month.split(',');
			month = parts[0];
			year = parts[1];
		}
		var form = this.getForm();
		form.month.value = month;
		form.year.value = year;
		form.submit();
	},
	weekNavigation : function(week, year) {
		if (year == undefined) {
			var parts = week.split(',');
			week = parts[0];
			year = parts[1];
		}
		var form = this.getForm();
		form.week.value = week;
		form.year.value = year;
		form.submit();
	},
	dayNavigation : function(day, month, year) {
		if (month == undefined) {
			var parts = day.split('-');
			year = parts[0];
			month = parts[1];
			day = parts[2];
		}
		var form = this.getForm();
		form.month.value = month;
		form.year.value = year;
		form.day.value = day;
		form.submit();
	},
	reset : function() {
		this.resetCheckIn();
		this.resetCheckOut();
		this.checkLimit(0, 0);
		this.checkBoxLimit(null, null);
		this.setOperation(CheckOpIn);
		var form = this.getForm();
		document.getElements('input[name^=boxIds]')[0].value = '';
	},
	resetCheckIn : function() {
		this.setBookFrom('', '');
		this.checkIn = '';
	},
	resetCheckOut : function() {
		this.setBookTo('', '');
		this.checkOut = '';
	},
	/**
	 * Control reservation validity and submit.
	 */
	bookIt : function() {
		// test if check in/out are seted
		if (this.getForm().ctype.value != 'period' && ! this.multi) {
			if (this.checkIn == '' || this.checkOut == '')
				return this.setCheckInfo(LGSelectCheckInAndCheckOut, 'error');
			// test if interval is in allowed limit
			else if (! this.isInLimit())
				return;
		} else if (this.multi) {
			var boxIds = document.getElements('input[name^=boxIds]');
			if (boxIds.length == 0)
				return this.setCheckInfo(LGSelectCheckInAndCheckOut, 'error');
		}
		// everything OK - complete form and submit
		var form = this.getForm();
		
		form.controller.value = 'reservation';
		form.task.value = 'add';
		Calendars.view = form.view.value;
		form.view.value = '';
		
		//open modal window
		
		suppements = $(document.body).getElements('[name^="supplements"]');
		
		iframeName = 'frame_add'; //name of iframe to sent form 
		SqueezeBox.$events['close'] = [];  //http://forum.joomla.org/viewtopic.php?p=2507364
		SqueezeBox.$events['open'] = []; 
		SqueezeBox.initialize();	
		SqueezeBox.open("",{handler: 'iframe', size: {x: 600, y: 300 + suppements.length*20}, iframeOptions: {name: iframeName}, iframePreload: false}); 
		SqueezeBox.asset.name = iframeName;
		
		if (typeof SqueezeBox.asset != "undefined" && SqueezeBox.asset.name==iframeName){			
			SqueezeBox.addEvent('open',function(content){ //when modal is opened, submit form
				document.bookSetting.target="";
				document.bookSetting.tmpl.value="";
				
				if (SqueezeBox.asset.name==iframeName){ //if modal have proper name, point form into it //TODO: add loading image
					//submit form to iframe
					document.bookSetting.target=iframeName;
					document.bookSetting.tmpl.value="component";
					document.bookSetting.submit(); 
					//restore form back to original
					document.bookSetting.controller.value = '';
					document.bookSetting.view.value = Calendars.view;
					document.bookSetting.task.value = 'display';
					document.bookSetting.target="";
					document.bookSetting.tmpl.value="";
				}
				else //modal failed to load, submit to current window
					document.bookSetting.submit();
			});
		} else { //modal failed to load, submit to current window
			document.bookSetting.submit();
		}
	},
	
	sleep : function(ms)
	{
		var dt = new Date();
		dt.setTime(dt.getTime() + ms);
		while (new Date().getTime() < dt.getTime());
	}, 
	
	/**
	 * Check if interval length overflows or underflows allowed limit.
	 * Make error message.
	 * @return boolean
	 */
	isInLimit : function() {
		var form = this.getForm();
		// selected interval units count
		var length = document.getElements('input[name^=boxIds]')[0].value.split(',').length;
		// test if interval underflows minimum limitation
		if (length < this.min) {
			this.setCheckInfo(LGMinimumLimitUnderflow.replace('%s', this.min), 'error');
			return false;
		}
		// test if interval overflows maximum limitation
		if (this.max != 0 && length > this.max) {
			this.setCheckInfo(LGMaximumLimitOverflow.replace('%s', this.max), 'error');
			return false;
		}
		return true;
	},
	unhighlightInterval : function(id) {
		var interval = this.getBoxInterval(this.getBox(id));
		for ( var i = interval[2]; i <= interval[3]; i++) {
			var box = $(interval[0] + interval[1] + i);
			if (box && !box.selected)
				box.className = this.cleanSelected(box.className);
		}
	},
	highlightInterval : function(id) {
		var box = this.getBox(id);
		if (box.rtype == '2' && box.fixFrom != 'any' && box.fixFrom != box.dayWeek) return; // box isn't start day of fixed from interval   
		var interval = this.getBoxInterval(box);
		for ( var i = interval[2]; i <= interval[3]; i++) {
			var box = $(interval[0] + interval[1] + i);
			if (!box || box.selected) return;
		}
		for ( var i = interval[2]; i <= interval[3]; i++) {
			var box = $(interval[0] + interval[1] + i);
			if (box) box.className = this.addSelected(box.className);
		}
	},
	cleanSelected : function(className) {
		return trim(className.replace('selected', ''));
	},
	addSelected : function(className) {
		return trim(className + ' selected');
	}
}
function disallowDate(date) {
	if (Calendars.dateBegin == '0' && Calendars.dateEnd == '0')
		return false;
	var year = date.getFullYear().toString();
	var month = date.getMonth() + 1;
	if (month < 10)
		month = '0' + month.toString();
	var day = date.getDate();
	if (day < 10)
		day = '0' + day.toString();
	var current = parseInt(year + month + day);
	return Calendars.dateBegin > current || Calendars.dateEnd < current;
}
function onSelectDate(calendar, date) {
	if (calendar.dateClicked)
		Calendars.dayNavigation(date);
}
