<?php

/**
 * Customer edit form template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	views
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewCustomer */

$config = AFactory::getConfig();
$document = JFactory::getDocument();

if(!JFactory::getUser()->id && !$config->enableRegistration){
	JLog::getInstance()->addEntry(array('comment'=>"New reservations are disabled"));
	$mainframe = JFactory::getApplication();
	$mainframe->redirect("./");
	exit;
}

?>
<h1><?php echo JText::_('Customer Profile'); ?></h1>
<div class="profile-edit">
	<form action="index.php" method="post" name="adminForm" id="member-profile">
		<?php 
			if ($config->rsTitleBefore || $config->rsFirstname || $config->rsMiddlename || $config->rsSurname || $config->rsTitleAfter || $config->rsCompany) { 
		?>
				<fieldset>
		    		<legend><?php echo JText::_('Details'); ?></legend>
		    		<table>
		    			<?php 
		    				if ($config->rsTitleBefore) { 
		    			?>
		    					<tr>
		    						<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsTitleBefore', 'title_before', 'Title before'); ?></td>
		    						<td><input class="text_area" type="text" name="title_before" id="title_before" size="60" maxlength="255" value="<?php echo $this->customer->title_before; ?>" /></td>
		    					</tr>
		    			<?php 
		    				}
		    				if ($config->rsFirstname) { 
		    			?>
			    				<tr>
			    					<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsFirstname', 'firstname', 'First name'); ?></td>
			    					<td><input class="text_area" type="text" name="firstname" id="firstname" size="60" maxlength="255" value="<?php echo $this->customer->firstname; ?>" /></td>
			    				</tr>
		    			<?php 
		    				}
		    				if ($config->rsMiddlename) {
		   				?>
			    				<tr>
			    					<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsMiddlename', 'middlename', 'Middle name'); ?></td>
			    					<td><input class="text_area" type="text" name="middlename" id="middlename" size="60" maxlength="255" value="<?php echo $this->customer->middlename; ?>" /></td>
			    				</tr>
		    			<?php 
		    				}
		    				if ($config->rsSurname) {
		   				?>
			    				<tr>
			    					<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsSurname', 'surname', 'Surname'); ?></td>
			    					<td><input class="text_area" type="text" name="surname" id="surname" size="60" maxlength="255" value="<?php echo $this->customer->surname; ?>" /></td>
			    				</tr>
		    			<?php 
		    				}
		    				if ($config->rsTitleAfter) {
		    			?>
			    				<tr>
			    					<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsTitleAfter', 'title_after', 'Title after'); ?></td>
			    					<td><input class="text_area" type="text" name="title_after" id="title_after" size="60" maxlength="255" value="<?php echo $this->customer->title_after; ?>" /></td>
			    				</tr>
		    			<?php 
		    				}
		    				if ($config->rsCompany) {
		   				?>
			    				<tr>
			    					<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsCompany', 'company', 'Company'); ?></td>
			    					<td><input class="text_area" type="text" name="company" id="company" size="60" maxlength="255" value="<?php echo $this->customer->company; ?>" /></td>
			    				</tr>
		    			<?php 
		    				}
		   					if (is_array($config->rsExtra)) { 
								foreach ($config->rsExtra as $field) { 
						?>		 
		    						<tr>
		    							<td class="key"><label for="<?php echo $field['name']; ?>"><?php echo $field['title']; ?>:</label></td>
		    							<td><input class="text_area" type="text" name="<?php echo $field['name']; ?>" id="<?php echo $field['name']; ?>" size="60" maxlength="255" value="<?php echo $this->escape(AUtils::getArrayValue($this->customer->fields, $field['name'] . '.value')); ?>" /></td>
		    						</tr>
		   				<?php 
								}
							} 
						?>
					</table>
		    	</fieldset>
    	<?php
			} 
    		if ($this->customer->id) { 
    	?>
	        	<fieldset>
	        		<legend><?php echo JText::_('System data'); ?></legend>
	        		<table>
	        			<?php if ($this->user->id) { ?>
	        				<tr>
	        					<td class="key"><?php echo JText::_('User'); ?>:</td>
	        					<td>
	        						<a href="<?php echo ARoute::editUser($this->user->id); ?>" title=""><?php echo $this->user->username; ?></a>
			    				</td>
			    			</tr>
		        			<tr>
		        				<td class="key"><label for="email" class="required"><?php echo JText::_('Email'); ?>: <span class="star"> *</span></label></td>
		        				<td><input class="text_area" type="text" name="email" id="email" size="60" maxlength="255" value="<?php echo $this->user->email; ?>" /></td>
		        			</tr>
	    					<tr>
	    						<td class="key"><?php echo JText::_('Register date'); ?>:</td>
	    						<td><?php echo AHtml::date($this->user->registerDate, ADATE_FORMAT_LONG); ?></td>
	    					</tr>
	       					<tr>
	       						<td class="key"><?php echo JText::_('Last visit date'); ?>:</td>
	       						<td><?php echo AHtml::date($this->user->lastvisitDate, ADATE_FORMAT_LONG); ?></td>
	       					</tr>
	        			<?php } else { ?>
	        				<tr><td class="key"><?php echo JText::_('User'); ?>:</td><td>
	        				<?php echo JText::_('Not found'); ?></td></tr>
	       				<?php } ?>
	       			</table>
	        	</fieldset>
		<?php 
    		} else { 
		?>
        		<fieldset>
        			<legend><?php echo JText::_('User acount'); ?></legend>
        			<table>
	        			<?php 
	        				if (! JFactory::getUser()->id) {
	        			?>
			        			<tr>
			        				<td class="key"><label for="username" class="required"><?php echo JText::_('Username'); ?>: <span class="star"> *</span></label></td>
			        				<td><input type="text" name="username" id="username" size="60" maxlength="255" value="<?php echo $this->user->username; ?>" class="text_area" /></td>
			        			</tr>
				        		<tr>
				        			<td class="key"><label for="email" class="required"><?php echo JText::_('Email'); ?>: <span class="star"> *</span></label></td>
				        			<td><input type="text" name="email" id="email" size="60" maxlength="255" value="<?php echo $this->user->email; ?>" class="text_area" /></td>
				        		</tr>
				        		<tr>
				        			<td class="key"><label for="password" class="required"><?php echo JText::_('New Password'); ?>: <span class="star"> *</span></label></td>
				        			<td><input type="password" name="password" id="password" size="40" value="<?php echo JRequest::getString('password'); ?>" class="text_area" autocomplete="off"/></td>
				        		</tr>
			        			<tr>
			        				<td class="key"><label for="password2" class="required"><?php echo JText::_('Verify Password'); ?>: <span class="star"> *</span></label></td>
			        				<td><input type="password" name="password2" id="password2" size="40" value="<?php echo JRequest::getString('password2'); ?>" class="text_area" autocomplete="off"/></td>
			        			</tr>
	    				<?php 
							} else { 
						?>
				        		<tr>
				        			<td class="key"><label><?php echo JText::_('Name'); ?>: </label></td>
				        			<td><?php echo $user->name; ?></td>
				        		</tr>
				        		<tr>
				        			<td class="key"><label><?php echo JText::_('Username'); ?>: </label></td>
				        			<td><?php echo $user->username; ?></td>
				        		</tr>
			    	   			<tr>
			    	   				<td class="key"><label><?php echo JText::_('Email'); ?>: </label></td>
			    	   				<td><?php echo $user->email; ?></td>
			    	   			</tr>
		    			<?php 
							} 
						?>
    				</table>
    			</fieldset>
    	<?php 
			} 
 			if ($config->rsStreet || $config->rsCity || $config->rsZip || $config->rsCountry || $config->rsTelephone || $config->rsFax) { 
		?>
		    	<fieldset>
		    		<legend><?php echo JText::_('Contact'); ?></legend>
		    		<table>
		    			<?php 
		    				if ($config->rsStreet) { 
		    			?>
					    		<tr>
					    			<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsStreet', 'street', 'Street'); ?></td>
					    			<td><input class="text_area" type="text" name="street" id="street" size="60" maxlength="255" value="<?php echo $this->customer->street; ?>" /></td>
					    		</tr>
		    			<?php 
		    				}
		    				if ($config->rsCity) {
			    		?>
								<tr>
									<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsCity', 'city', 'City'); ?></td>
									<td><input class="text_area" type="text" name="city" id="city" size="60" maxlength="255" value="<?php echo $this->customer->city; ?>" /></td>
								</tr>
		    			<?php 
		    				}
		    				if ($config->rsZip) {
			    		?>
								<tr>
									<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsZip', 'zip', 'Zip'); ?></td>
									<td><input class="text_area" type="text" name="zip" id="zip" size="60" maxlength="255" value="<?php echo $this->customer->zip; ?>" /></td>
								</tr>
		    			<?php 
		    				}
		    				if ($config->rsCountry) {
			    		?>
						    	<tr>
						    		<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsCountry', 'country', 'Country'); ?></td>
						    		<td><input class="text_area" type="text" name="country" id="country" size="60" maxlength="255" value="<?php echo $this->customer->country; ?>" /></td>
						    	</tr>
			    		<?php 
			    			}
			    			if ($config->rsTelephone) {
		    			?>
								<tr>
									<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsTelephone', 'telephone', 'Telephone'); ?></td>
									<td><input class="text_area" type="text" name="telephone" id="telephone" size="60" maxlength="255" value="<?php echo $this->customer->telephone; ?>" /></td>
								</tr>
			    		<?php 
			    			}
			    			if ($config->rsFax) {
		    			?>
		    					<tr>
		    						<td class="key"><?php echo AHtml::displayLabel($document, $config, 'rsFax', 'fax', 'fax'); ?></td>
		    						<td><input class="text_area" type="text" name="fax" id="fax" size="60" maxlength="255" value="<?php echo $this->customer->fax; ?>" /></td>
		    					</tr>
			    		<?php 
			    			}
			    		?>
		    		</table>
			    </fieldset>
   		<?php 
 			}
    	?>
		<div>
			<button type="submit" class="validate" onclick="return ViewCustomerSubmit.submitbutton('save')">
				<span>
					<?php echo JText::_('Submit'); ?>
				</span>
			</button>
			<?php 
				echo JText::_('or');
				if ($this->customer->id)
					$backLink = JRoute::_(ARoute::view(VIEW_CUSTOMER));
				elseif (isset($this->subject))
					$backLink = JRoute::_(ARoute::view(VIEW_SUBJECT, $this->subject->id, $this->subject->alias));
				else
					$backLink = 'javascript:history.go(-1)';
			?>
			<a href="<?php echo $backLink; ?>" title="<?php echo JText::_('Cancel'); ?>"><?php echo JText::_('Cancel'); ?></a>
		</div>
		<input type="hidden" name="option" value="<?php echo OPTION; ?>"/>
		<input type="hidden" name="controller" value="<?php echo CONTROLLER_CUSTOMER; ?>"/>
		<input type="hidden" name="task" value=""/>
		<input type="hidden" name="new_account" id="new_account" value="1"/>
		<input type="hidden" name="return" value="<?php echo $this->escape(JRequest::getString('return')); ?>"/>
		<?php 
			if (isset($this->subject)) { 
		?>
				<input type="hidden" name="startSubjectId" value="<?php echo $this->subject->id; ?>"/>
		<?php 
			}
			echo JHTML::_('form.token'); 
		?>
	</form>
</div>