<?php

/**
 * Rezervation controller.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  controllers
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

//import needed JoomLIB helpers
AImporter::helper('booking', 'config', 'controller', 'parameter', 'request', 'html');
//import next model
AImporter::model('customer', 'prices', 'reservation', 'reservations',  'reservationitem',  'reservationitems', 'reservationsupplements', 'reservationtypes', 'subject', 'supplements');


//import needed tables
AImporter::table('price', 'reservationsupplement', 'supplement');
//import needed objects
AImporter::object('box', 'date', 'day', 'interval', 'service');

class BookingControllerReservation extends AController
{
    
    /**
     * Main model
     * 
     * @var BookingModelReservation
     */
    var $_model;

    function __construct($config = array())
    {
        parent::__construct($config);
        if (IS_ADMIN) {
            $this->_model = $this->getModel('reservation');
        } elseif (IS_SITE) {
            $this->_model = new BookingModelReservation();
        }
        $this->_controllerName = CONTROLLER_RESERVATION;
    }
    
    /**
     * NOTE: next 3 function have to be on top because of some builder error
     */

    /**
     * Prepare email body to send. Replace variables by data.
     * 
     * @param string $body
     * @param TableReservation $reservation
     * @param array of TableReservationItems+supplements $items
     * @param string $status
     * @return string 
     */
    function replaceEmailBody($body, &$reservation, $items, $status = '')
    {	
		$matches = array();
        if (preg_match('#\{OBJECTS\}(.*)\{\/OBJECTS\}#is',$body,$matches)) {
        	
        	$pattern = $matches[1];
        	$replacements = array();

	        foreach ($items as $item) {
	        	/* @var $item TableReservationItems */
	        	$supplementsInfo = array();
	        	if (isset($item->supplements)) foreach ($item->supplements as $supplement)
	        		$supplementsInfo[] = $supplement->title . ': ' . BookingHelper::displaySupplementValue($supplement);

	        	$replacement = $pattern;
	        		
	        	$replacement = str_replace('{OBJECT TITLE}', $item->subject_title, $replacement);
	        	$replacement = str_replace('{DATE}', AHtml::interval($item, 0), $replacement);
	        	$replacement = str_replace('{QUANTITY}', $item->capacity, $replacement);
	        	$replacement = str_replace('{PRICE}', BookingHelper::displayPrice($item->fullPrice), $replacement);
	        	$replacement = str_replace('{PRICEWITHSUPPLEMENTS}', BookingHelper::displayPrice($item->fullPriceSupplements), $replacement);
	        	$replacement = str_replace('{DEPOSIT}', BookingHelper::displayPrice($item->fullDeposit), $replacement);
	        	$replacement = str_replace('{TAX}', BookingHelper::displayPrice(BookingHelper::getTax($item->fullPriceSupplements, $item->tax)), $replacement);
	        	$replacement = str_replace('{SUPPLEMENTS}', implode('<br/>', $supplementsInfo), $replacement);
	        	// marks for periodic reservations
	        	$replacement = str_replace('{TIMEFRAME}', AHtml::showRecurenceTimeframe($item), $replacement);
	        	$replacement = str_replace('{RECURRENCE PATTERN}', AHtml::showRecurencePattern($item), $replacement);
	        	$replacement = str_replace('{RANGE OF RECURRENCE}', AHtml::showRecurenceRange($item), $replacement);
	        	$replacement = str_replace('{RECURRENCE TOTAL}', $item->period_total, $replacement);
	        	
	        	$replacements[] = $replacement;
	        }
	        $body = str_replace($matches[0], implode('', $replacements), $body); 
        }
        
        list($fullPrice,$fullDeposit) = BookingHelper::countOverallPrice(null,$items);
        
        $body = str_replace('{ID}', $reservation->id, $body);
        $body = str_replace('{STATUS}', $status, $body);
        $body = str_replace('{FULLPRICE}', BookingHelper::displayPrice($fullPrice), $body);
        $body = str_replace('{FULLDEPOSIT}', BookingHelper::displayPrice($fullDeposit), $body);
        $body = str_replace('{FULLTAX}', BookingHelper::displayPrice(BookingHelper::getFullTax($items)), $body);
        $body = str_replace('{CUSTOMER}', BookingHelper::formatName($reservation), $body);
        $body = str_replace('{ADDRESS}', BookingHelper::formatAddress($reservation), $body);
        $body = str_replace('{COMPANY}', $reservation->company, $body);
        $body = str_replace('{EMAIL}', $reservation->email, $body);
        $body = str_replace('{TELEPHONE}', $reservation->telephone, $body);
        $body = str_replace('{FAX}', $reservation->fax, $body);
        $body = str_replace('{PAYMENT}', $reservation->payment_method_name, $body);
        $body = str_replace('{NOTE}', $reservation->note, $body);
        $body = str_replace('{LINK}', JURI::base()."administrator/".ARoute::edit(VIEW_RESERVATION, $reservation->id), $body);
        if(isset($reservation->fields) && !empty($reservation->fields))
	        foreach (unserialize($reservation->fields) as $field)
	        	$body = str_replace('{' . JString::strtoupper($field['title']) . '}', $field['value'], $body);
        
        
		$body .= "\n\n" . BookingHelper::get();
		
        
        return $body;
    }
    
        
    /**
     * Display default view - reservation list.	
     */
    function display()
    {
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        
        if ($this->_doRedirect) {
            JRequest::setVar('view', 'reservations');
        }
        
        $modelCustomer = new BookingModelCustomer();
        $modelCustomer->setIdByUserId();
        
        if ($modelCustomer->isCustomer()) {
            switch ($this->getTask()) {
                case 'storno':
                    $cids = ARequest::getCids();
                    if (count($cids)) {
                        if ($this->_model->stornoSafe($modelCustomer->getId(), $cids)) {
                            if ($this->_doRedirect) {
                                $mainframe->redirect(ARoute::convertUrl(JRoute::_(ARoute::view(VIEW_RESERVATIONS))), JText::_('Successfully cancelled'), 'message');
                            }
                        } else {
                            if ($this->_doRedirect) {
                                $mainframe->redirect(ARoute::convertUrl(JRoute::_(ARoute::view(VIEW_RESERVATIONS))), JText::_('Cancellation failed'), 'error');
                            }
                        }
                    } else {
                        if ($this->_doRedirect) {
                            $mainframe->redirect(ARoute::convertUrl(JRoute::_(ARoute::view(VIEW_RESERVATIONS))), JText::_('Choose reservations from list to cancel'), 'notice');
                        }
                    }
                case 'detail':
                    JRequest::setVar('view', 'reservation');
                    break;
                default:
                    parent::display();
                    return;
            }
        }
        
        if (IS_ADMIN || (IS_SITE && $modelCustomer->isAdmin())) {
            
            $id = ARequest::getCid();
            
            $task = $this->getTask();
            
            switch ($task) {
                case 'receive':
                case 'receiveDeposit':
                case 'unreceive':
                case 'storno':
                case 'trash':
                case 'active':
                case 'restore':
                case 'conflict':
                case 'prereserved':
                	$this->state($task, true, false);
                	$this->changeStatusInfo($id, $task);
                	ARequest::redirectList($this->_controllerName);
                    break;
                case 'detail':
                    JRequest::setVar('view', 'reservation');
                    break;
            }
        }
        if ($this->_doRedirect) {
            parent::display();
        }
    }

    /**
     * Send information to customer about change reservation status.
     * 
     * @param int $id reservation ID
     * @param string $task request parameter
     */
    function changeStatusInfo($id, $task)
    {
    	if (!$id){
    		JError::raiseWarning(400,'Id not set');
    		return false;
    	}
    	
        $config = &AFactory::getConfig();
        
        if ($config->mailingStatusClient) {
            
            switch ($task) {
                case 'receive':
                    $status = JText::_('reservation accepted');
                    break;
                case 'receiveDeposit':
                    $status = JText::_('reservation deposit received');
                    break;
                case 'unreceive':
                    $status = JText::_('reservation deposit not received');
                    break;
                case 'storno':
                    $status = JText::_('reservation cancelled');
                    break;
                default:
                    return;
            }
            
            $this->_model->setId($id);
            $reservation = &$this->_model->getObject();
            /* @var $reservation TableReservation */
            
            if (!$reservation->email)
            	return false;
            
            $modelSupplements = new BookingModelSupplements();
            $modelReservationSupplements = new BookingModelReservationSupplements();
			$modelReservationItems = new BookingModelReservationItems();
			
        	$modelReservationSupplements->init(array());
	        $modelReservationItems->init(array('reservation_item-reservation_id'=>$reservation->id));
	        
	        $reservedItemsDb=$modelReservationItems->getData();
	        $reservedItems=array();
        	if (count($reservedItemsDb)) foreach ($reservedItemsDb as $reservedItem) {
        		
	        	$newItem = JTable::getInstance('ReservationItems','Table');
	        	$newItem->id = $reservedItem->id;
	        	$newItem->load();

	        	unset($modelReservationSupplements->_data); //add suplements
        	 	$modelReservationSupplements->_lists['reservation'] = $reservedItem->id; 
        	 	$supplements = $modelReservationSupplements->getData();

        		$newItem->supplements = &BookingHelper::loadSupplements($modelSupplements, $newItem->subject, $reservedItem->capacity, $supplements);

        		$reservedItems[] = $newItem;
	        }
	        
	        //put email subject, body and attachments thorugh plugin (to add invoice)
            $mail = array();
            $email = JModel::getInstance('Email', 'BookingModel')->getItem($config->mailingStatusClient);
            $mail['subject'] = $email->subject;
            $mail['body'] = $this->replaceEmailBody($email->body, $reservation, $reservedItems, $status);
            $mail['attachments'] = null;

            $paymentStates = array('unreceive'=>0,'receiveDeposit'=>1,'receive'=>2); //translate task into new payment state
			
            JPluginHelper::importPlugin('booking');
            $dispatcher = JDispatcher::getInstance(); 
            $dispatcher->trigger('OnChangeStatusCustomerMail', array($id,isset($paymentStates[$task]) ? $paymentStates[$task] : $task ,&$mail) ); //trigger plugin (for VM Invoice)
                        JUtility::sendMail(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname'), $reservation->email, $mail['subject'], $mail['body'], $email->mode, null, null, $mail['attachments']);
            
            if (is_array($mail['attachments']))
            	JFile::delete($mail['attachments']);
        }
    }

    /**
     * Open editing form page
     */
    function editing()
    {
        parent::editing('reservation');
    }
    
    /**
     * Add item(s) to current reservation and continue.
     */
    function add_continue()
    {
    	$this->add_checkout(false);
    }
    
    /**
     * Add item(s) to current reservation and go to checkout / reload page.
     */
    function add_checkout($toCheckout=true){
    	$config = AFactory::getConfig();
    	$mainframe =& JFactory::getApplication();
    	$post = JRequest::get('post');
    	
    	$sessionItems = $mainframe->getUserState(OPTION.'.user_reservation_items');
    	
    	//reset reservations if can booked only one item
    	if($sessionItems && !($config->moreReservations)){
    		$sessionItems = array();
    		$mainframe->enqueueMessage(JText::_('You can book only one Item. Previous is deleted'));
    	}
    	
    	if (!$sessionItems)
    		$sessionItems = array();
    	
        foreach ($post['boxIds'] as $id => $boxIds) {
    		
    		$newItem = array();
    		$newItem['boxIds']=$boxIds;
    		$newItem['supplements']=isset($post['supplements'][$id]) ? $post['supplements'][$id] : array();
    		$newItem['ctype']=$post['ctype'][$id];
    		$newItem['subject']=$post['subject'][$id];
    		
    		$key = md5(serialize($newItem)); //key must be without capacity

    		$newItem['capacity']=isset($post['capacity'][$id]) ? $post['capacity'][$id] : 1;

    		if ($newItem['ctype'] == CTYPE_PERIOD) {
    			$newItem['period_rtype_id']=$post['period_rtype_id'][$id];
    			$newItem['period_price_id']=$post['period_price_id'][$id];
    			$newItem['period_time_up']=$post['period_time_up'][$id];
    			$newItem['period_time_down']=$post['period_time_down'][$id];
    			$newItem['period_type']=$post['period_type'][$id];
    			$newItem['period_recurrence']=$post['period_recurrence'][$id];
    			$newItem['period_monday']=$post['period_monday'][$id];
    			$newItem['period_tuesday']=$post['period_tuesday'][$id];
    			$newItem['period_wednesday']=$post['period_wednesday'][$id];
    			$newItem['period_thursday']=$post['period_thursday'][$id];
    			$newItem['period_friday']=$post['period_friday'][$id];
    			$newItem['period_saturday']=$post['period_saturday'][$id];
    			$newItem['period_sunday']=$post['period_sunday'][$id];
    			$newItem['period_month']=$post['period_month'][$id];
    			$newItem['period_week']=$post['period_week'][$id];
    			$newItem['period_day']=$post['period_day'][$id];
    			$newItem['period_date_up']=$post['period_date_up'][$id];
    			$newItem['period_end']=$post['period_end'][$id];
    			$newItem['period_occurrences']=$post['period_occurrences'][$id];
    			$newItem['period_date_down']=$post['period_date_down'][$id];
        	}
    		
    		$sessionItems[$key] = $newItem;
    		
    	}
    	
    	$mainframe->setUserState(OPTION.'.user_reservation_items',$sessionItems);
    	$mainframe->enqueueMessage(JText::_('Item added'));
    	
        //store system messages to session
        $messageQueue = $mainframe->getMessageQueue();
    	if (count($messageQueue)) {
			$session = JFactory::getSession();
			$session->set('application.queue', $messageQueue);
		}

    	//redirect parent / this page
    	echo '<script>'."\n";
    	echo 'if (window.parent)'."\n";
    	if ($toCheckout) 
    		echo "window.parent.location.href='".ARoute::view(VIEW_RESERVATION,null, null, array('layout'=>'form'))."';\n";
    	else {
    		echo "{
    				var e = window.parent.document.bookSetting.getElementsByTagName('input'); // all reservation form inputs
    				for (var i = 0; i < e.length; i++) // process each
    					if (e[i].getAttribute('name').match(/^boxIds\[\d+\]$/)) // hidden input with name boxIds[]
    						e[i].value = ''; // reset field
    				";
    		echo "window.parent.document.bookSetting.submit();}\n";  //re-submit parent form
    	}
    	echo 'else '."\n";
    	if ($toCheckout) 
    		echo "document.location.href='".ARoute::view(VIEW_RESERVATION,null, null, array('layout'=>'form'))."';\n";
    	else
    		echo "document.location.href='".ARoute::view(VIEW_SUBJECT,$newItem['subject'])."';\n";
    		
    	echo '</script>';
    	
    	$mainframe->close();
    }
    
    /**
     * Remove item from current reservation (from session).
     */
    function remove_item() {
    	
    	$mainframe =& JFactory::getApplication();
    	
    	$sessionItems = $mainframe->getUserState(OPTION.'.user_reservation_items');
    	if ($sessionItems) foreach ($sessionItems as $key => $sessionItem) {
    		if (JRequest::getVar('key')==$key){
    			unset($sessionItems[$key]);
    			$mainframe->enqueueMessage(JText::_('Item removed'));}
    	}

    	$mainframe->setUserState(OPTION.'.user_reservation_items',$sessionItems);
    	$mainframe->redirect(ARoute::view(VIEW_RESERVATION,null, null, array('layout'=>'form')));
    }
    
    /**
     * Remove item from existing reservation (from database). Ajax action.
     */
    function remove_item_db() {
    	$ret = $this->getModel('reservationitem')->removeitem(JRequest::getInt('id'), JRequest::getInt('rid'));
    	ob_clean();
    	die($ret ? '1' : '0');
    }
    
    /**
     * Save current reservation into user state.
     */
    function store()
    {
    	$post = JRequest::get('post');
    	$mainframe =& JFactory::getApplication();
		$reservedItems = array();

		//store itemns from post to session
    	foreach ($post['boxIds'] as $id => $boxIds) {
    		
    		$newItem = array();
    		$newItem['boxIds']=$boxIds;
    		$newItem['supplements']=isset($post['supplements'][$id]) ? $post['supplements'][$id] : array();
    		$newItem['ctype']=$post['ctype'][$id];
    		$newItem['subject']=$post['subject'][$id];
    		$key = md5(serialize($newItem)); //key must be without capacity

    		$newItem['capacity']=isset($post['capacity'][$id]) ? $post['capacity'][$id] : 1;

    		if ($newItem['ctype'] == CTYPE_PERIOD) {
    			$newItem['period_rtype_id']=$post['period_rtype_id'][$id];
    			$newItem['period_price_id']=$post['period_price_id'][$id];
    			$newItem['period_time_up']=$post['period_time_up'][$id];
    			$newItem['period_time_down']=$post['period_time_down'][$id];
    			$newItem['period_type']=$post['period_type'][$id];
    			$newItem['period_recurrence']=$post['period_recurrence'][$id];
    			$newItem['period_monday']=$post['period_monday'][$id];
    			$newItem['period_tuesday']=$post['period_tuesday'][$id];
    			$newItem['period_wednesday']=$post['period_wednesday'][$id];
    			$newItem['period_thursday']=$post['period_thursday'][$id];
    			$newItem['period_friday']=$post['period_friday'][$id];
    			$newItem['period_saturday']=$post['period_saturday'][$id];
    			$newItem['period_sunday']=$post['period_sunday'][$id];
    			$newItem['period_month']=$post['period_month'][$id];
    			$newItem['period_week']=$post['period_week'][$id];
    			$newItem['period_day']=$post['period_day'][$id];
    			$newItem['period_date_up']=$post['period_date_up'][$id];
    			$newItem['period_end']=$post['period_end'][$id];
    			$newItem['period_occurrences']=$post['period_occurrences'][$id];
    			$newItem['period_date_down']=$post['period_date_down'][$id];
    		}
    		
    		$reservedItems[$key] = $newItem;
    	}
    	
    	$mainframe->setUserState(OPTION.'.user_reservation_items',$reservedItems);

    	//store customer info to session
    	$customer  = array();
    	$reservationTable = JTable::getInstance('Reservation','Table');
    	$params = get_object_vars($reservationTable);
    	unset($params['id'],$params['customer'],$params['state'],$params['paid'],$params['checked_out'],$params['checked_out_time']);
    	foreach ($params as $param => $val)
    		if (isset($post[$param]))
    			$customer[$param] = $post[$param];
    			
    	$mainframe->setUserState(OPTION.'.user_reservation_info',$customer);
    	$mainframe->enqueueMessage(JText::_('Reservation saved'));
       		$mainframe->redirect(ARoute::view(VIEW_RESERVATION,null, null, array('layout'=>'form')));
    }
        
    /**
     * Empty session with current reservation.
     */
    function erase()
    {
    	$mainframe =& JFactory::getApplication();
    	$mainframe->setUserState(OPTION.'.user_reservation_items',null);
    	$mainframe->setUserState(OPTION.'.user_reservation_info',null);
    	$mainframe->enqueueMessage(JText::_('Reservation erased'));
    	if (JFactory::getApplication()->getUserState('com_booking.object.last'))
    		$this->setRedirect(JFactory::getApplication()->getUserState('com_booking.object.last'));
    	else
    		ARequest::redirectView(VIEW_SUBJECTS);
    }
    
    /**
     * Save new or existing reservation.
     * 
     * @param boolean $apply if true after save redirect on editing reservation page, if false redirect to reservations list.
     */
    function save($apply = false)
    {
        $modelCustomer = new BookingModelCustomer();
        $modelSubject = new BookingModelSubject();
        $modelReservationItem = new BookingModelReservationItem();
        $modelReservationItems = new BookingModelReservationItems();
        $modelSupplements = new BookingModelSupplements();
        $modelReservationSupplements = new BookingModelReservationSupplements();
                
        $config = &AFactory::getConfig();

        $modelCustomer->setIdByUserId();
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
            
        	//check for errors
        	$err=false;
        	if ($modelCustomer->isCustomer() && $config->useCaptcha && !BookingHelper::controlCaptcha()){ //captcha invalid
        		$mainframe->enqueueMessage('Captcha invalid', 'error');
        		$err=true;}
        	if ($modelCustomer->isCustomer() && $config->terms_of_contract_accept && !JRequest::getInt('accept_terms_of_contract')){
        		$mainframe->enqueueMessage('Accept Terms of Contract', 'error');
        		$err=true;}
            if ($modelCustomer->isCustomer() && $config->terms_of_privacy_accept && !JRequest::getInt('accept_terms_of_privacy')){
        		$mainframe->enqueueMessage('Accept Terms of Privacy', 'error');
        		$err=true;}
        	
            if ($err) 
            {
                JRequest::setVar('view', VIEW_RESERVATION);
                JRequest::setVar('layout', 'form');
                JRequest::setVar('task', 'refresh');
                JRequest::setVar('error', true);
                parent::display();
                return;
            }
            
			//get items
			$subjects = array();
			$reservedItems=array();
			
			$boxIdsArray = ARequest::getArray('boxIds');
			$postSubjects = ARequest::getIntArray('subject');
			$postCtypes = ARequest::getStringArray('ctype');
			$postSupplements = ARequest::getArray('supplements', false);
			$postCapacity = ARequest::getIntArray('capacity');
			$postMessages = ARequest::getArray('message');
			
			$post_period_rtype_id = ARequest::getIntArray('period_rtype_id');
			$post_period_price_id = ARequest::getIntArray('period_price_id');
			$post_period_time_up = ARequest::getStringArray('period_time_up');
			$post_period_time_down = ARequest::getStringArray('period_time_down');
			$post_period_type = ARequest::getIntArray('period_type');
			$post_period_recurrence = ARequest::getIntArray('period_recurrence');
			$post_period_monday = ARequest::getIntArray('period_monday');
			$post_period_tuesday = ARequest::getIntArray('period_tuesday');
			$post_period_wednesday = ARequest::getIntArray('period_wednesday');
			$post_period_thursday = ARequest::getIntArray('period_thursday');
			$post_period_friday = ARequest::getIntArray('period_friday');
			$post_period_saturday = ARequest::getIntArray('period_saturday');
			$post_period_sunday = ARequest::getIntArray('period_sunday');
			$post_period_month = ARequest::getIntArray('period_month');
			$post_period_week = ARequest::getIntArray('period_week');
			$post_period_day = ARequest::getIntArray('period_day');
			$post_period_date_up = ARequest::getStringArray('period_date_up');
			$post_period_end = ARequest::getIntArray('period_end');
			$post_period_occurrences = ARequest::getIntArray('period_occurrences');
			$post_period_date_down = ARequest::getStringArray('period_date_down');
			
        	$customer = &$modelCustomer->getObject();
        	/* @var $customer TableCustomer */
        	
        	        	
        	//check and prepare items firstly
			if (count($boxIdsArray)) foreach ($boxIdsArray as $key => $boxIds){
				
            	$newItem = JTable::getInstance('ReservationItems','Table');
            	/* $newItem->reservation_id = $id; */
            	$newItem->subject = $postSubjects[$key];
            	$newItem->message = empty($postMessages[$key]) ? '' : $postMessages[$key];
            	$newItem->capacity = isset($postCapacity[$key]) ? $postCapacity[$key] : 1;

                if (!isset($subjects[$newItem->subject])){
                	/*
	                $newSubject = JTable::getInstance('Subject','Table');
	        		$newSubject->id = $newItem->subject ;
	        		$newSubject->load();
	        		$newSubject->bind($newSubject); //bind to itself, because we need files array from params
	        		*/
	        		$modelSubject->setId($newItem->subject);
	        		$subjects[$newItem->subject] = $modelSubject->getObject();
        		}
        		
        		$subject = $subjects[$newItem->subject];
        		/* @var $subject TableSubject */

				$requestSupplements = !empty($postSupplements[$key]) ? $postSupplements[$key] : array();
                $newItem->supplements = &BookingHelper::loadSupplements($modelSupplements, $newItem->subject, $newItem->capacity, null ,$requestSupplements, count($boxIds)); //load supplements table from request

                if ($postCtypes[$key] == CTYPE_PERIOD) {
                	$newItem->period_rtype_id = $post_period_rtype_id[$key];
                	$newItem->period_price_id = $post_period_price_id[$key];
                	$newItem->period_time_up = $post_period_time_up[$key];
                	$newItem->period_time_down = $post_period_time_down[$key];
                	$newItem->period_type = $post_period_type[$key];
                	$newItem->period_recurrence = $post_period_recurrence[$key];
                	$newItem->period_monday = $post_period_monday[$key];
                	$newItem->period_tuesday = $post_period_tuesday[$key];
                	$newItem->period_wednesday = $post_period_wednesday[$key];
                	$newItem->period_thursday = $post_period_thursday[$key];
                	$newItem->period_friday = $post_period_friday[$key];
                	$newItem->period_saturday = $post_period_saturday[$key];
                	$newItem->period_sunday = $post_period_sunday[$key];
                	$newItem->period_month = $post_period_month[$key];
                	$newItem->period_week = $post_period_week[$key];
                	$newItem->period_day = $post_period_day[$key];
                	$newItem->period_date_up = $post_period_date_up[$key];
                	$newItem->period_end = $post_period_end[$key];
                	$newItem->period_occurrences = $post_period_occurrences[$key];
                	$newItem->period_date_down = $post_period_date_down[$key];
                }
                
                if (ARequest::getCid()) { // resave existing reservation
                	$newItem->id = JArrayHelper::getValue(ARequest::getArray('id'), $key);
                	$newItem->from = JArrayHelper::getValue(ARequest::getArray('from'), $key);
                	$newItem->to = JArrayHelper::getValue(ARequest::getArray('to'), $key);
                	$newItem->rtype = JArrayHelper::getValue(ARequest::getArray('rtype'), $key);
                	$newItem->price = JArrayHelper::getValue(ARequest::getArray('price'), $key);
                	$newItem->deposit = JArrayHelper::getValue(ARequest::getArray('deposit'), $key);
                	$newItem->fullPrice = JArrayHelper::getValue(ARequest::getArray('fullPrice'), $key);
                	$newItem->fullPriceSupplements = JArrayHelper::getValue(ARequest::getArray('fullPriceSupplements'), $key);
                	$newItem->fullDeposit = JArrayHelper::getValue(ARequest::getArray('fullDeposit'), $key);
                	$newItem->subject_title = JArrayHelper::getValue(ARequest::getArray('subject_title'), $key);
                	$newItem->tax = JArrayHelper::getValue(ARequest::getArray('tax'), $key);
                } else {	
                	//reserve from interval, in ID is subject ID
                	$box = &BookingHelper::getReservedInterval($subject, $postCtypes[$key], $boxIds, $newItem->supplements, $newItem->capacity, $newItem);
		                
	            	if (is_object($box)) {
	            		$newItem->id = null;
	                	$newItem->from = $box->from;
	                	$newItem->to = $box->to;
	                	$newItem->rtype = $box->rtype;
	                	$newItem->price = $box->price;
	                
	                		                		$onlinePaymentExpirationTime = $config->onlinePaymentExpirationTime;
	                
	                	//if expiration for online payment, get confgiruation in minutes and save in seconds
	                	$newItem->cancel_time = ($box->cancel_time==='0')? $onlinePaymentExpirationTime*60 : $box->cancel_time;
	                	$newItem->deposit = $box->deposit;
	                	$newItem->fullPrice = $box->fullPrice;
	                	$newItem->fullPriceSupplements = $box->fullPriceSupplements;
	                	$newItem->fullDeposit = $box->fullDeposit;
	                	$newItem->subject_title = $subject->title . ' / ' . $box->rtypeTitle;
	                	$newItem->tax = $subject->tax;
	                	
	                	$availableCapacity = $subject->total_capacity-$box->maxReserved;
	                	if (!$box->canReserve OR $availableCapacity<$newItem->capacity)
	                		$mainframe->redirect(ARoute::view(VIEW_SUBJECT, $subject->id, $subject->alias), 'Subject cannot reserved', 'error');
	            	}
                }
	            
	            //warning if some important field is missing (but not abort the save process)
                $fields = array('subject','rtype','from','to','capacity');
                foreach ($fields as $field)
                	if (empty($newItem->$field))
                		JError::raiseNotice(0,JText::sprintf('missing item', $field, $key));
                		
                $reservedItems[] = $newItem;
			}
			
			$checkLimit = $modelReservationItems->canReserveInLimit($customer, $subjects, $reservedItems);
			
	       	if ($checkLimit!==true)
	        	$mainframe->redirect(ARoute::view(VIEW_SUBJECT, $checkLimit->id, $checkLimit->alias), JText::sprintf('Cannot reserve in limit %s for %s days.', $checkLimit->rlimit_count, $checkLimit->rlimit_days, $checkLimit->title), 'error');
			     
			//store reservation
            $post = &JRequest::get('post');
            if ($modelCustomer->isCustomer())
            	$post['id'] = 0; //customer  only adding
            else 
            	$post['id'] = ARequest::getCid();
            if ($modelCustomer->isCustomer())
        		$post['customer'] = $modelCustomer->getId() ? $modelCustomer->getId() : 0; //anynomyous = 0
        	
        	//if every reservation must be confirmed by admin, state is pre-reserved
        	//if deposit must be paid immediately (online payment) set resevation as storned
        	//Reservation will be activated after confirmation of payment - ?controller=reservation&paid=receive&task=payment&type=paypal
        	
        	if ($modelCustomer->isCustomer()) {
        		if($config->confirmReservation == 1)
        			$post['state'] = RESERVATION_PRERESERVED;
        		else if($box->cancel_time === '0')
        			$post['state'] = RESERVATION_STORNED;
        		else
		    		$post['state'] = RESERVATION_ACTIVE;
        	
		    	$post['paid'] = RESERVATION_PENDING;
        	}
		    //$post['book_time'] = date('Y-m-d'); //moved to the method store
		            
            $id = $this->_model->store($post);

            $user = JFactory::getUser();
            
            if ($id) {
            	
            	if ($user->guest || (!$modelCustomer->getId() && !JRequest::getInt('customer'))) { // guest or non customer - create new account
            		$customer = JTable::getInstance('customer', 'table');
            		/* @var $customer TableCustomer */
            		$customer->bind($post);
					$customer->id = null;
					$customer->user = $modelCustomer->isAdmin() ? 0 : $user->get('id'); // do not assign new customer account witl logged administrator - when admin creates reservations
					$customer->state = CUSTOMER_STATE_ACTIVE;
					$customer->store();
					if (!$user->guest) {
						$reservation = JTable::getInstance('reservation', 'table');
						/* @var $reservation TableReservation */
						$reservation->load($id);
						$reservation->customer = $customer->id;
						$reservation->store();
					}					            		
            	}
            	
            	//var_dump($reservedItems);
            	//store items & get files to send customer
            	$filesSend = null;
            	foreach ($reservedItems as &$reservedItem){
            		$reservedItem->reservation_id = $id;
            		
                	if (!($reservedItem->id = $modelReservationItem->store((array)$reservedItem)))
                		$mainframe->enqueueMessage(JText::_('Subject not stored').': <br>'.nl2br(print_r($reservedItem,true)),'warning');
                	elseif ($config->mailingReservationClient) {
                		
                		$files = BookingHelper::getSubjectFiles($subjects[$reservedItem->subject],array('onlySend'=>true,'onlyFilepaths'=>true));
                		$filesSend = array_unique(array_merge((array)$filesSend,$files));
                	}
            	}

            	$mainframe->setUserState(OPTION.'.user_reservation_items',null);
    			$mainframe->setUserState(OPTION.'.user_reservation_info',null);
    	
                if ($config->mailingReservationClient || $config->mailingReservationManager) {
                    $reservation = &$this->_model->_table;
                    /* @var $reservation TableReservation */
                    
                    JPluginHelper::importPlugin('booking');
                    $dispatcher = JDispatcher::getInstance();
                    
                    //put customer email through plugin
                    $mail = array();
                    $email = JModel::getInstance('Email', 'BookingModel')->getItem($config->mailingReservationClient);
                    $mail['subject'] = $email->subject;
                    $mail['body'] = $this->replaceEmailBody($email->body, $reservation, $reservedItems);
                    $mail['attachments'] = $filesSend;
					$dispatcher->trigger('OnReservationCustomerMail', array($id,$reservation->paid,&$mail) ); 
                    
                    if ($config->mailingReservationClient && $reservation->email && ($modelCustomer->isCustomer() || JRequest::getInt('notify_customer')))
                    	JUtility::sendMail(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname'), $reservation->email, $mail['subject'], $mail['body'], $email->mode, null, null, $mail['attachments']);
                    
                    //put administrator email through plugin
                    $mail = array();
                    $email = JModel::getInstance('Email', 'BookingModel')->getItem($config->mailingReservationManager);
                    $mail['subject'] = $email->subject;
                    $mail['body'] = $this->replaceEmailBody($email->body, $reservation, $reservedItems);
                    $mail['attachments'] = null;
					$dispatcher->trigger('OnReservationAdministratorMail', array($id,$reservation->paid,&$mail) ); 
                        
                    if ($config->mailingReservationManager && $config->mailingManager && $modelCustomer->isCustomer()) { // notify managers after customer reservation
                    	JUtility::sendMail(JFactory::getApplication()->getCfg('mailfrom'), JFactory::getApplication()->getCfg('fromname'), $config->mailingManager, $mail['subject'], $mail['body'], $email->mode, null, null, $mail['attachments']);
                    }
                 }
                
                 if ($modelCustomer->isAdmin()) {
                 	if ($apply)
                 		ARequest::redirectEdit($this->_controllerName, $id);
                 	else
                 		ARequest::redirectList($this->_controllerName);
                 } else
                	$mainframe->redirect($this->getReservationRoute($id), JText::_('Reservation stored'), 'message');
            
            } else {
            	
            	JError::raiseWarning(JText::_('Reservation not stored'),'error');

            	JRequest::setVar('view','reservation');
    			JRequest::setVar('layout','form');
    			parent::display();
            }
    }

    /**
     * Get URL to display reservation on frontend.
     * 
     * @param int $reservationId
     * @param string $sessionIdMd5
     * @return string
     */
    function getReservationRoute($reservationId, $sessionIdMd5 = null)
    {
        $config = &AFactory::getConfig();
        return  ARoute::view(VIEW_RESERVATION).ARoute::id($reservationId).(JFactory::getUser()->get('id') === 0 ? ARoute::customUrl(array('session' => $sessionIdMd5 ? $sessionIdMd5 : md5(session_id())), false) : '');
    }

    /**
     * Cancel edit operation. Check in reservation and redirect to reservations list. 
     */
    function cancel()
    {
        parent::cancel('Reservation editing canceled');
    }

    function followup()
    {
    	$this->getModel('reservation')->followup();    	
    }
    
    /**
     * Serve reservation total price to the AJAX call.
     */
    function gettotal()
    {
    	$modelSupplements = JModel::getInstance('Supplements', 'BookingModel');
    	/* @var $modelSupplements BookingModelSupplements */
    	$newItem = JTable::getInstance('ReservationItems','Table');
    	/* @var $newItem TableReservationItems */
    	$subject = JTable::getInstance('Subject', 'Table');
    	/* @var $subject TableSubject */
    	
    	$postSubjects = ARequest::getIntArray('subject'); // list of reservation item
    	$boxIdsArray = ARequest::getArray('boxIds'); // selected reservation interval
    	$requestSupplements = ARequest::getArray('supplements'); // list of supplement
    	$ctype = JRequest::getString('ctype'); // calendar type
    	
    	$response = '';
    	$fullPriceSupplements = 0;
    	
    	foreach ($boxIdsArray as $key => $boxIds) {
    		$boxIds = explode(',', $boxIds);
    		
    		$subject->load($postSubjects[$key]);
    		$supplements = BookingHelper::loadSupplements($modelSupplements, $subject->id, 1, null, $requestSupplements, count($boxIds));
    		$box = BookingHelper::getReservedInterval($subject, $ctype, $boxIds, $supplements, 1, $newItem);
    	
    		$fullPriceSupplements += $box->fullPriceSupplements; 
    	}
    	
    	if (!empty($fullPriceSupplements))
    		$response = JText::_('Total Price') . ': ' . BookingHelper::displayPrice($fullPriceSupplements); // get total price formated with label
    	
    	ob_clean(); // prevent for some errors in string response
    	die($response);
    }
    }

?>