<?php

/**
 * Tax Rate parameter element.
 *
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	elements
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class JElementTaxRate extends JElement
{

	public function fetchElement($name, $value, $node, $control_name = null)
	{
		$value = @unserialize($value);
		if (!is_array($value))
			$value = array();
		
		JToolBar::getInstance('jelementtaxrate')->addButtonPath(JPATH_COMPONENT_ADMINISTRATOR . DS . 'elements');
		JToolBar::getInstance('jelementtaxrate')->appendButton('BookingLink', 'new', 'Add', 'javascript:void(0);');
		JToolBar::getInstance('jelementtaxrate')->appendButton('BookingLink', 'delete', 'Delete', 'javascript:void(0);');
		
		$code = JToolBar::getInstance('jelementtaxrate')->render();
		
		$code .= '
			<div class="clr"></div>
			  <table id="jelementtaxrate-table">
				<thead>
			      <tr>
				    <th width="1%"></th>
				    <th width="1%" nowrap="nowrap">' . JText::_('Title') . '</th>
				    <th width="1%" nowrap="nowrap">' . JText::_('Tax_Value_Percent') . '</th>
			      </tr>
				</thead>
				<tbody id="jelementtaxrate-tbody">';
		
		foreach ($value as $i => $row) 
			$code .= '
				  <tr>
				    <td>
					  <input type="checkbox" />
					</td>
					<td>
					  <input type="text" name="taxratetitle[' . $i . ']" value="' . htmlspecialchars($row[0]) . '" size="30" />
					</td>
					<td>
					  <input type="text" name="taxratevalue[' . $i . ']" value="' . htmlspecialchars($row[1]) . '" size="1" />
					</td>
				  </tr>';
		
		$code .= '
				</tbody>
			  </table>';
		
		$code .= '
			<script type="text/javascript">
				//<![CDATA[
				window.addEvent("domready", function() {
				
					if ($("jelementtaxrate-tbody").getElements("tr").length == 0) {
						$("jelementtaxrate-table").setStyle("display", "none");
						$("jelementtaxrate-delete").setStyle("display", "none");
					}
					
					$("jelementtaxrate-new").addEvent("click", function() {
						$("jelementtaxrate-table").setStyle("display", "");
						$("jelementtaxrate-delete").setStyle("display", "");
				
						var tr = new Element("tr");
						tr.set("html", \'<td><input type="checkbox" /></td><td><input type="text" name="taxratetitle[]" size="30" /></td><td><input type="text" name="taxratevalue[]" size="1" /></td>\').inject($("jelementtaxrate-tbody"));
						return false;
					});
				
					$("jelementtaxrate-delete").addEvent("click", function() {
						$("jelementtaxrate-tbody").getElements("input[type^=checkbox]").each(function(e, i) {
							if (e.checked)
								e.getParent().getParent().destroy();
						});
				
						if ($("jelementtaxrate-tbody").getElements("tr").length == 0) {
							$("jelementtaxrate-table").setStyle("display", "none");
							$("jelementtaxrate-delete").setStyle("display", "none");
						}
						return false;
					});
				});
				//]]>
			</script>';
		
		return $code;
	}
}