<?php

/**
 * Component helper for configuration.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  helpers 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class BookingConfig
{
    // Main
	var $allowReservations;
    var $loginBeforeReserving;
    var $enableRegistration;
    var $displayWhoReserve;
    var $showNoteInCalendar;
    var $useCaptcha;
    var $unRegisteregCanReserve;
    var $moreReservations;
    var $confirmReservation;
    var $customersUsergroup;
    var $templatesIcons;
    var $dateTypeJoomla;
    var $dateLong;
    var $dateNormal;
    var $dateDay;
    var $dateDayShort;
    var $time;
    var $jpgQuality;
    var $pngQuality;
    var $pngFilter;
    
    // Prices
	var $mainCurrency;
    var $lastZero;    
    var $decimals;
	var $decimalsPoint;
    var $thousandSeparator;
    var $priceFormat;
    var $onlinePaymentExpirationTime;
    var $taxRates;
    
    // Calendars
    var $firstDaySunday;
    var $quickNavigator;
    var $calendarDeep;
    var $calendarDeepMonth;
    var $calendarNumMonths;
    var $calendarDeepWeek;
    var $calendarDeepDay;
    var $bookCurrentDay;
    var $nightsStyle;
    var $colorCalendarFieldReserved;
    var $colorCalendarFieldFree;
    var $colorCalendarUnavailable;
    var $colorCalendarBoxReserved;
    
    // Frontend - Objects List
    var $images;
    var $imagesCache;
    var $displayThumbs;
    var $thumbWidth;
    var $thumbHeight;
    var $displayReadmore;
    var $readmoreLength;
    var $displayFilter;
    var $displayPagination;
    var $defaultPagination;
    var $displayPaginationSelector;
    var $displaySubjectsProperties;
    var $buttonBookit;
    var $subjectsCalendar;
    var $subjectsCalendarSkin;
    var $subjectsCalendarStart;
    var $subjectsCalendarDeep;
    var $subjectsWeek;
    var $subjectsWeekDeep;
    
    /* Frontend - Object Detail */
    
    var $multipleReservations;
    var $displaySubjectBack;
    var $displaySubjectTextPosition;
    var $priceLayout;
    
    // Main image
    var $displayImage;
    var $subjectThumbWidth;
    var $subjectThumbHeight;
    
    // Gallery
    var $displayGallery;
    var $galleryPosition;
    var $galleryStyle;
    var $galleryThumbWidth;
    var $galleryThumbHeight;
    var $galleryPreviewWidth;
    var $galleryPreviewHeight;
    var $displayProperties;

    // Mailing
    var $mailingManager;
    var $mailingRegistrationClient;
    var $mailingRegistrationManager;
    var $mailingReservationClient;
    var $mailingReservationManager;
    var $mailingStatusClient;
    
    // Reservations setting
    var $rsTitleBefore;
    var $rsFirstname;
    var $rsMiddlename;
    var $rsSurname;
    var $rsTitleAfter;
    var $rsCompany;
    var $rsStreet;
    var $rsCity;
    var $rsCountry;
    var $rsZip;
    var $rsEmail;
    var $rsTelephone;
    var $rsFax;
    var $rsNote;
    var $rsExtra;
    var $rsCompanyId;
    var $rsVatId;
    
    // Locations
    var $locations;
    var $pickuplocations;
    var $dropofflocations;
    
    // follow up
    var $followupEnabled;
    var $followupSchedule;
    var $followupEmail;

    function __construct()
    {
        $this->init();
    }
    
    function getConfigForUser($id)
    {
    	AImporter::helper('user');
    	AUser::$id = $id;
    	$this->init();
    	echo $this->mainCurrency;
    	$default = clone $this;
    	AUser::$id = 0;
    	$this->init();
    	return $default;
    }
    
    function changeConfigForUser($id)
    {
    	AImporter::helper('user');
    	AUser::$id = $id;
    	$this->init();
    }

    function init()
    {
        $user = JFactory::getUser();
        /* @var $user JUser */
        $mainframe = JFactory::getApplication();
        /* @var $mainframe JApplication */
        
        JModel::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_booking/models');
        JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_booking/tables');
        
        $params = AParameter::loadComponentParams();
        if ($mainframe->isSite()) {
            $menu = $mainframe->getMenu();
            /* @var $menu JMenuSite */
            $active = $menu->getActive();
            if (is_object($active)) {
            	jimport('joomla.html.parameter');
            	$activeParams = new JParameter($active->params);
            	$params->merge($activeParams);
            }
        }
        
        $this->images = $params->get('images');
        $this->imagesCache = $params->get('images_cache', 'cache/com_booking/');
        
        $this->templatesIcons = $params->get('templates_icons');
        
        // Prices
        $this->mainCurrency = $params->get('main_currency');
        $this->lastZero = (int) $params->get('last_zero', 0);
    	$this->decimals = (int) $params->get('decimals', 2);
		$this->decimalsPoint = $params->get('decimals_point', ',');
		$this->thousandSeparator = '';
    	if ($params->get('thousand_separator', 'space') == 'space')
			$this->thousandSeparator = ' ';
    	elseif ($params->get('thousand_separator', 'space') == 'comma')
    		$this->thousandSeparator = ',';
    	elseif ($params->get('thousand_separator', 'space') == 'point')
    		$this->thousandSeparator = '.';
    	elseif ($params->get('thousand_separator', 'space') == 'char')
    		$this->thousandSeparator = $params->get('thousand_separator_char');
    	$this->priceFormat = (int) $params->get('price_format', 2);
    	$this->onlinePaymentExpirationTime = abs($params->get('online_payment_expiration_time',15));
    	
    	$this->taxRates = @unserialize($params->get('taxrates', ''));
    	if (!is_array($this->taxRates))
    		$this->taxRates = array();
        
        // Calendars
        $this->firstDaySunday = (int) $params->get('first_day', 0);
        $this->quickNavigator = (int) $params->get('quick_navigator', 1);
        $this->calendarDeepMonth = (int) $params->get('calendar_deep_month', 5);
        $this->calendarNumMonths = (int) $params->get('calendar_num_months', 1);
        $this->calendarDeepWeek = (int) $params->get('calendar_deep_week', 20);
        $this->calendarDeepDay = (int) $params->get('calendar_deep_day', 100);
        $this->bookCurrentDay = (int) $params->get('book_current_day', 0);
        $this->nightsStyle = (int) $params->get('nights_style', 1);
        $this->colorCalendarFieldReserved = $params->get('color_calendar_field_reserved', 0);
        $this->colorCalendarFieldFree = $params->get('color_calendar_field_free', 0);
        $this->colorCalendarUnavailable = $params->get('color_calendar_unavailable', 0);
        $this->colorCalendarBoxReserved = $params->get('color_calendar_box_reserved', 0);
        
        if ($this->colorCalendarFieldReserved && JString::strpos($this->colorCalendarFieldReserved, '#') !== 0)
        	 $this->colorCalendarFieldReserved = '#' . $this->colorCalendarFieldReserved; // color picker does not fill color code with #
        
        if ($this->colorCalendarFieldFree && JString::strpos($this->colorCalendarFieldFree, '#') !== 0)
        	 $this->colorCalendarFieldFree = '#' . $this->colorCalendarFieldFree; // color picker does not fill color code with #
        
        if ($this->colorCalendarUnavailable && JString::strpos($this->colorCalendarUnavailable, '#') !== 0)
        	$this->colorCalendarUnavailable = '#' . $this->colorCalendarUnavailable; // color picker does not fill color code with #
        
        if ($this->colorCalendarBoxReserved && JString::strpos($this->colorCalendarBoxReserved, '#') !== 0)
        	 $this->colorCalendarBoxReserved = '#' . $this->colorCalendarBoxReserved; // color picker does not fill color code with #
        
        $this->dateTypeJoomla = $params->get('date_type') == 0;
        $this->dateLong = JString::trim($params->get('date_long'));
        $this->dateNormal = JString::trim($params->get('date_normal'));
        $this->dateDay = JString::trim($params->get('date_day'));
        $this->dateDayShort = JString::trim($params->get('date_day_short'));
        $this->time = JString::trim($params->get('time'));
        $this->jpgQuality = (int) $params->get('jpg_quality', 85);
        $this->pngQuality = (int) $params->get('png_quality', 9);
        $this->pngFilter = (int) $params->get('png_filter');
        
        $this->multipleReservations = (int) $params->get('multiple_reservations', 1);
        $this->displayImage = (int) $params->get('display_image_subject_detail');
        $this->subjectThumbWidth = (int) $params->get('display_thumbs_subject_detail_width');
        $this->subjectThumbHeight = (int) $params->get('display_thumbs_subject_detail_height');
        
        $this->displayGallery = (int) $params->get('display_gallery_subject_detail');
        $this->galleryPosition = $params->get('display_gallery_subject_position', 'below');
        $this->galleryStyle = $params->get('display_gallery_subject_style', 'slideshow');
        $this->galleryThumbWidth = (int) $params->get('display_gallery_thumbs_subject_detail_width');
        $this->galleryThumbHeight = (int) $params->get('display_gallery_thumbs_subject_detail_height');
        
        $this->galleryPreviewWidth = (int) $params->get('display_gallery_preview_subject_detail_width');
        $this->galleryPreviewHeight = (int) $params->get('display_gallery_preview_subject_detail_height');

        $this->enableRegistration = (int) $params->get('enable_registration',1);
        $this->displayWhoReserve = (int) $params->get('display_who_reserve',0);
        $this->allowReservations = (int) $params->getValue('allow_reservations');
        $this->unRegisteregCanReserve = $this->allowReservations == 1;
        $this->showNoteInCalendar = (int) $params->get('show_note_in_calendar',0);
        $this->customersUsergroup = (int) $params->get('customers_usergroup', CUSTOMER_GID);
        $this->loginBeforeReserving = (int) $params->get('login_before_reserving', 0);
        $this->moreReservations = (int) $params->get('more_reservations',1);
        $this->confirmReservation = (int) $params->get('confirm_reservation',0);
        
        $this->useCaptcha = (int) $params->get('use_captcha');
        $this->displaySubjectBack = (int) $params->get('display_subject_back', 1);
        $this->displaySubjectTextPosition = $params->get('display_subject_text_position', 'below_image');
        $this->priceLayout = $params->get('prices_layout', 'detailed_list');
        
        $this->displayThumbs = (int) $params->get('display_thumbs_subjects_list');
        $this->thumbWidth = (int) $params->get('display_thumbs_subjects_list_width');
        $this->thumbHeight = (int) $params->get('display_thumbs_subjects_list_height');
        $this->displayReadmore = (int) $params->get('display_readmore_subjects_list');
        $this->displaySubjectsProperties = (int) $params->get('subjects_properties', 1);
        $this->readmoreLength = (int) $params->get('display_readmore_subjects_list_length');
        $this->displayProperties = (int) $params->get('display_properties_subject_detail');
        $this->displayFilter = (int) $params->get('subjects_list_filter', 1);
        $this->displayPagination = (int) $params->get('subjects_pagination', 1);
        $this->defaultPagination = (int) $params->get('subjects_pagination_start', 10);
        $this->displayPaginationSelector = (int) $params->get('subjects_pagination_selector', 1);
        $this->buttonBookit = (int) $params->get('button_bookit', 1);
        $this->subjectsCalendar = (int) $params->get('subjects_calendar', 0);
        $this->subjectsCalendarSkin = JString::trim($params->get('subjects_calendar_skin', 'dhx_skyblue'));
        $this->subjectsCalendarStart = (int) $params->get('subjects_calendar_start', 0);
        $this->subjectsCalendarDeep = (int) $params->get('subjects_calendar_deep', 3);
        $this->subjectsWeek = (int) $params->get('subjects_week', 0);
        $this->subjectsWeekDeep = (int) $params->get('subjects_week_deep', 7);
        
        // Mailing
        $this->mailingManager = explode(',', str_replace(';', ',', JString::trim($params->get('mailing_manager', ''))));
        $this->mailingRegistrationClient = (int) $params->get('mailing_registration_client', 0);
    	$this->mailingRegistrationManager = (int) $params->get('mailing_registration_manager', 0);
    	$this->mailingReservationClient = (int) $params->get('mailing_reservation_client', 0);
    	$this->mailingReservationManager = (int) $params->get('mailing_reservation_manager', 0);
    	$this->mailingStatusClient = (int) $params->get('mailing_status_client', 0);
        
        // Reservations setting
        $this->rsTitleBefore = (int) $params->get('rs_title_before', 1);
        $this->rsFirstname = (int) $params->get('rs_firstname', 1);
        $this->rsMiddlename = (int) $params->get('rs_middlename', 1);
        $this->rsSurname = (int) $params->get('rs_surname', 1);
        $this->rsTitleAfter = (int) $params->get('rs_title_after', 1);
        $this->rsCompany = (int) $params->get('rs_company', 1);
        $this->rsStreet = (int) $params->get('rs_street', 1);
        $this->rsCity = (int) $params->get('rs_city', 1);
        $this->rsCountry = (int) $params->get('rs_country', 1);
        $this->rsZip = (int) $params->get('rs_zip', 1);
        $this->rsEmail = (int) $params->get('rs_email', 1);
        $this->rsTelephone = (int) $params->get('rs_telephone', 1);
        $this->rsFax = (int) $params->get('rs_fax', 1);
        $this->rsNote = (int) $params->get('rs_note', 1);
        $this->rsCompanyId = (int) $params->get('rs_company_id', 1);
        $this->rsVatId = (int) $params->get('rs_vat_id', 1);
        $this->rsExtra = @unserialize($params->get('fields', ''));
        if (is_array($this->rsExtra))
        	foreach ($this->rsExtra as $i => $field)
        		$this->rsExtra[$i]['name'] = JFilterOutput::stringURLSafe('fields ' . $field['title']);
        
        // Reservation Terms 
        $this->terms_of_contract_accept = (int) $params->get('terms_of_contract_accept', 0);
        $this->terms_of_contract = JModel::getInstance('Article', 'BookingModel')->getItem(1);
        $this->terms_of_privacy_accept = (int) $params->get('terms_of_privacy_accept', 0);
        $this->terms_of_privacy = JModel::getInstance('Article', 'BookingModel')->getItem(2);
        
        // Locations
        $this->locations = (int) $params->get('locations', 0);
        $this->pickuplocations = $this->locations ? JModel::getInstance('Locations', 'BookingModel')->getPickUp() : array();
        $this->dropofflocations = $this->locations ? JModel::getInstance('Locations', 'BookingModel')->getDropOff() : array();
        
        $this->followupEnabled = (int) $params->get('followup_enabled', 0);
        $this->followupSchedule = JString::trim($params->get('followup_schedule', '1t0d0h10m'));
        $this->followupEmail = (int) $params->get('followup_email', 0);
    }
}

?>