<?php

/**
 * Create parameter table for template properties. 
 * 
 * @version		$Id$
 * @package		ARTIO JoomLIB
 * @subpackage  helpers 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

if (! class_exists('JParameter'))
    jimport('joomla.html.parameter');

class AParameter extends JParameter
{
    
    /**
     * Image base 
     * 
     * @var string
     */
    var $images;

    /**
     * Construct object.
     * 
     * @param $data
     * @param $path
     */
    function __construct($data, $path = null, &$xml = null)
    {
        $this->images = JURI::root() . 'components/' . OPTION . '/assets/images/';
        parent::__construct($data, $path);
        if ($xml) {
            $this->loadSetupXML($xml);
        }
        
//        $j = new JRegistry($data);
//        foreach($j->toArray() as $k=>$v)
//        {
//        	$this->setValue($k,'params',$v);
//        }        
    }

    /**
     * Load object from XML source.
     * 
     * @param JSimpleXML $xml
     * @return boolean 
     */
    function loadSetupXML(&$xml)
    {
        $result = false;
        
        if ($params = &$xml->document->params) {
            $result = true;
            foreach ($params as $param) {
                $this->setXML($param);
            }
        }
        
        return $result;
    }

    /**
     * Render properties table.
     * 
     * @param string $name type of params to render
     * @param string $group params group to render 
     */
    function render($name = 'params', $group = '_default')
    {
        $params = $this->getParams($name, $group);
        $config = &AFactory::getConfig();
        $ripath = AImage::getIPath($config->templatesIcons);
        $ids = array();
        $html = array();
        $html[] = '<table class="template">';
        $html[] = '<thead>';
        $html[] = '<tr>';
        $html[] = '<th>&nbsp;</th>';
        $html[] = '<th>&nbsp;</th>';
        $html[] = '<th><h3>' . JText::_('Name') . '</h3></th>';
        $html[] = '<th><h3>' . JText::_('Value') . '</h3></th>';
        $html[] = '<th><h3>' . JText::_('Icon') . '</h3></th>';
        $html[] = '<th><h3>' . JText::_('Tools') . '</h3></th>';
        $html[] = '</tr>';
        $html[] = '</thead>';
        $html[] = '<tbody id="paramlist">';
        if (is_array($params)) {
            foreach ($params as $i => $param) {
                if (! is_null($param)) {
                	// prepare parameter properties
                    $label = $param[0];
                    $value = $param[1];
                    $id = (int) $param[5];
                    $searchable = (int) $param[6];
                    $filterable = (int) $param[7];
                    $type = $param[8];
                    $paramValue = $param[9];
                    $icon = $param[10];
                    $objects = (int) $param[12];
                    $object = (int) $param[13];
                    if ($type == 'radio') {
                        $value = '<input type="radio" class="inputRadio" name="params[' . $id . ']" value="" style="display: none" ' . (! $paramValue ? 'checked="checked"' : '') . '/>' . $value;
                    }
                    $ids[] = $id;
                    $html[] = '<tr id="params' . $id . '-row">';
                    $html[] = '<td class="check">';
                    $html[] = '<input type="checkbox" class="inputCheckbox" name="cid[]" id="params' . $id . '-check" value="' . $id . '"/>';
                    $html[] = '</td>';
                    $html[] = '<td>';
                    $html[] = '<span class="up" title="' . htmlspecialchars(JText::_('Move property up'), ENT_QUOTES) . '"></span>';
					$html[] = '<span class="down" title="' . htmlspecialchars(JText::_('Move property down'), ENT_QUOTES) . '"></span>';
					$html[] = '<input type="hidden" name="params-ordering[' . $id . ']" value="" />';
                    $html[] = '</td>';
                    $html[] = '<td class="label">' . $label . '</td>';
                    $html[] = '<td id="params' . $id . '-value">' . $value . '</td>';
                    // icon cell
                    $html[] = '<td>';
                    $thumb = AImage::thumb($ripath . $icon, 30, 30);
                    if ($thumb)
                    	$html[] = '<img src="' . htmlspecialchars($thumb) . '" alt="" id="params' . $id . '-icons" />';
                    else
                    	$html[] = '<img src="' . $this->images . 'spacer.gif" alt="" id="params' . $id . '-icons" />';
                    $html[] = '<input type="hidden" name="params-icons-orig[]" id="params' . $id . '-icons-orig" value="' . htmlspecialchars($icon) . '" />';
                    $html[] = '</td>';
                    // tools cell
                    $html[] = '<td id="params' . $id . '-toolbar">';
                    // render tools
                    $html[] = $this->tool(true, 'config', null, 'ATemplate.config(' . $id . ')', 'Config');
                    $html[] = $this->tool(true, 'trash', null, 'ATemplate.trash(' . $id . ',true)', 'Trash');
                    $html[] = $this->tool($searchable != 0, 'search', $id, null, 'Searchable');
                    $html[] = $this->tool($filterable != 0, 'filter', $id, null, 'Filterable');
                    $html[] = $this->tool($objects != 0, 'objects', $id, null, 'Show at Items List');
                    $html[] = $this->tool($object != 0, 'object', $id, null, 'Show at Item Detail');
                    
                    $html[] = '</td>';
                    $html[] = '</tr>';
                }
            }
        }
        $html[] = '</tbody>';
        $html[] = '</table>';
        $html[] = '<div class="glossary">';
        $glossary = array('Glossary' => null , 'Config' => 'config' , 'Trash' => 'trash' , 'Searchable' => 'search' , 'Filterable' => 'filter', 'Show at Items List' => 'objects', 'Show at Item Detail' => 'object');
        foreach ($glossary as $label => $icon) {
            if ($icon) {
                $html[] = $this->tool(true, $icon);
                ADocument::addScriptPropertyDeclaration('TmpImg' . ucfirst($icon), $this->getToolImage($icon), true, false);
            }
            $html[] = '<span>' . JText::_($label) . ($icon ? '' : ':') . '</span>';
        }
        $html[] = '</div>';
        $max = count($ids) ? max($ids) : 0;
        ADocument::addScriptPropertyDeclaration('TmpId', $max, false, false);
        return implode(PHP_EOL, $html);
    }

    /**
     * Get toolbar image as only info icon or button with javascript onclick event function.
     * 
     * @param boolean $icon add image or empty div
     * @param string $name name of image and tool
     * @param int $id property ID 
     * @param string $function javascript event function
     * @return string HTML code
     */
    function tool($icon, $name, $id = null, $function = null, $title = '')
    {
        $image = $this->getToolImage($name);
        $id = $id ? (' id="icon-' . $name . '-' . $id . '" ') : '';
        if ($icon) {
            $uname = ucfirst($name);
            $function = $function ? (' onclick="' . $function . ';" ') : '';
            $class = $function ? 'tool' : 'icon';
            return '<img src="' . $image . '" alt="' . $uname . '"' . $function . ' class="' . $class . '"' . $id . ' title="' . htmlspecialchars($title) . '"/>';
        } else {
            return '<div class="emptyIcon"' . $id . '>&nbsp;</div>';
        }
    }

    /**
     * Get tool image full path.
     * 
     * @param string $name
     * @return string
     */
    function getToolImage($name)
    {
        return $this->images . 'icon-16-' . $name . '.png';
    }

    /**
     * Get main table toolbar table.
     * 
     * @return string HTML code
     */
    function toolbar()
    {
        $bar = &JToolBar::getInstance('template-properties');
        $bar->appendButton('ALink', 'new', 'New', 'ATemplate.add()');
        $bar->appendButton('ALink', 'delete', 'Delete', 'ATemplate.trash(\'all\',true)');
        return $bar->render();
    }

    /**
     * Get toolbar button.
     * 
     * @param string $name tool name
     * @param string $function javascript onclick event function
     * @return array parts of HTML code
     */
    function button($name, $function)
    {
        $html = array();
        $html[] = '<td class="button">';
        $html[] = '<a class="toolbar" href="javascript:' . $function . '">';
        $html[] = '<span class="icon-32-' . $name . '" title="' . ucfirst($name) . '">&nbsp;</span>';
        $name = JString::ucfirst($name);
        $html[] = JText::_($name);
        $html[] = '</a>';
        $html[] = '</td>';
        return $html;
    }

    /**
     * Load param.
     * 
     * @param JSimpleXMLElement $node param node
     * @param string $control_name param name
     * @param string $group param group
     * @return array param values
     */
    function getParam(&$node, $control_name = 'params', $group = '_default')
    {
        $type = $node->attributes('type');
        $type = str_replace('mos_', '', $type); // compatibility fix with J!1.0
        $value = $this->get($node->attributes('name'), $node->attributes('default'), $group);
        switch ($type) {
            case 'checkbox': // custom rendering for checkbox
                $param = &$this->renderCheckBox($node, $value, $control_name);
                break;
            case 'radio': // custom rendering for radio button
                $param = &$this->renderRadio($node, $value, $control_name);
                break;
            case 'textarea': // custom rendering for textarea
                $param = &$this->renderEditor($node, $value, $control_name);
                break;
            default: // use standard renderer for others
                $element = &$this->loadElement($type);
                if (is_object($element))
                	$param = &$element->render($node, $value, $control_name);
                break;
        }
        $param[] = $node->attributes('searchable'); // use param in global seaching
        $param[] = $node->attributes('filterable'); // use param in filtering object's list
        $param[] = $node->attributes('type'); // data type (checkbox, radio etc.)
        $param[] = $value; // parameter value
        $param[] = $node->attributes('icon'); // decorative icon image
        $param[] = $node; // full XML node
        $param[] = $node->attributes('objects'); // use param on object's list
        $param[] = $node->attributes('object'); // use param on object detail
        return $param;
    }

    /**
     * Render check box.
     * 
     * @param JSimpleXMLElement $node param node
     * @param mixed $value param value
     * @param string $control_name param name
     * @return array
     */
    function renderCheckBox(&$node, $value, $control_name)
    {
        $param = array();
        
        $name = $node->attributes('name');
        $label = $node->attributes('label');
        
        $nodeName = $control_name . '[' . $name . ']';
        $nodeId = $control_name . $name;
        
        $param[] = '<label id="' . $nodeId . '-lbl" for="' . $nodeId . '">' . $label . '</label>';
        $param[] = '<input type="hidden" name="' . $nodeName . '" value="0"/><input type="checkbox" class="inputCheckbox" name="' . $nodeName . '" id="' . $nodeId . '" value="1" ' . (((int) $value == 1) ? 'checked="checked"' : '') . '/>';
        $param[] = '';
        $param[] = $label;
        $param[] = $value;
        $param[] = $name;
        
        return $param;
    }

    /**
     * Render radio buttons list.
     * 
     * @param JSimpleXMLElement $node param node
     * @param mixed $value param value
     * @param string $control_name param name
     * @return array
     */
    function renderRadio(&$node, $value, $control_name)
    {
        static $id;
        if (is_null($id)) {
            $id = 0;
        }
        $param = array();
        
        $name = $node->attributes('name');
        $label = $node->attributes('label');
        
        $nodeName = $control_name . '[' . $name . ']';
        $nodeId = $control_name . $name;
        
        $param[] = '<label id="' . $nodeId . '-lbl">' . $label . '</label>';
        
        $options = &$node->children();
        $count = count($options);
        $values = '';
        for ($i = 0; $i < $count; $i ++) {
            /* @var $option JSimpleXMLElement */
            $option = &$options[$i];
            $optionValue = $option->attributes('value');
            $id ++;
            $values .= '<input type="radio" class="inputRadio" name="' . $nodeName . '" id="radio' . $id . '" value="' . htmlspecialchars($optionValue) . '"';
            if ($value == $optionValue)
                $values .= ' checked="checked" ';
            $values .= '/><label for="radio' . $id . '">' . $optionValue . '</label>';
        }
        $param[] = $values;
        $param[] = '';
        $param[] = $label;
        $param[] = $value;
        $param[] = $name;
        return $param;
    }
    
    function renderEditor(&$node, $value, $control_name) 
    {
        $editor = &JFactory::getEditor();
    	/* @var $editor JEditor */
    	$param[] = '<label id="' . $control_name . $node->attributes('name') . '-lbl">' . $node->attributes('label') . '</label>';
        $param[] = $editor->display($control_name . '[' . $node->attributes('name') . ']', $value, 500, 500, 50, 10, false, array($control_name . $node->attributes('name')));
        $param[] = '';
        $param[] = $node->attributes('label');
        $param[] = $value;
        $param[] = $node->attributes('name');
        return $param;
    }

    /**
     * Load component main params configuration.
     * @return JParameter
     */
    function loadComponentParams()
    {
        static $params;
        if (is_null($params)) {
        	$db = JFactory::getDBO();
        	/* @var $db JDatabaseMySQL */
            $db->setQuery('SELECT `key`, `value` FROM `#__booking_config`');
            $data = array();
            foreach($db->loadAssocList() as $val)
            	$data[$val['key']] = $val['value'];
	        $params = new JParameter('', CONFIG);
    	    $params->loadArray($data);
        }
        return $params;
    }
}

?>