<?php

/**
 * Reservation model. Support for database operations.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  models
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

//import needed JoomLIB helpers
AImporter::helper('booking', 'model');

class BookingModelReservationItem extends AModel
{
    
    /**
     * Main table
     * 
     * @var TableReservation
     */
    var $_table;

    function __construct()
    {
        parent::__construct();
        $this->_table = $this->getTable('reservationitems');
    }

    /**
     * Save item and it's supplements.
     * 
     * @param array $data request data including supplements property
     * @return customer id if success, false in unsuccess
     */
	function store($data)
    {
    	if (empty($data['id']))
    		$this->_table->id = null; //dont ask why
    		
        if (! $this->_table->bind($data) || ! $this->_table->check() || ! $this->_table->store()) {
            return false;
        }                

        if (array_key_exists('supplements',$data) && count($data['supplements']))  {
	        
	        $tableSupplement = &$this->getTable('reservationsupplement');
	        
	        /* @var $tableSupplement TableReservationSupplement */
	        $tableSupplement->reservation = $this->_table->id;
	        
	        // delete existing supplements - will save again
	        $this->_db->setQuery('DELETE FROM #__booking_reservation_supplement 
	        		WHERE reservation=' . $this->_table->id);
	        $this->_db->query();
	        
	        foreach ($data['supplements'] as $supplement) {
	        	
	            /* @var $supplement TableSupplement */
	            $tableSupplement->bind($supplement);
	            $tableSupplement->id = 0;
	            $tableSupplement->supplement = $supplement->id;
	            $tableSupplement->store();
	        }
        }
        
        return $this->_table->id;
    }
    
    /**
     * Remove one reservation item with all assets (supplement, period).
     * @param int $id reservation item id
     * @param int $rid reservation id
     * @return mixed false: disallow remove only item, true: removed 
     */
    public function removeitem($id, $rid)
    {
    	$this->_db->setQuery("SELECT COUNT(*) FROM #__booking_reservation_items WHERE reservation_id = $rid");
    	if ($this->_db->loadResult() < 2) // disallow remove only item
    		return false;
    	$query = "DELETE i, s, p FROM #__booking_reservation_items AS i 
    			LEFT JOIN #__booking_reservation_supplement AS s ON i.id = s.reservation 
    			LEFT JOIN #__booking_reservation_period AS p ON i.id = p.reservation_item_id
    			WHERE i.id = $id AND i.reservation_id = $rid";
    	$this->_db->setQuery($query);
    	return $this->_db->query();
    }
}

?>