<?php

/**
 * Subject available price.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  tables 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class TablePrice extends JTable
{
    
    /**
     * Primary key
     * 
     * @var int
     */
    var $id;
    
    /**
     * Subject owner - ID
     * 
     * @var int
     */
    var $subject;
    
    /**
     * Price value
     * 
     * @var int
     */
    var $value;
    
    /**
     * Price deposit value
     * 
     * @var int
     */
    var $deposit;
    
    /**
     * Deposit is added to price multiply for each time unit or single.
     * 
     * @var int 1/0 ... multiply/single
     */
    var $deposit_multiply;
    
    /**
     * If multiply price by reserved capacity.
     * 
     * @var int 1/0 ... multiply/single
     */
    var $price_capacity_multiply;
    
    /**
     * If multiply deposit by reserved capacity.
     * 
     * @var int 1/0 ... multiply/single
     */
    var $deposit_capacity_multiply;
    
    /**
     * Count of booked units.
     * 
     * @var string
     */
    var $unit_count;
    
    /**
     * Discount for count of booked units.
     * 
     * @var string
     */
    var $unit_discount;
    /**
     * Price rezervation type
     * 
     * @var int
     */
    var $rezervation_type;
    
    /**
     * Start date validity - MySQL Date
     * 
     * @var string
     */
    var $date_up;
    
    /**
     * End date validity - MySQL Date
     * 
     * @var string
     */
    var $date_down;
    
    /**
     * Start time validity - MySQL Time
     * 
     * @var string
     */
    var $time_up;
    
    /**
     * End time validity - MySQL Time
     * 
     * @var string
     */
    var $time_down;
    
    /**
     * Price is valid on monday
     * 
     * @var boolean
     */
    var $monday;
    
    /**
     * Price is valid on tuesday
     * 
     * @var boolean
     */
    var $tuesday;
    
    /**
     * Price is valid on wednesday
     * 
     * @var boolean
     */
    var $wednesday;
    
    /**
     * Price is valid on thursday
     * 
     * @var boolean
     */
    var $thursday;
    
    /**
     * Price is valid on friday
     * 
     * @var boolean
     */
    var $friday;
    
    /**
     * Price is valid on saturday
     * 
     * @var boolean
     */
    var $saturday;
    
    /**
     * Price is valid on sunday
     * 
     * @var boolean
     */
    var $sunday;
    
    /**
     * In which week is price available.
     * 
     * @var int 0 - every, 1 - event, 2 - odd
     */
    var $week;
    
    /**
     * Time having to pay from order date
     *
     * @var int
     */
    var $cancel_time;

    /**
     * color for front-end calendar
     *
     * @var int
     */
    var $custom_color;
    
    /**
     * Constructor - init table name, primary key and database connector.
     * 
     * @param JDatabaseMySQL $db instance of database connector
     */
    function __construct(&$db)
    {
        parent::__construct('#__' . PREFIX . '_price', 'id', $db);
    }

    /**
     * Init empty object.
     */
    function init()
    {
        $this->id = 0;
        $this->subject = 0;
        $this->value = '';
        $this->deposit = '';
        $this->deposit_multiply = 0;
        $this->price_capacity_multiply = 1;
        $this->deposit_capacity_multiply = 1;
        $this->rezervation_type = 0;
        $this->unit_count = '';
        $this->unit_discount = '';
        $this->date_up = '';
        $this->date_down = '';
        $this->time_up = '';
        $this->time_down = '';
        $this->monday = 0;
        $this->tuesday = 0;
        $this->wednesday = 0;
        $this->thursday = 0;
        $this->friday = 0;
        $this->saturday = 0;
        $this->sunday = 0;
        $this->week = WEEK_EVERY;
        $this->cancel_time = '';
        $this->custom_color = '';
    }

    /**
     * Clean object data.
     */
    function clean()
    {
        $this->id = (int) $this->id;
        $this->subject = (int) $this->subject;
        $this->value = (float) $this->value;
        $this->deposit = (float) $this->deposit;
        $this->deposit_multiply = (int) $this->deposit_multiply;
        $this->price_capacity_multiply = (int) $this->price_capacity_multiply;
        $this->deposit_capacity_multiply = (int) $this->deposit_capacity_multiply;
        $this->rezervation_type = (int) $this->rezervation_type;
        $this->date_up = JString::trim((string) $this->date_up);
        $this->date_down = JString::trim((string) $this->date_down);
        $this->time_up = JString::trim((string) $this->time_up);
        $this->time_down = JString::trim((string) $this->time_down);
        $this->monday = (int) $this->monday;
        $this->tuesday = (int) $this->tuesday;
        $this->wednesday = (int) $this->wednesday;
        $this->thursday = (int) $this->thursday;
        $this->friday = (int) $this->friday;
        $this->saturday = (int) $this->saturday;
        $this->sunday = (int) $this->sunday;
        $this->week = (int) $this->week;
        $this->custom_color = JString::trim((string) $this->custom_color);
    }

    /**
     * Check before saving.
     */
    function check()
    {
        $this->clean();
        if (($result = parent::check())) {
            $result = false;
            $result = $this->value != 0.0 ? true : $result;
            $result = $this->rezervation_type != 0 ? true : $result;
            $this->date_up = AModel::date2save($this->date_up);
            $this->date_down = AModel::date2save($this->date_down);
            $this->time_up = AModel::time2save($this->time_up);
            $this->time_down = AModel::time2save($this->time_down);
        }
        return $result;
    }

    /**
     * Display object of Price with real data.
     * 
     * @param TablePrice $object  
     */
    function display(&$object)
    {
        $object->deposit = (int) $object->deposit == 0 ? '' : $object->deposit;
    }
    
    function loadBySubject($id)
    {
    	$this->_db->setQuery('');
    	return $this->_db->loadResult();
    }

    /**
     * @param TablePrice $price
     */
    function prepare(&$price)
    {
        $unitCounts = explode("\n", JString::trim(str_replace("\r\n", "\n", $price->unit_count)));
        $unitDiscounts = explode("\n", JString::trim(str_replace("\r\n", "\n", $price->unit_discount)));
        foreach ($unitCounts as $i => $unitCount)
            if (! JString::trim($unitCount))
                unset($unitCounts[$i]);
        foreach ($unitDiscounts as $i => $unitDiscount)
            if (! JString::trim($unitDiscount))
                unset($unitDiscounts[$i]);
        $countUnitCounts = count($unitCounts);
        $countUnitDiscounts = count($unitDiscounts);
        $count = $countUnitCounts > $countUnitDiscounts ? $countUnitCounts : $countUnitDiscounts;
        $price->discounts = array();
        for ($i = 0; $i < $count; $i ++) {
            $unitCount = isset($unitCounts[$i]) ? (int) $unitCounts[$i] : 0;
            $unitDiscount = isset($unitDiscounts[$i]) ? (float) $unitDiscounts[$i] : 0.0;
            $price->discounts[$unitCount] = $unitDiscount;
        }
        ksort($price->discounts);
    }
}

?>