<?php
/**
 * Reservations administration list template. 
 * Display browse table with advanced filter.
 * Set the toolbar for many operations with reservations.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	views
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewReservations */

JHTML::_('behavior.tooltip');
	
BookingHelper::setSubmenu(3);

JToolBarHelper::title(JText::_(COMPONENT_NAME).": ".JText::_('Reservations'), 'categories');
JToolBarHelper::editList();
JToolBarHelper::divider();
JToolBarHelper::deleteList('', 'trash', 'Trash');
JToolBarHelper::custom('restore', 'restore.png', 'restore_f2.png', 'Restore', true);
JToolBar::getInstance('toolbar')->appendButton('Confirm', 'Are you sure?', 'trash', 'Empty Trash', 'emptyTrash', false, true);
JToolBarHelper::divider();
JToolBarHelper::back();

?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<table>
		<tr>
			<td>
				<label for="filter_reservation-id" class="filter-search-lbl element-invisible"><?php echo JText::_('Res. #'); ?>: </label>
				<input type="text" name="filter_reservation-id" id="filter_reservation-id" onchange="this.form.submit();" value="<?php echo $this->escape($this->lists['reservation-id']); ?>" placeholder="<?php echo ISJ3 ? JText::_('Res. #') : ''; ?>" size="5" style="width: auto" />
   				<label for="filter_reservation-surname" class="filter-search-lbl element-invisible"><?php echo JText::_('Customer'); ?>: </label>
				<input type="text" name="filter_reservation-surname" id="filter_reservation-surname" onchange="this.form.submit();" value="<?php echo $this->escape($this->lists['reservation-surname']); ?>" placeholder="<?php echo ISJ3 ? JText::_('Customer') : ''; ?>" style="width: auto" size="15" />
				<label for="filter_items-subject_title" class="filter-search-lbl element-invisible"><?php echo JText::_('Item'); ?>: </label>
				<input type="text" name="filter_items-subject_title" id="filter_items-subject_title" onchange="this.form.submit();" value="<?php echo $this->escape($this->lists['items-subject_title']); ?>" placeholder="<?php echo ISJ3 ? JText::_('Item') : ''; ?>" style="width: auto" size="15" />
				<button onclick="this.form.submit();">
					<?php echo JText::_('Ok'); ?>
				</button>
				<button onclick="this.form.reset.value=1; this.form.submit();">
					<?php echo JText::_('Reset'); ?>
				</button>
				<?php 
					$options = array();
					$options[] = JHtml::_('select.option', '', '- ' . JText::_('Reservation Status') . ' -');
					$options[] = JHtml::_('select.option', RESERVATION_PRERESERVED, JText::_('Pre-reserved'));
					$options[] = JHtml::_('select.option', RESERVATION_ACTIVE, JText::_('Reserved'));
					$options[] = JHtml::_('select.option', RESERVATION_STORNED, JText::_('Cancelled'));
					$options[] = JHtml::_('select.option', RESERVATION_TRASHED, JText::_('Trashed'));
					$options[] = JHtml::_('select.option', RESERVATION_CONFLICTED, JText::_('Conflicted'));
					echo JHtml::_('select.genericlist', $options, 'filter_reservation_status', 'onchange="this.form.submit()"', 'value', 'text', $this->lists['reservation_status']);
				?>
				<?php
					$options = array();
					$options[] = JHtml::_('select.option', '', '- ' . JText::_('Payment Status') . ' -');
					$options[] = JHtml::_('select.option', RESERVATION_PENDING, JText::_('Unpaid'));
					$options[] = JHtml::_('select.option', RESERVATION_RECEIVE_DEPOSIT, JText::_('Deposit Paid'));
					$options[] = JHtml::_('select.option', RESERVATION_RECEIVE, JText::_('Paid in full'));
					echo JHtml::_('select.genericlist', $options, 'filter_payment_status', 'onchange="this.form.submit()"', 'value', 'text', $this->lists['payment_status']);
				?>
			</td>
			<td>
				<label for="filter_from" id="filter_from_label" class="element-invisible"><?php echo JText::_('From'); ?>: </label>
			</td>
			<td>
				<?php echo AHtml::getCalendar($this->lists['from'], 'filter_from', 'filter_from', ADATE_FORMAT_NORMAL, ADATE_FORMAT_NORMAL_CAL); ?>
			</td>
			<td>
				<label for="filter_to" id="filter_to_label" class="element-invisible"><?php echo JText::_('To'); ?>: </label>
			</td>
			<td>
				<?php echo AHtml::getCalendar($this->lists['to'], 'filter_to', 'filter_to', ADATE_FORMAT_NORMAL, ADATE_FORMAT_NORMAL_CAL); ?>
			</td>
		</tr>
	</table>
	<div id="editcell">
		<table class="adminlist table-striped table" cellspacing="1">
			<thead>
				<tr>
					<th width="1%" nowrap="nowrap">#</th>
					<th width="1%" nowrap="nowrap">
						<input type="checkbox" class="inputCheckbox" name="toggle" value="" onclick="checkAll(<?php echo count($this->items); ?>);" />
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JHTML::_('grid.sort', 'Res. #', 'id', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JHTML::_('grid.sort', 'Created', 'created', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th>
				        <?php echo JHTML::_('grid.sort', 'Customer', 'surname', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JText::_('Email'); ?>
					</th>
					<th>
				        <?php echo JHTML::_('grid.sort', 'Item', 'items-subject_title', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JHTML::_('grid.sort', 'Cap.', 'fullCapacity', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap" colspan="2">
				        <?php echo JHTML::_('grid.sort', 'From', 'from', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap" colspan="2">
				        <?php echo JHTML::_('grid.sort', 'To', 'to', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JHTML::_('grid.sort', 'Price', 'reservationFullPrice', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JText::_('Deposit'); ?>
					</th>
					<th width="1%">
				        <?php echo JHTML::_('grid.sort', 'Payment Status', 'paid', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%">
				        <?php echo JHTML::_('grid.sort', 'Reservation Status', 'state', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
				</tr>
			</thead>
			<tfoot>
    			<tr>
    				<td colspan="16">
    				    <?php echo $this->pagination->getListFooter(); ?>
    				</td>
    			</tr>
			</tfoot>
			<tbody>
				<?php if (! is_array($this->items) || ! count($this->items)) { ?>
					<tr>
						<td colspan="16">
							<?php echo JText::_('No items found.'); ?>
						</td>
					</tr>
				<?php 
					} else {
						foreach ($this->items as $i => $reservation) {
				    		/* @var $reservation TableReservation */
							
							list($isInvoice, $invoiceLink) = BookingHelper::getInvoiceLink($reservation->id);
							foreach ($this->reservedItems[$reservation->id] as $j => $reservedItem) {
								/* @var $reservedItem TableReservationItems */
							
				?>
				    	<tr class="row<?php echo $i % 2; ?>">
				    	<?php if ($j == 0) { ?>
				    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" align="right"><?php echo $this->pagination->getRowOffset($i); ?></td>
				    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" class="checkboxCell"><?php echo JHTML::_('grid.checkedout', $reservation, $i); ?></td>
				    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" align="right">
				    			<a href="<?php echo JRoute::_(ARoute::detail(CONTROLLER_RESERVATION, $reservation->id)); ?>" title="<?php echo $this->escape(JText::_('Show Reservation')); ?>::<?php echo $reservation->id; ?>" class="hasTip"><?php echo $reservation->id; ?></a>
				    			<?php if ($isInvoice==1) { ?>
				    				<a href="javascript:void(0)" title="<?php echo JText::_('Open invoice')?>" class="aIcon aIconInvoice aIconReservationInvoice" onclick="window.open('<?php echo $invoiceLink ?>','win2', 'status=yes,toolbar=yes,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');"></a>
				    			<?php } elseif ($isInvoice==2) { ?>
				    				<a href="javascript:void(0)" title="<?php echo JText::_('Invoice not available')?>::<?php echo JText::_($invoiceLink)?>" class="hasTip aIcon aIconInvoice aIconReservationInvoice"></a>
				    			<?php } ?>
				    		</td>
				    		<?php 
				    			$tip = '';
				    			if (AHtml::date($reservation->created, ADATE_FORMAT_LONG)) {
				    				$tip .= '<tr><th>' . JText::_('Created') . '</th>';
				    				$tip .= '<td>' . ($reservation->creator ? $reservation->creator : JText::_('UNREGISTERED CUSTOMER')) . '</td>';
				    				$tip .= '<td>' . AHtml::date($reservation->created, ADATE_FORMAT_LONG) . '</td></tr>';
				    			}
				    			if (AHtml::date($reservation->modified, ADATE_FORMAT_LONG)) {
				    				$tip .= '<tr><th>' . JText::_('Modified') . '</th>';
				    				$tip .= '<td>' . ($reservation->modifier ? $reservation->modifier : JText::_('UNREGISTERED CUSTOMER')) . '</td>';
				    				$tip .= '<td>' . AHtml::date($reservation->modified, ADATE_FORMAT_LONG) . '</td></tr>';
				    			}
				    			if ($tip)
				    				$tip = $this->escape('<table>' . $tip . '</table>');
				    		?>
							<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" align="right" nowrap="nowrap" <?php if ($tip) { ?>title="::<?php echo $tip; ?>" class="hasTip"<?php } ?>>							
				    			<?php echo AHtml::date($reservation->created, ADATE_FORMAT_LONG); ?></td>
				    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>">
				    			<?php 
				    				$tip = array(BookingHelper::formatName($reservation));
				    				if (JString::trim($reservation->telephone))
				    					$tip[] = JText::_('Phone') . ': ' . $reservation->telephone;
				    				if (JString::trim($reservation->email))
				    					$tip[] = JText::_('Email') . ': ' . $reservation->email;
				    				if ($reservation->customer) { 
								?>
				    				<a href="<?php echo JRoute::_(ARoute::detail(CONTROLLER_CUSTOMER, $reservation->customer)); ?>" title="<?php echo $this->escape(JText::_('Show Customer')); ?>::<?php echo $this->escape(implode('<br/>', $tip)); ?>" class="hasTip"><?php echo BookingHelper::formatName($reservation); ?></a>
				    			<?php } else { ?>
				    				<span title="<?php echo $this->escape(JText::_('Unregistered Customer')); ?>::<?php echo $this->escape(implode('<br/>', $tip)); ?>" class="hasTip"><?php echo BookingHelper::formatName($reservation); ?></span>
				    			<?php } ?>
				    		</td>
				    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>">
				    			<?php if ($reservation->email) { ?>
				    				<a href="mailto:<?php echo $this->escape($reservation->email); ?>" class="hasTip aIcon aIconEmail" title="<?php echo $this->escape(JText::_('Send E-mail to')); ?>::<?php echo $this->escape($reservation->email); ?>"></a>
				    			<?php } ?>
				    		</td>
				    	<?php } ?>
				    	<?php if (!$reservedItem) { ?>
				    		<td colspan="6"><?php echo JText::_('No item reserved'); ?></td>
				    	<?php } else { ?>
				    		<td>
				    			<a href="<?php echo JRoute::_(ARoute::edit(CONTROLLER_SUBJECT, $reservedItem->subject)); ?>" title="<?php echo $this->escape(JText::_('Show Item')); ?>::<?php echo $this->escape($reservedItem->subject_title); ?>" class="hasTip"><?php echo $reservedItem->subject_title; ?></a>
				    		</td>
				    		<td align="right" title="<?php echo $this->escape(JText::_('Reserved Capacity')); ?>::<?php echo $this->escape($reservedItem->capacity); ?>" class="hasTip"><?php echo $reservedItem->capacity; ?></td>
				    		<?php if ($reservedItem->rtype == RESERVATION_TYPE_PERIOD) { ?>
								<td nowrap="nowrap" align="center" width="1%" colspan="4"><?php echo JText::_('Periodic Reservation'); ?></td>
				    		<?php } else { ?>
				    			<td nowrap="nowrap" align="center" width="1%"><?php echo AHtml::date($reservedItem->from, ADATE_FORMAT_NORMAL); ?></td>
				    			<td nowrap="nowrap" align="center" width="1%"><?php echo AHtml::date($reservedItem->from, ATIME_FORMAT_SHORT); ?></td>
				    			<td nowrap="nowrap" align="center" width="1%"><?php echo AHtml::date($reservedItem->to, ADATE_FORMAT_NORMAL); ?></td>
				    			<td nowrap="nowrap" align="center" width="1%"><?php echo AHtml::date($reservedItem->to, ATIME_FORMAT_SHORT); ?></td>
				    		<?php } ?>
				        <?php } ?>
				        <?php if ($j==0){ ?>
				    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" nowrap="nowrap" align="right"><?php echo BookingHelper::displayPrice($reservation->reservationFullPrice); ?></td>
				    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" nowrap="nowrap" align="right" title="<?php echo $this->escape(JText::_('Expiration'))?>::<?php echo $this->escape($this->depositExpires[$reservation->id]); ?>" class="hasTip" style="padding-left: 20px; background-repeat: no-repeat; background-image: url('/components/com_booking/assets/images/icon-16-notice-note.png'); background-position: left center;"><?php echo BookingHelper::displayPrice($reservation->reservationFullDeposit); ?></td>
				    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" align="center">
				    			<?php switch ($reservation->paid) {
            							case RESERVATION_PENDING:
            								if (! JTable::isCheckedOut($this->user->get('id'), $reservation->checked_out)) { ?>
            									<span class="editlinktip hasTip aIcon aIconExpired" title="<?php echo $this->escape(JText::_('Unpaid')) . '::' . $this->escape(JText::_('Click to mark as deposit paid')); ?>" onclick="listItemTask('cb<?php echo $i; ?>','receiveDeposit')" style="cursor: pointer">&nbsp;</span>
            								<?php } else { ?>			
            									<span class="editlinktip hasTip aIcon aIconExpired" title="<?php echo $this->escape(JText::_('Unpaid')); ?>">&nbsp;</span>
            								<?php }
            								break;
            							case RESERVATION_RECEIVE_DEPOSIT:
            								if (! JTable::isCheckedOut($this->user->get('id'), $reservation->checked_out)) { ?>
            									<span class="editlinktip hasTip aIcon aIconPending" title="<?php echo $this->escape(JText::_('Deposit Paid')) . '::' . $this->escape(JText::_('Click to mark as paid in full')) ?>" onclick="listItemTask('cb<?php echo $i; ?>','receive')" style="cursor: pointer">&nbsp;</span>
            								<?php } else { ?>			
            									<span class="editlinktip hasTip aIcon aIconPending" title="<?php echo $this->escape(JText::_('Deposit Paid')); ?>">&nbsp;</span>
            								<?php }
            								break;
            							case RESERVATION_RECEIVE:
            								if (! JTable::isCheckedOut($this->user->get('id'), $reservation->checked_out)) { ?>
            									<span class="editlinktip hasTip aIcon aIconPublished" title="<?php echo $this->escape(JText::_('Paid in full')) . '::' . $this->escape(JText::_('Click to mark as unpaid')); ?>" onclick="listItemTask('cb<?php echo $i; ?>','unreceive')" style="cursor: pointer">&nbsp;</span>
            								<?php } else { ?>			
            									<span class="editlinktip hasTip aIcon aIconPublished" title="<?php echo $this->escape(JText::_('Paid in full')); ?>">&nbsp;</span>
            								<?php }
            								break;
        							} ?>
				    		</td>
				    		<td rowspan="<?php echo count($this->reservedItems[$reservation->id]); ?>" align="center">
				    			<?php 
        							switch ($reservation->state) {
										case RESERVATION_PRERESERVED:
							            	if (! JTable::isCheckedOut($this->user->get('id'), $reservation->checked_out)) { ?>
            									<span class="editlinktip hasTip aIcon aIconNew" title="<?php echo $this->escape(JText::_('Pre-reserved')) . '::' . $this->escape(JText::_('Click to mark as active')); ?>" onclick="listItemTask('cb<?php echo $i; ?>','active')" style="cursor: pointer">&nbsp;</span>			
            								<?php } else { ?>	
            									<span class="editlinktip hasTip aIcon aIconNew" title="<?php echo $this->escape(JText::_('Pre-reserved')); ?>">&nbsp;</span>
            								<?php }
							                break;
							            case RESERVATION_ACTIVE:
							            	if (! JTable::isCheckedOut($this->user->get('id'), $reservation->checked_out)) { ?>
            									<span class="editlinktip hasTip aIcon aIconTick" title="<?php echo $this->escape(JText::_('Reserved')) . '::' . $this->escape(JText::_('Click to mark as cancelled')); ?>" onclick="listItemTask('cb<?php echo $i; ?>','storno')" style="cursor: pointer;">&nbsp;</span>			
            								<?php } else { ?>	
            									<span class="editlinktip hasTip aIcon aIconTick" title="<?php echo $this->escape(JText::_('Reserved')); ?>">&nbsp;</span>
            								<?php }
            								break;
							            case RESERVATION_STORNED:
							            	if (! JTable::isCheckedOut($this->user->get('id'), $reservation->checked_out)) { ?>
            									<span class="editlinktip hasTip aIcon aIconUnpublish" title="<?php echo $this->escape(JText::_('Cancelled')) . '::' . $this->escape(JText::_('Click to mark as trashed')); ?>" onclick="listItemTask('cb<?php echo $i; ?>','trash')" style="cursor: pointer">&nbsp;</span>			
            								<?php } else { ?>	
            									<span class="editlinktip hasTip aIcon aIconUnpublish" title="<?php echo $this->escape(JText::_('Cancelled')); ?>">&nbsp;</span>
            								<?php }
							                break;
							            case RESERVATION_TRASHED:
							            	if (! JTable::isCheckedOut($this->user->get('id'), $reservation->checked_out)) { ?>
            									<span class="editlinktip hasTip aIcon aIconTrash" title="<?php echo $this->escape(JText::_('Trashed')) . '::' . $this->escape(JText::_('Click to mark as conflicted')); ?>" onclick="listItemTask('cb<?php echo $i; ?>','conflict')" style="cursor: pointer">&nbsp;</span>			
            								<?php } else { ?>	
            									<span class="editlinktip hasTip aIcon aIconTrash" title="<?php echo $this->escape(JText::_('Trashed')); ?>">&nbsp;</span>
            								<?php }
							                break;
							            case RESERVATION_CONFLICTED:
                							if (! JTable::isCheckedOut($this->user->get('id'), $reservation->checked_out)) { ?>
                            					<span class="editlinktip hasTip aIcon aIconNotice" title="<?php echo $this->escape(JText::_('Conflicted')) . '::' . $this->escape(JText::_('Click to mark as pre-reserved')); ?>" onclick="listItemTask('cb<?php echo $i; ?>','prereserved')" style="cursor: pointer">&nbsp;</span>			
                            				<?php } else { ?>	
                            					<span class="editlinktip hasTip aIcon aIconNotice" title="<?php echo $this->escape(JText::_('Conflicted')); ?>">&nbsp;</span>
                            				<?php }
                							 break;
        							} ?>
				    		</td>
				    		<?php } ?>
				    	</tr>
				    <?php 
							}
				    	}
					}
					?>
			</tbody>
		</table>
		<table align="center">
			<tr align="center">
				<td class="aIconLegend aIconNew"><?php echo $this->escape(JText::_('Pre-reserved')); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconTick"><?php echo $this->escape(JText::_('Reserved')); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconUnpublish"><?php echo $this->escape(JText::_('Cancelled')); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconTrash"><?php echo $this->escape(JText::_('Trashed')); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconNotice"><?php echo $this->escape(JText::_('Conflicted')); ?></td>
			</tr>
		</table>
		<div class="clr"></div>
		<table align="center">
			<tr align="center">
				<td class="aIconLegend aIconExpired"><?php echo $this->escape(JText::_('Unpaid')); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconPending"><?php echo $this->escape(JText::_('Deposit Paid')); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconPublished"><?php echo $this->escape(JText::_('Paid in full')); ?><span>&nbsp;</span></td>
			</tr>
		</table>
	</div>
	<input type="hidden" name="option" value="<?php echo OPTION; ?>"/>
	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="reset" value="0"/>
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_RESERVATION; ?>"/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>"/>
	<input type="hidden" name="<?php echo SESSION_TESTER; ?>" value="1"/>
	<?php echo JHTML::_('form.token'); ?>
</form>	