<?php

/**
 * Customer detail form template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	views
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

?>
<h1><?php echo JText::_('Customer Profile'); ?></h1>
<?php
if (isset($this->subject)) {
?>
	<div class="bookingToolbar">
		<a class="aIconToolBack tool back" href="<?php echo JRoute::_(ARoute::view(VIEW_SUBJECT, $this->subject->id, $this->subject->alias)); ?>" title="<?php echo $this->escape(JText::sprintf('Back to object', $this->subject->title)); ?>"><?php echo $this->escape(JText::sprintf('Back to object', $this->subject->title)); ?></a>
		<div class="clr">&nbsp;</div>
	</div>
<?php	
}
	$name = BookingHelper::formatName($this->customer);
	$company = JString::trim($this->customer->company);
	if ($name || $company) {
?>
		<div>
			<fieldset>
		    	<legend><?php echo JText::_('Details'); ?></legend>
		    	<table>
		    		<?php 
		    			if ($name) {
		    		?>
		    				<tr>
		    					<td class="key"><?php echo JText::_('Name'); ?>:</td>
			    				<td><?php echo $name; ?></td>
			    			</tr>
		    		<?php 
		    			}
		    			if ($company) {
		    		?>
		    				<tr>
		    					<td class="key"><?php echo JText::_('Company'); ?>:</td>
			    				<td><?php echo $company; ?></td>
			    			</tr>
		    		<?php 
		    			}
		    		?>
		    		<?php 
		    			if (is_array(AFactory::getConfig()->rsExtra)) {
		    				foreach (AFactory::getConfig()->rsExtra as $field) { 
					?>		 
		    					<tr>
		    						<td class="key"><?php echo $field['title']; ?>:</td>
			   						<td><?php echo AUtils::getArrayValue($this->customer->fields, $field['name'] . '.value'); ?></td>
			   					</tr>
		   			<?php 
							}
						} 
					?>
				</table>
		    </fieldset>
<?php 
	}
	$address = BookingHelper::formatAddress($this->customer);
	$telephone = JString::trim($this->customer->telephone);
	$fax = JString::trim($this->customer->fax);
	if ($address || $telephone || $fax) {
?>
		    <fieldset>
		    	<legend><?php echo JText::_('Contact'); ?></legend>
		    	<table>
		    		<?php 
		    			if ($address) {
		    		?>
		    				<tr>
		    					<td class="key"><?php echo JText::_('Address'); ?>:</td>
			    				<td><?php echo BookingHelper::formatAddress($this->customer); ?></td>
			    			</tr>
		    		<?php 
		    			}
		    			if ($telephone) {
		    		?>
		    				<tr>
		    					<td class="key"><?php echo JText::_('Phones'); ?>:</td>
			    				<td><?php echo $this->customer->telephone; ?></td>
			    			</tr>
		    		<?php 
		    			}
		    			if ($fax) {
		    		?>
		    				<tr>
		    					<td class="key"><?php echo JText::_('Fax'); ?>:</td>
			    				<td><?php echo $this->customer->fax; ?></td>
			    			</tr>
		    		<?php 
		    			}
		    		?>
		    	</table>
		    </fieldset>
<?php 
	}
?>
	<fieldset>
        <legend><?php echo JText::_('System data'); ?></legend>
        <table>
        	<tr>
        		<td class="key"><?php echo JText::_('User'); ?>:</td>
	        	<td>
    	   			<a href="<?php echo ARoute::editUser($this->user->id); ?>" title="<?php echo JText::_('Edit user acount'); ?>"><?php echo $this->user->username; ?></a>
    			</td>
    		</tr>	
       		<tr>
       			<td class="key"><?php echo JText::_('Email'); ?>:</td>
	       		<td><?php echo BookingHelper::getEmailLink($this->user); ?></td>
	       	</tr>
       		<tr>
       			<td class="key"><?php echo JText::_('Register date'); ?>:</td>
	        	<td><?php echo AHtml::date($this->user->registerDate, ADATE_FORMAT_LONG); ?></td>
	        </tr>
        		<tr>
        			<td class="key"><?php echo JText::_('Last visit date'); ?>:</td>
		       		<td><?php echo AHtml::date($this->user->lastvisitDate, ADATE_FORMAT_LONG); ?></td>
	       	</tr>
        </table>
    </fieldset>
	<?php if (JFactory::getUser()->id == $this->user->id) : ?>
		<a href="<?php echo JRoute::_(ARoute::edit(CONTROLLER_CUSTOMER)); ?>">
			<?php echo JText::_('Edit Profile'); ?></a>
	<?php endif; ?>
</div>	