<?php 

/**
 * Weekly calendar template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');

$config = AFactory::getConfig();

//$userCanReserve = $this->customer->id || $config->unRegisteregCanReserve;
$userCanReserve = $this->userCanReserve;

$this->days = &BookingHelper::getWeekCalendar($this->subject, ($this->setting = new BookingCalendarSetting()), $this->isAdmin ? $this->calendarnumweeks * 7 : 'week', $this->isAdmin);

$countDays = count($this->days->calendar); 
/* @var $countDays int days count */

// saved translated text into properties for optimization
$noAvailableReservations = JText::_('No available reservations');
$isReserved = JText::_('Is reserved');
$bookFullDay = JText::_('Book full day');
$leave = JText::_('Leave');


//load csss colors for prices
//-----------------------
$colors = array();
foreach($this->days->prices as $prices)
{
	foreach($prices->prices as $price)
	{
		$colors[] = $price->custom_color;
	}
}
$string = '';
foreach($colors as $i=>$color)
{
	$string .= "#bookSetting .price".$i." {	background-color: ".$color.";} ";
}
JFactory::getDocument()->addStyleDeclaration( $string );
//-------------------------

if ($countDays) {  
	
?>
  	<div class="weeklyCalendar">
    	<?php 
    		echo $this->loadTemplate('bookitform');
    	?>
    	<div class="clr"></div>
    	<?php 
    		echo $this->loadTemplate('prices');
    		if (!$this->isAdmin && $config->quickNavigator) { // customer has predefined navigation only
    	?>
			<div class="clr"></div>
			<div id="caltop" class="quickNavigator">
				<label for="iweek"><?php echo JText::_('Select week'); ?></label>
				<?php echo AHtml::getWeekSelect('iweek', $this->setting->week, $this->setting->year, $config->calendarDeepWeek, 'onchange="Calendars.weekNavigation(this.value)"'); ?>
			</div>
		<?php 
    		}
    		if ($this->isAdmin) { // admin has unlimited # of weeks to show
		?>
				<div class="clr"></div>
				<div id="caltop" class="quickNavigator">
					<label for="calendarnumweeks" style="padding-left: 20px"><?php echo JText::_('Num Weeks Visible'); ?></label>
					<input type="text" name="calendarnumweeks" id="calendarnumweeks" value="<?php echo $this->calendarnumweeks; ?>" size="1" onchange="this.form.submit()" />
					<button><?php echo JText::_('Submit'); ?></button>
				</div>		
		<?php 
			}
		foreach ($this->days->calendar as $j => $firstDay) {
			/* @var $firstDay BookingDay */
			
			$pricesPositions = array();
			foreach ($firstDay->boxes as $bkey => $box) {
				/* @var $box BookingTimeBox */
				$pricePosition = 0;
				foreach ($box->services as $skey => $service)
					/* @var $service BookingService */
					if (($service->canReserve = !(!in_array($service->rtypeId, $this->lists['rids']) || (!$service->canReserve)))) {
						if (!isset($pricesPositions[$service->priceIndex]) || $pricesPositions[$service->priceIndex] < $pricePosition)
							$pricesPositions[$service->priceIndex] = $pricePosition;
						$pricePosition++;	
						if ($service->rtype == RESERVATION_TYPE_DAILY)
							$box->haveDailyService = true;
					}
			}
	?>
			<div class="boxesDay">
				<h2><?php echo AHtml::date($firstDay->date, ADATE_FORMAT_NICE); ?></h2>
				<table class="boxes">
					<tr>
						<th>
							<span class="time"><?php echo JText::_('From - to'); ?></span>
							<?php 
								if (!$this->isAdmin && $this->subject->display_who_reserve) { 
							?>
									<span class="customer"><?php echo JText::_('Customer'); ?></span>
							<?php 
								} 
							?>
						</th>
					</tr>
					<?php 
						$bi = 0;
						$bc = count($firstDay->boxes);
						foreach ($firstDay->boxes as $box) {
							/* @var $box BookingTimeBox */
							$bi++;
							$usedBoxes = 0;
							//if ($box->rtype == RESERVATION_TYPE_DAILY && !$box->haveDailyService)
								//continue;
								
							$closedClassName = $box->closed ? ' closed hasTip' : '';
							$title = $box->closed ? $this->escape($box->closingDayTitle).'::'.$this->escape($box->closignDayText) : '';
					?>
							<tr>	
								<td class="box<?php echo $closedClassName; ?><?php if ($box->engaged) { ?> reserved<?php if($config->colorCalendarFieldReserved){ echo '"style="background-color:'.$config->colorCalendarFieldReserved; } }else if($config->colorCalendarFieldFree){ echo '" style="background-color:'.$config->colorCalendarFieldFree; } ?>" title="<?php echo $title; ?>">
									<span class="time"><?php echo $box->rtype == RESERVATION_TYPE_DAILY ? $bookFullDay : ($box->fromTime . ' - ' . $box->toTime); ?></span>
									<?php					
										foreach ($box->services as $i => $service) {
											/* @var $service BookingService */
											$emptyPricesCount = isset($pricesPositions[$service->priceIndex]) ? ($pricesPositions[$service->priceIndex] - $usedBoxes) : 0;
											for ($i = 0; $i < $emptyPricesCount; $i++) {
									?>
												<span class="price"></span>
									<?php
											} 
											$usedBoxes += $emptyPricesCount + 1;
											if ($service->canReserve && !$box->closed) {
									?>
												<span class="price price<?php echo $service->priceIndex; ?>" id="<?php echo $service->idShort; ?>">
									<?php
													if ($userCanReserve)
														ADocument::setBoxParams($service, $service->i, $bc, $bi);
													if ($this->subject->display_capacity && $this->subject->total_capacity>1)
														echo ($this->subject->total_capacity - $service->alreadyReserved);
									?>
												</span>
									<?php
											} else {
									?>			
												<span class="price"></span>
									<?php		
											}
										}
										if (!$box->closed) {
											if ($this->subject->display_who_reserve && isset($box->customerName) && count($box->customerName)) {
												if(strip_tags(json_encode($box->customerName)) != json_encode($box->customerName)){
									?>
														<span class="customer" <?php if($config->colorCalendarBoxReserved){ echo 'style="background-color:'.$config->colorCalendarBoxReserved.'"'; }?>><?php echo AHtml::showUserInfo($box->customerName); ?></span>
									<?php 
											} else { 
									?>
														<span class="price hasTip customer" title="<?php echo AHtml::showUserInfo($box->customerName); ?>" <?php if($config->colorCalendarBoxReserved){ echo 'style="background-color:'.$config->colorCalendarBoxReserved.'"'; }?>> </span>
									<?php
		        								} 
											}
											if ($this->isAdmin && !empty($box->customerName)) { // admin sees customer info always
												foreach ($box->customerName as $info) {
									?>
													<span class="time"><a href="<?php echo JRoute::_(ARoute::detail(CONTROLLER_RESERVATION, $info['reservation_id'])); ?>" title="<?php echo $this->escape(JText::_('Show Reservation')); ?>::<?php echo $info['reservation_id']; ?>" class="hasTip"><?php echo $info['name']; ?></a></span><br/>
									<?php
												} 
											}
										}
									?>
								</td>
							</tr>
					<?php 
						} 
					?>
				</table>
			</div>			
		<?php 
				if (($j + 1) % 7 == 0) { // after every week wrap page
		?>	
					<div class="clr"></div>
		<?php 	
				}
			} 
		?>
		<div class="clr"></div>
  </div>
<?php } else { ?>
	<p><?php echo $noAvailableReservations; ?></p>
<?php } ?>
<div class="calendarPagination">
	<?php if (! $this->setting->onCurrentWeek || $this->isAdmin) { // admin can browse to the past, customer can browse to the future only ?>
		<span class="previousPage">
			<a href="javascript:Calendars.weekNavigation(<?php echo $this->setting->previousWeek; ?>,<?php echo $this->setting->previousYear; ?>)"><?php echo JText::_('Previous week'); ?></a>
		</span>
	<?php } ?>
	<span class="currentPage">
		<a href="javascript:Calendars.weekNavigation(<?php echo $this->setting->currentWeek; ?>,<?php echo $this->setting->currentYear; ?>)"><?php echo JText::_('Current week'); ?></a>
	</span>
	<?php if (! $this->setting->lastAllowPage) { ?>
		<span class="nextPage">
			<a href="javascript:Calendars.weekNavigation(<?php echo $this->setting->nextWeek; ?>,<?php echo $this->setting->nextYear; ?>)"><?php echo JText::_('Next week'); ?></a> 
		</span>
	<?php } ?>
</div>