<?php
/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingModelUpgrade */

require_once dirname(__FILE__) . '/reinstall.php';

$db = JFactory::getDbo();

require_once(dirname(__FILE__).'/../admin/install.booking.php');
BookingInstaller::update(dirname(__FILE__).'/../admin/sql/install.mysql.utf8.sql');

$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'terms_of_contract'");
$termsOfContract = $db->Quote($db->loadResult());
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'terms_of_privacy'");
$termsOfPrivacy = $db->Quote($db->loadResult());

$db->setQuery('TRUNCATE TABLE #__booking_article');
$db->query();

$db->setQuery("INSERT INTO `#__booking_article` (`id`, `title`, `text`, `checked_out`, `checked_out_time`) VALUES
(1, 'Terms of Contract', $termsOfContract, 0, '0000-00-00 00:00:00'),
(2, 'Terms of Privacy', $termsOfPrivacy, 0, '0000-00-00 00:00:00')");
$db->query();

JTable::addIncludePath(dirname(__FILE__) . '/../admin/tables');
$email = JTable::getInstance('Email', 'Table');
/* @var $email TableEmail */

$email->id = null;
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_emails_subject_customer'");
$email->subject = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_body_customer'");
$email->body = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_mode'");
$email->mode = $db->loadResult() == 'plain_text' ? 0 : 1;
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_registration_client', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id");
$db->query();

$email->id = null;
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_emails_subject_admin'");
$email->subject = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_body_admin'");
$email->body = $db->loadResult();
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_registration_manager', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id");
$db->query();

$email->id = null;
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_emails_subject_customer'");
$email->subject = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_body_customer'");
$email->body = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_mode'");
$email->mode = $db->loadResult() == 'plain_text' ? 0 : 1;
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_reservation_client', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id");
$db->query();

$email->id = null;
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_emails_subject_administrator'");
$email->subject = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_body_admin'");
$email->body = $db->loadResult();
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_reservation_manager', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id");
$db->query();

$email->id = null;
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_change_status_emails_subject_customer'");
$email->subject = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_change_status_body_customer'");
$email->body = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_change_status_mode'");
$email->mode = $db->loadResult() == 'plain_text' ? 0 : 1;
$email->store();
$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_status_client', $email->id) ON DUPLICATE KEY UPDATE `value` = $email->id");
$db->query();

$managers = array();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_registrations_emails_from'");
$managers[] = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'send_notifications_emails_from'");
$managers[] = $db->loadResult();

$managers = implode(',',array_filter(array_map('trim', $managers), 'strlen'));

$db->setQuery("INSERT INTO `#__booking_config` (`key`, `value`) VALUES ('mailing_manager', $managers) ON DUPLICATE KEY UPDATE `value` = $managers");
$db->query();

$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'locations_pickup'");
$locationsPickup = $db->loadResult();
$db->setQuery("SELECT value FROM #__booking_config WHERE `key` = 'locations_dropoff'");
$locationsDropoff = $db->loadResult();

$locationsPickup = str_replace(array("\r\n", "\n\r"), "\n", $locationsPickup);
$locationsDropoff = str_replace(array("\r\n", "\n\r"), "\n", $locationsDropoff);

$locationsPickup = explode("\n", $locationsPickup);
$locationsDropoff = explode("\n", $locationsDropoff);

$locationsPickup = array_map('trim', $locationsPickup);
$locationsDropoff = array_map('trim', $locationsDropoff);

$locationsPickup = array_filter($locationsPickup, 'strlen');
$locationsDropoff = array_filter($locationsDropoff, 'strlen');

foreach ($locationsPickup as $locationPickup) {
	$db->setQuery("INSERT INTO #__booking_location (title, pick_up, drop_off) VALUES (".$db->Quote($locationPickup).", 1, 0)");
	$db->query();
}

foreach ($locationsDropoff as $locationDropoff) {
	$db->setQuery("INSERT INTO #__booking_location (title, pick_up, drop_off) VALUES (".$db->Quote($locationDropoff).", 0, 1)");
	$db->query();
}
