<?php

/**
 * Popup element to select subject.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  elements
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHTML::_('behavior.modal', 'a.modal');

jimport('joomla.html.parameter.element');

class JElementSubject extends JElement
{

    /**
     * Display button to open popup window. 
     * 
     * @param string $name
     * @param mixed  $value
     * @param mixed  $node
     * @param string $control_name
     */
    function fetchElement($name, $value, $node, $control_name = null)
    {
        if ($node instanceof JSimpleXMLElement) {
            $type = $node->attributes('use_type');
        } else {
            $type = (int) $node;
        }
        
        if (! class_exists('BookingModelSubject')) {
            if (! class_exists('AImporter')) {
                include_once (JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_booking' . DS . 'helpers' . DS . 'importer.php');
                include_once (JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_booking' . DS . 'helpers' . DS . 'html.php');
                include_once (JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_booking' . DS . 'helpers' . DS . 'model.php');
            }
            AImporter::defines();
            AImporter::model('subject');
            AImporter::table('subject');
        }
        
        $subjectModel = new BookingModelSubject();
        $subjectModel->setId($value);
        $subject = $subjectModel->getObject();
        
        if ($control_name) {
            $fieldName = $control_name . '[' . $name . ']';
        } else {
            $fieldName = $name;
        }
        
        $id = 'subject_id';
        $nameId='subject_name';
        
        if (preg_match('#^items\[([^\]]+)\]\[[^\]]+\]$#',$name,$matches)) { //if more subject selects on page (array)
        	$id='items['.$matches[1].']['.$id.']';
        	$nameId='items['.$matches[1].']['.$nameId.']';
        }
        
        $html = '<div style="float: left; height: 19px; padding-top: 3px;">';
        $html .= '<input style="color: #000000;" size="30" type="text" id="'.$nameId.'" value="' . htmlspecialchars($subject->title, ENT_QUOTES, ENCODING) . '" disabled="disabled" />';
        $html .= '</div>';
        $html .= '<div class="button2-left">';
        $html .= '<div class="blank">';
        $html .= '<a class="modal" title="' . JText::_('Select a Subjects') . '"  href="' . ARoute::browse(CONTROLLER_SUBJECT, true, '&type=' . $type.'&input='.$id) . '" rel="{handler: \'iframe\', size: {x: 1000, y: 600}}">' . JText::_('Select') . '</a>';
        $html .= '<a title="' . JText::_('Reset') . '"  href="#" onclick="document.getElementById(\'' . $id . '\').value=0;document.getElementById(\'' . $nameId . '\').value=\'\';">' . JText::_('Reset') . '</a>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '<input type="hidden" id="'.$id.'" name="' . $fieldName . '" value="' . $value . '" />';
        return $html;
    }
}

?>