<?php 

/**
 * Display module with information about logged customer
 * and URLs to create new registration, login exists customer,
 * display customers profile and display customers reservations. 
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  modules
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

$user = &JFactory::getUser();
/* @var $user JUser */

$modelCustomer = new BookingModelCustomer();
$modelCustomer->setIdByUserId();

$isAdmin = $modelCustomer->isAdmin();

?>
<div class="customersInfo<?php echo $moduleclassSfx; ?>">
	<?php 
	if ($user->id) { 
		 if ($modelCustomer->getId()) { 
	?> 
			<div class="customersName">
				<strong><?php echo JText::_('Customer'); ?>: </strong>
				<a href="<?php echo JRoute::_(ARoute::editUser()); ?>" title="<?php echo JText::_('Edit User Acount'); ?>">
					<?php echo $user->username; ?>
				</a>
			</div>
			<div class="customersProfile">
				<a href="<?php echo JRoute::_(ARoute::view(VIEW_CUSTOMER)); ?>" title="<?php echo JText::_('Display cutomer profile'); ?>">
					<?php echo JText::_('Profile'); ?>
				</a>
			</div>
			<?php if(JFactory::getApplication()->getUserState('com_booking.user_reservation_items')){ ?>
			<div class="customersCurrentReservation">
				<a href="<?php echo JRoute::_(ARoute::viewlayout(VIEW_RESERVATION, 'form')); ?>" title="<?php echo JText::_('Display current reservation'); ?>">
					<?php echo JText::_('Current Reservation'); ?>
				</a>
			</div>
			<?php } ?>
			<div class="customersReservations">
				<a href="<?php echo JRoute::_(ARoute::viewlayout(VIEW_RESERVATIONS, 'customer')); ?>" title="<?php echo JText::_('Display customer reservations'); ?>">
					<?php echo JText::_('Reservations'); ?>
				</a>
			</div>
		<?php 
		 	} elseif ($isAdmin) { 
		 ?>
			<div class="loggedAdmin">
				<strong><?php echo JText::_('Logged Administrator'); ?></strong>
				<a href="<?php echo JRoute::_(ARoute::editUser()); ?>" title="<?php echo JText::_('Edit User Acount'); ?>">
					<?php echo $user->username; ?>
				</a>
			</div>
			<div class="reservations">
				<a href="<?php echo JRoute::_(ARoute::viewlayout(VIEW_RESERVATIONS, 'admin')); ?>" title="<?php echo JText::_('Manage reservations'); ?>">
					<?php echo JText::_('Manage Reservations'); ?>
				</a>
			</div>
		<?php } else { ?>
			<div class="noLoggedCustomerOrAdmin">
				<strong><?php echo JText::_('No logged Customer or Admin'); ?></strong>
				<a href="<?php echo JRoute::_(ARoute::editUser()); ?>" title="<?php echo JText::_('Edit User Acount'); ?>">
					<?php echo $user->username; ?>
				</a>
			</div>
		<?php } ?>
			<div class="customerLogout">
				<a href="<?php echo JRoute::_(ARoute::logoutUser()); ?>" title="<?php echo JText::_('Logout customer from system'); ?>">
					<?php echo JText::_('Logout'); ?>				
				</a>
			</div>
	<?php } else { ?>
		<div class="customerNoLogged">
			<strong><?php echo JText::_('Customer no logged'); ?></strong>
		</div>
		<div class="customerLogin">
			<a href="<?php echo JRoute::_(ARoute::loginUser()); ?>" title="<?php echo JText::_('Login cutomer'); ?>">
				<?php echo JText::_('Login'); ?>
			</a>
		</div>
		<div class="customerRegistration">
			<a href="<?php echo JRoute::_(ARoute::edit(CONTROLLER_CUSTOMER)); ?>" title="<?php echo JText::_('Create new customer registration'); ?>">
				<?php echo JText::_('New registration'); ?>
			</a>
		</div>
	<?php } ?>
</div>