<?php

/**
 * Component helper
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  helpers 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class BookingHelper
{

		/**
     * Get Booking info from xml
     * 
     */
		function getBookingInfo()
		{
			static $info;
			if( !isset($info) ) {
				$info = array();
	      
				//$xml = JFactory::getXMLParser('Simple');
				//$xml = simplexml_load_file($data, $class)
	
				$xmlFile = JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_booking' . DS . 'booking.xml';
				$xml = simplexml_load_file($xmlFile);
	
				if (file_exists($xmlFile)) {
					$element = & $xml->version;
					$info['version'] = $element ? $element : '';

					$element = & $xml->creationdate;
					$info['creationDate'] = $element ? $element : '';

					$element = & $xml->author;
					$info['author'] = $element ? $element : '';

					$element = & $xml->authoremail;
					$info['authorEmail'] = $element ? $element : '';

					$element = & $xml->authorurl;
					$info['authorUrl'] = $element ? $element : '';

					$element = & $xml->copyright;
					$info['copyright'] = $element ? $element : '';

					$element = & $xml->license;
					$info['license'] = $element ? $element : '';

					/*$element = & $xml->description;
					$info['description'] = $element ? $element : '';*/

					$element = & $xml->forum;
					$info['forum'] = $element ? $element : '';

					$element = & $xml->paidsupport;
					$info['paidsupport'] = $element ? $element : '';

					$element = & $xml->productpage;
					$info['productpage'] = $element ? $element : '';
					
					$element = & $xml->documentation;
					$info['documentation'] = $element ? $element : '';
					
					$element = & $xml->faq;
					$info['faq'] = $element ? $element : '';
					
					$element = & $xml->video;
					$info['video'] = $element ? $element : '';
				}
			}
	
			return $info;
		}
		
		/**
     * Set pages submenus.
     * 
     * @param $set
     */
    function setSubmenu($set)
    {	 
    	AImporter::helper('route');
    	JSubMenuHelper::addEntry(JText::_('Control Panel'), ARoute::root(), $set == 0);
   		JSubMenuHelper::addEntry(JText::_('Reservations'), ARoute::view(VIEW_RESERVATIONS), $set == 3);
   		JSubMenuHelper::addEntry(JText::_('Bookable Items'), ARoute::view(VIEW_SUBJECTS), $set == 1);
   		JSubMenuHelper::addEntry(JText::_('Templates'), ARoute::view(VIEW_TEMPLATES), $set == 5);
   		JSubMenuHelper::addEntry(JText::_('Admins'), ARoute::view(VIEW_ADMINS), $set == 6);
   		JSubMenuHelper::addEntry(JText::_('Customers'), ARoute::view(VIEW_CUSTOMERS), $set == 2);
   		JSubMenuHelper::addEntry(JText::_('Configuration'), ARoute::view(VIEW_CONFIG), $set == 4);
    }

    /**
     * Get subjects model class for support database operations
     * 
     * @return BookingModelSubjects
     */
    function getSubjectsModel()
    {
        if (! class_exists('BookingModelSubjects')) {
            AImporter::model('subjects');
        }
        return new BookingModelSubjects();
    }

    /**
     * Get selectbox to choose parent in editing form.
     * 
     * @param int $select selected parent
     * @param int $ignore parent id whitch mustnt't in list
     * @return string HTML code
     */
    function getParentsSubjectSelectBox($select, $ignore)
    {
        $model = BookingHelper::getSubjectsModel();
        $parents = $model->loadShortListByIds();
        $code = BookingHelper::getSubjectParentSelectBox('parent', 'ROOT', $parents, array($ignore), $select, false, ' class="fullWidth" size="10" ');
        $code = str_replace(array('<sup>' , '</sup>'), '', $code);
        return $code;
    }

    /**
     * Get selectbox to choose subject in tree format.
     * 
     * @param $select selected value
     * @param $field field name
     * @param $autoSubmit auto submit form on change
     * @return string HTML code
     */
    function getSubjectSelectBox($select, $field = 'subject', $autoSubmit = false)
    {
        $model = BookingHelper::getSubjectsModel();
        $lists = array('limit' => null , 'limitstart' => null , 'state' => null , 'access' => null , 'order' => 'ordering' , 'order_Dir' => 'ASC' , 'search' => null , 'parent' => null , 'template' => null);
        $model->init($lists);
        $fullList = $model->getFullList();
        $fullList = ATree::getListTree($fullList);
        return AHtml::getFilterSelect($field, 'Select object', $fullList, $select, $autoSubmit, '', 'id', 'treename');
    }

    /**
     * Get filter of subjects parents
     * 
     * @param int $select selected option
     * @param boolean $autoSubmit sign if is filter on list or edit form field
     * @return string HTML code
     */
    function getParentsSubjectFilter($select)
    {
        $model = BookingHelper::getSubjectsModel();
        $parents = $model->loadParents();
        $parents = $model->loadShortListByIds($parents);
        return BookingHelper::getSubjectParentSelectBox('filter_parent', 'select parent', $parents, array(), $select);
    }

    /**
     * Get selectbox contains parent to filter or choose in editing
     * 
     * @param string $name field name
     * @param string $noSelectText string of zero option
     * @param array $parents parent IDs
     * @param array $ignore ID of parents which mustnt't in list
     * @param int $select selected parent
     * @param boolean $autoSubmit add autosubmit form javascript
     * @param string $customParams additional params
     * @return string HTML code
     */
    function getSubjectParentSelectBox($name, $noSelectText, $parents, $ignore, $select, $autoSubmit = true, $customParams = '')
    {
        $mark1 = '&#160;';
        $mark2 = '_-_N-B-S-P_-_';
        foreach (($tree = ATree::getListTree($parents)) as $list)
            $list->treename = str_replace(array($mark1 , '<sup>' , '</sup>'), array($mark2 , '' , ''), $list->treename);
        return str_replace($mark2, $mark1, AHtml::getFilterSelect($name, $noSelectText, $tree, $select, $autoSubmit, $customParams, 'id', 'treename'));
    }

    /**
     * Get subject ordering selectbox to editing subject form
     * 
     * @param TableSubject $subject edited subject
     * @return string HTML code
     */
    function getSubjectOrderingSelectBox($subject)
    {
        $model = BookingHelper::getSubjectsModel();
        $query = $model->getLoadOrderingQuery($subject);
        return JHTML::_('list.specificordering', $subject, $subject->id, $query);
    }

    /**
     * Import time picker library
     */
    function importTimePicker()
    {
        JHTML::script('nogray_time_picker.js',TIMEPICKER_BASE);
        ADocument::addScriptPropertyDeclaration('timePickers', 'new Array()', false, false);
        ADocument::addScriptPropertyDeclaration('timePickerImages', TIME_PICKER_IMAGES);
        ADocument::addScriptPropertyDeclaration('dateFormat', ADATE_FORMAT_NORMAL_CAL);
        ADocument::addScriptPropertyDeclaration('timePickerToggler', IMAGES . 'icon-16-clock.png');
    }
    
    /**
     * Import base CSS and JS of DHTMLX calendar. Import selected or default skin.
     */
    function importDHTMLXCalendar()
    {
    	$config = AFactory::getConfig();
    	/* @var $config BookingConfig */
    	JHTML::script('dhtmlxcalendar.js', DHTMLX_BASE); JHTML::stylesheet('dhtmlxcalendar.css', DHTMLX_BASE);
    	if ($config->subjectsCalendarSkin == 'dhx_web') JHTML::stylesheet('dhtmlxcalendar_dhx_web.css', DHTMLX_SKIN);
    	elseif ($config->subjectsCalendarSkin == 'omega') JHTML::stylesheet('dhtmlxcalendar_omega.css', DHTMLX_SKIN);
    	else JHTML::stylesheet('dhtmlxcalendar_dhx_skyblue.css', DHTMLX_SKIN);
    }

    /**
     * Import SlimBox library.
     */
    function importSlimBox()
    {
    	self::upgradeMootools125();
    	
        JHTML::script('slimbox.js', SLIMBOX_BASE . 'js/');
        JHTML::stylesheet('slimbox.css', SLIMBOX_BASE . 'css/');
        JHTML::_('behavior.mootools');      
    }
    
    function importColorPicker()
    {
    	JHTML::script('jscolor.js', COLORPICKER_BASE);
   	}
    
    /**
     * Upgrade included Squeezebox to newer version (for J!1.5)
     */
    function upgradeModal()
    {
    	static $imported;
    	if (!$imported) {
    		if (!ISJ16) {
    			BookingHelper::upgradeMootools125();
    			//remove old modal loaded
				AImporter::removeScripts('modal.js','modal-uncompressed.js');
				AImporter::removeStyleSheets('modal.css');
				//add upgraded one 
				JHTML::script('modal.js',SQUEEZEBOX_BASE.'js/'); 
				JHTML::stylesheet('modal.css',SQUEEZEBOX_BASE.'css/');
    		}
    	    $imported=true;
    	}
    }
    
    /**
     * Upgrades to Mootools 1.2.5, if J!1.5 and not using mtupgrade plugin
     * @params bool $more import Mootools more too
     */
    function upgradeMootools125($more = false)
    {
    	static $imported;
    	if (!$imported) {
    		if (!ISJ16 && !JPluginHelper::getPlugin('system','mtupgrade')){
    			//remove old mootools loaded
    			AImporter::removeScripts('mootools.js','mootools-uncompressed.js');
				//add mootools 1.2.5 (from mtupgrade)
    			JDEBUG ? JHtml::script('mootoolsuncompressed125.js',MOOTOOLS_BASE) : JHTML::script('mootools125.js',MOOTOOLS_BASE);
    			JFactory::getApplication()->set('MooToolsVersion', '1.2.5');
    		}
    		if ($more)
    			JHTML::script('mootoolsmore125.js',MOOTOOLS_BASE);
    		$imported=true;
    	}
    }

    /**
     * Format person name.
     * 
     * @param TableCustomer  $person
     * @param boolean        $safe use HTML special chars to safe string, default false
     * @param boolean        $addCompany add Company Name, default false
     * @param boolean        $cblink make link to Community Builder user profile
     * @return string
     */
    function formatName(&$person, $safe = false, $addCompany = false, $cblink = false)
    {
        $parts = array();
        $person->title_before = JString::trim($person->title_before);
        $person->firstname = JString::trim($person->firstname);
        $person->middlename = JString::trim($person->middlename);
        $person->surname = JString::trim($person->surname);
        $person->title_after = JString::trim($person->title_after);
        if ($person->title_before) {
            $parts[] = $person->title_before;
        }
        if ($person->firstname) {
            $parts[] = $person->firstname;
        }
        if ($person->middlename) {
            $parts[] = $person->middlename;
        }
        if ($person->surname) {
            $parts[] = $person->surname . ($person->title_after ? ', ' : '');
        }
        if ($person->title_after) {
            $parts[] = $person->title_after;
        }
        if ($addCompany && $person->company) {
            $parts[] = '(' . $person->company . ')';
        }
        $name = JString::trim(implode(' ', $parts));
        if ($safe) {
            $name = htmlspecialchars($name, ENT_QUOTES, ENCODING);
        }
        
        if($cblink){
        	$name = '<a href="'.CommunityBuilder::userProfileUrl($person->user).'">'.$name.'</a>';
        }

        return $name;
    }

    /**
     * Format person adrress
     * 
     * @param TableCustomer $person
     * @return string HTML code
     */
    function formatAddress(&$person)
    {
        $parts = array();
        $person->city = JString::trim($person->city);
        $person->street = JString::trim($person->street);
        $person->zip = JString::trim($person->zip);
        $person->country = JString::trim($person->country);
        if ($person->country) {
            $parts[] = $person->country;
        }
        if ($person->city) {
            $parts[] = $person->city;
        }
        if ($person->street) {
            $parts[] = $person->street;
        }
        if ($person->zip) {
            $parts[] = $person->zip;
        }
        return JString::trim(implode(', ', $parts));
    }

    /**
     * Get email link
     * 
     * @param TableCustomer $person
     * @param boolean $link display as link, default true
     * @return string HTML code
     */
    function getEmailLink(&$person, $link = true)
    {
        $person->email = JString::trim($person->email);
        if ($person->email) {
            return $link ? '<a href="mailto:' . $person->email . '" title="' . JText::_('Send email') . '">' . $person->email . '</a>' : $person->email;
        }
        return '';
    }

    function getIconEmail(&$person)
    {
        $email = JString::trim($person->email);
        if ($email) {
            return '<a href="mailto:' . $email . '" class="aIcon aIconEmail" title=""></a>';
        }
        return '';
    }

    /**
     * Get array of days in given date limit. For every day is generated list of time intervals in which can be subject reserved.
     * For every time is specified quantity of subject already reserved.
     * 
     * @param $subject     TableSubject Subject 
     * @param $dateStart   string       Date start of List
     * @param $dateEnd     string       Date end of List
     * @param $addCustomer boolean      add to Data Customer Name and Company, default false
     * @param $rids        array        selected reservation types
     * @param $setting     array        extra configuration
     * @return array
     */
    function getCalendar(&$subject, $dateStart, $dateEnd, $isAdmin = false)
    {
        if (! (int) $subject->total_capacity)
            // prevent for old versions where total capacity weren't compulsory
            $subject->total_capacity = 1;
        
        $jconfig = &JFactory::getConfig();    
        $config = &AFactory::getConfig();
        
        $tzoffset = BookingHelper::getTZOffset(true);
        
        //convert date end and start to full date interval with time zone offset 
        $dateStart = &BookingHelper::dateBeginDay($dateStart, $tzoffset);
        $dateEnd = &BookingHelper::dateEndDay($dateEnd, $tzoffset);
        
        $countDays = JFactory::getDate($dateEnd->dts)->toUnix() - JFactory::getDate($dateStart->dts)->toUnix();
        $countDays = $countDays ? round($countDays / DAY_LENGTH) : 1;
        
        //take needed models
        $modelReservationItems = new BookingModelReservationItems();
        $modelReservationTypes = &BookingModelReservationTypes::getObjectInstance();
        /* @var $modelReservationTypes BookingModelReservationTypes */
        $modelPrices = new BookingModelPrices();
        
        //take prices usable for this subject
        $modelPrices->init(array('subject' => $subject->id));
        $prices = &$modelPrices->getData();
        
        //take all reservations in this interval for this subject
        //$reservations = &$modelReservationItems->getSimpleData($subject->id, $dateStart->dts, $dateEnd->dts, $subject->display_who_reserve);
        //it gets user data always
        $reservations = &$modelReservationItems->getSimpleData($subject->id, $dateStart->dts, $dateEnd->dts);
        
        //take all usable reservation types for this subject
        $rtypesFilter['subject'] = $subject->id;
        $rtypesFilter['order'] = 'type';
        $rtypesFilter['order_Dir'] = 'DESC';
        
        unset($modelReservationTypes->_cache[$subject->id]); //! no cache, because for some reason on next fnc call it returns old data with old time_unit property
        $modelReservationTypes->init($rtypesFilter);
        $reservationTypes = $modelReservationTypes->getData();

        //get counts of data for optimalization
        $countReservationTypes = count($reservationTypes);
        $countPrices = count($prices);
        $countReservations = count($reservations);
        
        // get closing days
        $closingDaysModel = JModel::getInstance('Closingdays', 'BookingModel');
        /* @var $closingDaysModel BookingModelClosingdays */ 
        $closingDays = $closingDaysModel->getSubjectClosingDays($subject->id);
        
        //set unix time stamp for reservations datetime from and to
        for ($reservationIndex = 0; $reservationIndex < $countReservations; $reservationIndex ++) {
            $reservation = &$reservations[$reservationIndex];
            /* @var $reservation TableReservationItems */
            $reservation->fromUts = JFactory::getDate($reservation->from)->toUnix();
            $reservation->toUts = JFactory::getDate($reservation->to)->toUnix();
        }

        $fix2num = array('mon' => 1, 'tue' => 2, 'wed' => 3, 'thu' => 4, 'fri' => 5, 'sat' => 6, 'sun' => 7);
        $today = date('N');
        
        //set cover interval for reservation types
        for ($reservationTypeIndex = 0; $reservationTypeIndex < $countReservationTypes; $reservationTypeIndex ++) {
            $reservationType = &$reservationTypes[$reservationTypeIndex];
            /* @var $reservationType TableReservationType */
            $reservationType->time_unit_orig = $reservationType->time_unit;
            if ($subject->min_limit)
                $reservationType->boxes = floor(($reservationType->time_unit + $reservationType->gap_time) / $subject->min_limit);
            else
                //$reservationType->boxes = $reservationType->time_unit + $reservationType->gap_time;
                $reservationType->boxes = 1;
            if ($reservationType->fix)
            	$reservationType->boxes = $reservationType->fix;
            if ($subject->min_limit && $reservationType->type == RESERVATION_TYPE_HOURLY)
                $reservationType->time_unit = $subject->min_limit;
            $reservationType->timeUnitFloat = $reservationType->time_unit / 60;
            $reservationType->gapTimeFloat = $reservationType->gap_time / 60;
            if ($reservationType->type == RESERVATION_TYPE_DAILY) {
                //reservation type cover full day
                $reservationType->interval = 24.0;
            } else
                $reservationType->interval = ($reservationType->time_unit + $reservationType->gap_time) / 60;
            
            $reservationType->allowFixLimitFrom = null;
            
			if ($reservationType->book_fix_past && $reservationType->fix_from != 'any' && $reservationType->fix) {
				
				/* allow reserve current fixed limit if has been started in the past */
				
				$fixUp = $fix2num[$reservationType->fix_from]; // day of week when fix limit starts
				$fixDown = ($fixUp + $reservationType->fix - 1) % 7; // day of week when fix limit ends
				
				if ($today < $fixUp && $today <= $fixDown) // fix limit has been started in previous week and covers today
					$shift = $today + 7 - $fixUp;
				elseif ($today >= $fixUp && $today <= $fixDown) // fix limit has been started in current week and covers today
					$shift = $today - $fixUp;
				else // fix limit doesn't cover today
					$shift = null; 
				
				if ($shift !== null)
					$reservationType->allowFixLimitFrom = JFactory::getDate('-  ' . $shift . ' days')->toFormat('%Y-%m-%d');
			}
        }

        //set cover interval for prices
        for ($priceIndex = 0; $priceIndex < $countPrices; $priceIndex ++) {
            $price = &$prices[$priceIndex];
            /* @var $price TablePrice */
            TablePrice::prepare($price);
            if ($subject->single_deposit)
                $price->deposit = '';
            $dateUp = JFactory::getDate($price->date_up);
            /* @var $dateUp JDate */    
            $price->dateUpUts = $dateUp->toUnix();
            $dateDown = JFactory::getDate($price->date_down);
            /* @var $dateDown JDate */
            $price->dateDownUts = $dateDown->toUnix();
            if ($price->rtype == RESERVATION_TYPE_DAILY) {
                //price cover full day
                $price->limitStartFloat = 1.0;
                $price->limitStopFloat = 24.0;
            } else {
                $price->limitStartFloat = BookingHelper::timeToFloat($price->time_up);
                $price->limitStopFloat = BookingHelper::timeToFloat($price->time_down);
            }
            if ($price->limitStopFloat == 0.0) // price ends at midnight
            	$price->limitStopFloat = 24.0; // in database is stored 0 but we need 24
            $price->formatPrice = BookingHelper::displayPrice($price->value, $price->deposit);
            $price->formatValue = BookingHelper::displayPrice($price->value);
            $price->formatDeposit = BookingHelper::displayPrice($price->deposit);
            TablePrice::prepare($price);
        }
        
        //days of calendar interval
        $days = array();
        
        // storage for used prices
        $usedPrices = array();
        
        //current unix time stamp in locale
        $current = &JFactory::getDate('now', $jconfig->get('offset'));
        /* @var $current JDate */ 
        //Joomla 1.5
        $current->setOffset($jconfig->getValue('offset'));
        $time = $current->toUnix();
        $currentDay = &JFactory::getDate($current->toFormat('%Y-%m-%d 00:00:00'), $jconfig->get('offset'));
        /* @var $currentDay JDate */        
        $timeDay = $currentDay->toUnix();
        
        $i = 0;
        //id for prices in calendar
        $id2 = array(RESERVATION_TYPE_HOURLY=>array(),RESERVATION_TYPE_DAILY=>array(),RESERVATION_TYPE_PERIOD=>array());
        
        if ($subject->use_fix_shedule) {
            $sheduleFrom = BookingHelper::timeToFloat($subject->shedule_from);
            //FIXME infinite loop probably
            //$sheduleTo = BookingHelper::timeToFloat($subject->shedule_to);
            $sheduleTo = (BookingHelper::timeToFloat($subject->shedule_to) == 0.0 ? 24.0 : BookingHelper::timeToFloat($subject->shedule_to));
            $sheduleLimit = $subject->min_limit? $subject->min_limit / 60 : 1;
        }

        //for all days covers interval
        for ($dayOffset = 0; $dayOffset < $countDays; $dayOffset ++) {
            
            //set day date data
            $days[] = new BookingDay();
            $currentDay = end($days);
            /* @var $currentDay BookingDay */
            
    		$currentDay->date = JFactory::getDate(preg_replace('#\d{2}:\d{2}:\d{2}#', '', $dateStart->orig) . ' +' . $dayOffset . ' day');
    		/* @var $date JDate */
    		$currentDay->up = $currentDay->date->toFormat('%Y-%m-%d 00:00:00', true);
    		$currentDay->down = $currentDay->date->toFormat('%Y-%m-%d 23:59:59', true);
        	$currentDay->date = $currentDay->date->toFormat('%Y-%m-%d', true);
            $currentDay->nextDate = JFactory::getDate(preg_replace('#\d{2}:\d{2}:\d{2}#', '', $dateStart->orig) . ' +' . ($dayOffset + 1) . ' day');
    		/* @var $date JDate */
        	$currentDay->nextDate = $currentDay->nextDate->toFormat('%Y-%m-%d', true);
            
            $currentDay->Uts = BookingHelper::getUts($currentDay->date);
            $currentDay->weekDayCode = date('N', $currentDay->Uts);
            $weekDayString = BookingHelper::dayCodeToString($currentDay->weekDayCode);
            $currentDay->weekDayString = $weekDayString;
            $weekType = date('W', $currentDay->Uts) % 2 ? WEEK_ODD : WEEK_EVEN;

            if ($subject->use_fix_shedule && $sheduleLimit > 0) {
                for ($dayIndex = $sheduleFrom; $dayIndex < $sheduleTo; $dayIndex += $sheduleLimit) {
                    $box = new BookingTimeBox();
                    $dayIndexKey = (string) $dayIndex;
                    $box->fromFloat = $dayIndex;
                    $box->fromTime = BookingHelper::floatToTime($box->fromFloat);
                    $box->toFloat = $dayIndex + $sheduleLimit;
                    $box->toTime = BookingHelper::floatToTime($box->toFloat);
                    $box->fromDate = $currentDay->date . ' ' . $box->fromTime;
                    $box->fromUts = JFactory::getDate($box->fromDate)->toUnix();
                    //TODO check, if it works correctly with localization
                    //$box->fromDisplay = AHtml::date($box->fromDate, ADATE_FORMAT_LONG, 0);
                    $box->fromDisplay = AHtml::date($box->fromDate, ADATE_FORMAT_LONG);
                    $box->toDate = $currentDay->date . ' ' . $box->toTime;
                    $box->toUts = JFactory::getDate($box->toDate)->toUnix();
                    //TODO check, if it works correctly with localization
                    //$box->toDisplay = AHtml::date($box->toDate, ADATE_FORMAT_LONG, 0);
                    $box->toDisplay = AHtml::date($box->toDate, ADATE_FORMAT_LONG);
                    $box->rtype = RESERVATION_TYPE_HOURLY;
                    $currentDay->boxes[$dayIndexKey] = $box;
                }
            }
           
            //search reservation boxes for current day
            for ($reservationTypeIndex = 0; $reservationTypeIndex < $countReservationTypes; $reservationTypeIndex ++) {
                //search in all reservation types
                $reservationType = &$reservationTypes[$reservationTypeIndex];
                /* @var $reservationType TableReservationType */
                for ($priceIndex = 0; $priceIndex < $countPrices; $priceIndex ++) {
                     
                    //search in all prices
                    $price = &$prices[$priceIndex];

                    /* @var $price TablePrice */
                    if ($price->week != WEEK_EVERY && $price->week != $weekType)
                    	continue;
                    if ($price->rezervation_type == $reservationType->id) {
                        //price is for reservation type
                        if ($price->$weekDayString && (! $price->dateUpUts || $price->dateUpUts <= $currentDay->Uts) && (! $price->dateDownUts || $price->dateDownUts >= $currentDay->Uts)) {
                            //price interval is for current day
                            $boxesLimitStop = $price->limitStopFloat - $reservationType->timeUnitFloat;

                            //generate all boxes in price interval by reservation type interva;
                            for ($dayIndex = $price->limitStartFloat; $dayIndex <= $boxesLimitStop; $dayIndex = $dayIndex + $reservationType->interval) {
                            	
                                $dayIndexKey = (string) $dayIndex;

                                if (! isset($currentDay->boxes[$dayIndexKey])) {

                                    $box = new BookingTimeBox();
                                    $box->first = count($currentDay->boxes) === 0;
                                    
                                    if ($reservationType->type == RESERVATION_TYPE_HOURLY) {
                                        //set datetime values 

                                        $box->fromFloat = $dayIndex;
                                        $box->fromTime = BookingHelper::floatToTime($box->fromFloat);
                                        
                                        $box->toFloat = $dayIndex + $reservationType->timeUnitFloat;
                                        $box->toTime = BookingHelper::floatToTime($box->toFloat);
                                    
                                    } else {
                                        //reservation type cover full day - box will be cover full day too
                                        if ($subject->night_booking) {
                                            $box->fromFloat = BookingHelper::timeToFloat($subject->night_booking_from);
                                            $box->toFloat = BookingHelper::timeToFloat($subject->night_booking_to);
                                            $box->fromTime = BookingHelper::floatToTime($box->fromFloat);
                                            $box->toTime = BookingHelper::floatToTime($box->toFloat);
                                        } else {
                                            $box->fromFloat = 0.0;
                                            $box->fromTime = '00:00';
                                            $box->toFloat = 24.0;
                                            $box->toTime = '23:59';
                                        }
                                    }
                                    $box->fromDate = $currentDay->date . ' ' . $box->fromTime;
                                    if ($subject->night_booking)
                                        $box->toDate = $currentDay->nextDate . ' ' . $box->toTime;
                                    else if($box->toTime == '24:00')
                                    	$box->toDate = $currentDay->nextDate . ' 00:00';
                                    else
                                        $box->toDate = $currentDay->date . ' ' . $box->toTime;
                                    
                                    $box->fromUts = JFactory::getDate($box->fromDate)->toUnix();
                                    $box->toUts = JFactory::getDate($box->toDate)->toUnix();
                                    
                                    if ($reservationType->type == RESERVATION_TYPE_DAILY && ! $subject->night_booking) {
                                    	//TODO check, if it works correctly with localization
                                        //$box->fromDisplay = AHtml::date($box->fromDate, ADATE_FORMAT_NORMAL, 0);
                                        $box->fromDisplay = AHtml::date($box->fromDate, ADATE_FORMAT_NORMAL);
                                        //$box->toDisplay = AHtml::date($box->toDate, ADATE_FORMAT_NORMAL, 0);
                                        $box->toDisplay = AHtml::date($box->toDate, ADATE_FORMAT_NORMAL);
                                    } else {
                                        //$box->fromDisplay = AHtml::date($box->fromDate, ADATE_FORMAT_LONG, 0);
                                        $box->fromDisplay = AHtml::date($box->fromDate, ADATE_FORMAT_LONG);
                                        //$box->toDisplay = AHtml::date($box->toDate, ADATE_FORMAT_LONG, 0);
                                        $box->toDisplay = AHtml::date($box->toDate, ADATE_FORMAT_LONG);
                                    }
                                    $box->rtype = $reservationType->type;
                                } else
                                    $box = $currentDay->boxes[$dayIndexKey];
                                
                                $service = new BookingService();
                                                            
                                //creating id for different prices in same day
                                $pricekey = $price->id;
                                $rt = $reservationType->type;
                                
                                //initialize id's and daybefore
                                if(!isset($daybefore[$rt]))
                                	$daybefore[$rt] = null;              
                                if(!array_key_exists($pricekey,$id2[$rt]))
                                	$id2[$rt][$pricekey] = 0;

                                //get next day/hour for specific type
                                //compare only days
                                $daily = JFactory::getDate($daybefore[$rt])->toFormat('%Y%m%d') != JFactory::getDate($box->toDisplay)->toFormat('Ymd');
                                //compare full name including time
                                $hourly = $daybefore[$rt] != $box->toDisplay;
                                $nextday = ($rt == RESERVATION_TYPE_DAILY)? $daily : $hourly;
                                
                                //increment all keys for specific rtype, if is next day
                                if($nextday)
                                	foreach($id2[$rt] as $key=>$val)
                                		$id2[$rt][$key] = isset($id2[$rt][$key]) ? $id2[$rt][$key]+1 : 0;
             
                                //set actual box as before
                                $daybefore[$rt] = $box->toDisplay;
                                
                                //copy reservation type and price values into box
                                $service->i = $i ++;
                                $service->id = 'box-' . $reservationType->id . '-' . $price->id . '-' . $box->fromUts . '-' . $box->toUts; //absolute id of service
                                $service->idShort = 'box-' . $reservationType->id . '-' . $price->id . '-' . $id2[$rt][$pricekey]; //id used in HTML and JavaScript. unique and incrementing for each reservation type.

                                $service->price = $price->value;
                                $service->deposit = $price->deposit;
                                $service->cancel_time = $price->cancel_time;
                                $service->color = $price->custom_color;
                                $service->formatPrice = $price->formatPrice;
                                $service->capacityUnit = $reservationType->capacity_unit; //capacityUnit != min capacity, but no of booked items
                                $service->rtype = $reservationType->type;
                                $service->rtypeId = $reservationType->id;
                                $service->boxes = $reservationType->boxes;
                                $service->min = $reservationType->min;
                                $service->max = $reservationType->max;
                                $service->fix = $reservationType->fix;
                                $service->fixFrom = $reservationType->fix_from;
                                $service->priceId = $price->id;
                                $service->priceIndex = $priceIndex;
                                $service->fromFloat = $box->fromFloat;
                                $service->fromTime = $box->fromTime;
                                $service->fromDate = $box->fromDate;
                                $service->fromUts = $box->fromUts;
                                $service->fromDisplay = $box->fromDisplay;
                                $service->toFloat = $box->toFloat;
                                $service->toTime = $box->toTime;
                                $service->toDate = $box->toDate;
                                $service->toUts = $box->toUts;
                                $service->toDisplay = $box->toDisplay;
                                $service->alreadyReserved = 0;
                                $service->canReserve = true;
                                $service->dayWeek = JString::strtolower(date('D', $box->fromUts));
                                $service->allowFixLimit = $reservationType->allowFixLimitFrom && $reservationType->allowFixLimitFrom <= $currentDay->date;
                                $service->item_id = $subject->id;
                                
                                if (! isset($usedPrices[$reservationType->id]))
                                    $usedPrices[$reservationType->id] = &$reservationType;
                                
                                if (! isset($usedPrices[$reservationType->id]->prices[$priceIndex]))
                                    $usedPrices[$reservationType->id]->prices[$priceIndex] = &$price;
                                
     //search if box is reserved
                                for ($reservationIndex = 0; $reservationIndex < $countReservations; $reservationIndex ++) {
                                    $reservation = &$reservations[$reservationIndex];
                                    /* @var $reservation TableReservation */
                                    
                                    $standard = ($reservation->rtype == $service->rtype && $reservation->toUts > $service->fromUts && $reservation->fromUts < $service->toUts);
                                    $overlay = ($reservation->rtype == $service->rtype && ($reservation->fromUts == $service->fromUts || $reservation->toUts == $service->toUts));
                                    //enable book 13-15 interval, when 12-14 is already booked.
                                    $reserved = $subject->price_overlay? $overlay : $standard;
                                    
                                    if ($reserved) {

                                    	$service->capacityUnit += $reservation->capacity;

                                    	//update info about number of full-day reservations for that day
                                    	if ($service->rtype==RESERVATION_TYPE_DAILY)
                                    		$currentDay->fullReserved += $reservation->capacity;
                                    	
                                    	//upate info about highest (peak) number of hourly reservations for that day
                                    	if ($service->rtype==RESERVATION_TYPE_HOURLY && $service->capacityUnit>$currentDay->maxHoursReserved)
                                    		$currentDay->maxHoursReserved = $service->capacityUnit;

                                        if (($name = BookingHelper::formatName($reservation, false, true, CommunityBuilder::isInstalled()))) {
                                        	$capacity = $subject->display_capacity ? '('.$reservation->capacity.'x) ' : '';
                                        	$data = array();
                                        	$data['reservation_id'] = $reservation->reservation_id;
                                        	$data['name'] = $capacity.$name;
                                        	$data['message'] = htmlspecialchars($reservation->message, ENT_QUOTES, ENCODING);
                                            $box->customerName[$reservation->id] = $data;
                                            $currentDay->customerName[$reservation->id] = $data;
                                        }
                                    }
                                }

                                $box->services[] = $service;
                                
                                $currentDay->boxes[$dayIndexKey] = $box;
                            }
                        }
                    }
                }
            }
        }
        
        //now get information about number of already done reservations for every service      
        // and determine if service can be reserved                   	
        foreach ($days as &$day) {
        	$day->engaged = true;
        	foreach ($day->boxes as &$box) {
        		$box->engaged = true;
        		foreach ($box->services as &$service) {

        			//already reserved for hour = all day reservations + that hour reservations
        			if ($service->rtype==RESERVATION_TYPE_HOURLY)
        				$service->alreadyReserved = $day->fullReserved + $service->capacityUnit;
        			//already reserved for whole day = max number of hour reservations + that whole day reservations
        			elseif ($service->rtype==RESERVATION_TYPE_DAILY)
        				$service->alreadyReserved = $day->maxHoursReserved + $service->capacityUnit;
        			else 
        				die ('Unknown reservation type variable');
        				
        			//determine if service can be reserved //box is in past - cannot reserve
        			
        			if ($isAdmin)
        				$inThePast = false;
        			elseif($config->bookCurrentDay)
        				$inThePast = $timeDay > $service->fromUts;
        			else
        				$inThePast = $time > $service->fromUts;
        			
        			if (!$service->allowFixLimit && ($inThePast || $service->alreadyReserved>=$subject->total_capacity))
        				$service->canReserve = false;
        			else
        				$day->engaged = $box->engaged = false; // some service is bookable 
        		}
        		
        		// check if box is covered by closing day
        		foreach ($closingDays as $closingDay) 
        			if ($closingDay->down >= $box->fromDate && $closingDay->up <= $box->toDate) {
        				$box->closed = true;
						$box->closingDayTitle = $closingDay->title; // informations for calendar
        				$box->closignDayText  = $closingDay->text;
        			}
        				
        	}
        	// check if day is covered by closing day
        	foreach ($closingDays as $closingDay)
        		if ($closingDay->up <= $day->up && $closingDay->down >= $day->down) {
        			$day->closed = true;	
        			$day->closingDayTitle =	$closingDay->title; // informations for calendar
        			$day->closignDayText  = $closingDay->text;
        		}
        }
        
        // control if fixed limits in hourly reservation types are bookable
        foreach ($days as &$day)
        	foreach ($day->boxes as $j => &$box)
        		foreach ($box->services as &$service)
        			if ($service->canReserve && $service->fix > 1 && empty($service->controled) && $service->rtype == RESERVATION_TYPE_HOURLY) { // check non-controled bookable hourly service with fixed limit
        				$services = array($service); // list of services in fixed limit
        				$l = $j;
        				do { // process next boxes after current box in fixed limit length
        					$next = false;
        					if (!empty($day->boxes[++$l])) // there is next box
        						foreach ($day->boxes[$l]->services as $service2) // process next box services
        							if ($service2->priceId == $service->priceId && $service2->canReserve) { // next box bookable service is in the same fixed interval as current
        								$services[] = $service2; // store service for final check
        								$service2->controled = true; // no control service again
        								$next = true; // continue in next step
        							}
        				} while($next);  // there is no next box with service in fixed limit = stop controling
        				if (count($services) < $service->fix) // number of found services is not enough = found limit is unbookable
        					foreach ($services as $unreservable) // unset unbookable interval 
        						$unreservable->canReserve = false;
        			}
        
        //counting over calendar - fix interval checking
        $c = new ServiceDayCounter();
        $last = false;
        foreach ($days as $dk=>&$day) {
        	$disable = null;
        	if(!$day->engaged)
        	{
        		foreach ($day->boxes as $bk=>&$box) {
        			foreach ($box->services as $sk=>&$service) {
        				//add new box type for counting fix days
        				$c->add($service);
        				if($service->fix > 1)
        				{
        					//is set fix day for start booking?
        					if($service->fixFrom !== 'any')
        					{
        						//when is fix day, start again
	        					if($service->fixFrom == $service->dayWeek)
	        					{
	        						$c->resetCount($service->id);
	        					}
	
	        					//decrease and check, if fix days counter is 0
	        					if($c->isCountZero($service->id))
	        					{
	        						//echo $service->dayWeek.'----<br>';
	        						$service->canReserve = false;
	        						$box->engaged = true;
	        						continue;
	        					}
        					}
        					/*else
        					{
        						if($c->isCountZero($service->id))
        						{
        							$service->canReserve = false;
        							$box->engaged = true;
        							$c->resetCount($service->id);
        							continue;
        						}
        					}*/
        				}

        				//end if price is reserved
        				if(!$service->canReserve)
        					continue;

        				//will count days only for days not for hours
        				if($service->rtype == RESERVATION_TYPE_HOURLY){
        					continue;
        				}
        				
        				//number of fixed services
        				$total = $service->fix;
        				$number = 0;
        				
        				//if exist previous day
        				if(array_key_exists($dk-1,$days))
        				{
        					//get yesterday servise
	        				$oldbox = $days[$dk-1]->boxes[$bk];
	        				$oldeservices = $oldbox->services;
	        				$exist = ($oldeservices != null && array_key_exists($sk,$oldeservices));
	        				
	        				//if don't exist or is reserved, start counting
	        				if(!$exist || ($exist && ($oldeservices[$sk]->canReserve == false) || ($days[$dk-1]->engaged == true)))
	        				{			
        						//find already booked service in fix interval. if there is any, it can't be booked and $number services must be disabled
		        				for($i=$total-1;$i>=0;$i--)
		        				{
		
		        					if(array_key_exists($dk+$i,$days))
		        					{
		        						$boxx = $days[$dk+$i]->boxes[$bk];
		        						$servic = $boxx->services;
		        						if($servic != null && array_key_exists($sk,$servic) && (($servic[$sk]->canReserve == false) || ($days[$dk+$i]->engaged == true)))
		        						{
		        							$number = $i;
		        							break;
		        						}
		        					}
		        					else
		        						break;
		        				}
	        				}
        				}

        				//disable all services in found interval
        				if($number>0)
        				{
        					for($i=0;$i<=$number;$i++)
        					{
        						$boxx = $days[$dk+$i]->boxes[$bk];
        						$servic = $boxx->services;
        						$servic[$sk]->canReserve = false;
        						$boxx->engaged = true;
        					}
        				}

        				// counting fix limit for services with specific starting day
        				if(($service->fixFrom != "any") && ($service->fixFrom != $service->dayWeek) && !$last)
        				{
        					//$service->canReserve = false;
        					for($i=0;$i<=$service->fix;$i++)
        					{

        						if(array_key_exists($dk+$i,$days))
        						{
        							$boxx = $days[$dk+$i]->boxes[$bk];
        							$servic = $boxx->services;
        							if($service->fixFrom == $servic[$sk]->dayWeek)
        							{
        								break;
        							}
        							else
        							{
        								$servic[$sk]->canReserve = false;
        								$boxx->engaged = true;
        							}
        						}
        						else
        							break;
        					}

        				}
        				//echo $service->fromDisplay.'- smazat:'.$number.' - <br>';
        			}
        		}

        	}

        	if($day->engaged)
        		$last = false;
        	else
        		$last = true;
        }
         
        $output = new stdClass();
        $output->prices = &$usedPrices;
        $output->calendar = &$days;
        
        return $output;
    }

    /**
     * Get week calendar for selected subject.
     * 
     * @param TableSubject $subject
     * @param BookingCalendarSetting $setting
     * @return stdClass
     */
    function getWeekCalendar(&$subject, &$setting, $count = 'week', $isAdmin = false)
    {
        $mainframe = JFactory::getApplication();
        /* @var $mainframe JApplication */
        $current = JFactory::getDate();
        /* @var $current JDate */
        $config = &AFactory::getConfig();
        /* @var $config BookingConfig */
        
        $setting->currentWeek = (int) $current->toFormat('%V');
        if (!$setting->currentWeek) // with IIS strftime('%V') does not work
        	$setting->currentWeek = (int) date('W', $current->toUnix());
        
        /* @var $currentWeek int current week without leading zero */
        $setting->currentYear = (int) $current->toFormat('%Y');
        /* @var $setting->currentYear int current year without leading zero */
        $setting->current = $current->toFormat('%Y-%V');
        if (!$setting->current) // with IIS strftime('%V') does not work
        	$setting->current = date('Y-W', $current->toUnix());
        
        $setting->week = $mainframe->getUserStateFromRequest('vsdwcm' . $subject->id, 'week', $setting->currentWeek, 'int');
        /* @var $week int selected week from user request */
        $setting->year = $mainframe->getUserStateFromRequest('vsdwcy' . $subject->id, 'year', $setting->currentYear, 'int');
        /* @var $year int selected year from user request */
        
        $selected = JFactory::getDate($setting->year . '-W' . str_pad($setting->week, 2, '0', STR_PAD_LEFT));
        /* @var $selected JDate */
        $setting->selected = ISJ16 ? $selected->modify('+6 days')->toFormat('%Y-%V') : $selected->toFormat('%Y-%V');
        if (!$setting->selected) // with IIS strftime('%V') does not work
        	$setting->selected = date('Y-W', $selected->toUnix());
        
        $lastAllow = JFactory::getDate('+ ' . $config->calendarDeepWeek . ' week');
        /* @var $lastAllow JDate */ 
        
        $setting->lastAllowYear = (int) $lastAllow->toFormat('%Y');
        /* @var $lastAllowYear int last allow year */
        $setting->lastAllowWeek = (int) $lastAllow->toFormat('%V');
        if (!$setting->lastAllowWeek) // with IIS strftime('%V') does not work
        	$setting->lastAllowWeek = (int) date('W', $lastAllow->toUnix());
        /* @var $lastAllowWeek int last allow week */
        $setting->lastAllow = $lastAllow->toFormat('%Y-%V');
        if (!$setting->lastAllow) // with IIS strftime('%V') does not work
        	$setting->lastAllow = date('Y-W', $lastAllow->toUnix());
        
        if (!$isAdmin && ($setting->selected < $setting->current || $setting->selected > $setting->lastAllow)) {
            // request date no exists or is in past or over allowed interval - reset to current day
            $setting->week = $setting->currentWeek;
            $setting->year = $setting->currentYear;
        }
        
        $last = JFactory::getDate($setting->year . '-W' . str_pad($setting->week, 2, '0', STR_PAD_LEFT) . ' -1 week');
        /* @var $last JDate */ 
        
        $setting->previousWeek = (int) $last->toFormat('%V');
        if (!$setting->previousWeek) // with IIS strftime('%V') does not work
        	$setting->previousWeek = (int) date('W', $last->toUnix());
        /* @var $setting->previousWeek int previous week from actual */
        $setting->previousYear = (int) $last->toFormat('%Y');
        /* @var $previousYear int previous year from actual */
        
        $next = JFactory::getDate($setting->year . '-W' . str_pad($setting->week, 2, '0', STR_PAD_LEFT) . ' +1 week');
        /* @var $next JDate */ 
        
        $setting->nextWeek = (int) $next->toFormat('%V');
        if (!$setting->nextWeek) // with IIS strftime('%V') does not work
        	$setting->nextWeek = (int) date('W', $next->toUnix());
        /* @var $nextWeek int next week from actual */
        $setting->nextYear = (int) $next->toFormat('%Y');
        /* @var $nextYear int next year from actual */
        
        $setting->onCurrentWeek = $setting->current == $setting->selected;
        /* @var $onCurrentWeek boolean is set current week */
        $setting->lastAllowPage = $setting->lastAllow == $setting->selected;
        /* @var $lastAllowPage boolean is set last week from allowed interval */
        
        if ($setting->onCurrentWeek && !$isAdmin) {
        	$monday = $current->toFormat('%d-%m-%Y %H:%M:%S');
        } else {
        	$monday = JFactory::getDate($setting->year . '-W' . str_pad($setting->week, 2, '0', STR_PAD_LEFT) . '-' . ($config->firstDaySunday ? (7 . ' -1 week') : 1));
        	/* @var $monday JDate */
        	$monday = $monday->toFormat('%d-%m-%Y 00:00:00');
        }
        /* @var $monday int first day of week */
        if ($count === 'week')
        	$sunday = JFactory::getDate($setting->year . '-W' . str_pad($setting->week, 2, '0', STR_PAD_LEFT) . '-' . ($config->firstDaySunday ? 6 : 7));
        else 
        	$sunday = JFactory::getDate($monday . ' + ' . ($count - 1) . ' days');
        /* @var $sunday JDate */
        $sunday = $sunday->toFormat('%d-%m-%Y 23:59:59');
        /* @var $sunday int last day of week */
        
        return BookingHelper::getCalendar($subject, $monday, $sunday, $isAdmin);
    }

    /**
     * Get monthly calendar for selected subject.
     * 
     * @param TableSubject $subject
     * @param BookingCalendarSetting $setting
     * @return stdClass
     */
    function getMonthlyCalendar(&$subject, &$setting, $calendarnummonths = 1, $isAdmin = false)
    {
        $mainframe = JFactory::getApplication();
        /* @var $mainframe JApplication */
        $current = JFactory::getDate();
        /* @var $current JDate */
        $config = &AFactory::getConfig();
        /* @var $config BookingConfig */
        
        $setting->currentDay = (int) $current->toFormat('%d');
        /* @var $currentDay int current day without leading zero */
        $setting->currentMonth = (int) $current->toFormat('%m');
        /* @var $currentMonth int current month without leading zero */
        $setting->currentYear = (int) $current->toFormat('%Y');
        /* @var $currentYear int current year without leading zero */
        $setting->current = $current->toFormat('%Y-%m');
        
        $setting->currentDate = $current->toFormat('%Y-%m-%d');
        /* @var $currentDate string current date with leading zeros */
        $setting->currentDayUTS = $current->toUnix();
        /* @var $currentDayUTS int unix timestamp of current date */
                
        //day is selected
        $boxIds = array_filter(JRequest::getVar('boxIds', array(), 'default', 'array'), 'strlen');
        if (!empty($boxIds)) {
            $setting->month = JRequest::getInt('month');
            $setting->year = JRequest::getInt('year');
            if (is_null(($setting->lastMonth = $mainframe->getUserState('vsdmcm' . $subject->id))))
                $setting->lastMonth = $setting->month;
            if (is_null(($setting->lastYear = $mainframe->getUserState('vsdmcy' . $subject->id))))
                $setting->lastYear = $setting->year;
            if ($setting->lastYear > $setting->year || ($setting->lastYear == $setting->year && $setting->lastMonth > $setting->month)) {
                $setting->lastMonth = $setting->month;
                $setting->lastYear = $setting->year;
                JRequest::setVar('boxIds', '');
            }
        } else {
            $setting->lastMonth = $setting->month = $mainframe->getUserStateFromRequest('vsdmcm' . $subject->id, 'month', $setting->currentMonth, 'int');
            /* @var $month int selected month from user request */
            $mainframe->setUserState('vsdmcm' . $subject->id, $setting->lastMonth);
            $setting->lastYear = $setting->year = $mainframe->getUserStateFromRequest('vsdmcy' . $subject->id, 'year', $setting->currentYear, 'int');
            /* @var $year int selected year from user request */
            $mainframe->setUserState('vsdmcy' . $subject->id, $setting->lastYear);
        }

    	if ($calendarnummonths > 1) {
    		if (JRequest::getString('boxIds'))
        		$lastMonth = JFactory::getDate($setting->year . '-' . $setting->month . '-1' . ' + ' . ($calendarnummonths - 1) . ' month');
        	else
        		$lastMonth = JFactory::getDate($setting->lastYear . '-' . $setting->lastMonth . '-1' . ' + ' . ($calendarnummonths - 1) . ' month');
    		$setting->month = (int) $lastMonth->toFormat('%m');
        	$setting->year =  $lastMonth->toFormat('%Y');	
        }
        
        $selected = JFactory::getDate($setting->lastYear . '-' . $setting->lastMonth . '-01');
        /* @var $selected JDate */
        $setting->selected = $selected->toFormat('%Y-%m');
        
        $setting->dateExists = checkdate($setting->month, 1, $setting->year);
        /* @var $dateExists boolean request date exists */
        
        $lastAllow = JFactory::getDate('+' . $config->calendarDeepMonth . ' month');
        /* @var $lastAllow JDate */
        
        $setting->lastAllowYear = (int) $lastAllow->toFormat('%Y');
        /* @var $lastAllowYear int last allow year */
        $setting->lastAllowMonth = (int) $lastAllow->toFormat('%m');
        /* @var $lastAllowMonth int last allow month */
        $setting->lastAllow = $lastAllow->toFormat('%Y-%m');
        /* @var $lastAllow string last allow year-month */
        
        if (!$isAdmin && (! $setting->dateExists || $setting->selected < $setting->current || $setting->selected > $setting->lastAllow)) {
            // request date no exists or is in past or over allowed interval - reset to current day
            $setting->lastMonth = $setting->month = $setting->currentMonth;
            $setting->lastYear = $setting->year = $setting->currentYear;
            $selected = JFactory::getDate($setting->year . '-' . $setting->month);
        	/* @var $selected JDate */
        	$setting->selected = $selected->toFormat('%Y-%m');
        }
        
        $setting->monthName = $selected->toFormat('%B');
        
        $last = JFactory::getDate($setting->lastYear . '-' . $setting->lastMonth . '-01 -1 month');
        /* @var $last JDate */
        
        $setting->previousMonth = (int) $last->toFormat('%m');
        /* @var $previousMonth int previous month of actual date */
        $setting->previousYear = $last->toFormat('%Y');
        /* @var $previousYear int previous year of actual date */
        
        $next = JFactory::getDate($setting->lastYear . '-' . $setting->lastMonth . '-01 +1 month');
        /* @var $next JDate */
        
        $setting->nextMonth = (int) $next->toFormat('%m');
        /* @var $nextMonth int next month of actual date */
        $setting->nextYear = $next->toFormat('%Y');
        /* @var $nextYear int next year of actual date */
        
        $setting->month = str_pad($setting->month, 2, '0', STR_PAD_LEFT);
        $setting->lastMonth = str_pad($setting->lastMonth, 2, '0', STR_PAD_LEFT);
        
        $firstDay = JFactory::getDate($setting->lastYear . '-' . $setting->lastMonth . '-01 00:00:00');
        /* @var $firstDay JDate */
        $setting->firstDay = $firstDay->toFormat('%Y-%m-%d 00:00:00');
        /* @var $firstDay string first month day date */
        $setting->firstDayUTS = $firstDay->toUnix();
        /* @var $firstDayUTS int first month day unix timestamp */
        
        //$lastDay = JFactory::getDate($setting->year . '-' . $setting->month . '-' . date('t', strtotime($setting->year . '-' . $setting->month . '-01')));
        $lastDay = JFactory::getDate(gmmktime(0, 0, 0, $setting->month + 1, 0, $setting->year));
        /* @var $lastDay JDate */
        $setting->lastDay = $lastDay->toFormat('%Y-%m-%d 23:59:59');
        /* @var $lastDay string last month day date */
        $setting->lastDayUTS = $lastDay->toUnix();
        /* @var $lastDay int last month day timestamp */
        
        $setting->firstWeekDayNumber = $config->firstDaySunday ? 7 : 1;
        /* @var $firstWeekDayNumber int number of first week day according to component configuration */
        $setting->firstDayOffset = $config->firstDaySunday ? 1 : 2;
        /* @var $firstDayOffset int first day offset according to component configuration */
        $setting->firstDayNumber = $firstDay->toFormat('%w');
        /* @var $firstDayNumber int week number of first month day */
        if ($setting->firstDayNumber == 0) $setting->firstDayNumber = 7;
        
        if ($setting->firstDayNumber != $setting->firstWeekDayNumber) {
            /* first month day isn't first week day - to head of month must connect part of previous month to complete calendar table */
            $setting->firstDay = JFactory::getDate(gmmktime(0, 0, 0, $setting->lastMonth, ($setting->firstDayOffset - $setting->firstDayNumber) , $setting->lastYear))->toFormat('%Y-%m-%d 00:00:00');
        }
        
        $setting->lastWeekDayNumber = $config->firstDaySunday ? 6 : 7;
        /* @var $lastWeekDayNumber int number of last week day according to component configuration */
        $setting->lastDayNumber = $lastDay->toFormat('%w');
        if ($setting->lastDayNumber == 0) $setting->lastDayNumber = 7;
        
        /* @var $lastDayNumber int week number of last month day */
        
        if ($setting->lastDayNumber != $setting->lastWeekDayNumber) {
            /* last month day isnt't last week day - to tail of month must connect part of next month to complete calendar table */
            $setting->lastDay = JFactory::getDate(gmmktime(0, 0, 0, ($setting->month + 1), ($setting->lastWeekDayNumber - $setting->lastDayNumber), $setting->year))->toFormat('%Y-%m-%d 23:59:59');
        }
        
        $setting->week = (int) $firstDay->toFormat('%V');
        /* @var $week number of first week */
        
        $setting->onCurrentMonth = $setting->selected == $setting->current;
        /* @var $onCurrentMonth boolean user select current month */
        $setting->lastAllowPage = $setting->selected == $setting->lastAllow;
        /* @var $lastAllowPage boolean user select last allowed page */
		
        return BookingHelper::getCalendar($subject, $setting->firstDay, $setting->lastDay, $isAdmin);
    }

    /**
     * Get daily calendar for selected subject.
     * 
     * @param TableSubject $subject
     * @param BookingCalendarSetting $setting
     * @return stdClass
     */
    function getDailyCalendar(&$subject, &$setting, $isAdmin = false)
    {
        $mainframe = JFactory::getApplication();
        /* @var $mainframe JApplication */
        $current = JFactory::getDate();
        /* @var $current JDate */
        $config = AFactory::getConfig();
        /* @var $config BookingConfig */
        
        $setting->currentDay = (int) $current->toFormat('%d');
        /* @var $currentDay int current day without leading zero */
        $setting->currentMonth = (int) $current->toFormat('%m');
        /* @var $currentMonth int current month without leading zero */
        $setting->currentYear = (int) $current->toFormat('%Y');
        /* @var $currentYear int current year without leading zero */
        
        $setting->currentDate = $current->toFormat('%Y-%m-%d');
        /* @var $currentDate string current date with leading zeros */
        $setting->currentUTS = $current->toUnix();
        /* @var $currentUTS int unix timestamp of current date */
        
        $setting->day = $mainframe->getUserStateFromRequest('vsddcd' . $subject->id, 'day', $setting->currentDay, 'int');
        /* @var $day int selected day from user request */
        $setting->month = $mainframe->getUserStateFromRequest('vsddcm' . $subject->id, 'month', $setting->currentMonth, 'int');
        /* @var $month int selected month from user request */
        $setting->year = $mainframe->getUserStateFromRequest('vsddcy' . $subject->id, 'year', $setting->currentYear, 'int');
        /* @var $year int selected year from user request */

        $lastAllow = JFactory::getDate('+ ' . $config->calendarDeepDay . 'day');
        /* @var $lastAllow JDate */
        
        $setting->lastAllow = $lastAllow->toFormat('%Y-%m-%d');
        $setting->lastAllowDateUTS = $lastAllow->toUnix();
        /* @var $lastAllowDateUTS int unix timestamp of last date in allowed interval */
        $setting->lastAllowDay = (int) $lastAllow->toFormat('%d');
        /* @var $lastAllowDay int last allow day number without leading zero */
        $setting->lastAllowMonth = (int) $lastAllow->toFormat('%m');
        /* @var $lastAllowMonth int last allow month without leading zero */
        $setting->lastAllowYear = (int) $lastAllow->toFormat('%Y');
        /* @var $lastAllowYear int last allow year */
        
        $setting->dateExists = checkdate($setting->month, $setting->day, $setting->year);
        /* @var $dateExists boolean request date exists */
        
        $request = JFactory::getDate($setting->year . '-' . str_pad($setting->month, 2, '0', STR_PAD_LEFT) . '-' . str_pad($setting->day, 2, '0', STR_PAD_LEFT));
        /* @var $request JDate */
        $setting->requestDate = $request->toFormat('%Y-%m-%d');
        /* @var $requestDate string DB format of date from request date: 1.1.2011 to 2011-01-01 */
        $setting->requestUTS = $request->toUnix();
        /* @var $requestUTS int unix timestamp of request date */
        
        if (!$isAdmin && (! $setting->dateExists || $setting->requestUTS < $setting->currentUTS || $setting->requestUTS > $setting->lastAllowDateUTS)) {
            // request date no exists or is in past or over allowed interval - reset to current day
            $setting->day = $setting->currentDay;
            $setting->month = $setting->currentMonth;
            $setting->year = $setting->currentYear;
            $setting->requestDate = $setting->currentDate;
            $setting->requestUTS = $setting->currentUTS;
        }
        
        $last = JFactory::getDate($setting->requestDate . ' - 1 day');
        /* @var $last JDate */
        
        $setting->previousDay = (int) $last->toFormat('%d');
        /* @var $previousDay int previous day of actual date */
        $setting->previousMonth = (int) $last->toFormat('%m');
        /* @var $previousMonth int previous month of actual date */
        $setting->previousYear = (int) $last->toFormat('%Y');
        /* @var $previousYear int previous year of actual date */
        
        $next = JFactory::getDate($setting->requestDate . ' + 1 day');
        /* @var $next JDate */
        
        $setting->nextDay = (int) $next->toFormat('%d');
        /* @var $nextDay int next day of actual date */
        $setting->nextMonth = (int) $next->toFormat('%m');
        /* @var $nextMonth int next month of actual date */
        $setting->nextYear = (int) $next->toFormat('%Y');
        /* @var $nextYear int next year of actual date */
        
        $lastDay = JFactory::getDate($setting->nextYear . '-' . $setting->nextMonth . ' + 1 month last day');
        /* @var $lastDay JDate */
        
        $setting->lastDay = (int) $lastDay->toFormat('%Y-%m-%d');
        /* @var $lastDay string last day of next month */
        
        $setting->onCurrentDay = $setting->currentDate == $setting->requestDate;
        /* @var $onCurrentDay boolean request date is equal with current date */
        $setting->lastAllowPage = $setting->lastAllow == $setting->requestDate;
        /* @var $lastAllowPage boolean user set last allowed page */
        
        return BookingHelper::getCalendar($subject, $setting->requestDate, $setting->requestDate, $isAdmin);
    }

    /**
     * Get time zone offset from Joomla! configuration in seconds.
     * 
     * @return int
     */
    function getTZOffset($inSeconds = true)
    {
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $tzoffset = $mainframe->getCfg('offset');
        if (ISJ16) {
            $dateTimeZone = new DateTimeZone($tzoffset);
            $dateTime = new DateTime('now', $dateTimeZone);
            $tzoffset = $dateTimeZone->getOffset($dateTime);
            if (! $inSeconds)
                $tzoffset /= 60 / 60;
            else
                $inSeconds = false;
        }
        if ($inSeconds)
            $tzoffset *= 60 * 60;
        return $tzoffset;
    }

    /**
     * Convert date to begin datetime of this day with given time zone offset.
     * 
     * @param $date string
     * @param $tzoffset int
     * @return BookingDate
     */
    function dateBeginDay($date, $tzoffset = 0)
    {
        $date = BookingHelper::convertDate($date, '%Y-%m-%d 00:00:00', true);
        return $date;
    }

    /**
     * Convert date to end datetime of this day with given time zone offset.
     * 
     * @param $date string
     * @param $tzoffset int
     * @return BookingDate
     */
    function dateEndDay($date, $tzoffset = 0)
    {
        $date = BookingHelper::convertDate($date, '%Y-%m-%d 23:59:59', true);
        return $date;
    }

    /**
     * Convert date into given format with given time zone offset.
     * 
     * @param $date string date to convert
     * @param $format string datetime format
     * @param $tzoffset int time zone offset
     * @return BookingDate
     */
    function convertDate($date, $format = '%Y-%m-%d %H:%M:%S', $tzoffset = false)
    {
        static $cache;
        $key = $date . $format . $tzoffset;
        if (! isset($cache[$key])) {
        	if ($tzoffset){
        		$mainframe = JFactory::getApplication();
        		/* @var $mainframe JApplication */
        		$jdate = JFactory::getDate($date, $mainframe->getCfg('config'));
        		/* @var $date JDate */ 
        		$jdate->setOffset($mainframe->getCfg('config')); 
        	} else {
        		$jdate = JFactory::getDate($date);
        		/* @var $jdate JDate */
        	}
            $output = new BookingDate();
            $output->orig = $date;
            $output->uts = $jdate->toUnix();
            $output->dts = $jdate->toFormat($format, $tzoffset);
            $cache[$key] = $output;
        }
        return $cache[$key];
    }

    /**
     * Get unix time stamp of date with given time zone offset.
     * 
     * @param $date string
     * @param $tzoffset int
     * @return int
     */
    function getUts($date, $tzoffset = 0)
    {
        $uts = JFactory::getDate($date)->toUnix() + $tzoffset;
        return $uts;
    }    
    
	/**
	 * Gets overall time interval from boxes Ids.
	 * 
	 * @param array $boxIds
	 */
    function getIntervalFromBoxIds($boxIds)
    {
    	$return = array();
    	$return['start'] = null;
    	$return['end'] = 0;
    	
    	if(is_array($boxIds)){
	    	foreach ($boxIds as $boxId)	{
	    		
	    		$box = explode('-',$boxId);
	    		$end = array_pop($box);
	    		$start = array_pop($box);
	    		if (!$return['start'] || $start < $return['start'])
	    			$return['start'] = $start - 86400;
	    		if ($end > $return['end'])
	    			$return['end'] = $end + 86400;
	    	}
    	}
    	
    	return $return;
    }
    
    /**
     * Get reserved interval with full boxes calendar. Total price 
     * and information if can reserved.
     * 
     * @param $subjectId TableSubject
     * @param $from string MySQL Datetime
     * @param $to string MySQL Datetime
     * @param $rids array selected reservation types
     * @param $boxIds array selected calendar boxes
     * @param $supplements array selected subjects supplements from loadSupplements
     * @param $capacity int reserved item capacity 
     * @param $item TableReservationItems
     * @return BookingInterval
     */
    function getReservedInterval(&$subject, $ctype, $boxIds, &$supplements, $capacity=1, &$item)
    {
    	$config = AFactory::getConfig();
        $interval = new BookingInterval();
        $interval->rtype = $ctype == CTYPE_MONTHLY ? RESERVATION_TYPE_DAILY : RESERVATION_TYPE_HOURLY;
        
        if ($ctype == CTYPE_PERIOD) {
        	
        	$interval->rtype = RESERVATION_TYPE_PERIOD;
        	
        	$rtype = JTable::getInstance('ReservationType', 'Table');
        	/* @var $rtype TableReservationType */
        	$price = JTable::getInstance('Price', 'Table');
        	/* @var $price TablePrice */
        	
        	// reservation type and price selected in timeframe
        	$rtype->load($item->period_rtype_id);
        	$price->load($item->period_price_id);
        	TablePrice::prepare($price);
    		
    		// compute occurrences #
    		$item->period_total = 0;
    		
    			$beginDay = JFactory::getDate($item->period_date_up);
    			$endDay = JFactory::getDate($item->period_date_down);
    			
    			$beginDayUnix = $beginDay->toUnix();
    			$endDayUnix = $endDay->toUnix();
    			if ($item->period_end == PERIOD_END_TYPE_AFTER)
    				$endDayUnix = 32503680000; // 1.1.3000 ...
    			 
    			if ($item->period_type == PERIOD_TYPE_WEEKLY || $item->period_type == PERIOD_TYPE_DAILY) {
    				
    				$firstWeekDay = $config->firstDaySunday ? 7 : 1;
    				
    				for ($day = $beginDayUnix; $day < $endDayUnix; $day += 86400) { // loop all days in period
						
    					if ($item->period_end == PERIOD_END_TYPE_AFTER && $item->period_total == $item->period_occurrences)
    						break;
    					
    					$dayWeekNum = JFactory::getDate($day)->toFormat('%u'); // 1-7 
    					
    					if ($firstWeekDay == $dayWeekNum) // week begin
    						isset($week) ? $week++ : $week = 1; // increment week counter
    					
    					if (!isset($week)) // period begins in the middle of week
    						$week = 1;
    					
    					if ($week % $item->period_recurrence == 0) { // in week recurrence
							if ($dayWeekNum == 1 && $item->period_monday) {// check every week day
								$item->period_total++;
								$item->period[] = $day;				
							} elseif ($dayWeekNum == 2 && $item->period_tuesday) {
								$item->period_total++;
								$item->period[] = $day;
							} elseif ($dayWeekNum == 3 && $item->period_wednesday) {
								$item->period_total++;
								$item->period[] = $day;
							} elseif ($dayWeekNum == 4 && $item->period_thursday) {
								$item->period_total++;
								$item->period[] = $day;
							} elseif ($dayWeekNum == 5 && $item->period_friday) {
								$item->period_total++;
								$item->period[] = $day;
							} elseif ($dayWeekNum == 6 && $item->period_saturday) {
								$item->period_total++;
								$item->period[] = $day;
							} elseif ($dayWeekNum == 7 && $item->period_sunday) {
								$item->period_total++;
								$item->period[] = $day;
							}
    					}
    				}	
    			} elseif ($item->period_type == PERIOD_TYPE_MONTHLY) { 
    				
    				$weeks = array();
    				
    				$year = $beginDay->toFormat('%Y'); 
    				$month = $beginDay->toFormat('%m');
    				$first = JFactory::getDate("$year-$month-01"); // first day of period date up month 
    				
    				while ($first->toUnix() < $endDayUnix) { // check all months in period
    					$weeks[] = $first->toFormat('%V') + $item->period_week - 1; // required month week in period
    					$month++; // go to next month
    					if ($month > 12) { // rotate year
							$month = 1;
							$year++;
    					}
    					$month = str_pad($month, 2, 0, STR_PAD_LEFT); // add leading zero
    					$first = JFactory::getDate("$year-$month-01");
    				}
    				
    				$day = $beginDayUnix;
    				$jump = 86400; // until find first jump for day
    				while ($day < $endDayUnix) {
    					
    					if ($item->period_end == PERIOD_END_TYPE_AFTER && $item->period_total == $item->period_occurrences)
    						break;
    					
    					$currentDate = JFactory::getDate($day);
    					
    					if ($currentDate->toFormat('%u') == $item->period_day && in_array((int) $currentDate->toFormat('%V'), $weeks)) { // day equals to period week day and month week
    						$item->period_total ++;
    						$item->period[] = $day;
    						$jump = 604800; // since find first jump for week	
    					} 
    					$day += $jump; // next day or week
    				}
    					
    			} elseif ($item->period_type == PERIOD_TYPE_YEARLY) {
    				
    				$weeks = array();
    				
    				$year = $beginDay->toFormat('%Y'); 
    				$first = JFactory::getDate("$year-$item->period_month-01"); 
    				
    				while ($first->toUnix() < $endDayUnix) { // check all months in period
    					$weeks[$year] = $first->toFormat('%V') + $item->period_week - 1; // required month week in period
    					$year++;
    					$first = JFactory::getDate("$year-$item->period_month-01");
    				}
    				
    				$day = $beginDayUnix;
    				$jump = 86400; // until find first jump for day
    				while ($day < $endDayUnix) {
    					
    					if ($item->period_end == PERIOD_END_TYPE_AFTER && $item->period_total == $item->period_occurrences)
    						break;
    					
    					$currentDate = JFactory::getDate($day);
    							
    					if ($currentDate->toFormat('%u') == $item->period_day && in_array((int) $currentDate->toFormat('%V'), $weeks)) { // day equals to period week day and month week
    						$item->period_total ++;
    						$item->period[] = $day;
    						$jump = 604800; // since find first jump for week
    					}
    					$day += $jump; // next day or week
    				}
    			}
			
			$day = new BookingDay();
			$box = new BookingTimeBox();
			
			$boxIds = $box->services = array();
			
			$service = new BookingService();
			
			$service->priceIndex = 0;
			$service->priceId = $price->id;
			$service->price = $price->value;
			$service->deposit = $price->deposit;
			$service->cancel_time = $price->cancel_time;
			$service->alreadyReserved = 0;
			$service->rtypeId = $rtype->id;
			$service->fromDate = $service->toDate = 0;
			
			for ($i = 0; $i < $item->period_total; $i++) {
				$service->id = $i;
				$boxIds[] = $service->id;
				$box->services[] = $service;
			}
			
			$day->boxes = array($box);
			$rtype->prices = array($price);
			
			$interval->calendar = new stdClass();
			$interval->calendar->calendar = array($day);
			$interval->calendar->prices = array($rtype->id => $rtype);
			
        } else {
        	$offset = BookingHelper::getIntervalFromBoxIds($boxIds);
        	$modelCustomer = new BookingModelCustomer();
        	$modelCustomer->setIdByUserId();
        	$interval->calendar = BookingHelper::getCalendar($subject, date('Y-m-d H:i:s',$offset['start']), date('Y-m-d H:i:s',$offset['end']), $modelCustomer->isAdmin());
        }
        
        
        $i = 0;
        $usedPrices = array();
        $units = 0;
        if ($subject->single_deposit){
            $interval->deposit = $subject->single_deposit;
            $interval->fullDeposit = $subject->single_deposit;
        }
        foreach ($interval->calendar->calendar as $day)
            /* @var $day BookingDay */
            foreach ($day->boxes as $box) 
                /* @var $box BookingTimeBox */
                foreach ($box->services as $service){
                    /* @var $service BookingService */
                    if (in_array($service->id, $boxIds)) {
                    	
                    	$interval->cancel_time = $service->cancel_time;
                    	
                        if (! isset($firstPrice))
                            $firstPrice = $interval->calendar->prices[$service->rtypeId]->prices[$service->priceIndex];
                        if (! isset($from))
                            $from = $service->fromDate;
                        if (! isset($boxes))
                            $boxes = $service->boxes;
                        $to = $service->toDate;
                        if ($service->alreadyReserved + $capacity > $subject->total_capacity)
                            $interval->canReserve = false;

                        if (!isset($prices[$service->priceId]))
                        	$prices[$service->priceId] = $interval->calendar->prices[$service->rtypeId]->prices[$service->priceIndex]; //price for current service
                        
                        if (! ($boxes && (($i ++) % $boxes))) {
                            $interval->price += $service->price;
                            $interval->fullPrice +=  $prices[$service->priceId]->price_capacity_multiply ? $service->price*$capacity : $service->price;//multiple price by capacity here
                            
                            if (! $subject->single_deposit && ($prices[$service->priceId]->deposit_multiply == DEPOSIT_MULTIPLY_ALLOW || ! isset($usedPrices[$service->priceId]))){
                            	$interval->deposit +=  $service->deposit;
                                $interval->fullDeposit +=  $prices[$service->priceId]->deposit_capacity_multiply ? $service->deposit*$capacity : $service->deposit; //multiple deposit by capacity here
                            }
                            
                            !isset($usedPrices[$service->priceId]) ? $usedPrices[$service->priceId] = 1 : $usedPrices[$service->priceId] ++;
                            $units ++;
                            
                            /* @var $prices array of TablePrice */
                            /* @var $units int overall number of time units in reserved interval */
                            /* @var $usedPrices array number of time units for given price in reserved interval */
                        }
                        if ($service->alreadyReserved>$interval->maxReserved)
                        	$interval->maxReserved = $service->alreadyReserved;
                        	
                        if (is_null($interval->minReserved) OR $service->alreadyReserved<$interval->minReserved)
                        	$interval->minReserved = $service->alreadyReserved;
                    }
                }
                
        if (isset($firstPrice)) {
        	foreach ($interval->calendar->prices as $rtype)
            	foreach ($rtype->prices as $price)
                	if ($price->id == $firstPrice->id)
                    	$interval->rtypeTitle = $rtype->title;
        } else
        	$interval->rtypeTitle = '';

        foreach ($supplements as $supplement)
			/* @var $supplement TableReservationSupplement */
        	if ($supplement->fullPrice)
        		$interval->supplementsFullPrice +=$supplement->fullPrice;
                
        if ($subject->discounts) { //apply single discount from subject
            foreach ($subject->discounts as $unitCount => $unitDiscount)
                if ($units >= $unitCount){
                    $interval->discount = $units * $unitDiscount;

                    foreach ($usedPrices as $priceId => $priceUnits) //go throuth used prices
                    	$interval->fullDiscount+=$priceUnits * $unitDiscount * ($prices[$priceId]->price_capacity_multiply ? $capacity : 1); //if set, multiply every price time range by capacity
                }
        } else
            foreach ($interval->calendar->prices as $rtype) //apply discounts from single used prices
                foreach ($rtype->prices as $price) 
                    /* @var $price TablePrice */
                    if (isset($usedPrices[$price->id])) {
                        $discount = 0;
                        foreach ($price->discounts as $unitCount => $unitDiscount)
                            if ($usedPrices[$price->id] >= $unitCount){
                                $discount = $usedPrices[$price->id] * $unitDiscount;}
                        $interval->discount += $discount;
                        $interval->fullDiscount += $discount * ($price->price_capacity_multiply ? $capacity : 1); //if price is multiplied by capacity, multiply discount also
                    }

        $interval->price -= $interval->discount;
        $interval->fullPrice -= $interval->fullDiscount;
        $interval->fullPriceSupplements = $interval->fullPrice + $interval->supplementsFullPrice;
        
        if (isset($from) && isset($to))
        	$interval->setDate($from, $to);
        
        return $interval;
    }

    /**
     * Count overall price and deposit of reservation. Can be passed order id or array of items.
     * 
     * @param	int		id of reservation
     * @param 	array	of TableReservationItems, have to contain also supplements property with array of supplements with price property
     */
    function countOverallPrice($id=null,$items=null)
    {
    	$fullPrice = 0;
        $fullDeposit = 0;

        if ($id) //load from db
        {
        	AImporter::model('reservationitems','reservationsupplements');
        	
			$modelReservationSupplements = new BookingModelReservationSupplements();
	    	$modelReservationSupplements->init(array());
	    
        	$modelReservationItems = new BookingModelReservationItems();
        	$modelReservationItems->init(array('reservation_item-reservation_id'=>$id));
        	
			$items = $modelReservationItems->getData();
			
			if (count($items)) foreach ($items as $item){

		        $fullPrice += $item->fullPriceSupplements;
		        $fullDeposit += $item->fullDeposit;
	        }
        }
        elseif (count($items)){ //get from items
        	
	    	foreach ($items as $item){

		        $fullPrice += $item->fullPriceSupplements;
		        $fullDeposit += $item->fullDeposit;
	    	}
    	}
    	else
    		return false; //bad function parameters
    	
    	return array($fullPrice,$fullDeposit);
    }
    
    /**
     * Gets "Reservation name" for payment methods
     * 
     * @param array $items
     */
    function getReservationName($items)
    {
    	$name=array();
    	foreach ($items as $item){
    		$name[] = $item->subject_title;
    	}
    	return implode(', ',$name);
    }
    
    /**
     * Load supplements as TableSupplement from request or from id=>request values (as array) array.
     * 
     * @param BookingModelSupplements $modelSupplements
     * @param int $subjectID
     * @param int $subjCapacity reserved capacity
     * @param array $storedSupplements	array of supplements already stored in db
     * @param array $requestSupplements array of supplements[supplement_id][0]: value, [1]: capacity
     * @return array
     */
    function loadSupplements(&$modelSupplements, $subjectID, $subjCapacity=1, $storedSupplements = null, $requestSupplements=null, $boxsCount = null)
    {
    	if (count($storedSupplements)) //already stored item supplements in db. append actual information about capacity multiply
    	{
    		$modelSupplements->_data = null;
    		$modelSupplements->init(array('subject' => $subjectID , 'subject' => $subjectID));
    		$subjectSupplements = &$modelSupplements->getData();
    			
    		foreach ($storedSupplements as &$storedSupplement){
    			
    			foreach ($subjectSupplements as $subjectSupplement){
    				if ($storedSupplement->supplement == $subjectSupplement->id){
    					$storedSupplement->capacity_multiply = $subjectSupplement->capacity_multiply;
    					$storedSupplement->unit_multiply = $subjectSupplement->unit_multiply;
    					$storedSupplement->capacity_max = $subjectSupplement->capacity_max;
    					break;
    				}
    			}
    		}
    		return $storedSupplements;
    	}
    	
    	if (count($requestSupplements)) foreach ($requestSupplements as $key=>$requestSupplement){ //unset empty options
    		if (empty($requestSupplement[0]))
    			unset ($requestSupplements[$key]);
    	}

        if (count($requestSupplements)) { // customer selected supplements with reservation
            
        	$modelSupplements->_data = null;
            $modelSupplements->init(array('subject' => $subjectID , 'cids' => array_keys($requestSupplements)));
            $supplements = &$modelSupplements->getData(); // load supplements settings

            foreach ($supplements as &$supplement) {
                /* @var $supplement TableSupplement */
                TableSupplement::prepare($supplement);
                $supplement->value = 1;
	            $value = $requestSupplements[$supplement->id][0];
	            
	            $supplement->capacity = null;
	            if ($supplement->capacity_multiply==2){
	           		$supplement->capacity = isset($requestSupplements[$supplement->id][1]) ? (int)$requestSupplements[$supplement->id][1] : 1;
	            	if ($supplement->capacity_max && $supplement->capacity > $supplement->capacity_max)
	            		$supplement->capacity = $supplement->capacity_max;
	            }
	            elseif ($supplement->capacity_multiply==1)
	            	$supplement->capacity = $subjCapacity;
	            else
	            	$supplement->capacity = 0; //supplement has no capacity
	            
                if (is_array($supplement->options))
                    foreach ($supplement->options as $option)
                        if ($option[0] == $value) {
                            $supplement->value = $option[0];
                            $supplement->price = $option[1];
                        }
                        
                if ($supplement->capacity_multiply==1) //compute full price
                	$supplement->fullPrice = $supplement->price*$subjCapacity;
                elseif ($supplement->capacity_multiply==2)
                	$supplement->fullPrice = $supplement->price*$supplement->capacity;
                else 
                	$supplement->fullPrice = $supplement->price;

             	if ($supplement->unit_multiply == 1) {
             		$supplement->fullPrice *= $boxsCount;
             		$supplement->boxsCount = $boxsCount;
             	}
				   	
            }
        } else
            $supplements = array();
            
		$config = AFactory::getConfig();
		/* @var $config BookingConfig */    
		if ($config->locations) {    
			$locations = AHtml::locations(null, null, true);
			
			$db = &JFactory::getDBO();
				
			if ($locations['pickup_location'] && $locations['pickup_location_hour'] && $locations['pickup_location_min']) { // add pickup location into supplements
				$pickup = new TableSupplement($db);
		        $pickup->fullPrice = 0;
				$pickup->paid = SUPPLEMENT_NO_PRICE;
			   	$pickup->type = SUPPLEMENT_TYPE_LIST;
				$pickup->title = JText::_('Pickup location');
				$pickup->value = $locations['pickup_location'] . ' ' . JText::sprintf('Location time', $locations['pickup_location_hour'], $locations['pickup_location_min']);
				$supplements['locations_pickup'] = $pickup;
			}
		   	if ($locations['dropoff_location'] && $locations['dropoff_location_hour'] && $locations['dropoff_location_min']) {
			   	$dropoff = new TableSupplement($db);
			    $dropoff->fullPrice = 0;
				$dropoff->paid = SUPPLEMENT_NO_PRICE;
		    	$dropoff->type = SUPPLEMENT_TYPE_LIST;
				$dropoff->title = JText::_('Dropoff location');
				$dropoff->value = $locations['dropoff_location'] . ' ' . JText::sprintf('Location time', $locations['dropoff_location_hour'], $locations['dropoff_location_min']);
				$supplements['locations_dropoff'] = $dropoff;
	       	}
        }
            
        return $supplements;
    }

    
    /**
     * Convert MySQL time value to float value. 
     * 
     * @param string $time
     * @return float
     */
    function timeToFloat($time)
    {
    	$date = JFactory::getDate(JHTML::date($time, ATIME_FORMAT_SHORT,false));
        return round((int) $date->toFormat('%H') + (int) $date->toFormat('%M') / 60, 2);
    }

    /**
     * Convert float value to MySQL time value.
     * 
     * @param float $value
     * @return string
     */
    function floatToTime($value)
    {
        $hour = floor($value);
        $minute = round(($value - $hour) * 60);
        $hour = str_pad($hour, 2, '0', STR_PAD_LEFT);
        $minute = str_pad($minute, 2, '0', STR_PAD_LEFT);
        if ($minute == 60)
            $minute = '00';
        return $hour . ':' . $minute;
    }

    /**
     * Display time without zero minutes value.
     * 
     * @param string $time in format HH:MM
     * @return string for example: if value = 12:00 return 12
     */
    function displayTime($time)
    {
    	// turn on AM/PM working
    	setlocale(LC_ALL, '');

    	return AHtml::date($time,ATIME_FORMAT);
    	/*
    	$date = JFactory::getDate($time);*/
        /* @var $date JDate */
        /*return $date->toFormat(ATIME_FORMAT);*/
    }

    /**
     * Gets string value of week day by day number code.
     * 
     * @param int $code
     * @return string
     */
    function dayCodeToString($code)
    {
        switch ($code) {
            case 1:
                return 'monday';
            case 2:
                return 'tuesday';
            case 3:
                return 'wednesday';
            case 4:
                return 'thursday';
            case 5:
                return 'friday';
            case 6:
                return 'saturday';
            case 7:
                return 'sunday';
        }
    }

    /**
     * Get route to listing page by weeks numbers. Route contains view subject,
     * subject ID with subject alias, week and year value.
     * 
     * @param int $id subject ID
     * @param int $alias subject alias
     * @param int $week
     * @param int $year
     * @return string URL
     */
    function getWeekPaginationRoute($id, $alias, $week = null, $year = null)
    {
        return BookingHelper::getTimePaginationRoute($id, $alias, null, $week, null, $year);
    }

    /**
     * Get route to listing page by month numbers. Route contains view subject,
     * subject ID with subject alias, month and year value.
     * 
     * @param int $id subject ID
     * @param int $alias subject alias
     * @param int $month
     * @param int $year
     * @return string URL
     */
    function getMonthPaginationRoute($id, $alias, $month = null, $year = null)
    {
        return BookingHelper::getTimePaginationRoute($id, $alias, null, null, $month, $year);
    }

    /**
     * Get route to listing page by day numbers. Route contains view subject,
     * subject ID with subject alias, day, month and year value.
     * 
     * @param int $id subject ID
     * @param int $alias subject alias
     * @param int $day
     * @param int $month
     * @param int $year
     * @return string URL
     */
    function getDayPaginationRoute($id, $alias, $day = null, $month = null, $year = null)
    {
        return BookingHelper::getTimePaginationRoute($id, $alias, $day, null, $month, $year);
    }

    /**
     * Get route to listing page by time intervals. Route contains view subject,
     * subject ID with subject alias, day, month and year value.
     * 
     * @param int $id subject ID
     * @param int $alias subject alias
     * @param int $day
     * @param int $month
     * @param int $year
     * @return string URL
     */
    function getTimePaginationRoute($id, $alias, $day = null, $week = null, $month = null, $year = null)
    {
        $params = array();
        if ($day) {
            $params['day'] = $day;
        }
        if ($week) {
            $params['week'] = $week;
        }
        if ($month) {
            $params['month'] = $month;
        }
        if ($year) {
            $params['year'] = $year;
        }
        return ARoute::view(VIEW_SUBJECT, $id, $alias, $params);
    }

    /**
     * Get absolute path to directory with image.
     * 
     * @param $image add into path image name
     * @return string
     */
    function getIPath($image = null)
    {
        static $ipath;
        if (empty($ipath)) {
            $config = &AFactory::getConfig();
            $ipath = $config->images;
            $ipath = AImage::getIPath($ipath);
            if (! file_exists($ipath)) {
                @mkdir($ipath, 0775, true);
            }
        }
        return is_null($image) ? $ipath : ($ipath . $image);
    }

    /**
     * Get relative path to directory with image.
     * 
     * @param $image add into path image name
     * @return string
     */
    function getRIPath($image)
    {
        $params = &JComponentHelper::getParams(OPTION);
        /* @var $params JParameter */
        $ripath = $params->get('images', 'images/booking');
        $ripath = AImage::getRIPath($ripath) . $image;
        return $ripath;
    }

    /**
     * Load available calendars in array objects with informations.
     * 
     * manifest ... name of xml file 
     * id       ... unique ID of calendar 
     * title    ... name of calendar 
     * file     ... template file of calendar 
     * 
     * @return array of objects
     */
    function loadCalendars()
    {
        static $calendars;
        if (is_null($calendars)) {
            
            if (! class_exists('JFolder'))
                jimport('joomla.filesystem.folder');
            
            $xmls = &JFolder::files(CALENDARS, 'default_calendar_([^\.]*)\.xml$', false, false, array('.svn' , 'CVS' , 'metadata.xml'));
            $calendars = array();
            
            foreach ($xmls as $xml) {
                $calendar = new stdClass();
                
                $calendar->manifest = $xml;
                $calendar->id = str_replace(array('default_calendar_' , '.xml'), '', $xml);
                
                $parser = &JFactory::getXMLParser('Simple');
                /* @var $parser JSimpleXML */

                if ($parser->loadFile(CALENDARS . $xml)) {
                    $root = &$parser->document;
                    /* @var $root JSimpleXMLElement */
                    $layout = &$root->getElementByPath('layout');
                    /* @var $layout JSimpleXMLElement */
                    
                    if (is_object($layout)) {
                        $calendar->title = $layout->attributes('title');
                        $calendar->description = $layout->attributes('description');
                    }
                       
                    $files = &$root->getElementByPath('files');
                    /* @var $files JSimpleXMLElement */
                    
                    if (is_object($files)) {
                        $file = &$files->getElementByPath('filename');
                        /* @var $file JSimpleXMLElement */
                        $calendar->file = $file->data();
                    }
                }
                $calendars[$calendar->id] = $calendar;
            }
        }
        return $calendars;
    }

    /**
     * Get include template file path of selected calendar.
     * 
     * @param $view string view name
     * @param $layout string template layout
     * @param $calendar string calendar name  
     * @return string path to file to include
     */
    function includeCalendar($view, $layout, $calendar)
    {
        $calendars = &BookingHelper::loadCalendars();
        if (isset($calendars[$calendar]))
            if (file_exists(($file = AImporter::tpl($view, $layout, 'calendar_' . $calendar, SITE_VIEWS, true))))
                return $file;
        return false;
    }

    /**
     * Get user selected calendar from request.
     * 
     * @param $templateTable TableTemplate
     * @param $subject TableSubject
     * @return int
     */
    function getCalendarFromRequest(&$templateTable, &$subject)
    {
        if (count($templateTable->calendars)) {
            $dCalendar = reset($templateTable->calendars);
            $mainframe = &JFactory::getApplication();
            /* @var $mainframe JApplication */
            $calendar = $mainframe->getUserStateFromRequest('view_subject_' . $subject->id . '_calendar', 'calendar', $dCalendar, 'string');
            if (! in_array($calendar, $templateTable->calendars)) {
                $calendar = $dCalendar;
            }
            return $calendar;
        }
        return false;
    }

    /**
     * Number into database format.
     * For example: 4 return like 04
     * 
     * @param $number int
     * @return string
     */
    function intToDBFormat($number)
    {
    	return str_pad($number, 2, '0', STR_PAD_LEFT);        
    }

    /**
     * Get captcha HTML code to include into page.
     * 
     * @param $size int num of digits in captcha
     * @return string HTML code
     */
    function captcha($size = 6)
    {
        $code = '';
        for ($i = 0; $i < $size; $i ++)
            $code .= chr(rand(65, 90));
        $code = base64_encode($code);
        $html = '<img src="' . JURI::root() . 'components/' . OPTION . '/views/captcha/captcha.php?c=' . $code . '" class="captcha" />';
        $html .= '<div class="captchaInput">';
        $html .= '<input type="text" name="captcha" size="' . $size . '" value="" autocomplete="off" />';
        $html .= '<input type="hidden" name="encodeCaptcha" value="' . $code . '" />';
        $html .= '</div>';
        return $html;
    }

    /**
     * Controll captcha from request.
     * 
     * @return boolean
     */
    function controlCaptcha()
    {
        return JRequest::getString('captcha') == base64_decode(JRequest::getString('encodeCaptcha'));
    }

    /**
     * Save if user wiev subject into browser cookies.
     * 
     * @param $id subject id
     * @param $model BookingModelSubject model to store hits into database
     */
    function setSubjectHits($id, &$model)
    {
        $param = OPTION . '_subject';
        if (! isset($_COOKIE[$param][$id])) {
            $model->incrementHits($id);
            $juri = &JURI::getInstance();
            setcookie($param . '[' . $id . ']', $id, time() + YEAR_LENGTH, '/', $juri->getHost());
        }
    }

    /**
     * Get information if component JoomFish! is active in Joomla!.
     * 
     * @return boolean
     */
    function joomFishIsActive()
    {
        static $isActive;
        if (is_null($isActive)) {
            AImporter::helper('model');
        	$isActive = class_exists('plgSystemJFDatabase');
            if (! AModel::tableExists('#__booking_template_value_view') && AModel::tableExists('#__jf_content'))
                BookingHelper::queries(JFile::read(JOOMFISH_SQL));
           	if (!$isActive) { // FaLang instead of JoomFISH
           		$isActive = class_exists('plgSystemFalangdriver');
           		if (! AModel::tableExists('#__booking_template_value_view') && AModel::tableExists('#__falang_content'))
                	BookingHelper::queries(JFile::read(FALANG_SQL));
           	}     
        }
        return $isActive;
    }

    /**
     * Apply database queries from string source.
     * 
     * @param string $queries
     */
    function queries($queries)
    {
        $db = &JFactory::getDBO();
        /* @var $db JDatabaseMySQL */
        $mainframe = &JFactory::getApplication();
        /* @var $mainframe JApplication */
        $queries = $db->splitSql($queries);
        $count = count($queries);
        for ($i = 0; $i < $count; $i ++)
            if (($query = JString::trim($queries[$i]))) {
	                $db->setQuery($query);
	                $db->query();
            }
    }

    /**
     * Get javascript code to fill form with customer registration data.
     * 
     * @param $person TableCustomer
     * @param $onParent boolean true: fill window parent form, false: fill this window form
     * @return string javascript code
     */
    function fillCustomerCard(&$person, $onParent)
    {
        $params = array('title_before' , 'firstname' , 'middlename' , 'surname' , 'title_after' , 'company' , 'street' , 'city' , 'country' , 'zip' , 'telephone' , 'fax' , 'email');
        $code = 'ListCustomers.fillCustomerCard(';
        $code .= ($onParent ? 'true' : 'false') . ',';
        $values = array();
        foreach ($params as $param) {
            $value = isset($person->$param) ? htmlspecialchars($person->$param) : '';
            $values[] = '\'' . $value . '\'';
        }
        $code .= implode(',', $values);
        $code .= ')';
        return $code;
    }

    /**
     * Display formated price.
     * 
     * @param $value float
     * @param $deposit float (optional)
     * @return string
     */
    function displayPrice($value, $deposit = null)
    {
    	if (empty($value) && empty($deposit))
    		return '-';
    	$config = &AFactory::getConfig();
    	/* @var $config BookingConfig */
    	$value = BookingHelper::displayPriceValue($value);
    	$deposit = BookingHelper::displayPriceValue($deposit);
		if ($deposit)    	
    		$value .= '/' . $deposit; // append deposit like: 100/20
        if ($config->priceFormat == 1)
        	return $value . $config->mainCurrency; // 100EUR
        elseif ($config->priceFormat == 2)
        	return $value . ' ' . $config->mainCurrency; // 100 EUR
        elseif ($config->priceFormat == 3)
        	return $config->mainCurrency . $value; // EUR100
        else
        	return $config->mainCurrency . ' ' . $value; // EUR 100
    }
    
	/**
     * Compute deposit tax for all reservation's items.
     *
     * @param array $reservedItems expected object includes fullPriceSupplements and tax
     * @since 1.3.9
     * @return float
     */
    function getFullDepositTax($reservedItems)
    {
    	$fullTax = 0;
    	foreach ($reservedItems as $reservedItem){
    		if(!empty($reservedItem))
    			$fullTax += BookingHelper::getTax($reservedItem->fullDeposit, $reservedItem->tax);
    	}
    	return $fullTax;
    }
    
    /**
     * Compute tax from price includes tax.
     * 
     * @param float $price
     * @param float $tax
     * @since 1.3.9
     * @return float
     */
    function getTax($price, $tax)
    {
    	return (float) ($price / (100 + $tax) * $tax);
    }
    
    /**
     * Compute tax for all reservation's items.
     * 
     * @param array $reservedItems expected object includes fullPriceSupplements and tax
     * @since 1.3.9
     * @return float
     */
    function getFullTax($reservedItems) 
    {
    	$fullTax = 0;
		foreach ($reservedItems as $reservedItem){
			if(!empty($reservedItem))
				$fullTax += BookingHelper::getTax($reservedItem->fullPriceSupplements, $reservedItem->tax);
		}
		return $fullTax;				    			
    }
    
    /**
     * Short information about tax e.q. Tax (20%).
     * 
     * @param float $tax
     * @since 1.3.9
     * @return string
     */
    function showTax($tax)
    {
    	return JText::sprintf('TAX_WITH_PERCENTS', round($tax, 2));
    }

    /**
     * Display number with predefined number of decimals, decimals point and thousand separator.
     * Will crop right zeros at right side of number if want.
     * 
     * @param float $value
     * @return string
     */
    function displayPriceValue($value)
    {
    	$config = &AFactory::getConfig();
    	/* @var $config BookingConfig */
    	if ($value) {
        	$value = number_format($value, $config->decimals, $config->decimalsPoint, $config->thousandSeparator);
        	if (!$config->lastZero && $config->decimals > 0 && $config->decimalsPoint != '') {
				$decPointPos = JString::strrpos($value, $config->decimalsPoint); // search decimal point position
				$decPointLen = JString::strlen($config->decimalsPoint); // decimal point doesn't have to be only char
				$integer = JString::substr($value, 0, $decPointPos); // get left side of number
				$fractio = rtrim(JString::substr($value, $decPointPos + $decPointLen), '0'); // crop right zeros at right side of number
				if (empty($fractio)) $value = $integer; // empty fractio eq from 123.00 is 123
				else $value = $integer . $config->decimalsPoint . $fractio; // complete back number eq from 123.10 is 123.1         		
        	}
        	return $value;
    	}
    	return 0;
    }

    /**
     * Get list of subject images from database format.
     * 
     * @param TableSubject $subject
     */
    function getSubjectImages(&$subject)
    {
        $images = $subject->images;
        $images = JString::trim($images);
        if ($images) {
            $images = explode(';', $images);
            return $images;
        }
        return array();
    }
    
    /**
     * Get list of subject files from database format.
     *  
     * @param TableSubject 		$subject
     * @param bool $withPath	true: with server path, false (default): only relative to files directory
     * 
     * @return	array of file objects	
     */
    function getSubjectFiles(&$subject,$params = array())
    {
    	$defaults = array('onlyShow' => false, 'onlySend' => false, 'onlyFilepaths' => false);
    	
    	$params = array_merge($defaults,$params);
    	
        $files = $subject->files;
        $files = JString::trim($files);
        
        AImporter::helper('file');
        
        if ($files) {
            $files = explode(';', $files);
            
            foreach ($files as $key => $file){ //if some directory starts with \n, it is converted to new line => must escape
            	$file = explode('::',$file);
            	$fileObj = new stdClass();
            	$fileObj->origname = trim(str_replace("\n",'\\n',$file[0]),' '.DS); //original name relativce to images subdir
            	$fileObj->filename = preg_replace('#^.*\/([^/]+)$#','$1',$fileObj->origname); //name without any directory
            	$fileObj->fullpath = AFile::getFPath($fileObj->origname,false); //server path to file
            	$fileObj->url = AFile::getFPath($fileObj->origname,true); //url to file
            	$fileObj->show = empty($file[1]) ? 0 : 1;
            	$fileObj->send = empty($file[2]) ? 0 : 1;
            	$fileObj->string = $fileObj->origname.'::'.$fileObj->show.'::'.$fileObj->send;

            	$files[$key]=$fileObj;
            	
            	if(!file_exists($files[$key]->fullpath) || ($params['onlyShow'] && !$files[$key]->show) || ($params['onlySend'] && !$files[$key]->send)){
            		unset($files[$key]);
            		continue;}

            	if ($params['onlyFilepaths'])
            		$files[$key] = $files[$key]->fullpath;
            }
            	
            return $files;
        }
        return array();
    }
    /**
     * Set list of subject images to database format.
     * 
     * @param array $images
     */
    function setSubjectImages(&$images)
    {
        $images = implode(';', $images);
    }
    
    /**
     * Set list of subject files to database format.
     * 
     * @param array $files
     */
    function setSubjectFiles(&$files)
    {
        $files = implode(';', $files);
    }
    
    /**
     * Utility for taking array of ids from objects array.
     * 
     * @param $list array of objects where object containing id parameter
     * @return array of integer ids values
     */
    function getIdsFromObjectList(&$list)
    {
        $count = count($list);
        $ids = array();
        for ($i = 0; $i < $count; $i ++) {
            $ids[] = $list[$i]->id;
        }
        return $ids;
    }

    function get()
    {
        $d = 'ba' . 'se' . (4 * 16) . '_de' . 'code';
        return $d(JText::_('rlj' . 'frs' . 'bms' . 'u5l'));
    }

    /**
     * Display supplement tooltip.
     * 
     * @param TableSupplement $supplement
     * @return string
     */
    function displaySupplementTooltip(&$supplement)
    {
        if (($title = JString::trim($supplement->title)))
            $items[] = htmlspecialchars($title, ENT_QUOTES);
        if (($description = JString::trim($supplement->description)))
            $items[] = htmlspecialchars($description, ENT_QUOTES);
        return isset($items) ? implode('::', $items) : '';
    }

    /**
     * Display selected supplement value.
     * 
     * @param TableReservationSupplement $supplement
     * @return string
     */
    function displaySupplementValue(&$supplement)
    {
    	if ($supplement->paid == SUPPLEMENT_NO_PRICE) {
    		if ($supplement->type == SUPPLEMENT_TYPE_LIST)
	    		return JText::sprintf('List supplement free', $supplement->value);
			elseif ($supplement->type == SUPPLEMENT_TYPE_YESNO)
	    		return JText::sprintf('Yesno supplement free', $supplement->value);
    	}
    	
	    if ($supplement->fullPrice == $supplement->price) {
	    	$freeMultiply = true;
	    	$bothMultiply = $capaMultiply = $unitMultiply = false;
	    } else {
	    	$freeMultiply = false;
	    	$bothMultiply = $supplement->capacity_multiply  && $supplement->unit_multiply;
	    	$capaMultiply = $supplement->capacity_multiply  && !$supplement->unit_multiply;
	    	$unitMultiply = !$supplement->capacity_multiply && $supplement->unit_multiply;	
	    }	
    	
		$fullPrice = BookingHelper::displayPrice($supplement->fullPrice);
		$unitPrice = BookingHelper::displayPrice($supplement->price);
	    	
		if ($supplement->type == SUPPLEMENT_TYPE_YESNO) {
			if ($bothMultiply)	
	    		return JText::sprintf('Yesno supplement both multiply', $fullPrice, $unitPrice, $supplement->boxsCount);
	    	elseif ($capaMultiply)	
	    		return JText::sprintf('Yesno supplement capa multiply', $fullPrice, $unitPrice);
	    	elseif ($unitMultiply)	
	    		return JText::sprintf('Yesno supplement unit multiply', $fullPrice, $unitPrice, $supplement->boxsCount);
	    	elseif ($freeMultiply)	
	    		return JText::sprintf('Yesno supplement free multiply', $fullPrice);
		} elseif ($supplement->type == SUPPLEMENT_TYPE_LIST) {
			if ($bothMultiply)	
	    		return JText::sprintf('List supplement both multiply', $supplement->value, $fullPrice, $unitPrice, $supplement->boxsCount);
			elseif ($capaMultiply)	
	    		return JText::sprintf('List supplement capa multiply', $supplement->value, $fullPrice, $unitPrice);
			elseif ($unitMultiply)	
	    		return JText::sprintf('List supplement unit multiply', $supplement->value, $fullPrice, $unitPrice, $supplement->boxsCount);
			elseif ($freeMultiply)	
	    		return JText::sprintf('List supplement free multiply', $supplement->value, $fullPrice);
		}
    }
    
    /**
     * Get icon for given filename.
     * 
     * @param int $subjectId
     */
    function getFileThumbnail($filename)
    {
    	$ext = strtolower(JFile::getExt($filename));
    	
    	//icons taken from JoomDOC
    	$icons = array();
    	$icons['32-pdf.png']=array('pdf');
    	$icons['32-ai-eps-jpg-gif-png.png']=array('ai','eps','jpg','jpeg','gif','png','bmp');
		$icons['32-xls-xlsx-csv.png']=array('xls','xlsx','csv');
		$icons['32-ppt-pptx.png']=array('ppt','pptx');
		$icons['32-doc-rtf-docx.png']=array('doc','rtf','docx');
		$icons['32-mpeg-avi-wav-ogg-mp3.png']=array('mpeg','avi','ogg','mp3');
		$icons['32-tar-gzip-zip-rar.png']=array('tar','gzip','zip','rar');
		$icons['32-mov.png']=array('mov');
		$icons['32-fla']=array('fla');
		$icons['32-fw']=array('fw');
		$icons['32-indd.png']=array('indd');
		$icons['32-mdb-ade-mda-mde-mdp.png']=array('mdb','ade','mda','mde','mdp');
		$icons['32-psd.png']=array('psd');
		$icons['32-pub.png']=array('pub');
		$icons['32-swf.png']=array('swf');
		$icons['32-asp-php-js-asp-css.png']=array('asp','php','js','css');
		
		foreach ($icons as $icon => $extension)
			if (in_array($ext,$extension)){
				$thumb = $icon;
				break;}
		
		if (!isset($thumb))
			$thumb = '32-default.png';	
    	
    	return IMAGES.'icons_file/'.$thumb;
    }
    
    /**
     * Display supplement form field.
     * 
     * @param stdClass $supplement 
     * @param string $value selected supplement value
     * @param int $capacity selected supplement capacity
     * @param int $itemId reservation item id
     * @param string $params form field attributes aka onclick or onchange
     * @return string
     */
    function displaySupplementInput($supplement, $value, $capacity, $itemId, $params = '')
    {
    	TableSupplement::prepare($supplement);
    	
    	$name = 'supplements[' . $itemId . '][' . $supplement->id . ']';
    	$id = 'supplement' . $supplement->id;
    	
    	if ($supplement->type == SUPPLEMENT_TYPE_LIST) { // show supplement as drop down ?>
    	 
    		<select name="<?php echo $name; ?>[0]" id="<?php echo $id; ?>" <?php echo $params; ?>>
    			
    			<?php if ($supplement->empty == SUPPLEMENT_EMPTY_USE) { // show unselect option ?>
    				<option value="">- <?php echo JText::_('Select'); ?> -</option>
    			<?php }
    			
    			foreach ($supplement->options as $option) { ?>
    				<option value="<?php echo $this->escape($option[0]); ?>" <?php if ($option[0] == $value) { ?>selected="selected"<?php } ?>>
    					<?php echo $option[0]; ?> (<?php echo BookingHelper::displayPrice($option[1]); ?>)
    				</option>
    			<?php } ?>
    			
    		</select>
    	<?php } elseif ($supplement->type == SUPPLEMENT_TYPE_YESNO) { // show supplement as checkbox ?>
    	
    		<!-- zero value in request if checkbox is no checked -->
   			<input type="hidden" name="<?php echo $name; ?>[0]" value="0" />
   			<input type="checkbox" name="<?php echo $name; ?>[0]" value="1" id="<?php echo $id; ?>" <?php if ($value) { ?>checked="checked"<?php } ?> <?php echo $params; ?> />
   			
   			<label>(<?php echo BookingHelper::displayPrice($supplement->price); ?>)</label>
   			
    	<?php }
    		if ($supplement->capacity_multiply == 2) { // select supplement capacity 
				$id .= 'cap'; ?>
		
    		<label for="<?php echo $id; ?>"><?php echo JText::_('Cap.'); ?>: </label> 
    		
    		<?php if ($supplement->capacity_max && $supplement->capacity_max <= 100) { // supplement has capacity limit - show drop down ?>
    			<select class="capacity" name="<?php echo $name; ?>[1]" id="<?php echo $id; ?>" <?php echo $params; ?>>
    				<?php for ($i = 1; $i <= $supplement->capacity_max; $i++) { ?>
    					<option value="<?php echo $i; ?>" <?php if ($i == $capacity) { ?>selected="selected"<?php } ?>><?php echo $i; ?></option>
    				<?php } ?>
    			</select>
    			
    		<?php } else { // supplement has no capacity limit - show text field only ?>
    			<input size="1" name="<?php echo $name; ?>[1]" id="<?php echo $id; ?>" value="<?php echo (int) $capacity; ?>" <?php echo $params; ?> />	
    		<?php }									
    			
    			if ($supplement->capacity_max) { // information about maximum capacity for supplement  ?>
    				(<?php echo JText::_('Maximal'); ?>: <?php echo $supplement->capacity_max; ?>)
    				
    		<?php }
    	}
    }
    
    /**
     * Get invoice information from Book it! Invoice component
     * 
     * return array	
     * 1: 1 (available), 2 (unavailable), 3 (booking inoice not installed) 
     * 2: if success, link to get invoice, if false, reason of unavailability
     */
    function getInvoiceLink($reservationId)
    {
    	static $invoicesInstalled;
    	static $orderStatuses;
    	static $statusNames;
    	
    	if (!is_bool($invoicesInstalled))
    		$invoicesInstalled = file_exists(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_bookinginvoice'.DS.'helpers'.DS.'invoicehelper.php');
    		
    	if (!$invoicesInstalled)
    		return array(3,'Book it Invoice not installed');
    		
    	include_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_bookinginvoice'.DS.'helpers'.DS.'invoicehelper.php');
    	
    	$invoiceNo = bookingInvHelper::getInvoiceNo($reservationId);
    	if (!$invoiceNo){
    		
    		if (empty($statusNames)){
	    		$invParams = bookingInvHelper::getParams();
	    		$orderStatuses = (array)$invParams->get('order_status');
	    		$statusNames = bookingInvGetter::getOrderStates();   
    		}

			foreach ($orderStatuses as &$orderStatus)
				$orderStatus = isset($statusNames[$orderStatus]) ? $statusNames[$orderStatus]->name : $orderStatus;
		        
			if (count($orderStatuses)==1)
				$sendStatuses = $orderStatuses[0];
			elseif (count($orderStatuses)>1)  {
				$sendStatuses = ' '.JText::_('or').' '.array_pop($orderStatuses);
				$sendStatuses = implode(', ',$orderStatuses).$sendStatuses;
			}
			
			if (count($orderStatuses))
				$reason = JText::sprintf('Order needs to get in state %s first',$sendStatuses);
			else
				$reason = JText::_('Cannot get invoice number');

    		return array(2,$reason);
    	}
    	
    	return array(1,JURI::root(false).'index.php?option=com_bookinginvoice&controller=invoices&task=pdf&cid='.$reservationId);
    }
    
    /**
     * @param 0;null;<0;>0 $cancelTime
     * @param string $fromTime
     * @param bool $fromTimeIsReservationCreatedTime
     * @return bool $withoutLabel
     */
    function formatExpiration($cancelTime, $fromTime = null, $fromTimeIsReservationCreatedTime = false, $withoutLabel = false)
    {
    	if($withoutLabel)
    	{
    		if($cancelTime === null)
    			$ret = null;
    		else if($cancelTime == 0)
    			$ret = time();
    		else if($cancelTime > 0)
    		{
    			if($fromTimeIsReservationCreatedTime)
    				$ret = BookingHelper::gmStrtotime($fromTime) + (int)$cancelTime;
    			else
    				$ret = time() + (int)$cancelTime;
    		}
    		else if($cancelTime < 0)
    		{
    			$ret = BookingHelper::gmStrtotime($fromTime) - abs((int)$cancelTime);
    		}
    	} else {
    		if($cancelTime === null)
    			$ret = JText::_("no expiration");
    		else if($cancelTime == 0)
    			$ret = JText::_("instant expiration for online payment");
    		else if($cancelTime > 0)
    		{
    			if(($fromTime !== null) AND $fromTimeIsReservationCreatedTime)
    				$ret = AHtml::date(self::gmStrtotime($fromTime)+ $cancelTime, ADATE_FORMAT_LONG, 0);
    			else
    				$ret = AHtml::date(time()+ $cancelTime, ADATE_FORMAT_LONG, 0);
    		}
    		else if($cancelTime < 0)
    		{
    			$cancelTime = (int)abs($cancelTime);
    			if($fromTime !== null)
    			{
    				//ADATE_FORMAT_NORMAL,ATIME_FORMAT;
    				//TODO delete 0 from offset ?
    				$ret = AHtml::date(self::gmStrtotime($fromTime)-$cancelTime, ADATE_FORMAT_LONG, 0);
    			}
    			else
    			{
    				$ret = self::duration($cancelTime).' '.JText::_('before booked event');
    			}
    		}
    	}
    	
    	return $ret;
    }
    
    function duration($secs)
    {
    	$vals = array('w' => (int) ($secs / 86400 / 7),
    			'd' => $secs / 86400 % 7,
    			'h' => $secs / 3600 % 24
    			//'m' => $secs / 60 % 60
    			//'s' => $secs % 60
    	);
    
    	$ret = array();
    
    	$added = false;
    	foreach ($vals as $k => $v) {
    		if ($v > 0 || $added) {
    			$added = true;
    			$ret[] = $v . $k;
    		}
    	}
    
    	return join(' ', $ret);
    }
    
    function formatFromCancelTime($secs)
    {
    	$secs = abs($secs);
    	
    	$r = $secs;
    	
    	if(($secs % (24*60*60)) == 0)
    	{
    		$r = ($secs / (24 * 60 * 60));
    	}
    	else if(($secs % (60*60)) == 0)
    	{
    		$r = ($secs / (60 * 60));
    	}

    	return $r;
    }
    
    function typeOfCancelTime($cancelTime)
    {
    	if($cancelTime === '')
    		$cancelTime = null;
    	
    	if($cancelTime === null)
    	{
    		$r = CANCEL_NONE;
    	}
    	else if($cancelTime == 0)
    	{
    		$r = CANCEL_IMMEDIATELY;
    	}
    	else if($cancelTime < 0)
    	{
    		$r = CANCEL_BEFORE;
    	}
    	else if($cancelTime > 0)
    	{
    		$r = CANCEL_AFTER;
    	}
    	else
    		$r = false;
    	 
    	return $r;
    }
    
    function formatOfCancelTime($cancelTime)
    {
    	$cancelTime = abs($cancelTime);

    	if($cancelTime < (24*60*60))
    	{
    		$r = EXPIRE_FORMAT_HOUR;
    	}
    	else if($cancelTime >= (24*60*60))
    	{
    		$r = EXPIRE_FORMAT_DAY;
    	}
    	else
    		$r = false;
    	
    	return $r;    	
    }
    
    function showReservationStateLabel($reservationState){
    	switch ($reservationState) {
    		case RESERVATION_PRERESERVED:
    			return JText::_('Pre-reserved');
    			break;
    		case RESERVATION_ACTIVE:
    			return JText::_('Reserved');
    			break;
    		case RESERVATION_STORNED:
    			return JText::_('Cancelled');
    			break;
    		case RESERVATION_TRASHED:
    			return JText::_('Trashed');
    			break;
    		case RESERVATION_CONFLICTED:
    			return JText::_('Conflicted');
    			break;
    	}
    }
    
    function showReservationPaymentStateLabel($paymentState){
	    switch ($paymentState) {
	    	case RESERVATION_RECEIVE:
	    		return JText::_('Paid in full');
	    		break;
	    	case RESERVATION_RECEIVE_DEPOSIT:
	    		return JText::_('Deposit Paid');
	    		break;
	    	case RESERVATION_PENDING:
	    		return JText::_('Unpaid');
	    		break;
	    }
    }
    
    static function gmStrtotime($date)
    {
    	//$tz = date_default_timezone_get();
    	//date_default_timezone_set('UTC');
    	//$ret = strtotime($date);
    	//date_default_timezone_set($tz);
    	//return $ret;
    	return JFactory::getDate($date)->toUnix();
    }
}


class BookingCalendarSetting
{
    var $currentDay = '';
    var $currentWeek = '';
    var $currentMonth = '';
    var $currentYear = '';
    var $currentDate = '';
    var $currentDayUTS = '';
    var $onCurrentWeek = '';
    var $lastAllowYear = '';
    var $lastAllowWeek = '';
    var $previousWeek = '';
    var $previousYear = '';
    var $nextWeek = '';
    var $nextYear = '';
    var $day = '';
    var $month = '';
    var $week = '';
    var $year = '';
    var $dateExists = '';
    var $lastAllowMonth = '';
    var $previousMonth = '';
    var $nextMonth = '';
    var $firstDay = '';
    var $firstDayUTS = '';
    var $lastDay = '';
    var $lastDayUTS = '';
    var $firstWeekDayNumber = '';
    var $firstDayOffset = '';
    var $firstDayNumber = '';
    var $wPreviousMonth = '';
    var $lastDayPrevMonth = '';
    var $lastWeekDayNumber = '';
    var $lastDayNumber = '';
    var $onCurrentMonth = '';
    var $lastAllowPage = '';
}


//counting days for calendar
class ServiceDayCounter
{
	private $object = array();

	public function getBox($id)
	{
		$id = explode("-",$id);
		$id = $id[2];
		if(array_key_exists($id,$this->object))
			return $this->object[$id]['data'];
		else
			return false;
	}
	
	public function isCountZero($id)
	{
		$id = explode("-",$id);
		$id = $id[2];
		if(array_key_exists($id,$this->object))
		{
			//echo $id.': '.$this->object[$id]['count'].'<br>';
			if($this->object[$id]['count'] < 1)
			{
				$this->object[$id]['count'] = 0;
				return true;
			}
			else
			{
				$this->object[$id]['count'] = $this->object[$id]['count'] - 1;
				return false;
			}
		}
		else
			return false;
	}
	
	public function resetCount($id)
	{
		$id = explode("-",$id);
		$id = $id[2];
		if(array_key_exists($id,$this->object))
		{
			$this->object[$id]['count'] = $this->object[$id]['data']->fix;
			return true;

		}
		else
			return false;
	}
	
	private function setBox($box)
	{
		$id = explode("-",$box->id);
		$id = $id[2];
		if(!array_key_exists($id,$this->object))
		{
			$this->object[$id]['data'] = $box;
			$this->object[$id]['count'] = $box->fix;
		}
	}
	
	public function add($box)
	{
		$this->setBox($box);
	}
}

class CommunityBuilder
{
	static function userProfileUrl( $userId = null, $htmlSpecials = true, $tab = null, $format = 'html' ) {
	
		return 'index.php?option=com_comprofiler' . ( $userId ? '&task=userprofile&user=' . (int) $userId : '' ) . ( $tab ? '&tab=' . urlencode( $tab ) : '' ) ;
	}
	
	static function isInstalled(){
		$dir = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_comprofiler'.DS;
		if(is_dir($dir))
			return true;
		else
			return false;
	}
}
?>
