<?php

/**
 * Reservation table object.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  tables 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

class TableReservationItems extends JTable
{
    /**
     * Primary key
     * 
     * @var int
     */
    var $id;
    /**
     * ID of reservation item.
     * 
     * @var int
     */
    var $reservation_id;
    /**
     * Use Reservation type constant (daily,hourly ...)
     * 
     * @var int
     */
    var $rtype;
    /**
     * Rezerved subject ID
     * 
     * @var int
     */
    var $subject;
    /**
     * Reserved subject title
     * 
     * @var string
     */
    var $subject_title;
    /**
     * Rezervation valid from
     * 
     * @var string MySQL datetime
     */
    var $from;
    /**
     * Rezervation valid to
     * 
     * @var string MySQL Datetime
     */
    var $to;
    /**
     * Rezervation capacity
     * 
     * @var string MySQL Datetime
     */
    var $capacity;
    /**
     * Price for single capacity in timeline.
     * 
     * @var float
     */
    var $price;
    /**
     * Price deposit
     * 
     * @var float
     */
    var $deposit;
    /**
     * Full price multiplied by capacity (if set so)
     * 
     * @var float
     */
    var $fullPrice;
    /**
     *  Full reservation price with supplements.
     * 
     * @var float
     */
    var $fullPriceSupplements;
    /**
     *  Full deposit multiplied by capacity (if set so)
     * 
     * @var float
     */
    var $fullDeposit;
    /**
     * Tax value in percent.
     * 
     * @var float
     */
    var $tax;
    /**
     * Time having to pay from order date
     *
     * @var int
     */
    var $cancel_time;
    /**
     * Message to calendar
     *
     * @var string
     */
    var $message;
    /**
     * Time up in period timeframe
     * @var time
     */
    var $period_time_up;
    /**
     * Time down in period timeframe
     * @var time
     */
    var $period_time_down;
    /**
     * Daily, Weekly, Monthly, Yearly.
     * Value of constants: PERIOD_TYPE_DAILY, PERIOD_TYPE_WEEKLY, PERIOD_TYPE_MONTHLY, PERIOD_TYPE_YEARLY 
     * @var int
     */
    var $period_type;
    /**
     * Recurrence in period type
     * EQ recurrence every # week
     * @var int
     */
    var $period_recurrence;
    /**
     * Period is valid for Monday
     * @var bool
     */
    var $period_monday;
    /**
     * Period is valid for Tuesday
     * @var bool
     */
    var $period_tuesday;
    /**
     * Period is valid for Wednesday
     * @var bool
     */
    var $period_wednesday;
    /**
     * Period is valid for Thursday
     * @var bool
     */
    var $period_thursday;
    /**
     * Period is valid for Friday
     * @var bool
     */
    var $period_friday;
    /**
     * Period is valid for Saturday
     * @var bool
     */
    var $period_saturday;
    /**
     * Period is valid for Sunday
     * @var bool
     */
    var $period_sunday; 
    /**
     * Recurrence in one year month (month number 1-12) 
     * @var int
     */
    var $period_month;
    /**
     * Recurrence in one month week (week number 1-4)
     * @var int
     */
    var $period_week;
    /**
     * Recurrence in one week day (day number 1-7)
     * @var int
     */
    var $period_day;
    /**
     * Period end type (no end, end after # occurrences, end in date)
     * Value of constants: PERIOD_END_TYPE_NO, PERIOD_END_TYPE_AFTER, PERIOD_END_TYPE_DATE 
     * @var int
     */   
    var $period_end;
    /**
     * Number of occurrences to end period (with period end after occurrences #)
     * @var int
     */
    var $period_occurrences;
    /**
     * Date up of period
     * @var date
     */
    var $period_date_up;
    /**
     * Date down of period (with period end in date)
     * @var date
     */
    var $period_date_down;
    /**
     * Total number of occurrences computed according settings.
     * @var int
     */
    var $period_total;
    
    var $period;
    
    /**
     * Construct object.
     * 
     * @param JDatabaseMySQL $db database connector
     */
    function __construct(& $db)
    {
        parent::__construct('#__' . PREFIX . '_reservation_items', 'id', $db);
    }

    /**
     * Init empty object
     * 
     */
    function init()
    {
        $this->id = 0;
        $this->reservation_id = 0;
        $this->rtype = 0;
        $this->subject = 0;
        $this->subject_title = '';
        $this->fax = '';
        $this->from = '';
        $this->to = '';
        $this->capacity = 0;
        $this->price = 0;
        $this->deposit = 0;
        $this->fullPrice = 0;
        $this->fullDeposit = 0;
        $this->cancel_time = '';
        $this->message = '';
    }

    /**
     * Clean object data.
     */
    function clean()
    {
        $this->capacity = $this->capacity ? $this->capacity : '';
        $this->price = ($this->price != 0.0 && $this->price != 0) ? $this->price : '';
        $this->deposit = ($this->deposit != 0.0 && $this->deposit != 0) ? $this->deposit : '';
    }

    /**
     * Reservation full price + supplements prices (if set, multiplied by capacity).
     * 
     * @param array $supplements
     * @return void
     */
    /*
    function setFullPriceSupplements(&$supplements)
    {
    	$this->fullPriceSupplements = $this->fullPrice;
    	
        foreach ($supplements as $supplement){
        	$this->fullPriceSupplements += $supplement->price * ($supplement->capacity_multiply ? $this->capacity : 1);
        }
    }
    */

    function bind($data)
    {
        if (($result = parent::bind($data))) {
        	$this->id = (int) $this->id;
            $this->reservation_id = (int) $this->reservation_id;
            $this->rtype = (int) $this->rtype;
            $this->subject = (int) $this->subject;
            $this->subject_title = JString::trim($this->subject_title);
            $this->from = JString::trim($this->from);
            $this->to = JString::trim($this->to);
            $this->capacity = (int) $this->capacity;
            $this->price = (float) $this->price;
            $this->deposit = (float) $this->deposit;
            $this->fullPrice = (float) $this->fullPrice;
            $this->fullDeposit = (float) $this->fullDeposit;
            $this->message = JString::trim($this->message);
        }
        return $result;
    }
    
    function store($updateNulls = false) {
    	if (isset($this->period)) {
    		$period = $this->period;
    		unset($this->period);
    	}
    	parent::store($updateNulls);
    	if (isset($period)) {
    		$reservationperiod = JTable::getInstance('ReservationPeriod', 'Table');
    		/* @var $reservationperiod TableReservationPeriod */
    		$reservationperiod->reservation_item_id = $this->id;
    		foreach ($period as $item) {
    			$reservationperiod->id = null;
    			$reservationperiod->from = date('Y-m-d', $item) . ' ' . $this->period_time_up;
    			$reservationperiod->to = date('Y-m-d', $item) . ' ' . $this->period_time_down;
    			$reservationperiod->store();
    		}
    	}
    	return true;
    }

    /**
     * Check object data before saving.
     * 
     * @return boolean
     */
    function check()
    {
        if (($result = parent::check())) {
            $this->from = AModel::datetime2save($this->from);
            $this->to = AModel::datetime2save($this->to);
        }
        
        return $result;
    }
}
?>