<?php

/**
 * Admins administration list template. 
 * Display browse table with advanced filter.
 * Set the toolbar for many operations with admins.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewAdmins */

JHTML::_('behavior.tooltip');

BookingHelper::setSubmenu(6);

$mainframe = &JFactory::getApplication();
/* @var $mainframe JApplication */
$document = &JFactory::getDocument();
/* @var $document JDocument */
$template = $mainframe->getTemplate();

JToolBarHelper::title(JText::_(COMPONENT_NAME).": ".JText::_('Reservation Managers'), 'cbadmins.png');
JToolBarHelper::custom('setAsAdmin','new','new','Make Global Manager');
JToolBarHelper::custom('setAsNoAdmin','cancel','cancel','Unset from Global Managers');

?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<fieldset id="filter-bar">
   		<label for="filter_search"><?php echo JText::_('Filter'); ?></label>
		<input type="text" name="filter_search" id="filter_search" onchange="this.form.submit();" value="<?php echo $this->escape($this->lists['search']); ?>" />
		<button>
			<?php echo JText::_('OK'); ?>
		</button>
		<button  onclick="this.form.reset.value=1;this.form.submit();">
			<?php echo JText::_('Reset'); ?>
		</button>
		<select name="filter_global_manager" id="filter_global_manager" onchange="this.form.submit()">
			<option value="">- <?php echo JText::_('Global Manager'); ?> -</option>
			<option value="1"<?php if ($this->lists['global_manager'] === '1') { ?> selected="selected"<?php } ?>><?php echo JText::_('JYES'); ?></option>
			<option value="0"<?php if ($this->lists['global_manager'] === '0') { ?> selected="selected"<?php } ?>><?php echo JText::_('JNO');  ?></option>
		</select>
	</fieldset>
	<div id="editcell">
		<table class="adminlist" cellspacing="1">
			<thead>
				<tr>
					<th width="1%" nowrap="nowrap">#</th>
					<th width="1%" nowrap="nowrap">
						<input type="checkbox" class="inputCheckbox" name="toggle" value="" onclick="checkAll(<?php echo count($this->items); ?>);" />
					</th>
					<th>
				        <?php echo JHTML::_('grid.sort', 'Name', 'name', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JHTML::_('grid.sort', 'Username', 'username', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JHTML::_('grid.sort', 'Group', 'usertype', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JText::_('Email'); ?>
					</th>
					<th width="1%" nowrap="nowrap">
				        <?php echo JHTML::_('grid.sort', 'Manager Type', 'isadmin', $this->lists['order_Dir'], $this->lists['order']); ?>
					</th>
				</tr>
			</thead>
			<tfoot>
    			<tr>
    				<td colspan="7">
    				    <?php echo $this->pagination->getListFooter(); ?>
    				</td>
    			</tr>
			</tfoot>
			<tbody>
				<?php if (! is_array($this->items) || ! count($this->items)) { ?>
					<tr><td colspan="7"><?php echo JText::_('No items found.'); ?></td></tr>
				<?php } else { ?>
				    <?php 
				    	foreach ($this->items as $i => $item) {
				    		/* @var $item TableAdmin */ 
							$item->checked_out = 0; // required by JHtmlGrid::checkedOut 
				    ?>
				    	<tr class="row<?php echo ($i % 2); ?>">
				    		<td align="right"><?php echo $this->pagination->getRowOffset($i); ?></td>
				    		<td><?php echo JHTML::_('grid.checkedout', $item, $i); ?>
				    		</td>
				    		<td><a href="<?php echo JRoute::_(ARoute::editUser($item->id)); ?>" title="<?php echo $this->escape(JText::_('Edit User Acount')); ?>::<?php echo $this->escape($item->name)?>" class="hasTip"><?php echo $item->name; ?></a></td>
				    		<td nowrap="nowrap"><?php echo $item->username; ?></td>
				    		<td nowrap="nowrap"><?php echo JText::_($item->usertype); ?></td>
				    		<td><a href="mailto:<?php echo $item->email; ?>" title="<?php echo $this->escape(JText::_('Send E-mail to')); ?>::<?php echo $this->escape($item->email); ?>" class="hasTip"><?php echo $item->email; ?></a></td>
				    		<td align="center"> 
				    			<?php if ($item->isadmin) { ?>
            						<a onclick="listItemTask('cb<?php echo $i; ?>','setAsNoAdmin')" href="javascript:void(0)" title="<?php echo $this->escape(JText::_('Unset from Global Managers')); ?>::<?php echo $this->escape($item->name); ?>" class="hasTip">
            							<img src="/components/com_booking/assets/images/icon-16-language.png" alt="" />
            						</a>
								<?php } else { ?>
									<a onclick="listItemTask('cb<?php echo $i; ?>','setAsAdmin')" href="javascript:void(0)" title="<?php echo $this->escape(JText::_('Make Global Manager')); ?>::<?php echo $this->escape($item->name); ?>" class="hasTip">
            							<img src="/components/com_booking/assets/images/icon-16-disabled.png" alt="" />
            						</a>
            					<?php } ?>
				    		</td>
				    		
				    	</tr>
				    <?php } ?>
				<?php } ?>
			</tbody>
		</table>
		<table align="center">
			<tr align="center">
				<td style="background: url('/components/com_booking/assets/images/icon-16-language.png') no-repeat scroll left center transparent; padding: 0px 30px 0px 20px;">
					<?php echo JText::_('Global Manager'); ?>
				</td>
				<td style="background: url('/components/com_booking/assets/images/icon-16-disabled.png') no-repeat scroll left center transparent; padding: 0px 30px 0px 20px;">
					<?php echo JText::_('Non Manager'); ?>
				</td>
			</tr>
		</table>
	</div>
	<input type="hidden" name="option" value="<?php echo OPTION; ?>"/>
	<input type="hidden" name="task" value="<?php echo JRequest::getCmd('task'); ?>"/>
	<input type="hidden" name="reset" value="0"/>
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_ADMIN; ?>"/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>"/>
	<?php echo JHTML::_('form.token'); ?>
</form>