<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  	views
 * @copyright		Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 			ARTIO s.r.o., http://www.artio.net
 * @license     	GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        	http://www.artio.net Official website
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class BookingViewLocations extends JView
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * (non-PHPdoc)
	 * @see JView::display()
	 */
	public function display($tpl = null)
	{
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');
		$this->addToolbar();
		BookingHelper::setSubmenu('');
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		JToolBarHelper::title(JText::_('Locations'), 'location');
		JToolbarHelper::addNew('add');
		JToolbarHelper::editList('edit');
		JToolbarHelper::divider();
		JToolbarHelper::publish('pick_up_publish', 'Pick Up', true);
		JToolbarHelper::unpublish('pick_up_unpublish', 'Not Pick Up', true);
		JToolbarHelper::publish('drop_off_publish', 'Drop Off', true);
		JToolbarHelper::unpublish('drop_off_unpublish', 'Not Drop Off', true);
		JToolbarHelper::divider();
		JToolbarHelper::deleteList();
	}
}
