<?php

/**
 * Subjects administration list template. 
 * Display browse table with advanced filter.
 * Set the toolbar for many operations with subjects.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewSubjects */

JHTML::_('behavior.tooltip');

$bar = &JToolBar::getInstance('toolbar');

BookingHelper::setSubmenu(1);

JToolBarHelper::title(JText::_(COMPONENT_NAME).": ".JText::_('Bookable items'), 'object');

$bar->appendButton('Popup', 'new', 'New', ARoute::view(VIEW_SELECT_TEMPLATE, null, null, array('tmpl' => 'component')));
JToolBarHelper::editList();

JToolBarHelper::divider();

//is any item in state archived?
$archivedexists = false;
if(is_array($this->items))
	foreach($this->items as $item)
	{
		if($item->state == "-1")
		{
			$archivedexists = true;
			break;
		}
	}
if($archivedexists) JToolBarHelper::unarchiveList();
JToolBarHelper::archiveList();

JToolBarHelper::publish();
JToolBarHelper::unpublishList();

JToolBarHelper::custom('copy', 'copy.png', 'copy_f2.png', 'Copy');

JToolBarHelper::divider();

//is any item in state trashed?
$trashedexists = false;
if(is_array($this->items))
	foreach($this->items as $item)
	{
		if($item->state == "-2")
		{
			$trashedexists = true;
			break;
		}
	}
JToolBarHelper::deleteList('', 'trash', 'Trash');
if($trashedexists) JToolBarHelper::custom('restore', 'restore.png', 'restore_f2.png', 'Restore', true);
if($trashedexists) $bar->appendButton('Confirm', 'Are you sure?', 'trash', 'Empty Trash', 'emptyTrash', false, true);

$colspan = $this->selectable ? 7 : 11;

$editSubject = $this->escape(JText::_('Edit object'));
$editTemplate = $this->escape(JText::_('Edit template'));
$notFound = '- ' . JText::_('not found') . ' -';
$appendSubject = $this->escape(JText::_('Append object'));

$userId = $this->user->id;

$orderDir = $this->lists['order_Dir'];
$order = $this->lists['order'];


$itemsCount = count($this->items);
if ($itemsCount > 2) {
	$itemsCount = 2;
}


$element = $this->type == SUBJECT_BOOKABLE || $this->type == SUBJECT_PARENT;

$ipath = &BookingHelper::getIPath();

$subjectTable = new TableSubject(($db = &JFactory::getDBO()));

?>
<form action="index.php" method="post" name="adminForm" id="adminForm">
	<fieldset id="filter-bar">
		<label for="filter_search"><?php echo JText::_('Filter'); ?></label>
		<input type="text" name="search" id="filter_search" onchange="this.form.submit();" value="<?php echo $this->escape($this->lists['search']); ?>" class="inputbox" />
		<button>
			<?php echo JText::_('OK'); ?>
		</button>
		<button onclick="this.form.reset.value=1;this.form.submit();">
			<?php echo JText::_('Reset'); ?>
		</button>
		<?php 
			echo $this->lists['filter_parent']; 
			echo $this->lists['filter_template']; 
		?>
		<select name="filter_state" id="filter_state" onchange="this.form.submit()">
			<option value="">- <?php echo JText::_('Item Status'); ?> -</option>
			<option value="<?php echo SUBJECT_STATE_PUBLISHED; ?>"<?php if ($this->lists['state'] === (string) SUBJECT_STATE_PUBLISHED) { ?> selected="selected"<?php } ?>><?php echo JText::_('Published'); ?></option>
			<option value="<?php echo SUBJECT_STATE_UNPUBLISHED; ?>"<?php if ($this->lists['state'] === (string) SUBJECT_STATE_UNPUBLISHED) { ?> selected="selected"<?php } ?>><?php echo JText::_('Unpublished'); ?></option>
			<option value="<?php echo SUBJECT_STATE_ARCHIVED; ?>"<?php if ($this->lists['state'] === (string) SUBJECT_STATE_ARCHIVED) { ?> selected="selected"<?php } ?>><?php echo JText::_('Archived'); ?></option>
			<option value="<?php echo SUBJECT_STATE_DELETED; ?>"<?php if ($this->lists['state'] === (string) SUBJECT_STATE_DELETED) { ?> selected="selected"<?php } ?>><?php echo JText::_('Trashed'); ?></option>
		</select>
	</fieldset>
	<?php if ($element) { ?>
		<p style="text-align: center"><strong style="color: red">
			<?php 
				if ($this->type == SUBJECT_PARENT) {
					echo JText::_('You can only select parent subjects for subjects list');
				} elseif ($this->type == SUBJECT_BOOKABLE) {
					echo JText::_('You can only select no parent subjects for subject detail');
				} 
			?>
		</strong></p>
	<?php } ?>
	<div id="editcell">
		<table class="adminlist" cellspacing="1">
			<thead>
				<tr>
					<th width="1%">#</th>
					<?php if (! $this->selectable) { ?>
						<th width="1%">
														
							<input type="checkbox" class="inputCheckbox" name="toggle" value="" onclick="checkAll(2);" />
							
						</th>
					<?php } ?>
					<th width="1%">&nbsp;</th>
					<th>
				        <?php echo JHTML::_('grid.sort', 'Title', 'title', $orderDir, $order); ?>
					</th>
					<th><?php echo JText::_('Template'); ?></th>
					<th width="1%">
				        <?php echo JHTML::_('grid.sort', 'State', 'state', $orderDir, $order); ?>
					</th>
					<?php if (! $this->selectable) { ?>
						<th width="12%">
				        	<?php 
				        		echo JHTML::_('grid.sort', 'Order', 'ordering', $orderDir, $order);
				        		if ($this->turnOnOrdering) {
									echo JHTML::_('grid.order', $this->items);
								} 
							?>
						</th>
					<?php } ?>	
					<th width="1%">
						<?php echo JHTML::_('grid.sort', 'Access', 'access', $orderDir, $order); ?>
					</th>
					<?php if (! $this->selectable) { ?>
						<th width="1%">
							<?php echo JHTML::_('grid.sort', 'Hits', 'hits', $orderDir, $order); ?>
						</th>
					<?php } ?>
					<th width="1%">
				        <?php echo JHTML::_('grid.sort', 'ID', 'id', $orderDir, $order); ?>
					</th>
		    		<?php if (! $this->selectable) { ?>
						<th width="1%">
							<?php echo JText::_('Calendar'); ?>
						</th>
					<?php } ?>
				</tr>
			</thead>
			<tfoot>
    			<tr>
    				<td colspan="<?php echo $colspan; ?>">
    				    <?php 
    				    	    				    	
    				    	echo '&nbsp;';
    				    	
    				    ?>
    				</td>
    			</tr>
			</tfoot>
			<tbody>
				<?php if (! is_array($this->items) || ! $itemsCount && $this->tableTotal) { ?>
					<tr><td colspan="<?php echo $colspan; ?>" class="emptyListInfo"><?php echo JText::_('No items found.'); ?></td></tr>
				<?php } elseif(! $this->tableTotal) { ?>
					<tr><td colspan="<?php echo $colspan; ?>" class="emptyListInfo"><?php echo JText::_('Empty object list info'); ?></td></tr>
				<?php
					} else {
												
						for ($i = 0; $i < 2; $i++) {
							if (! isset($this->items[$i])) {
								continue;
							}
						
				    		$subject = &$this->items[$i];
				    		$subjectTable->bind($subject);
				    		$title = $this->escape($subject->title);
				    		$titleEdit = $editSubject . '::' . $title;
				    		$template = &$this->templateHelper->getTemplateById($subject->template);
				    		$link = JRoute::_(ARoute::edit(CONTROLLER_SUBJECT, $subject->id));
				    		$input = isset($this->input) ? $this->input : 'false';
				    		$js = 'javascript:ListSubjects.select(' . $subject->id . ',\'' . $title . '\',\'' . $this->escape($subject->alias) . '\',\''.$this->escape($input).'\')';
				    		$isCheckedOut = JTable::isCheckedOut($userId, $subject->checked_out); 
				?>
				    	<tr class="row<?php echo ($i % 2); ?>">
				    		<td  style="text-align: right; white-space: nowrap;"><?php echo number_format($this->pagination->getRowOffset($i), 0, '', ' '); ?></td>
				    			<?php if (! $this->selectable) { ?>
				    				<td class="checkboxCell"><?php echo JHTML::_('grid.checkedout', $subject, $i); ?></td>
				    			<?php } ?>
				    		<td>
					    		<?php
					    			if (isset($subjectTable->image) && ($thumb = AImage::thumb($ipath . $subjectTable->image, 30, 30))) {
					    				if (! $this->selectable) {
					    					if ($isCheckedOut) {
					    		?>				    					
					    						<img src="<?php echo $thumb; ?>" alt="" />
					    		<?php 
					    					} else {
					    		?>
					    						<a href="<?php echo $link; ?>" title="<?php echo $titleEdit; ?>"><img src="<?php echo $thumb; ?>" alt="" /></a>
					    		<?php 
					    					}
					    				} else {
								?>
					    					<a href="<?php echo $js; ?>" title="<?php echo $appendSubject; ?>"><img src="<?php echo $thumb; ?>" alt="" /></a>
					    		<?php
					    				}
					    			} else 
					    				echo '&nbsp;'; 
					    		?>
				    		</td>
				    		<td>
				    			<?php 
				    				if (! $this->selectable) {
				    					if (! $isCheckedOut) { 
				    			?>
				                			<span class="editlinktip hasTip" title="<?php echo $titleEdit; ?>">
												<a href="<?php echo $link; ?>" title=""><?php echo $subject->treename; ?></a>
						            		</span>
						        <?php 
				    					} else                    
						        			echo $subject->treename;
						        	} else {
						        		if (($this->type == SUBJECT_BOOKABLE && $subject->children == 0) || ($this->type == SUBJECT_PARENT && $subject->children > 0)) { 
						        ?>
						        			<a href="<?php echo $js; ?>" title="<?php echo $appendSubject; ?>"><?php echo $subject->treename; ?></a>
						        <?php 
						        		} else
						        			echo $subject->treename;
						        	} 
						        ?>
				    		</td>
				    		<td>
				    			<?php 
				    				if ($template && ! $element) { 
				    			?>
				    				<a href="<?php echo JRoute::_(ARoute::edit(CONTROLLER_TEMPLATE, $template->id)); ?>" title="<?php echo $editTemplate; ?>"><?php echo $template->name; ?></a>
				    			<?php 
				    				} elseif ($template)
				    					echo $template->name;
				    				else
				    					echo $notFound;
				    			?>
				    		</td>
				    		<td style="text-align: center;"><?php echo AHtml::state($subject, $i, ! $element); ?></td>
				    		<?php if (! $this->selectable) { ?>
				    			<td class="order" align="right" style="text-align: right;"><?php echo AHtml::orderTree($this->items,$i, $this->pagination, $this->turnOnOrdering, $itemsCount); ?></td>
				    		<?php } ?>
				    		<td style="text-align: center;">
				    			<?php 
				    				if ($element)
				    					echo AHtml::noActiveAccess($subject, $i, $subject->state);
				    				else {
				    					if (ISJ16)
				    						echo $subject->groupname;
				    					else
				    						echo JHTML::_('grid.access', $subject, $i, $subject->state);
				    				} 
				    			?>
				    		</td>
				    		<?php if (! $this->selectable) { ?>
				    			<td style="text-align: right; white-space: nowrap;"><?php echo ((int) $subject->hits == 0) ? '-' : number_format($subject->hits, 0, '', ' '); ?></td>
				    		<?php } ?>
				    		<td style="text-align: right; white-space: nowrap;"><?php echo number_format($subject->id, 0, '', ' '); ?></td>
				    		<?php if (! $this->selectable) { ?>
				    			<td align="center">
				    				<?php echo JHtml::link(JRoute::_('index.php?option=com_booking&view=subject&layout=calendar&cid[]=' . $subject->id), JHtml::image('components/com_booking/assets/images/icon-16-calendar.png', JText::_('Calendar'))); ?>
				    			</td>
				    		<?php } ?>
				    	</tr>
				    <?php 
				    	}
					} 
					?>
			</tbody>
		</table>
		<table align="center">
			<tr align="center">
				<td class="aIconLegend aIconPending"><?php echo JText::_('Pending'); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconPublished"><?php echo JText::_('Published'); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconExpired"><?php echo JText::_('Expired'); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconUnpublish"><?php echo JText::_('Unublished'); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconArchived"><?php echo JText::_('Archived'); ?><span class="aIconSeparator">&nbsp;</span></td>
				<td class="aIconLegend aIconTrash"><?php echo JText::_('Deleted'); ?></td>
			</tr>
		</table>
		<div class="clr"></div>
	</div>
	<input type="hidden" name="option" value="<?php echo OPTION; ?>"/>
	<input type="hidden" name="task" value="<?php echo JRequest::getCmd('task'); ?>"/>
	<input type="hidden" name="type" value="<?php echo $this->type; ?>"/>
	<?php if (isset($this->input)) {?>
	<input type="hidden" name="input" value="<?php echo $this->input; ?>"/>
	<?php }?>
	<?php 
		$tmpl = JRequest::getCmd('tmpl');
		if ($tmpl) { 
	?>
			<input type="hidden" name="tmpl" value="<?php echo $tmpl; ?>"/>
	<?php 
		} 
	?>
	<input type="hidden" name="reset" value="0"/>
	<input type="hidden" name="template" value="0"/>
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_SUBJECT; ?>"/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $order; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $orderDir; ?>"/>
	<input type="hidden" name="<?php echo SESSION_TESTER; ?>" value="1"/>
	<?php echo JHTML::_('form.token'); ?>
</form>	
