<?php

/**
 * @version		$Id$
 * @package		ARTIO Booking 
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JToolBarHelper::title(JText::_('Check Updates'), 'upgrade');

BookingHelper::setSubmenu(7);

$params = &AParameter::loadComponentParams();

$artioDownloadId = JString::trim($params->get('artioDownloadId'));

$this->regInfo = $this->get('RegisteredInfo');

$this->newVer = $this->get('NewestVersion');
$data = JApplicationHelper::parseXMLInstallFile(MANIFEST);
$this->oldVer = $data['version'];

$needConfirm = ($artioDownloadId && (is_null($this->regInfo) || ($this->regInfo->code != 10)));

$downloadPaid = true;

ADocument::addScriptPropertyDeclaration('BookingNeedConfirm', $needConfirm ? true : false);
ADocument::addScriptPropertyDeclaration('BookingTxtConfirm', JText::_('You will obtain the non-paid version of Bookit. Are you sure you want to use the automatic upgrade from server?'));

?>
<div class="width-100">
<fieldset class="adminform">
	<legend><?php echo JText::_('Check Updates'); ?></legend>
	<table class="adminform">
		<tr>
    		<th colspan="2"><?php echo JText::_('Version Info'); ?></th>
		</tr>
		<tr>
    		<td width="20%"><?php echo JText::_('Installed version').':'; ?></td>
    		<td><?php echo $this->oldVer; ?></td>
		</tr>
		<tr>
    		<td><?php echo JText::_('Newest version').':'; ?></td>
    		<td><?php echo $this->newVer; ?></td>
		</tr>
		<?php 
			if ($this->oldVer < $this->newVer && $this->newVer != '?.?.?') {
				$changelog = JString::trim(JFile::read('http://www.artio.cz/updates/joomla/booking2/changelog'));
				if ($changelog) {
		?>
					<tr>
						<td><?php echo JText::_('Changes in last version').':'; ?></td>
    					<td><?php echo $changelog; ?></td>
    				</tr>
		<?php			
				}
			}
		?>
	</table>
<?php $available = false; ?>
<?php if ($artioDownloadId) { ?>
    <table class="adminform">
    	<tr>
        	<th colspan="2"><?php echo JText::_('Registration Info'); ?></th>
    	</tr>
    	<?php if (is_null($this->regInfo)) { ?>
	        <tr>
	            <td colspan="2"><?php echo JText::_('Could not retrieve registration information.'); ?></td>
	        </tr>
        <?php } else if ($this->regInfo->code == 90) { ?>
        	<tr>
            	<td colspan="2"><?php echo JText::_('Download ID was not found in our database.'); ?></td>
        	</tr>
        <?php } else {
        	$regTo = $this->regInfo->name;
        	if (! empty($this->regInfo->company))
            	$regTo .= ', ' . $this->regInfo->company;
            $available = true;
        ?>
        <tr>
            <td width="20%"><?php echo JText::_('Registered to'); ?>:</td>
            <td><?php echo $regTo; ?></td>
        </tr>
        <?php
	        if ($this->regInfo->code == 10 || $this->regInfo->code == 30) {
	            $dateText = JText::_('Free upgrades available until');
	        } elseif ($this->regInfo->code == 20) {
	            $dateText = JText::_('Free upgrades expired');
	        }
        ?>
        <tr>
            <td><?php echo $dateText; ?>:</td>
            <td><?php echo $this->regInfo->date; ?></td>
        </tr>
        <?php } ?>
    </table>
    <?php } ?>

<form enctype="multipart/form-data" action="index.php" method="post" name="adminForm">
<?php
	if ((strnatcasecmp($this->newVer, $this->oldVer) > 0) ||
		(strnatcasecmp($this->newVer, substr($this->oldVer, 0, strpos($this->oldVer, '-'))) == 0) ||
		($this->newVer == "?.?.?"))
	{
        $btnText = JText::_('Upgrade from ARTIO Server');
	} elseif ($this->newVer == $this->oldVer) {
    	$btnText = JText::_('Reinstall from ARTIO Server');
	}
	
	if ($available && !empty($btnText))
	{
?>
	    <table class="adminform">
	        <tr>
	            <th><?php echo $btnText; ?></th>
	        </tr>
	        <tr>
	            <td>
	                   <?php
	                   if ($this->newVer == '?.?.?') {
	                       echo JText::_('Server not available.');
	                   } else { ?>
	                       <input class="button" type="button" value="<?php echo $btnText; ?>" onclick="BookingUpdate.submitbutton()" />
	                   <?php } ?>
	            </td>
	        </tr>
	    </table>
	<?php } ?>
		<table class="adminform">
			<tr>
		    	<th colspan="2"><?php echo JText::_('Upload Package File'); ?></th>
			</tr>
			<tr>
		    	<td width="120">
		        	<label for="install_package"><?php echo JText::_('Package File'); ?>:</label>
		    	</td>
		    	<td>
		        	<input class="input_box" id="install_package" name="install_package" type="file" size="57" />
		        	<input class="button" type="submit" value="<?php echo JText::_('Upload File'); ?> &amp; <?php echo JText::_('Install'); ?>" />
		    	</td>
			</tr>
		</table>

	<input type="hidden" name="option" value="<?php echo OPTION; ?>" />
	<input type="hidden" name="task" value="doUpgrade" />
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_UPGRADE; ?>" />
	<input type="hidden" name="fromserver" value="0" />
	<input type="hidden" name="ext" value="" />
	<?php echo JHTML::_('form.token'); ?>
</form>
</fieldset>
</div>