<?php

function BookingBuildRoute(&$query)
{
    static $replaces;
    if (is_null($replaces))
        $replaces = BookingReplaces();
    
    $segments = array();
    
    if (isset($query['view'])) {
        $segments[] = $replaces[$query['view']];
        unset($query['view']);
    }
    if (isset($query['id'])) {
        $segments[] = $query['id'];
        unset($query['id']);
    }
    if (isset($query['layout'])) {
        $segments[] = $replaces[$query['layout']];
        unset($query['layout']);
    }
    
    return $segments;
}

function BookingParseRoute($segments)
{
	$vars = array();
	$vars['view'] = BookingSearchReplace($segments[0]);
	
    if (isset($segments[1])) {
        switch ($vars['view']) {
            case 'reservations':
                $vars['layout'] = BookingSearchReplace($segments[1]);
                break;
            case 'reservation':
                $vars['layout'] = BookingSearchReplace($segments[1]);
                break;
            default:
                $vars['id'] = (int) $segments[1];
                break;
        }
        return $vars;
    } elseif(count($segments) == 0) { // menu link
    	$active = JFactory::getApplication()->getMenu()->getActive();
    	if (is_object($active)) {
    		$juri = JURI::getInstance($active->link);
    		return $juri->getQuery(true);
    	}
    	return $vars;
    }
    return $vars;
}

function BookingReplaces()
{
    $language = &JFactory::getLanguage();
    /* @var $language JLanguage */
    
    $language->load('com_booking', JPATH_SITE);
    
    $replaces['subject'] = 'SEO Subject';
    $replaces['subjects'] = 'SEO Subjects';
    $replaces['selectsubjects'] = 'SEO Selectsubjects';
    $replaces['reservations'] = 'SEO Reservations';
    $replaces['reservation'] = 'SEO Reservation';
    $replaces['customer'] = 'SEO Customer';
    $replaces['admin'] = 'SEO Admin';
    $replaces['form'] = 'SEO Form';
    $replaces['quickbook'] = 'SEO Quickbook';
    $replaces['date'] = 'SEO date';
    
    foreach ($replaces as &$replace){
    	$translated = JText::_($replace);
    	$replace = $translated==$replace ? str_replace(' ','',$replace) : $translated;
    }
    
    return $replaces;
}

function BookingSearchReplace($key)
{
    static $replaces;
    
    if (is_null($replaces))
        $replaces = BookingReplaces();
    
    if (($value = array_search($key, $replaces)))
        return $value;
    
    return null;
}

?>