<?php

/**
 * Reservation detail template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHTML::_('behavior.tooltip');

/* @var $this BookingViewReservation */

$config = &AFactory::getConfig();

?>
<h1><?php echo JText::sprintf('Reservation detail', $this->reservation->id); ?></h1>
<div class="bookingToolbar">
	<?php 
		if (! $this->customer->id && ! $this->isAdmin) {
			$url = JRoute::_(ARoute::view(VIEW_SUBJECTS));
		} else {
			$url = JRoute::_(ARoute::view(VIEW_RESERVATIONS));
		} 
	?>
	<a class="aIconToolBack tool back" href="<?php echo $url; ?>" title="<?php echo JText::_('Back', true); ?>"><?php echo JText::_('Back', true); ?></a>
	<?php if ($this->isAdmin) { ?>
		<a href="<?php echo JRoute::_(ARoute::edit(CONTROLLER_RESERVATION, $this->reservation->id)); ?>" class="aIconToolEdit tool"><?php echo JText::_('Edit'); ?></a>
	<?php } ?>
	<div class="clr">&nbsp;</div>
</div>
<div class="reservation">
	<?php 
    	$name = BookingHelper::formatName($this->reservation);
    	$company = JString::trim($this->reservation->company);
    	if ($name || $company || count($this->reservation->fields) || $this->reservation->company_id || $this->reservation->vat_id) { 
    ?>
			<fieldset>
		    	<legend><?php echo JText::_('Customer'); ?></legend>
		    	<table>
		    		<?php 
		    			if ($name) { 
		    		?>
		    				<tr>
		    					<td class="key"><?php echo JText::_('Name'); ?>: </td>
		    					<td><?php echo $name; ?></td>
		    				</tr>
		    		<?php 
		    			} 
		    		 	if ($company) {		
		    		?>
		    				<tr>
		    					<td class="key"><?php echo JText::_('Company'); ?>: </td>
		    					<td><?php echo $company; ?></td>
		    				</tr>
		    		<?php 
		    		 	}
		    		 	if ($this->reservation->company_id) {
    		 		?>
		    				<tr>
		    					<td class="key"><?php echo JText::_('Company ID'); ?>: </td>
		    					<td><?php echo $this->reservation->company_id; ?></td>
		    				</tr>
		    		<?php 
		    		 	}
		    		 	if ($this->reservation->vat_id) {
	   		 		?>
		    				<tr>
		    					<td class="key"><?php echo JText::_('Vat ID'); ?>: </td>
		    					<td><?php echo $this->reservation->vat_id; ?></td>
		    				</tr>
		    		<?php 
		    		 	}
		    		 	if(is_array($config->rsExtra))
		    		 	foreach ($config->rsExtra as $field) {
		    		?>		 
		    		 		<tr>
		    					<td class="key"><?php echo $field['title']; ?>: </td>
		    					<td><?php echo AUtils::getArrayValue($this->reservation->fields, $field['name'] . '.value'); ?></td>
		    				</tr>
		    		<?php } ?>
		    	</table>
		    </fieldset>
    <?php 
    	}
    	
    	$z=0;
		$countReservedItems = count($this->reservedItems);
    	if ($countReservedItems)
    		foreach ($this->reservedItems as $reservedItem){
				$id = $z++;
				$subject = $this->subjects[$reservedItem->subject];
				$capacity = $subject->display_capacity || $subject->total_capacity>1 || $reservedItem->capacity>1; //display capacity row
				$fullPrice = $reservedItem->fullPrice!=$reservedItem->price; //display full price
				$fullDeposit = $reservedItem->fullDeposit!=$reservedItem->deposit; //display full deposit
				$fullPriceSupplements = $reservedItem->fullPrice!=$reservedItem->fullPriceSupplements; //display full price with supplements
	
    ?>
    <fieldset>
    	<legend><?php if ($countReservedItems>1) echo '#'.($id+1).' '?><?php echo JText::_('Reservation'); ?></legend>
    	<table class="reserved_item">
    		<tr>	
    			<td class="key"><?php echo JText::_('Object'); ?>: </td>
    			<td colspan="5">
    				<?php if ($subject) { ?>
    					<a href="<?php echo JRoute::_(ARoute::view(VIEW_SUBJECT, $subject->id, $subject->alias)); ?>" title="<?php echo $this->escape(JText::_('Display object')); ?>">
    						<?php echo $reservedItem->subject_title; ?>
    					</a>
    				<?php 
    					} else {
    						echo $reservedItem->subject_title;
    					}
    				?>
    			</td>
    		</tr>
    		<?php if ($reservedItem->rtype == RESERVATION_TYPE_PERIOD) { ?>
    			<tr>
    				<td class="key"><?php echo JText::_('Timeframe'); ?></td>
    				<td><?php echo AHtml::showRecurenceTimeframe($reservedItem); ?></td>
    			</tr>
    			<tr>
    				<td class="key"><?php echo JText::_('Recurrence Pattern'); ?></td>
    				<td><?php echo AHtml::showRecurencePattern($reservedItem); ?></td>
    			</tr>
    			<tr>
    				<td class="key"><?php echo JText::_('Range of Recurrence'); ?></td>
    				<td><?php echo AHtml::showRecurenceRange($reservedItem); ?></td>
    			</tr>
    			<tr>
    				<td class="key"><?php echo JText::_('Recurrence Total'); ?></td>
    				<td><?php echo $reservedItem->period_total; ?></td>
    			</tr>
    		<?php } else { ?>
   				<tr>	
   					<td class="key"><?php echo AHtml::intervalLabel($reservedItem, null); ?>: </td>
    				<td colspan="5"><?php echo AHtml::interval($reservedItem, null); ?></td>
    			</tr>
    		<?php } ?>
    		<?php if ($capacity){?>
    		<tr>	
    			<td class="key"><?php echo JText::_('Capacity'); ?>: </td>
   				<td colspan="5"><?php echo number_format($reservedItem->capacity, 0, '', ' '); ?></td>
   			</tr>
   			<?php } ?>
			<?php 
				foreach ($reservedItem->supplements as $supplement) {
					/* @var $supplement TableReservationSupplement */
			?>				
					<tr>
						<td class="key hasTip" title="<?php echo BookingHelper::displaySupplementTooltip($supplement); ?>"><?php echo $supplement->title; ?>: </td>
    					<td colspan="5"><?php echo BookingHelper::displaySupplementValue($supplement); ?></td>
    				</tr>
    		<?php } ?>

    			<tr>	
		    		<td class="key"><label><?php echo ITEM_PRICE_TIP ?></label></td>
	    			<td width="1*"><?php echo BookingHelper::displayPrice($reservedItem->price); ?></td>
    				<td class="key"><label><?php if ($fullPrice){ ?><?php echo FULL_PRICE_TIP; } ?></label></td>
	    			<td width="1*"><?php if ($fullPrice){ ?><?php echo BookingHelper::displayPrice($reservedItem->fullPrice); ?><?php } ?></td>
	    			<td class="key"><label><?php if ($fullPriceSupplements) {?><?php echo FULL_PRICE_SUPPLEMENTS_TIP; } ?></label></td>
		    		<td width="1*"><?php if ($fullPriceSupplements) {?><?php echo BookingHelper::displayPrice($reservedItem->fullPriceSupplements); ?><?php } ?></td>
	    		</tr>
	    		<tr>
			    	<td class="key"><?php echo BookingHelper::showTax($reservedItem->tax); ?>:</td>
					<td><?php echo BookingHelper::displayPrice(BookingHelper::getTax($reservedItem->fullPriceSupplements, $reservedItem->tax)); ?></td>    						
	    		</tr>
		    <?php if ($reservedItem->fullDeposit) { ?>
	    			<tr>	
	    				<td class="key"><label><?php echo ITEM_DEPOSIT_TIP ?></label></td>
	    				<td><?php echo BookingHelper::displayPrice($reservedItem->deposit); ?></td>
	    				<td class="key"><label><?php if ($fullDeposit){ ?><?php echo FULL_DEPOSIT_TIP; } ?></label></td>
	    				<td><?php if ($fullDeposit){ ?><?php echo BookingHelper::displayPrice($reservedItem->fullDeposit); ?><?php } ?></td>
		    			<td class="key"><label></label></td>
		    			<td></td>
		    		</tr>
    			<?php } ?>
    		<?php if (($countReservedItems == 1) && ($reservedItem->cancel_time !== null)) {?>
    		<tr>
		    	<td class="key"><?php echo JText::_('Deposit must be paid before'); ?>: </td>
				<td><strong><?php echo BookingHelper::formatExpiration($reservedItem->cancel_time,$reservedItem->from); ?></strong></td>				
    		</tr>
    		<?php }?>
    		<tr>	
    				<td class="key"><label><?php echo JText::_('Message'); ?></label></td>
    				<td><?php echo htmlspecialchars($reservedItem->message); ?></td>
    			</tr>
    	</table>
    </fieldset>
    <?php } ?>
    
    <fieldset>
    	<legend><?php echo JText::_('Reservation Status And Payment'); ?></legend>
    		<table>
    		<?php if ($this->isAdmin && AHtml::date($this->reservation->created, ADATE_FORMAT_LONG)) { ?>
	    		<tr>
	    			<td class="key"><label><?php echo JText::_('Created'); ?></label></td>
	    			<td>
	    				<?php echo $this->reservation->creator ? $this->reservation->creator : JText::_('UNREGISTERED CUSTOMER'); ?>
	    				<?php echo AHtml::date($this->reservation->created, ADATE_FORMAT_LONG); ?>
	    			</td>
	 			</tr>
   			<?php } ?>
   			<?php if ($this->isAdmin && AHtml::date($this->reservation->modified, ADATE_FORMAT_LONG)) { ?>
   				<tr>
   					<td class="key"><label><?php echo JText::_('Modified'); ?></label></td>
   					<td>
   						<?php echo $this->reservation->modifier ? $this->reservation->modifier : JText::_('UNREGISTERED CUSTOMER'); ?>
   						<?php echo AHtml::date($this->reservation->modified, ADATE_FORMAT_LONG); ?>
   					</td>
   				</tr>
   			<?php } ?>
        	<tr>	
    			<td class="key"><?php echo JText::_('Payment Status'); ?>: </td>
   				<td>
    				<?php 
    					echo BookingHelper::showReservationPaymentStateLabel($this->reservation->paid);
    				?>
				</td>
    		</tr>
    		<tr>	
    			<td class="key"><?php echo JText::_('Reservation Status'); ?>: </td>
    			<td>
					<?php 
						echo BookingHelper::showReservationStateLabel($this->reservation->state);
					?>
				</td>
   			</tr>
   			<?php if ($countReservedItems>1) {?>
   			<tr>
				<td class="key"><?php echo JText::_('Total Price'); ?>: </td>
				<td><strong><?php echo BookingHelper::displayPrice($this->reservation->fullPrice); ?></strong></td>
			</tr>
			<tr>
		    	<td class="key"><?php echo JText::_('Tax'); ?>: </td>
				<td><strong><?php echo BookingHelper::displayPrice(BookingHelper::getFullTax($this->reservedItems)); ?></strong></td>				
    		</tr>
   			<tr>
				<td class="key"><?php echo JText::_('Deposit'); ?>: </td>
				<td><strong><?php echo BookingHelper::displayPrice($this->reservation->fullDeposit); ?></strong></td>
			</tr>
			<?php
			$globalexpiration = false;
			foreach ($this->reservedItems as $reservedItem){
				if ($reservedItem->cancel_time !== null)
				{
					$globalexpiration = true;
					break;
				}
			}
				
			if ($globalexpiration) {?>
			<tr>
		    	<td class="key"><?php echo JText::_('Deposit must be paid before'); ?>: </td>
				<td><strong><?php echo $this->depositExpires; ?></strong></td>				
    		</tr>
    		<?php } ?>
			<?php } ?>
    	</table>
    </fieldset>
</div>


<?php 
	$adrress = BookingHelper::formatAddress($this->reservation);
	$email = BookingHelper::getEmailLink($this->reservation);
	$telephone = JString::trim($this->reservation->telephone);
	$fax = JString::trim($this->reservation->fax);
	$note = JString::trim($this->reservation->note);
	if ($adrress || $email || $telephone || $fax || $note) { 
?>
		<div class="reservation">
		    <fieldset>
		    	<legend><?php echo JText::_('Reservation Contact'); ?></legend>
		    	<table>
		    		<?php 
		    			if ($adrress) {
		    		?>
			    			<tr>	
			    				<td class="key"><?php echo JText::_('Adrress'); ?>: </td>
			    				<td><?php echo $adrress; ?></td>
			    			</tr>
		    		<?php 
		    			}
		    			if ($email) {
		    		?>
		    				<tr>	
		    					<td class="key"><?php echo JText::_('Email'); ?>: </td>
		    					<td><?php echo $email; ?></td>
		    				</tr>
		    		<?php 
		    			}
		    			if ($telephone) {
		    		?>
				    		<tr>	
				   				<td class="key"><?php echo JText::_('Phones'); ?>: </td>
				    			<td><?php echo $telephone; ?></td>
				    		</tr>
		    		<?php 
		    			}
		    			if ($fax) {
		    		?>
				    		<tr>	
				   				<td class="key"><?php echo JText::_('Fax'); ?>: </td>
				   				<td><?php echo $fax; ?></td>
				    		</tr>
				    <?php 
		    			}
						if ($note) {
		    		?>
				    		<tr>	
				   				<td class="key"><?php echo JText::_('Note'); ?>: </td>
				   				<td><?php echo $note; ?></td>
				    		</tr>
				    <?php 
		    			}
				    ?>		    			
		    	</table>
		    </fieldset>
		</div>
<?php 
	}
?>
<div class="clr">&nbsp;</div>

<div class="bookingToolbar">
	<?php 
	list($avail,$text) = BookingHelper::getInvoiceLink($this->reservation->id);
	if ($avail==1)
		echo '<a href="javascript:void(0)" class="aIconToolInvoice tool invoice" onclick="window.open(\''.$text.'\',\'win2\', \'status=yes,toolbar=yes,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no\');">'.JText::_('Invoice').'</a>';
	elseif ($avail==2)
		echo '<span href="javascript:void(0)" class="hasTip aIconToolInvoice tool invoice" title="'.JText::_('Invoice not available').'::'.JText::_($text).'">'.JText::_('Invoice not available').'</span>';
	?>
	<div class="clr"></div>
</div>