<?php

/**
 * Reservation add form template. Displayed in iframe when clicked Book-It
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewReservation */

JHTML::_('behavior.tooltip');

$titleCheckout = $this->escape(JText::_('Save checkout'));
$titleContinue = $this->escape(JText::_('Save continue'));
$titleStorno = $this->escape(JText::_('Back'));

$config = &AFactory::getConfig();
$document = &JFactory::getDocument();
/* @var $document JDocument */

$document->addStyleDeclaration('#main {min-height:100px!important}'); //override of stylesheet

if (count($this->reservedItems)){
	$newItemSubject = $this->subjects[end($this->reservedItems)->subject];
	$backUrl = JRoute::_(ARoute::view(VIEW_SUBJECT, $newItemSubject->id, $newItemSubject->alias));
}
else
	$backUrl = JRoute::_(ARoute::root());
?>
<form action="index.php" method="post" name="adminForm" id="adminForm" class="reservation">
    <h1><?php echo JText::_('Add Reservation') ?></h1>

    <?php 
		$z=0;
		$countReservedItems = count($this->reservedItems);
    	if ($countReservedItems)
    		foreach ($this->reservedItems as $reservedItem){
    			/* @var $reservedItem TableReservationItems */
				$id = $z++;
				$subject = $this->subjects[$reservedItem->subject];
		
	?>
    <div class="reservation">
    	<fieldset>
    		<table>
    			<tr>
    				<td class="key"><?php echo JText::_('Item'); ?>: </td>
    				<td>
    					<a href="<?php echo JRoute::_(ARoute::view(VIEW_SUBJECT, $subject->id, $subject->alias)); ?>" title="<?php echo $this->escape(JText::sprintf('Display subject %s', $subject->title)); ?>">
    						<?php echo $subject->title . ' / ' . $reservedItem->box->rtypeTitle; ?>
    					</a>
    				</td>
    				<?php if (isset($reservedItem->key)) { ?>
    				<td rowspan="15" valign="top" width="1%">
    					<a href="<?php echo JRoute::_(ARoute::customUrl(array('key' => $reservedItem->key)).ARoute::controller(CONTROLLER_RESERVATION).ARoute::task('remove_item')); ?>">
    						<img src="<?php echo IMAGES?>icon-16-cancel.png" title="<?php echo JText::_('Remove item from reservation')?>" alt="<?php echo JText::_('Remove item from reservation')?>">
    					</a>
    				</td>
    				<?php } ?>
    			</tr>
    			
    			<?php 
    				if (is_object($reservedItem->box)) {
    					
    					if ($subject->display_capacity || $subject->total_capacity>1) {
    						
    						$max = $subject->total_capacity-$reservedItem->box->maxReserved;
    			?>
	    				<tr>	
							<td class="key"><label for="capacity[<?php echo $id?>]" class="required" style="float: right"><?php echo JText::_('Capacity'); ?>: <span class="star">*</span></label></td>
			    			<td>
			    				<?php if ($max>1) { ?>
				    				<?php if ($max<=100) { ?>
				    				<select class="capacity" name="capacity[<?php echo $id?>]" id="capacity[<?php echo $id?>]">
				    					<?php for ($i = 1; $i <= $max; $i++) { ?>
				    						<option value="<?php echo $i; ?>" <?php if ($i == $reservedItem->capacity) { ?>selected="selected"<?php } ?>><?php echo $i; ?></option>
				    					<?php } ?>
				    				</select>
				    				<?php } else { ?>
				    					<input class="capacity" name="capacity[<?php echo $id?>]" id="capacity[<?php echo $id?>]" value="<?php echo $reservedItem->capacity; ?>" style="float: right">
				    				<?php } ?>
			    				<?php  } else { ?>
			    				1
			    				<?php  } ?>
			    				(<strong class="hasTip" title="<?php echo JText::_('Total capacity')?>::<?php echo JText::_('Total capacity info')?>"><?php echo JText::_('Total capacity'); ?>: </strong>
			    				<span><?php echo $subject->total_capacity; ?></span>
			    				<?php if ($reservedItem->box->maxReserved>0) { ?>
			    				<strong class="hasTip" title="<?php echo JText::_('Booked in interval')?>::<?php echo JText::_('Booked in interval info')?>"><?php echo JText::_('Booked in interval'); ?>: </strong>
			    				<span><?php 
			    				echo $reservedItem->box->minReserved;
			    				if ($reservedItem->box->maxReserved!=$reservedItem->box->minReserved)
			    					echo ' - '.$reservedItem->box->maxReserved;
			    				?></span>	
			    				<?php } ?>
			    				<?php if ($subject->minimum_capacity>0) { ?>
			    				<strong class="hasTip" title="<?php echo JText::_('Minimum capacity')?>::<?php echo JText::_('Minimum capacity info')?>"><?php echo JText::_('Minimal capacity'); ?>: </strong>
			    				<span><?php echo $subject->minimum_capacity; ?></span>
			    				<?php } ?>)
			    			</td>
			    		</tr>
		    	<?php 
    				}
    			?>
    					<?php if ($reservedItem->ctype == CTYPE_PERIOD) { ?>
    						<tr>
    							<td class="key"><?php echo JText::_('Timeframe'); ?></td>
    							<td><?php echo AHtml::showRecurenceTimeframe($reservedItem); ?></td>
    						</tr>
    						<tr>
    							<td class="key"><?php echo JText::_('Recurrence Pattern'); ?></td>
    							<td><?php echo AHtml::showRecurencePattern($reservedItem); ?></td>
    						</tr>
    						<tr>
    							<td class="key"><?php echo JText::_('Range of Recurrence'); ?></td>
    							<td><?php echo AHtml::showRecurenceRange($reservedItem); ?></td>
    						</tr>
    						<tr>
    							<td class="key"><?php echo JText::_('Recurrence Total'); ?></td>
    							<td><?php echo $reservedItem->period_total; ?></td>
    						</tr>
    					<?php } else { ?>
		    				<tr>	
		    					<td class="key"><?php echo AHtml::intervalLabel($reservedItem); ?>: </td>
		    					<td><?php echo AHtml::interval($reservedItem); ?></td>
		    				</tr>
		    			<?php } ?>
		    			
			    		<?php foreach ($reservedItem->supplements as $supplement) { ?>
	    				<?php /* @var $supplement TableSupplement */ ?>
	    					<tr>
	    						<td class="key hasTip" title="<?php echo BookingHelper::displaySupplementTooltip($supplement); ?>"><?php echo $supplement->title; ?>: </td>
		    					<td>
		    						<input type="hidden" name="supplements[<?php echo $id?>][<?php echo $supplement->id; ?>][0]" value="<?php echo $this->escape($supplement->value); ?>" />
		    						
		    						<?php echo BookingHelper::displaySupplementValue($supplement); ?>
		    						
		    						<?php if ($supplement->capacity_multiply==2) {?>
		    							<?php echo JText::_('Capacity') ?>: 
		    							<?php if ($supplement->capacity_max && $supplement->capacity_max<=100) { ?>
					    				<select class="capacity" name="supplements[<?php echo $id?>][<?php echo $supplement->id; ?>][1]" style="float: none">
					    					<?php for ($i = 1; $i <= $supplement->capacity_max; $i++) { ?>
					    						<option value="<?php echo $i; ?>" <?php if ($i == $supplement->capacity) { ?>selected="selected"<?php } ?>><?php echo $i; ?></option>
					    					<?php } ?>
					    				</select>
					    				<?php } else { ?>
					    					<input size="5" class="capacity" name="supplements[<?php echo $id?>][<?php echo $supplement->id; ?>][1]" value="<?php echo $supplement->capacity; ?>" style="float: none">
										<?php } ?>
										<?php if ($supplement->capacity_max){ ?>
											(<?php echo JText::_('Maximal')?>: <?php echo $supplement->capacity_max ?>)
										<?php } ?>
		    						<?php } ?>
	    						</td>
	    					</tr>
						<?php } ?>   
					
		    			<tr>	
		    				<td class="key"><?php echo ITEM_PRICE_TIP ?> </td>
			    			<td><?php echo BookingHelper::displayPrice($reservedItem->price); ?></td>
			    		</tr>
			    		<?php if ($reservedItem->deposit) { ?>
		    				<tr>	
		    					<td class="key"><?php echo ITEM_DEPOSIT_TIP ?> </td>
		    					<td><?php echo BookingHelper::displayPrice($reservedItem->deposit); ?></td>
		    				</tr>
    					<?php } ?>
    					<tr>	
		    				<td class="key"><?php echo JText::_('Total Price'); ?>: </td>
		    				<td><?php echo BookingHelper::displayPrice($reservedItem->fullPriceSupplements); ?></td>
		    			</tr>
		    			<?php if($reservedItem->cancel_time !== null){?>
		    			<tr>
		    				<td class="key"><?php echo JText::_('Deposit must be paid before'); ?>: </td>
		    				<td><?php echo BookingHelper::formatExpiration($reservedItem->cancel_time,$reservedItem->from); ?></td>
						</tr>
						<?php } ?>
    				<?php } ?>
 
    			</table>
    			
    			<?php foreach ($reservedItem->boxIds as $bid) { ?>
				<input type="hidden" name="boxIds[<?php echo $id?>][]" value="<?php echo $bid; ?>" />
				<?php } ?>
				<input type="hidden" name="ctype[<?php echo $id?>]" value="<?php echo $reservedItem->ctype; ?>" />
				<input type="hidden" name="subject[<?php echo $id?>]" value="<?php echo $reservedItem->subject; ?>" />
				<?php if ($reservedItem->ctype == CTYPE_PERIOD) { ?>
					<input type="hidden" name="period_rtype_id[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_rtype_id); ?>" />
					<input type="hidden" name="period_price_id[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_price_id); ?>" />
					<input type="hidden" name="period_time_up[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_time_up); ?>" />
					<input type="hidden" name="period_time_down[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_time_down); ?>" />
					<input type="hidden" name="period_type[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_type); ?>" />
					<input type="hidden" name="period_recurrence[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_recurrence); ?>" />
					<input type="hidden" name="period_monday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_monday); ?>" />
					<input type="hidden" name="period_tuesday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_tuesday); ?>" />
					<input type="hidden" name="period_wednesday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_wednesday); ?>" />
					<input type="hidden" name="period_thursday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_thursday); ?>" />
					<input type="hidden" name="period_friday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_friday); ?>" />
					<input type="hidden" name="period_saturday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_saturday); ?>" />
					<input type="hidden" name="period_sunday[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_sunday); ?>" />
					<input type="hidden" name="period_month[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_month); ?>" />
					<input type="hidden" name="period_week[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_week); ?>" />
					<input type="hidden" name="period_day[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_day); ?>" />
					<input type="hidden" name="period_date_up[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_date_up); ?>" />
					<input type="hidden" name="period_end[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_end); ?>" />
					<input type="hidden" name="period_occurrences[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_occurrences); ?>" />
					<input type="hidden" name="period_date_down[<?php echo $id?>]" value="<?php echo $this->escape($reservedItem->period_date_down); ?>" />
				<?php } ?>	
    		</fieldset>
    		<div class="clr">&nbsp;</div>
    	</div>
<?php  } ?>

   	<div class="bookingToolbar">
   		<table>
   		<tr>
		<td><a class="aIconToolSave tool save" title="<?php echo $titleCheckout; ?>" href="javascript:submitbutton('add_checkout')" ><?php echo $titleCheckout; ?></a></td>
		<?php if($config->moreReservations){?><td><a class="aIconToolSave tool save" title="<?php echo $titleContinue; ?>" href="javascript:submitbutton('add_continue')" ><?php echo $titleContinue; ?></a></td><?php }?>
		<td><a class="aIconToolCancel tool save" title="<?php echo $titleStorno; ?>" href="javascript:void(0)" onclick="window.parent.SqueezeBox.close()" ><?php echo $titleStorno; ?></a></td>
		</tr>
		</table>
		
		<div class="clr"></div>
	</div>
	
	<input type="hidden" name="option" value="<?php echo OPTION; ?>" />
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_RESERVATION; ?>" />
	<input type="hidden" name="task" value="add_checkout" />
	<input type="hidden" name="view" value="reservation" />
	<input type="hidden" name="layout" value="form" />
	<input type="hidden" name="Itemid" value="<?php echo JRequest::getInt('Itemid'); ?>" />
	<?php echo JHTML::_('form.token'); ?> 
</form> 