<?php
/**
 * Reservations administration list template. 
 * Display browse table with advanced filter.
 * Set the toolbar for many operations with reservations.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

/* @var $this BookingViewReservations */

JHTML::_('behavior.tooltip');

?>

<h1><?php echo JText::_('Manage Reservations'); ?></h1>
<form action="<?php echo JRoute::_(ARoute::viewlayout(VIEW_RESERVATIONS, 'admin')); ?>" method="post" name="adminForm" id="adminForm" class="registration">
	<div class="filter">
		<div class="filterItem">
		<label for="filter_items-subject_title" id="filter_subject_label"><?php echo JText::_('Item'); ?>: </label>
			<input type="text" name="filter_items-subject_title" id="filter_items-subject_title" size="15" class="inputbox" onchange="this.form.submit();" value="<?php echo $this->escape($this->lists['items-subject_title']); ?>"/>
			<label for="filter_from" id="filter_from_label"><?php echo JText::_('From'); ?>: </label>
			<?php echo AHtml::getCalendar($this->lists['from'], 'filter_from', 'filter_from', ADATE_FORMAT_MYSQL_DATE, ADATE_FORMAT_MYSQL_DATE_CAL); ?>
			<label for="filter_to" id="filter_to_label"><?php echo JText::_('To'); ?>: </label>
			<?php echo AHtml::getCalendar($this->lists['to'], 'filter_to', 'filter_to', ADATE_FORMAT_MYSQL_DATE, ADATE_FORMAT_MYSQL_DATE_CAL); ?>
		</div>
		<div class="filterItem">
			<?php 
				$options = array();
				$options[] = JHtml::_('select.option', '', '- ' . JText::_('Reservation Status') . ' -');
				$options[] = JHtml::_('select.option', RESERVATION_PRERESERVED, JText::_('Pre-reserved'));
				$options[] = JHtml::_('select.option', RESERVATION_ACTIVE, JText::_('Reserved'));
				$options[] = JHtml::_('select.option', RESERVATION_STORNED, JText::_('Cancelled'));
				$options[] = JHtml::_('select.option', RESERVATION_TRASHED, JText::_('Trashed'));
				$options[] = JHtml::_('select.option', RESERVATION_CONFLICTED, JText::_('Conflicted'));
				echo JHtml::_('select.genericlist', $options, 'filter_reservation_status', 'onchange="this.form.submit()"', 'value', 'text', $this->lists['reservation_status']);
				$options = array();
				$options[] = JHtml::_('select.option', '', '- ' . JText::_('Payment Status') . ' -');
				$options[] = JHtml::_('select.option', RESERVATION_PENDING, JText::_('Unpaid'));
				$options[] = JHtml::_('select.option', RESERVATION_RECEIVE_DEPOSIT, JText::_('Deposit Paid'));
				$options[] = JHtml::_('select.option', RESERVATION_RECEIVE, JText::_('Paid in full'));
				echo JHtml::_('select.genericlist', $options, 'filter_payment_status', 'onchange="this.form.submit()" class="inputbox"', 'value', 'text', $this->lists['payment_status']);
			?>
		</div>
		<div class="buttons">
			<input class="button btn btn-primary" type="submit" onclick="this.form.submit();" value="<?php echo $this->escape(JText::_('Filter')); ?>" />
			<input class="button btn btn-primary" type="submit" onclick="this.form.reset.value=1; this.form.submit();" value="<?php echo $this->escape(JText::_('Reset')); ?>" />
		</div>
		<div class="clr"></div>
	</div>
	<div class="bookingToolbar">
		<a class="aIconToolPublish tool publish" href="#" onclick="ViewReservations.task('receive')" title="<?php echo JText::_('Receive', true); ?>"><?php echo JText::_('Receive', true); ?></a>
		<a class="aIconToolPending tool pending" href="#" onclick="ViewReservations.task('receiveDeposit')" title="<?php echo JText::_('Deposit', true); ?>"><?php echo JText::_('Deposit', true); ?></a>
		<a class="aIconToolUnpublish tool unpublish" href="#" onclick="ViewReservations.task('unreceive')" title="<?php echo JText::_('Unreceive', true); ?>"><?php echo JText::_('Unreceive', true); ?></a>
		<a class="aIconToolApply tool apply" href="#" onclick="ViewReservations.task('active')" title="<?php echo JText::_('Reserved', true); ?>"><?php echo JText::_('Reserved', true); ?></a>
		<a class="aIconToolCancel tool cancel" href="#" onclick="ViewReservations.task('storno')" title="<?php echo JText::_('Cancel', true); ?>"><?php echo JText::_('Cancel', true); ?></a>
		<a class="aIconToolTrash tool trash" href="#" onclick="ViewReservations.task('trash')" title="<?php echo JText::_('Trash', true); ?>"><?php echo JText::_('Trash', true); ?></a>
		<a class="aIconToolRestore tool restore" href="#" onclick="ViewReservations.task('restore')" title="<?php echo JText::_('Restore', true); ?>"><?php echo JText::_('Restore', true); ?></a>
		<div class="clr"></div>
	</div>
	<table width="100%">
		<thead>
			<tr>
				<td width="1%" class="sectiontableheader">
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($this->items); ?>);" />
				</td>
				<td nowrap="nowrap" class="sectiontableheader"><?php echo JText::_('Res. #'); ?></td>
				<td class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'Customer', 'surname', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'Item', 'items-subject_title', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td nowrap="nowrap" class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'Cap.', 'items-capacity', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'Price', 'reservationFullPrice', $this->lists['order_Dir'], $this->lists['order']); ?>
					<br/>
				    <?php echo JHTML::_('grid.sort', 'Deposit', 'reservationFullDeposit', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td colspan="2" nowrap="nowrap" class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'From', 'from', $this->lists['order_Dir'], $this->lists['order']); ?>
					<br/>
				    <?php echo JHTML::_('grid.sort', 'To', 'to', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
				<td nowrap="nowrap" class="sectiontableheader">
				    <?php echo JHTML::_('grid.sort', 'Payment Status', 'paid', $this->lists['order_Dir'], $this->lists['order']); ?>
					<br/>
				    <?php echo JHTML::_('grid.sort', 'Reservation Status', 'state', $this->lists['order_Dir'], $this->lists['order']); ?>
				</td>
			</tr>
		</thead>
		<tbody>
			<?php if (empty($this->items)) { ?>
				<tr>
					<td colspan="15">
						<?php echo JText::_('No items found.'); ?>
					</td>
				</tr>
			<?php 
				} else {
					foreach ($this->items as $i => $subject) {
				    	/* @var $subject TableReservation */
						foreach ($this->reservedItems[$subject->id] as $j => $reservedItem) {	
							/* @var $reservedItem TableReservationItems  */
				?>
				    <tr class="sectiontableentry<?php echo $i % 2 ? 1 : 2; ?>">
				    	<?php if ($j==0){ ?>
				    	<td rowspan="<?php echo count($this->reservedItems[$subject->id]); ?>"><?php echo JHTML::_('grid.checkedout', $subject, $i); ?></td>
				    	<td rowspan="<?php echo count($this->reservedItems[$subject->id]); ?>">
				    		<a href="<?php echo ARoute::detail(CONTROLLER_RESERVATION, $subject->id); ?>" title="<?php echo JText::_('Display reservation', true); ?>"><?php echo $subject->id; ?></a>				    		
				    	</td>
				    	<td rowspan="<?php echo count($this->reservedItems[$subject->id]); ?>">
				    		<?php echo BookingHelper::formatName($subject); ?>
				    	</td>
				    	<?php } ?>
				    	<?php if (!$reservedItem) { ?>
				    		<td colspan="5">No subject reserved</td>
				    	<?php } else { ?>
				    	<td>
				    		<?php if (!is_null($reservedItem->subject)) { ?>
				   				<a href="<?php echo JRoute::_(ARoute::view(VIEW_SUBJECT, $reservedItem->subject, $reservedItem->subjectAlias)); ?>" title="<?php echo $this->escape(sprintf(JText::_('Display object %s', true), $reservedItem->subjectTitle)); ?>">
				   					<?php echo $reservedItem->subjectTitle; ?>
				   				</a>
				   			<?php } else { ?>
				   				<span title="<?php echo JText::_('Subject not found', true); ?>"><?php echo $subject->subject_title; ?></span>
				   			<?php } ?>
			    		</td>
			    		<td>
				    		<?php echo $reservedItem->capacity; ?>
				    	</td>
				    	<td>
				    		<?php echo BookingHelper::displayPrice($reservedItem->fullPriceSupplements); ?>
				    		<br/>
				    		<?php echo BookingHelper::displayPrice($reservedItem->fullDeposit); ?>
				    	</td>
				    	<?php if ($reservedItem->rtype == RESERVATION_TYPE_PERIOD) { ?>
				    		<td colspan="2"><?php echo JText::_('Periodic Reservation'); ?></td>
				    	<?php } else { ?>
				    		<td>
				    			<?php echo AHtml::date($reservedItem->from, ADATE_FORMAT_NORMAL); ?>
				    			<br/><br/>
				    			<?php echo AHtml::date($reservedItem->to, ADATE_FORMAT_NORMAL); ?>
				    		</td>
				    		<td>
				    			<?php echo AHtml::date($reservedItem->from, ATIME_FORMAT_SHORT); ?>
				    			<br/><br/>
				    			<?php echo AHtml::date($reservedItem->to, ATIME_FORMAT_SHORT); ?>
				    		</td>
				    	<?php } ?>
				    	<?php } ?>
				   		<?php if ($j==0){ ?>
				   		<td rowspan="<?php echo count($this->reservedItems[$subject->id]); ?>">
				   			<?php switch ($subject->paid) {
            						case RESERVATION_PENDING:
            							if (! JTable::isCheckedOut($this->user->get('id'), $subject->checked_out)) { ?>
           									<span class="editlinktip hasTip aIcon aIconExpired" title="<?php echo JText::_('Unpaid', true) . '::' . JText::_('Click to mark as deposit received', true); ?>" onclick="listItemTask('cb<?php echo $i; ?>','receiveDeposit')" style="cursor: pointer">&nbsp;</span>
           								<?php } else { ?>			
           									<span class="editlinktip hasTip aIcon aIconExpired" title="<?php echo JText::_('Unpaid', true); ?>">&nbsp;</span>
           								<?php }
           								break;
           							case RESERVATION_RECEIVE_DEPOSIT:
            							if (! JTable::isCheckedOut($this->user->get('id'), $subject->checked_out)) { ?>
            								<span class="editlinktip hasTip aIcon aIconPending" title="<?php echo JText::_('Deposit received', true) . '::' . JText::_('Click to mark as paid', true) ?>" onclick="listItemTask('cb<?php echo $i; ?>','receive')" style="cursor: pointer">&nbsp;</span>
            							<?php } else { ?>			
            								<span class="editlinktip hasTip aIcon aIconPending" title="<?php echo JText::_('Deposit received', true); ?>">&nbsp;</span>
            							<?php }
            							break;
           							case RESERVATION_RECEIVE:
            							if (! JTable::isCheckedOut($this->user->get('id'), $subject->checked_out)) { ?>
          									<span class="editlinktip hasTip aIcon aIconPublished" title="<?php echo JText::_('Fully paid', true) . '::' . JText::_('Click to mark as unpaid', true); ?>" onclick="listItemTask('cb<?php echo $i; ?>','unreceive')" style="cursor: pointer">&nbsp;</span>
            							<?php } else { ?>			
            								<span class="editlinktip hasTip aIcon aIconPublished" title="<?php echo JText::_('Fully paid', true); ?>">&nbsp;</span>
            							<?php }
            							break;
        						} ?>
				    		<br/><br/>
				   			<?php 
        						switch ($subject->state) {
									case RESERVATION_PRERESERVED:
						            	if (! JTable::isCheckedOut($this->user->get('id'), $subject->checked_out)) { ?>
           									<span class="editlinktip hasTip aIcon aIconNew" title="<?php echo JText::_('Pre-reserved', true) . '::' . JText::_('Click to mark as active', true); ?>" onclick="listItemTask('cb<?php echo $i; ?>','active')" style="cursor: pointer">&nbsp;</span>			
           								<?php } else { ?>	
            								<span class="editlinktip hasTip aIcon aIconTick" title="<?php echo JText::_('Pre-reserved', true); ?>">&nbsp;</span>
            							<?php }
            							break;
						            case RESERVATION_ACTIVE:
						            	if (! JTable::isCheckedOut($this->user->get('id'), $subject->checked_out)) { ?>
           									<span class="editlinktip hasTip aIcon aIconTick" title="<?php echo JText::_('Reserved', true) . '::' . JText::_('Click to mark as cancelled', true); ?>" onclick="listItemTask('cb<?php echo $i; ?>','storno')" style="cursor: pointer">&nbsp;</span>			
           								<?php } else { ?>	
            								<span class="editlinktip hasTip aIcon aIconTick" title="<?php echo JText::_('Reserved', true); ?>">&nbsp;</span>
            							<?php }
            							break;
							        case RESERVATION_STORNED:
							            if (! JTable::isCheckedOut($this->user->get('id'), $subject->checked_out)) { ?>
            								<span class="editlinktip hasTip aIcon aIconUnpublish" title="<?php echo JText::_('Cancelled', true) . '::' . JText::_('Click to mark as trashed', true); ?>" onclick="listItemTask('cb<?php echo $i; ?>','trash')" style="cursor: pointer">&nbsp;</span>			
            							<?php } else { ?>	
            								<span class="editlinktip hasTip aIcon aIconUnpublish" title="<?php echo JText::_('Cancelled', true); ?>">&nbsp;</span>
            							<?php }
						                break;
						            case RESERVATION_TRASHED:
						            	if (! JTable::isCheckedOut($this->user->get('id'), $subject->checked_out)) { ?>
           									<span class="editlinktip hasTip aIcon aIconTrash" title="<?php echo JText::_('JTRASHED', true) . '::' . JText::_('Click to mark as conflicted', true); ?>" onclick="listItemTask('cb<?php echo $i; ?>','conflict')" style="cursor: pointer">&nbsp;</span>			
           								<?php } else { ?>	
           									<span class="editlinktip hasTip aIcon aIconTrash" title="<?php echo JText::_('JTRASHED', true); ?>">&nbsp;</span>
           								<?php }
						                break;
						         	case RESERVATION_CONFLICTED:
						               	if (! JTable::isCheckedOut($this->user->get('id'), $subject->checked_out)) { ?>
						            		<span class="editlinktip hasTip aIcon aIconNotice" title="<?php echo JText::_('Conflicted', true) . '::' . JText::_('Click to mark as pre-reserved', true); ?>" onclick="listItemTask('cb<?php echo $i; ?>','prereserved')" style="cursor: pointer">&nbsp;</span>			
						            	<?php } else { ?>	
						            		<span class="editlinktip hasTip aIcon aIconTrash" title="<?php echo JText::_('Conflicted', true); ?>">&nbsp;</span>
						            	<?php }
						                break;
       							} ?>
			    		</td>
				    	<?php } ?>
				   	</tr>
				 <?php 
						}
					}
				} 
			?>
		</tbody>
	</table>
	<div class="reservations-legend">
		<span class="aIconLegend aIconNew"><?php echo JText::_('Pre-reserved', true); ?><span class="aIconSeparator">&nbsp;</span></span>
		<span class="aIconLegend aIconTick"><?php echo JText::_('Reserved', true); ?><span class="aIconSeparator">&nbsp;</span></span>
		<span class="aIconLegend aIconUnpublish"><?php echo JText::_('Cancelled', true); ?><span class="aIconSeparator">&nbsp;</span></span>
		<span class="aIconLegend aIconTrash"><?php echo JText::_('Trashed', true); ?><span class="aIconSeparator">&nbsp;</span></span>
		<span class="aIconLegend aIconNotice"><?php echo JText::_('Conflicted', true); ?></span>
	</div>
	<div class="clr"></div>
	<div class="reservations-legend">
		<span class="aIconLegend aIconExpired"><?php echo JText::_('Unpaid', true); ?><span class="aIconSeparator">&nbsp;</span></span>
		<span class="aIconLegend aIconPending"><?php echo JText::_('Deposit Paid', true); ?><span class="aIconSeparator">&nbsp;</span></span>
		<span class="aIconLegend aIconPublished"><?php echo JText::_('Paid in Full', true); ?><span>&nbsp;</span></span>
	</div>
	<div class="pagination"><?php echo $this->pagination->getListFooter(); ?></div>
	<div class="clr"></div>
	<input type="hidden" name="option" value="<?php echo OPTION; ?>"/>
	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="layout" value="admin"/>
	<input type="hidden" name="reset" value="0"/>
	<input type="hidden" name="controller" value="<?php echo CONTROLLER_RESERVATION; ?>"/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->lists['order_Dir']; ?>"/>
	<input type="hidden" name="<?php echo SESSION_TESTER; ?>" value="1"/>
	<?php echo JHTML::_('form.token'); ?>
</form>	