<?php

/**
 * Monthly calendar template.
 * 
 * @version		$Id$
 * @package		ARTIO Booking
 * @subpackage  views
 * @copyright	Copyright (C) 2010 ARTIO s.r.o.. All rights reserved.
 * @author 		ARTIO s.r.o., http://www.artio.net
 * @license     GNU/GPL http://www.gnu.org/copyleft/gpl.html
 * @link        http://www.artio.net Official website
 */

defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');

$config = AFactory::getConfig();

//$userCanReserve = $this->customer->id || $config->unRegisteregCanReserve;
$userCanReserve = $this->userCanReserve;
$this->setting = new BookingCalendarSetting();
$calendarnummonths = empty($this->calendarnummonths) ? $config->calendarNumMonths : $this->calendarnummonths; // in the back-end admin has tool to change # of showed months
$this->days = &BookingHelper::getMonthlyCalendar($this->subject, $this->setting, $calendarnummonths, $this->isAdmin);

ADocument::addDomreadyEvent('
Calendars.currentYear = "' . $this->setting->currentYear . '";
Calendars.currentMonth = "' . $this->setting->currentMonth . '";
Calendars.nextYear = "' . $this->setting->nextYear . '";
Calendars.nextMonth = "' . $this->setting->nextMonth . '";
Calendars.calendarType = "monthly";
');

//load csss colors for prices
//-----------------------
$colors = array();
foreach($this->days->prices as $prices)
{
	foreach($prices->prices as $price)
	{
		$colors[] = $price->custom_color;
	}
}
$string = '';
foreach($colors as $i=>$color)
{
	$string .= "#bookSetting .price".$i." {	background-color: ".$color.";} ";
}
JFactory::getDocument()->addStyleDeclaration( $string );
//-------------------------

$titleMakeReservation = JText::_('Make %s reservation for full day %s for price %s');
/* @var $titleMakeReservation string save translation into property for optimizing */

echo $this->loadTemplate('bookitform');
?>
<div class="clr"></div>
<?php

echo $this->loadTemplate('prices');  

if (!$this->isAdmin && $config->quickNavigator) { // customer has navigation in predefined length only
?>
	<div class="clr"></div>
	<div class="quickNavigator">
		<label for="imonth"><?php echo JText::_('Select month'); ?>: </label>
		<?php echo AHtml::getMonthsSelect('imonth', (int) $this->setting->lastMonth, $this->setting->lastYear, $config->calendarDeepMonth, 'onchange="Calendars.monthNavigation(this.value)"'); ?>
	</div>
<?php 
}

if ($this->isAdmin) { // admin has unlimited month and year navigation
?> 
	<div class="clr"></div>
	<div class="quickNavigator">
		<label for="imonth"><?php echo JText::_('Select month'); ?>: </label>
		<?php echo AHtml::monthYearPicker('imonth', $this->setting->lastMonth . '-' . $this->setting->lastYear); ?>
		<script type="text/javascript">
			// <![CDATA[
			/**
		 	 * Function calls Month/Year Picker after change month.
		 	 */
			function __doPostBack(id) {
				Calendars.monthNavigation($(id).value.replace(/\-/, ',').replace(/^0/,'')); 
			}
			// ]]>
		</script>
		<label for="calendarnummonths"><?php echo JText::_('NUMBER OF MONTHS'); ?></label>
		<input type="text" name="calendarnummonths" id="calendarnummonths" value="<?php echo $this->calendarnummonths; ?>" size="1" onchange="this.form.submit()"  class="input-mini" />
		<button><?php echo JText::_('Submit'); ?></button>
	</div>
<?php } ?>

<h2 class="subjectSubtitle calendarTitle"><?php echo ($this->setting->monthName . ' ' . $this->setting->year); ?></h2>
<table id="top" class="monthlyCalendar">
	<!-- Days names header -->
	<?php
		ob_start(); 
		if ($this->subject->night_booking && $config->nightsStyle) { 
	?>
		<tr>
			<th><?php echo JText::_('Week'); ?></th>
			<?php if ($config->firstDaySunday) { ?>
				<th width="14%"><?php echo JText::_('Sun to mon'); ?></th>
			<?php } ?>
			<th width="14%"><?php echo JText::_('Mon to tue'); ?></th>
			<th width="14%"><?php echo JText::_('Tue to wed'); ?></th>
			<th width="14%"><?php echo JText::_('Wed to thu'); ?></th>
			<th width="14%"><?php echo JText::_('Thu to fri'); ?></th>
			<th width="14%"><?php echo JText::_('Fri to sat'); ?></th>
			<th width="14%"><?php echo JText::_('Sat to sun'); ?></th>
			<?php if (! $config->firstDaySunday) { ?>
				<th width="14%"><?php echo JText::_('Sun to mon'); ?></th>
			<?php } ?>
		</tr>
	<?php } else { ?>
		<tr>
			<th><?php echo JText::_('Week'); ?></th>
			<?php if ($config->firstDaySunday) { ?>
				<th width="14%"><?php echo JText::_('Sun'); ?></th>
			<?php } ?>
			<th width="14%"><?php echo JText::_('Mon'); ?></th>
			<th width="14%"><?php echo JText::_('Tue'); ?></th>
			<th width="14%"><?php echo JText::_('Wed'); ?></th>
			<th width="14%"><?php echo JText::_('Thu'); ?></th>
			<th width="14%"><?php echo JText::_('Fri'); ?></th>
			<th width="14%"><?php echo JText::_('Sat'); ?></th>
			<?php if (! $config->firstDaySunday) { ?>
				<th width="14%"><?php echo JText::_('Sun'); ?></th>
			<?php } ?>
		</tr>
	<?php 
		} 
		$head = ob_get_clean(); // save for next using
		echo $head;
	?>
	<!-- Body with months days -->
	<tr>
		<td class="week"><?php echo $this->setting->week ++; ?></td>
		<?php 
			$pcount = count($this->days->calendar);
			$break = 0;
			$month = 1;
			for ($i = 0; $i < $pcount; $i++) {
				$day = $this->days->calendar[$i];
				/* @var $day BookingDay */
				
				$firstBox = reset($day->boxes);
				$closedClassName = is_object($firstBox) && $firstBox->closed ? ' closed hasTip' : '';
				$title = is_object($firstBox) && $firstBox->closed ? $this->escape($firstBox->closingDayTitle).'::'.$this->escape($firstBox->closignDayText) : '';
		?>
				<td class="day<?php echo $closedClassName; ?><?php if ($day->engaged) { ?> reserved<?php if($config->colorCalendarFieldReserved){ echo '"style="background-color:'.$config->colorCalendarFieldReserved; }}else if($config->colorCalendarFieldFree){ echo '" style="background-color:'.$config->colorCalendarFieldFree; } ?>" title="<?php echo $title; ?>">
					<?php 
						if ($this->subject->night_booking && $config->nightsStyle) { 
					?>
							<span class="date" ><?php echo JText::sprintf('Night booking date', AHtml::date($day->date, ADATE_FORMAT_NICE_SHORT), AHtml::date($day->nextDate, ADATE_FORMAT_NICE_SHORT)); ?></span>
					<?php } else { ?>
						<span class="date" ><?php echo AHtml::date($day->date, ADATE_FORMAT_NICE_SHORT); ?></span>
					<?php } ?>
		<?php
					if (! ($break && !$isLastWeek)) {
						foreach ($day->boxes as $box) {
							/* @var $box BookingTimeBox */
							if (!$box->closed) {
								foreach ($box->services as $service) {
									/* @var $service BookingService */
									if ($service->allowFixLimit || ($service->rtype == RESERVATION_TYPE_DAILY && (($config->bookCurrentDay && $day->Uts === strtotime($this->setting->currentDate)) || ($this->isAdmin || $day->Uts > $this->setting->currentDayUTS)) && $service->canReserve && in_array($service->rtypeId, $this->lists['rids']))) {
										if ($userCanReserve)
											ADocument::setBoxParams($service, $service->i, $pcount, $i);
		?>		
										<span class="price price<?php echo $service->priceIndex; ?>" id="<?php echo $service->idShort; ?>">
		<?php 
										if ($this->subject->display_capacity && $this->subject->total_capacity>1)
											echo ($this->subject->total_capacity - $service->alreadyReserved);
		?>
										</span>
        <?php 
									}
								}
							}
						}							
						if ($this->isAdmin && !empty($box->customerName)) { // admin sees customer info always
							foreach ($box->customerName as $info) { 
		?>
								<span class="time"><a href="<?php echo JRoute::_(ARoute::detail(CONTROLLER_RESERVATION, $info['reservation_id'])); ?>" title="<?php echo $this->escape(JText::_('Show Reservation')); ?>::<?php echo $info['reservation_id']; ?>" class="hasTip"><?php echo $info['name']; ?></a></span><br/>
		<?php 
							}
						}						
						if (!$this->isAdmin && $this->subject->display_who_reserve && isset($day->customerName) && count($day->customerName)) {
							if(strip_tags(json_encode( $day->customerName)) != json_encode($day->customerName)){
        ?>
								<span class="customer" <?php if($config->colorCalendarBoxReserved){ echo 'style="background-color:'.$config->colorCalendarBoxReserved.'"'; }?>><?php echo AHtml::showUserInfo($day->customerName); ?></span>
						<?php }else{ ?>
								<span class="price hasTip customer" title="<?php echo AHtml::showUserInfo($day->customerName); ?>" <?php if($config->colorCalendarBoxReserved){ echo 'style="background-color:'.$config->colorCalendarBoxReserved.'"'; }?>> </span>
		<?php
        					}
						}
					}
		?> 
				</td>
		<?php		
				if (date('m', strtotime($day->date)) != date('m', strtotime($day->nextDate)) && $i > 6 && $config->calendarNumMonths > 1) {
					$lastMonthDay = $i % 7;
					$break++; // last day in month
				}
		 
				if ($i % 7 == 6 && $pcount > $i + 1) { // end of week and next week is coming
					$isLastWeek = $pcount - $i == 8;
		?>
					</tr>
		<?php
					if ($break == 1) { // last of month hapened
						if ($lastMonthDay != 6) { // not last week day, week continues in next month
							$i -= 7; // repeat last week with start of next month
							$this->setting->week --; // repeat last week number
							$break = -1; // set as -1 to ignore next step (repeating of end of this month in next month)
						} else
							$break = 0;
						$nextMonth = JFactory::getDate($this->setting->selected . '-01' . ' + ' . ($month++) . ' month');
						/* @var $nextMonth JDate */
		?>
						</table>
						<h2 class="subjectSubtitle calendarTitle"><?php echo ($nextMonth->toFormat('%B') . ' ' . $nextMonth->toFormat('%Y')); ?></h2>
						<table class="monthlyCalendar">
		<?php
							echo $head;				
					}
		?>
					<tr>
						<td class="week"><?php echo $this->setting->week ++; ?></td>
						
		<?php 
				}
			} 
		?>
	</tr>
</table>
<!-- Calendar pagination -->
<div class="calendarPagination">
	<?php if (! $this->setting->onCurrentMonth || $this->isAdmin) { // admin can browse to the past, customer can browse to the future only ?>
		<span class="previousPage"> 
			<a href="javascript:Calendars.monthNavigation(<?php echo $this->setting->previousMonth; ?>,<?php echo $this->setting->previousYear; ?>)"><?php echo JText::_('Previous month'); ?></a>
		</span>
	<?php } ?>
	<span class="currentPage"> 
		<a href="javascript:Calendars.monthNavigation(<?php echo $this->setting->currentMonth; ?>,<?php echo $this->setting->currentYear; ?>)"><?php echo JText::_('Current month'); ?></a>
	</span> 
	<?php if (! $this->setting->lastAllowPage) { ?>
		<span class="nextPage"> 
			<a href="javascript:Calendars.monthNavigation(<?php echo $this->setting->nextMonth; ?>,<?php echo $this->setting->nextYear; ?>)"><?php echo JText::_('Next month'); ?></a> 
		</span>
	<?php } ?>
</div>