<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

include_once(__DIR__ . DS . 'helper.php');

/* Update component admin */

$target = 'administrator' . DS . 'components' . DS . ARTIO_UPGRADE_OPTION;
$source = 'admin';
ArtioReinstall::addFilesOp($this, $target, $source);

/* Update component manifest */

$source = '';
ArtioReinstall::addFilesOp($this, $target, $source, false);

/* Update component site */

$target = 'components' . DS . ARTIO_UPGRADE_OPTION;
$source = 'site';
ArtioReinstall::addFilesOp($this, $target, $source);

/* Update admin language */

$target = 'administrator' . DS . 'language';
$source = 'language' . DS . 'admin';
ArtioReinstall::addFilesOp($this, $target, $source);

/* Update search plugin */

$target = 'plugins' . DS . 'search' . (J16 ? DS . 'joomdoc' : '');
$source = 'admin' . DS . 'extensions' . DS . 'plg_search_joomdoc';
ArtioReinstall::addFilesOp($this, $target, $source, false);

/* Update editors-xtd plugin */

$target = 'plugins' . DS . 'editors-xtd' . (J16 ? DS . 'joomdoc' : '');
$source = 'admin' . DS . 'extensions' . DS . 'plg_editors-xtd_joomdoc';
ArtioReinstall::addFilesOp($this, $target, $source, false);

/* Check database */

include_once(__DIR__ . DS . '..' . DS . 'admin' . DS . 'install.joomdoc.php');
JoomDOCInstaller::checkDatabase();

jimport('joomla.filesystem.file');
$sql = __DIR__ . DS . '..' . DS . 'admin' . DS . 'sql' . DS . 'install.mysql.utf8.sql';
if (JFile::exists($sql)) {
    $queries = JFile::read($sql);
    if ($queries) {
        $db =& JFactory::getDbo();
        /* @var $db JDatabaseMySQL */
        $queries =& $db->splitSql($queries);
        foreach ($queries as $query) {
            $query = JString::trim($query);
            if ($query) {
                $db->setQuery($query);
                $db->query();
            }
        }
    }
}
?>