<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

function com_install () {
    // install component extensions
    JLoader::register('AInstaller', JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_joomdoc' . DS . 'libraries' . DS . 'joomdoc' . DS . 'installer' . DS . 'installer.php');
    AInstaller::install(JPATH_ROOT . DS . 'administrator' . DS . 'components' . DS . 'com_joomdoc' . DS . 'extensions');
    // load component language
    JFactory::getLanguage()->load('com_joomdoc', JPATH_ADMINISTRATOR);

    JoomDOCInstaller::checkDatabase();

    echo '<h2 style="color: rgb(183, 207, 95); margin: 0pt; padding: 15px;">' . JText::_('JOOMDOC') . '</h2>';
    echo '<img style="float: left; margin-left: 15px; margin-right: 10px; margin-bottom: 10px;" src="' . JURI::root() . 'components/com_joomdoc/assets/images/' . 'icon-48-joomdoc.png' . '" alt="JoomDOC logo" />';
    echo '<div style="width: 50em; margin: 0pt; padding: 0.5em;">';
    echo '<p>' . JText::_('JOOMDOC_DESC') . '</p>';
    echo '<p>' . JText::_('JOOMDOC_INSTALL_INFO') . '</p>';
    echo '<p><a style="font-weight: bold; color: #B7CF5F; font-size: 1.1em;" href="' . JRoute::_('index.php?option=com_joomdoc') . '" title="">' . JText::_('JOOMDOC_OPEN') . '</a></p>';
    echo '</div>';
}

class JoomDOCInstaller {
    function checkDatabase () {
        $db =& JFactory::getDbo();
        /* @var $db JDatabaseMySQL */
        $fields = reset($db->getTableFields('#__joomdoc'));
        if (!isset($fields['asset_id'])) {
            /* since 3.1.0 */
            $db->setQuery('ALTER TABLE `#__joomdoc` ADD `asset_id` INT(11) NULL');
            $db->query();
        }
        if (!isset($fields['license'])) {
            /* since 3.2.0 */
            $db->setQuery('ALTER TABLE `#__joomdoc` ADD `license` INT(11) NULL');
            $db->query();
        }
        $fields = reset($db->getTableFields('#__joomdoc_file'));
        if (!isset($fields['state'])) {
            /* since 3.2.0 */
            $db->setQuery('ALTER TABLE `#__joomdoc_file` ADD `state` TINYINT NULL');
            $db->query();
            $db->setQuery('UPDATE `#__joomdoc_file` SET `state` = 1');
            $db->query();
        }
    }
}
?>