<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

class JHtmlJoomDOC {
    /**
     * Display icon tool to set item as default or non default.
     *
     * @param int $value value of item parameter default
     * @param int $i order number in list to identify row
     * @param string $entity name of entity
     * @param boolean $canChange icon is active or disabled
     * @return string HTML code
     */
    public static function defaults ($value, $i, $entity, $canChange) {
        $states[JOOMDOC_STATE_UNDEFAULT] = array(J16 ? 'disabled.png' : 'administrator/images/disabled.png', JoomDOCHelper::getTask($entity, JOOMDOC_TASK_DEFAULT), 'JOOMDOC_DEFAULT', 'JOOMDOC_TO_DEFAULT');
        $states[JOOMDOC_STATE_DEFAULT] = array(J16 ? 'featured.png' : 'administrator/images/publish_g.png', JoomDOCHelper::getTask($entity, JOOMDOC_TASK_UNDEFAULT), 'JOOMDOC_UNDEFAULT', 'JOOMDOC_TO_UNDEFAULT');
        $state = JArrayHelper::getValue($states, $value, $states[JOOMDOC_STATE_DEFAULT]);
        $html = JHtml::_('image', (J16 ? 'admin/' : '') . $state[0], JText::_($state[2], true), null, true);
        if ($canChange)
            $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" title="' . JText::_($state[3], true) . '">' . $html . '</a>';
        return $html;
    }

    /**
     * Parent documents (folders) tree list form field (select box).
     *
     * @param string $selected selected value
     * @param string $name field name param
     * @param string $id field id param
     * @return string HTML code
     */
    public static function parents ($selected, $name = 'joomdoc_parent', $id = 'joomdoc_parent') {
        $parents = JoomDOCFileSystem::getParents();
        $tree = array();
        // group parents and their children
        foreach ($parents as $parent) {
        	// this params require JHtml::_('select.genericlist'
            $parent->name = $parent->title;
            $parent->parent_id = $parent->parent;
            // ID and PARENT have to be numeric, cannot use path as array key, use CRC32 to get unique number for each path
            $parent->id = crc32($parent->path);
            // add item to parent group
            $tree[crc32($parent->parent)][] = $parent;
        }
        // make tree list
        $tree = JHtml::_('menu.treerecurse', 0, '', array(), $tree);
        // JHtml::_('select.genericlist' has problem with tree format
        $html = '<select name="' . htmlspecialchars($name, ENT_QUOTES) . '" id="' . htmlspecialchars($id, ENT_QUOTES) . '">';
        // empty value
        $html .= '<option value="">' . JText::_('JOOMDOC_SEARCH_EVERYWHERE') . '</option>';
        foreach ($tree as $list) {
            $html .= '<option value="' . htmlspecialchars($list->path, ENT_QUOTES) . '" ' . ($selected == $list->path ? 'selected="selected"' : '') . '>';
            $html .= $list->treename . '</option>';
        }
        $html .= '</select>';
        return $html;
    }
}
?>