<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die();

class JoomDOCModelDocuments extends JoomDOCModelList {

    /**
     * Paths to search documents.
     *
     * @var array
     */
    var $paths;

    /**
     * Database connector.
     *
     * @var JDatabaseMySQL
     */
    var $_db;
    /**
     * Create object and set filter.
     *
     * @param array $config
     * @return void
     */
    function __construct ($config = array ()) {

        $this->filter[JOOMDOC_FILTER_TITLE] = JOOMDOC_STRING;
        $this->filter[JOOMDOC_FILTER_FILENAME] = JOOMDOC_STRING;
        $this->filter[JOOMDOC_FILTER_ACCESS] = JOOMDOC_INT;
        $this->filter[JOOMDOC_FILTER_CATEGORY] = JOOMDOC_INT;
        $this->filter[JOOMDOC_FILTER_STATE] = JOOMDOC_STRING;
        $this->filter[JOOMDOC_FILTER_ORDERING] = JOOMDOC_STRING;
        $this->filter[JOOMDOC_FILTER_DIRECTION] = JOOMDOC_STRING;
        $this->filter[JOOMDOC_FILTER_START] = JOOMDOC_INT;
        $this->filter[JOOMDOC_FILTER_LINKS] = JOOMDOC_INT;
        $this->filter[JOOMDOC_FILTER_LIMIT] = JOOMDOC_INT;
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(JOOMDOC_FILTER_ID, JOOMDOC_FILTER_TITLE, JOOMDOC_FILTER_STATE, JOOMDOC_FILTER_ACCESS, JOOMDOC_FILTER_CREATED, JOOMDOC_FILTER_ORDERING, JOOMDOC_ORDER_ORDERING, JOOMDOC_FILTER_HITS, JOOMDOC_FILTER_PUBLISH_UP, JOOMDOC_FILTER_PUBLISH_DOWN, JOOMDOC_FILTER_PATH, JOOMDOC_FILTER_UPLOAD);
        }

        parent::__construct($config);
    }

    /**
     * Get SQL query for documents list.
     *
     * @return string
     */
    protected function getListQuery () {
        $mainframe =& JFactory::getApplication();
        /* @var $mainframe JApplication */

        // have concrete paths of search files
        if (count(($paths = $this->getState(JOOMDOC_FILTER_PATHS)))) {
            // cleanup paths and quote
            $paths = $this->getQuotedArray($paths);
            if (count($paths) && (!isset($this->docids) && !isset($this->fileids))) {
                $paths = implode(', ', $paths);
                // search latest version of files document
                $this->_db->setQuery('SELECT MIN(`id`) FROM `#__joomdoc` WHERE `path` IN (' . $paths . ') GROUP BY `path`');
                $this->docids =& $this->_db->loadResultArray();
                // search lastest version ids of file
                $this->_db->setQuery('SELECT MAX(`id`) FROM `#__joomdoc_file` WHERE `path` IN (' . $paths . ') GROUP BY `path`');
                $this->fileids =& $this->_db->loadResultArray();
                $this->_db->setQuery('SELECT `path`, SUM(`hits`) AS `hits` FROM `#__joomdoc_file` WHERE `path` IN (' . $paths . ') GROUP BY `path`');
                $this->hits =& $this->_db->loadObjectList('path');
            }
        }

        if (!isset($this->docids) && !isset($this->fileids)) {
            $this->docids = $this->fileids = array();
        }

        if ($mainframe->isSite()) {

            /* on site control document access */
            $published = JoomDOCModelList::getDocumentPublished();

            $query = 'SELECT `document`.`id`, `document`.`title`, `document`.`description`, `document`.`full_alias`, `document`.`modified`, `document`.`created`, `document`.`created_by`, `document`.`state`, `document`.`params`, `document`.`favorite`, `document`.`ordering`, `document`.`publish_up`, (' . $published . ') AS `published`, `file`.`upload`, `file`.`path`, `file`.`state` AS `file_state`, `document`.`checked_out`, `license`.`id` AS `license_id`, `license`.`title` AS `license_title`, `license`.`alias` AS `license_alias`, `license`.`state` AS `license_state` ';

        } else {
            $query = 'SELECT `file`.`upload`, `file`.`path`, `file`.`state` AS `file_state`, `document`.`id`, `document`.`title`, `document`.`ordering`, `document`.`access`, `document`.`publish_up`, `document`.`publish_down`, `document`.`state` AS `published`, `document`.`checked_out`, `document`.`checked_out_time`, `document`.`created_by`, `document`.`state`, `document`.`favorite`, `document`.`parent_path`, `editor`.`name` AS `editor`, `access`.`' . (J16 ? 'title' : 'name') . '` AS `access_title`, `document`.`full_alias`, `license`.`id` AS `license_id`, `license`.`title` AS `license_title`, `license`.`alias` AS `license_alias` ';
        }

        // complet query from/join state
        $query .= 'FROM `#__joomdoc_file` AS `file` ';
        $query .= 'LEFT JOIN `#__joomdoc` AS `document` ON `file`.`path` = `document`.`path` ';
        // user who checked out document
        $query .= 'LEFT JOIN `#__users` AS `editor` ON `editor`.`id` = `document`.`checked_out` ';
        // document access name, in Joomla 1.6.x is used different table then Joomla 1.5.x
        $query .= 'LEFT JOIN `#__' . (J16 ? 'viewlevels' : 'groups') . '` AS `access` ON `access`.`id` = `document`.`access` ';
        // document license
        $query .= 'LEFT JOIN `#__joomdoc_license` AS `license` ON `license`.`id` = `document`.`license` ';

        // filter for files
        if (count($this->fileids)) {
            $where[] = '(`file`.`id` IN (' . implode(', ', $this->fileids) . ') OR `file`.`id` IS NULL)';
        }
        // filter for documents
        if (count($this->docids)) {
            $where[] = '(`document`.`id` IN (' . implode(', ', $this->docids) . ') OR `document`.`id` IS NULL)';
        }
        // without output
        if (!count($this->fileids) && !count($this->docids)) {
            $where[] = '0';
        }
        // in frontend only published files in backend according to user filter
        if ($mainframe->isSite()) {
            $where[] = '`file`.`state` = ' . JOOMDOC_STATE_PUBLISHED;
        } elseif ($this->state->get(JOOMDOC_FILTER_STATE) != 0) {
            $where[] = '`file`.`state` = ' . $this->state->get(JOOMDOC_FILTER_STATE);
        }

        $filter = $this->getState(JOOMDOC_FILTER_SEARCH);

        // filter for keywords
        if (!empty($filter) && $filter->keywords) {

            $keywords = JString::strtolower($filter->keywords);

            if ($filter->type == JOOMDOC_SEARCH_ANYKEY || $filter->type == JOOMDOC_SEARCH_ALLKEY) {
                // search for any/all word from keywords
                // split to unique words
                $keywords = explode(' ', $keywords);
            } else {
                // search for full phrase
                $keywords = array($keywords);
            }
            // cleanup and quote words
            $keywords = $this->getQuotedArray($keywords, $filter->type != JOOMDOC_SEARCH_REGEXP);

            foreach ($keywords as $keyword) {
                $criteria = array();
                if ($filter->areaTitle) {
                    // document title or file path
                    if ($filter->type == JOOMDOC_SEARCH_REGEXP) {
                        $criteria[] = '`document`.`title` REGEXP ' . $keyword;
                        $criteria[] = '`file`.`path` REGEXP ' . $keyword;
                    } else {
                        $criteria[] = 'LOWER(`document`.`title`) LIKE ' . $keyword;
                        $criteria[] = 'LOWER(`file`.`path`) LIKE ' . $keyword;
                    }
                }
                if ($filter->areaText) {
                    // document description
                    if ($filter->type == JOOMDOC_SEARCH_REGEXP) {
                        $criteria[] = '`document`.`description` REGEXP ' . $keyword;
                    } else {
                        $criteria[] = 'LOWER(`document`.`description`) LIKE ' . $keyword;
                    }
                }
                if ($filter->areaFull) {
                    // file content
                    if ($filter->type == JOOMDOC_SEARCH_REGEXP) {
                        $criteria[] = '`file`.`content` REGEXP ' . $keyword;
                    } else {
                        $criteria[] = 'LOWER(`file`.`content`) LIKE ' . $keyword;
                    }
                }
                if ($filter->areaMeta) {
                    // need non escaped form
                    $keyword = JString::substr($keyword, 1, JString::strlen($keyword) - 2);
                    if (J16) {
                        /* in Joomla 1.6 and higher is used JSON params format
                         for example: {"files_without_doc":"1","metakeywords":"joomdoc,artio,joomla,documents","metadescription":"JoomDOC is Joomla component to manage list of shared documents."}
                         */
                        if ($filter->type == JOOMDOC_SEARCH_REGEXP) {
                            $metakeywords = $this->_db->quote('.*"metakeywords":"' . $keyword . '".*');
                            $metadescription = $this->_db->quote('.*"metadescription":"' . $keyword . '".*');
                        } else {
                            $metakeywords = $this->_db->quote('%"metakeywords":"' . $keyword . '"%');
                            $metadescription = $this->_db->quote('%"metadescription":"' . $keyword . '"%');
                        }
                    } else {
                        /* in Joomla 1.5 is used standard params format
                         for example:
                         files_without_doc=1
                         metakeywords=artio,shared,public,documents
                         metadescription=ARTIO shared documents to public using.
                         */
                        if ($filter->type == JOOMDOC_SEARCH_REGEXP) {
                            $metakeywords = $this->_db->quote('.*metakeywords=' . $keyword . "\n" . '.*');
                            $metadescription = $this->_db->quote('.*metadescription=' . $keyword . "\n" . '.*');
                        } else {
                            $metakeywords = $this->_db->quote('%metakeywords=' . $keyword . "\n" . '%');
                            $metadescription = $this->_db->quote('%metadescription=' . $keyword . "\n" . '%');
                        }
                    }
                    if ($filter->type == JOOMDOC_SEARCH_REGEXP) {
                        $criteria[] = '`document`.`params` REGEXP ' . $metakeywords;
                        $criteria[] = '`document`.`params` REGEXP ' . $metadescription;
                    } else {
                        $criteria[] = 'LOWER(`document`.`params`) LIKE ' . $metakeywords;
                        $criteria[] = 'LOWER(`document`.`params`) LIKE ' . $metadescription;
                    }
                }
                // find word in one of items
                if (count($criteria)) {
                    $oneWordFilter[] = '(' . implode(' OR ', $criteria) . ')';
                }
            }
            if (isset($oneWordFilter)) {
                if ($filter->type == JOOMDOC_SEARCH_ALLKEY) {
                    // all words
                    $where[] = '(' . implode(' AND ', $oneWordFilter) . ')';
                } else {
                    // any word
                    $where[] = '(' . implode(' OR ', $oneWordFilter) . ')';
                }
            }
        }

        if (isset($where)) {
            $query .= ' WHERE ' . implode(' AND ', $where);
        }

        if (in_array($this->state->get(JOOMDOC_FILTER_ORDERING), array(JOOMDOC_ORDER_PATH, JOOMDOC_ORDER_UPLOAD, JOOMDOC_ORDER_HITS, JOOMDOC_ORDER_TITLE, JOOMDOC_ORDER_ORDERING))) {
            $query .= ' ORDER BY `' . $this->_db->getEscaped($this->state->get(JOOMDOC_FILTER_ORDERING) . '` ' . JString::strtoupper($this->state->get(JOOMDOC_FILTER_DIRECTION)));
        }

        return $query;
    }

    /**
     * Get documents list.
     *
     * @return array
     */
    public function getItems () {
        //$items =& $this->_getList($this->getListQuery(), $this->state->get(JOOMDOC_FILTER_START), $this->state->get(JOOMDOC_FILTER_LIMIT));
        $items =& $this->_getList($this->getListQuery());
        $count = count($items);
        for ($i = 0; $i < $count; $i++) {
            $item =& $items[$i];
            $item->hits = isset($this->hits[$item->path]) ? $this->hits[$item->path]->hits : 0;
        }
        return $items;
    }

    /**
     * Prepare string array to using in SQL query.
     * Walk array and remove empty strings.
     * Non empty string escape and quote.
     *
     * @param array $items
     * @param boolean $search use for search, add % at begin and the end of item
     * @return array
     */
    public function getQuotedArray ($items, $search = false) {
        $mark = $search ? '%' : '';
        foreach ($items as $i => $item) {
            $item = JString::trim($item);
            if ($item)
                $items[$i] = $this->_db->quote($mark . $item . $mark);
            else
                unset($items[$i]);
        }
        // reindexing
        $items = array_merge($items);
        return $items;
    }

    /**
     * Get document titles for selected paths.
     *
     * @param array $paths relative paths
     * @return array stdClass with params title and path (title can be empty if file hasn't document)
     */
    public function getPathsDocsTitles ($paths) {
        $paths = $this->getQuotedArray($paths);
        if (!count($paths)) {
            return array();
        }
        // latest versions of all documents
        $this->_db->setQuery('SELECT MIN(`id`) FROM `#__joomdoc` GROUP BY `path` ORDER BY `id`');
        $docs = $this->_db->loadResultArray();
        count($docs) ? JArrayHelper::toInteger($docs) : $docs = array(0);
        // latest versions of all files 
        $this->_db->setQuery('SELECT MAX(`id`) FROM `#__joomdoc_file` WHERE `state` = ' . JOOMDOC_STATE_PUBLISHED . ' GROUP BY `path` ORDER BY `id`');
        $files = $this->_db->loadResultArray();
        count($files) ? JArrayHelper::toInteger($files) : $files = array(0);
        $query = 'SELECT `document`.`title`, `file`.`path` ';
        $query .= 'FROM `#__joomdoc_file` AS `file` ';
        $query .= 'LEFT JOIN `#__joomdoc` AS `document` ON `document`.`path` = `file`.`path` ';
        // for selected paths
        $query .= 'WHERE `file`.`path` IN (' . implode(', ', $paths) . ') ';
        // only last versions of published documents or non documents
        $query .= ' AND ((`document`.`id` IN (' . implode(', ', $docs) . ') AND (' . JoomDOCModelList::getDocumentPublished() . ')) OR `document`.`id` IS NULL) ';
        // only last versions of non trashed files
        $query .= 'AND `file`.`id` IN (' . implode(', ', $files) . ')';
        $this->_db->setQuery($query);
        return $this->_db->loadObjectList();
    }

    /**
     * Set documents as favorite/unfavorite
     *
     * @param array $ids   documents IDs
     * @param int   $value value use constantS JOOMDOC_FAVORITE/JOOMDOC_STANDARD to set as favorite/unfavorite
     * @return int num of affected rows
     */
    function setFavorite ($ids, $value) {
        if (count($ids)) {
            JArrayHelper::toInteger($ids);
            $this->_db->setQuery(sprintf('UPDATE `#__joomdoc` SET `favorite` = %d WHERE `id` IN (%s)', $value, implode(', ', $ids)));
            $this->_db->query();
            return $this->_db->getAffectedRows();
        }
        return 0;
    }

    function searchPaths ($paths) {
        if (count($paths)) {
            $this->_db->setQuery('SELECT DISTINCT `path` FROM `#__joomdoc_file` WHERE `path` IN (' . implode(', ', array_map(array($this->_db, 'quote'), $paths)) . ')');
            return $this->_db->loadResultArray();
        }
        return array();
    }
}
?>