<?php

/**
 * @version		$Id$
 * @package		Joomla.Administrator
 * @subpackage	JoomDOC
 * @author      ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

class JHtmlJoomDOC {
    /**
     * Display icon tool to set item as default or non default.
     *
     * @param int $value value of item parameter default
     * @param int $i order number in list to identify row
     * @param string $entity name of entity
     * @param boolean $canChange icon is active or disabled
     * @return string HTML code
     */
    public static function defaults ($value, $i, $entity, $canChange) {
        $states[JOOMDOC_STATE_UNDEFAULT] = array(J16 ? 'disabled.png' : 'administrator/images/disabled.png', JoomDOCHelper::getTask($entity, JOOMDOC_TASK_DEFAULT), 'JOOMDOC_DEFAULT', 'JOOMDOC_TO_DEFAULT');
        $states[JOOMDOC_STATE_DEFAULT] = array(J16 ? 'featured.png' : 'administrator/images/publish_g.png', JoomDOCHelper::getTask($entity, JOOMDOC_TASK_UNDEFAULT), 'JOOMDOC_UNDEFAULT', 'JOOMDOC_TO_UNDEFAULT');
        $state = JArrayHelper::getValue($states, $value, $states[JOOMDOC_STATE_DEFAULT]);
        $html = JHtml::_('image', (J16 ? 'admin/' : '') . $state[0], JText::_($state[2], true), null, true);
        if ($canChange)
            $html = '<a href="#" onclick="return listItemTask(\'cb' . $i . '\',\'' . $state[1] . '\')" title="' . JText::_($state[3], true) . '">' . $html . '</a>';
        return $html;
    }

    /**
     * Parent documents (folders) tree list form field (select box).
     *
     * @param string $selected selected value
     * @param string $name field name param
     * @param string $id field id param
     * @return string HTML code
     */
    public static function parents ($selected, $name = 'joomdoc_parent', $id = 'joomdoc_parent') {
        $parents = JoomDOCFileSystem::getParents();
        $tree = array();
        // group parents and their children
        foreach ($parents as $parent) {
        	// this params require JHtml::_('select.genericlist'
            $parent->name = $parent->title;
            $parent->parent_id = $parent->parent;
            // ID and PARENT have to be numeric, cannot use path as array key, use CRC32 to get unique number for each path
            $parent->id = crc32($parent->path);
            // add item to parent group
            $tree[crc32($parent->parent)][] = $parent;
        }
        // make tree list
        $tree = JHtml::_('menu.treerecurse', 0, '', array(), $tree);
        // JHtml::_('select.genericlist' has problem with tree format
        $html = '<select name="' . htmlspecialchars($name, ENT_QUOTES) . '" id="' . htmlspecialchars($id, ENT_QUOTES) . '" autocomplete="off">';
        // empty value
        $html .= '<option value="">' . JText::_('JOOMDOC_SEARCH_EVERYWHERE') . '</option>';
        foreach ($tree as $list) {
            $html .= '<option value="' . htmlspecialchars($list->path, ENT_QUOTES) . '" ' . ($selected == $list->path ? 'selected="selected"' : '') . '>';
            $html .= $list->treename . '</option>';
        }
        $html .= '</select>';
        return $html;
    }
    
    /**
     * Folders navigator with MooTree.
     * 
     * @param array $folders data in this format: JObject('ident' => 'relative path', 'route' => 'URL to open folder', 'title' => 'Folder name', 'entry' => 'Is accessible')
     * @param string $parent root folder 
     * @param bool $ajax generate one tree list only
     * @return string source of tree
     */
    public static function mooTree($folders = null, $parent = '', $ajax = false) {
    	$config = JoomDOCConfig::getInstance();
    	$document = JFactory::getDocument();
    	$mainframe = JFactory::getApplication();
		$document->addScript(JURI::root(true) . '/media/system/js/mootree' . (JDEBUG ? '-uncompressed' : '') . '.js');
		$document->addStyleSheet(JURI::root(true) . '/media/system/css/mootree.css');
		$path = JoomDOCRequest::getPath();
		$code = '';
		if (!$ajax) {
			$code .= '<div id="MooTree"></div>'; // here MooTree will draw tree
			$code .= '<ul id="MooTreeSrc">'; // start of source of tree
		}
		if (is_null($folders)) {
			$folders = JoomDOCFileSystem::getNonTrashedParents($parent, 1, ($ajax ? null : $path));
			if (empty($folders)) return ''; // nothing to do
			foreach ($folders as $i => $item) {
				$folder = new JObject();
				$folder->set('ident', $item);
				$folder->set('route', JoomDOCRoute::viewDocuments($item));
				$folder->set('title', basename($item));
				$folder->set('entry', JoomDOCAccessFileSystem::enterFolder(false, $item));
				$folders[$i] = $folder;
			}
		}
		foreach ($folders as $i => $folder) { // all folders into deep
			$currentLevel = count(explode(DS, $folder->get('ident'))); // level of folder deep (folders in doc root have 1)
			if (!empty($lastLevel)) { // not for root folder
				if ($currentLevel > $lastLevel) $code .= '<ul>'; // it's subfolder of previous folder
				elseif ($currentLevel < $lastLevel){
					$code .= str_repeat('</li></ul>', $lastLevel - $currentLevel).'</li>'; // end of subfolder, close previous subfolders
				}
				else $code .= '</li>'; // at the same level as previous
			}
			if ($folder->get('entry'))
				$code .= '<li id="' . str_replace(DS, '-', $folder->get('ident')) . '"' . ($folder->get('ident') == $path ? ' class="selected"' : '') . '>
						<a href="' . JRoute::_($folder->get('route')) . '" target="folderframe" name="' . $folder->get('ident') . '">' . $folder->get('title') . '</a>'; // current item, tag leave open to append subfolder	
			$lastLevel = $currentLevel;
		}
		if (empty($lastLevel))
			$lastLevel = 0;
		$code .= str_repeat('</li></ul>', $lastLevel); // end of source of tree
		if ($ajax) {
			ob_clean();
			die($code);
		}
		// start MooTree after completely loading page
		$js = "
			window.addEvent('domready', function() {
				var tree = new MooTreeControl(
				{
					div: 'MooTree', 
					mode: 'folders', 
					grid: true, 
					theme: '" . htmlspecialchars(JURI::root(true), ENT_QUOTES) . "/media/system/images/mootree.gif', 
					loader: { // set up Ajax loader
						icon: null, 
						text: '" . JText::_('JOOMDOC_LOADING', true) . "', 
						color:'#FF0000'
    				},
					onClick: function(node) { // event after click on folder
						window.location = node.data.url; 
					},
					onExpand: function(node, state) { // event after expand tree node
						if (state && treeLoading < 0) { // opening
							node.loading = true;
							node.clear(); // clear the node to append loader
							node.insert(node.control.loader); // insert loader into the node
							new Request({
								method: 'GET',
								url: '" . JRoute::_(JoomDOCRoute::updatemootree(), false) . "',
								data: {
									path: node.data.name
								},
								onSuccess: function(html, xml) {
									node.clear(); // clear loader from the node
									node.loading = false;
									var ul = new Element('ul#MooTreeSrc');
									ul.set('html', html);
									$$('body').adopt(ul);
									tree.adopt('MooTreeSrc', node);
								}
							}).send();
						}
						treeLoading --;
					}
				},
				{
					text: '" . ($parent ? $parent : $config->explorerRoot) . "', 
				 	open: true, 
				 	data: {
						url: '" . JRoute::_(JoomDOCRoute::viewDocuments($mainframe->isSite() ? $parent : 'JoomDOC'), false) . "', 
						target: 'folderframe'
    				}
    			}
			);
			tree.adopt('MooTreeSrc'); // load source in ul structure
			tree.selected = tree.get('node_" . htmlspecialchars(str_replace(DS, '-', $path), ENT_QUOTES) . "');
		";
		if ($path)
			$js .= "
				tree.get('node_" . htmlspecialchars(str_replace(DS, '-', (JFile::exists(JoomDOCFileSystem::getFullPath($path)) ? JoomDOCFileSystem::getParentPath($path) : $path)), ENT_QUOTES) . "').selected = true;
			";
		// open actual folder path
		$breadCrumbs = JoomDOCFileSystem::getPathBreadCrumbs($path);
		foreach ($breadCrumbs as $i => $breadCrumb) {
			if ($i) {
				$js .= "
					var node = tree.get('node_" . htmlspecialchars(str_replace(DS, '-', $breadCrumb->path), ENT_QUOTES) . "');
					if (node) node.toggle(false, true);
				";
			}
		}
		$js .= '});
			var treeLoading = ' . (count($breadCrumbs) - 2) . ';';
		$document->addScriptDeclaration($js);
		return $code;
    }
    
    /**
     * Filter folder list for frontend (published, ACL etc)
     * 
     * @param JoomDOCFolder $root
     * @param string $parent
     * @return array
     */
    public static function folders($root, $parent)
    {
    	$folders = array();
    	$root->initIteration();
    	$parents = array(JoomDOCFileSystem::getRelativePath($parent));
    	while ($root->hasNext()) {
    		$item = $root->getNext();
    		$access = new JoomDOCAccessHelper($item);
    		$itemParent = JoomDOCFileSystem::getParentPath($access->relativePath);
    		if (!(empty($itemParent) || in_array($itemParent, $parents))) // parent has to be visible
    			continue;
    		if ($access->docid && $item->document->published == JOOMDOC_STATE_UNPUBLISHED) // item has to published
    			continue;
    		$folder = new JObject(); // prepare data for MooTree
    		$folder->set('ident', $access->relativePath);
    		$folder->set('route', JoomDOCRoute::viewDocuments($access->relativePath, $access->alias));
    		$folder->set('title', $access->docid ? $item->document->title : $item->getFileName());
    		$folder->set('entry', $access->canEnterFolder);
    		$folders[] = $folder;
    		$parents[] = $access->relativePath; // save into visible parents
    	}
    	return $folders;
    }
}
?>