<?php

/**
 * @version	$Id$
 * @package	Joomla.Administrator
 * @subpackage	JoomDOC
 * @author   	ARTIO s.r.o., info@artio.net, http:://www.artio.net
 * @copyright	Copyright (C) 2011 Artio s.r.o.. All rights reserved.
 * @license	GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die('Restricted access');

/**
 * Filter option list for field.
 * 
 * INSTALLATION
 * copy file into folder
 * administrator/components/com_falang/contentelements
 */
class translationJoomdocfieldFilter extends translationFilter
{
    public function __construct ($contentElement) 
    {
    	$this->filterNullValue = 0;
    	$this->filterType = 'joomdocfield';
    	$this->filterField = $contentElement->getFilter($this->filterType);
		parent::__construct($contentElement);
   	}
    
    public function _createfilterHTML()
    {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		
		$query->select('id, title');
		$query->from('#__joomdoc_field');
		$query->order('title');
		
		$db->setQuery($query);
		$fields = $db->loadObjectList();
		
		$empty = JHtml::_('select.option', $this->filterNullValue, '-', 'id', 'title');
		array_unshift($fields, $empty);
		
		$filter['title'] = 'Field';
		$filter['html'] = JHtml::_('select.genericlist', $fields, $this->filterType . '_filter_value', 'onchange="this.form.submit()"', 'id', 'title', $this->filter_value);
		return $filter;
    }
}