<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   3.11.0
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2013 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

class SEFView extends JView
{
    function __construct($config = null)
    {
        parent::__construct($config);
        $this->_addPath('template', $this->_basePath.DS.'views'.DS.'templates');
    }
    
    function display($tpl = null)
    {
        // Load JS
        JHtml::script('joomsef.js', 'administrator/components/com_sef/assets/js/', true);
        
        // Set JS texts
        $js = 'JoomSEF.txtHomePage = '.json_encode('('.JText::_('COM_SEF_HOMEPAGE').')').";\n";
        $doc = JFactory::getDocument();
        $doc->addScriptDeclaration($js);
        
        parent::display($tpl);
    }
    
    function showInfoText($str)
    {
        $sefConfig =& SEFConfig::getConfig();
        
        $this->assign('infoString', JText::_($str));
        $this->assign('infoShown', $sefConfig->showInfoTexts);
        
        // Prepare JS variables
        $document =& JFactory::getDocument();
        $js = "var jsInfoTextShown = ".($sefConfig->showInfoTexts ? 'true' : 'false').";\n";
        $js .= "var jsInfoTextHide = '".JText::_('COM_SEF_INFOTEXT_HIDE', true)."';\n";
        $js .= "var jsInfoTextShow = '".JText::_('COM_SEF_INFOTEXT_SHOW', true)."';\n";
        $js .= "var jsInfoTextUrl = '".JURI::root()."administrator/index.php?option=com_sef&controller=config&task=setinfotext';\n";
        $document->addScriptDeclaration($js);
        
        // Load JS
        JHTML::script('infotexts.js', 'administrator/components/com_sef/assets/js/', false);
        JHTML::_('behavior.mootools');
        
        $prevLayout = $this->setLayout('default');
        echo $this->loadTemplate('infotext');
        $this->setLayout($prevLayout);
    }
    
    function getAjaxField($container, $id, $value, $task, $title, $img, $alt, $visible, $link = true) {
        $html = '<div id="sef_'.$container.'_'.$id.'_'.$value.'" style="display: '.($visible ? 'block' : 'none').';">';
        $html .= '<span class="'.($link ? 'editlinktip ' : '').'hasTip" title="'.$title.'">';
        if ($link) {
            $html .= '<a href="javascript:void(0);" onclick="JoomSEF.ajaxItemTask(\''.$container.'\', \''.$id.'\', \''.$task.'\');">';
        }
        $html .= JHtml::_('image', $img, $alt, array('border' => 0), true);
        if ($link) {
            $html .= '</a>';
        }
        $html .= '</span>';
        $html .= '</div>';
        
        return $html;
    }
    
    function getAjaxWorking($container) {
        $html = '<div id="sef_'.$container.'_working" style="display: none;">';
        $html .= '<img src="'.JUri::base(true).'/components/com_sef/assets/images/ajax-loader-small.gif" border="0" alt="Working" />';
        $html .= '</div>';
        
        return $html;
    }

	function showStatus($type)
	{
	    static $status;
	    if( !isset($status) ) {
	        $status = SEFTools::getSEOStatus();
	    }
	    
        $html = '<div id="sef_status_'.$type.'">';
        $html .= '<div id="sef_status_'.$type.'_1"'.($status[$type] ? '' : ' style="display: none"').'>';
        $html .= '<span style="font-weight: bold; color: green;">'.JText::_('COM_SEF_ENABLED').'</span>';
        $html .= ' <input type="button" class="btn btn-danger btn-small" onclick="JoomSEF.ajaxItemTask(\'status\', \''.$type.'\', \'disableStatus\');" value="'.JText::_('COM_SEF_DISABLE').'" />';
        $html .= '</div>';
        $html .= '<div id="sef_status_'.$type.'_0"'.(!$status[$type] ? '' : ' style="display: none"').'>';
        $html .= '<span style="font-weight: bold; color: red;">'.JText::_('COM_SEF_DISABLED').'</span>';
        $html .= ' <input type="button" class="btn btn-success btn-small" onclick="JoomSEF.ajaxItemTask(\'status\', \''.$type.'\', \'enableStatus\');" value="'.JText::_('COM_SEF_ENABLE').'" />';
        $html .= '</div>';
        $html .= $this->getAjaxWorking('status_'.$type);
        $html .= '</div>';
        
        echo $html;
	}
}