<?php
/**
 * SEF component for Joomla!
 * 
 * @package   JoomSEF
 * @version   3.12.2
 * @author    ARTIO s.r.o., http://www.artio.net
 * @copyright Copyright (C) 2015 ARTIO s.r.o. 
 * @license   GNU/GPLv3 http://www.artio.net/license/gnu-general-public-license
 */

// XML definition file
$this->_addFileOp('/administrator/components/com_sef/sef.xml', 'upgrade', '/sef.xml');
$this->_addFileOp('/administrator/components/com_sef/license.txt', 'upgrade', '/license.txt');
$this->_addFileOp('/administrator/components/com_sef/changelog.txt', 'upgrade', '/admin/changelog.txt');

// Admin files
$this->_addFileOp('/administrator/components/com_sef/install.sef.php', 'upgrade', '/admin/install.sef.php');
$this->_addFileOp('/administrator/components/com_sef/uninstall.sef.php', 'upgrade', '/admin/uninstall.sef.php');
$this->_addFileOp('/administrator/components/com_sef/controller.php', 'upgrade', '/admin/controller.php');
$this->_addFileOp('/administrator/components/com_sef/views/sef/tmpl/default.php', 'upgrade', '/admin/views/sef/tmpl/default.php');
$this->_addFileOp('/administrator/components/com_sef/views/sefurls/tmpl/default.php', 'upgrade', '/admin/views/sefurls/tmpl/default.php');
$this->_addFileOp('/administrator/components/com_sef/assets/images/icon-16-apply.png', 'upgrade', '/admin/assets/images/icon-16-apply.png');
$this->_addFileOp('/administrator/components/com_sef/assets/images/icon-16-cancel.png', 'upgrade', '/admin/assets/images/icon-16-cancel.png');
$this->_addFileOp('/administrator/components/com_sef/assets/images/icon-16-edit2.png', 'upgrade', '/admin/assets/images/icon-16-edit2.png');
$this->_addFileOp('/administrator/components/com_sef/assets/js/crawler.js', 'upgrade', '/admin/assets/js/crawler.js');
$this->_addFileOp('/administrator/components/com_sef/assets/js/joomsef.js', 'upgrade', '/admin/assets/js/joomsef.js');
$this->_addFileOp('/administrator/components/com_sef/models/sefurl.php', 'upgrade', '/admin/models/sefurl.php');
$this->_addFileOp('/administrator/components/com_sef/controllers/cron.php', 'upgrade', '/admin/controllers/cron.php');
$this->_addFileOp('/administrator/components/com_sef/controllers/sefurls.php', 'upgrade', '/admin/controllers/sefurls.php');
$this->_addFileOp('/administrator/components/com_sef/views/sef/view.html.php', 'upgrade', '/admin/views/sef/view.html.php');
$this->_addFileOp('/administrator/components/com_sef/views/sefurls/view.html.php', 'upgrade', '/admin/views/sefurls/view.html.php');
$this->_addFileOp('/administrator/components/com_sef/view.php', 'upgrade', '/admin/view.php');

// Language files
// We need to check every directory for existence and copy only the languages in use
if( JFolder::exists(JPATH_ROOT.'/administrator/language/en-GB') ) {
    $this->_addFileOp('/administrator/language/en-GB/en-GB.com_sef.ini', 'upgrade', '/language/admin/en-GB.com_sef.ini');
}
if( JFolder::exists(JPATH_ROOT.'/administrator/language/cs-CZ') ) {
    $this->_addFileOp('/administrator/language/cs-CZ/cs-CZ.com_sef.ini', 'upgrade', '/language/admin/cs-CZ.com_sef.ini');
}

// Frontend files
$this->_addFileOp('/components/com_sef/joomsef.php', 'upgrade', '/site/joomsef.php');

// Extensions

// Plugins
$this->_addFileOp('/plugins/system/joomsef.php', 'upgrade', '/admin/plugin/joomsef.php');
$this->_addFileOp('/plugins/system/joomsef.xml', 'upgrade', '/admin/plugin/joomsef.xml');
$this->_addFileOp('/plugins/system/joomsefgoogle.php', 'upgrade', '/admin/plugin/joomsefgoogle.php');
$this->_addFileOp('/plugins/system/joomsefgoogle.xml', 'upgrade', '/admin/plugin/joomsefgoogle.xml');

// Content elements (if JoomFish is present)

// UPDATE THE DATABASE INFORMATION
$this->_addSQL("ALTER TABLE `#__sefurls` ADD KEY `idx_updates` (`locked`, `flag`)");
$this->_addSQL("ALTER TABLE `#__sefurls` ENGINE=InnoDB");
