<?php
/**
 * SEF component for Joomla! 1.5
 *
 * @author      ARTIO s.r.o.
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 * @version     3.1.0
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.installer.installer');
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class com_sefInstallerScript
{
    public function postflight($action, $installer)
    {
        if ($action == 'install') {
            $db =& JFactory::getDBO();
            
            // Get component ID
            $db->setQuery("SELECT `extension_id` FROM `#__extensions` WHERE `type` = 'component' AND `element` = 'com_sef'");
            $id = $db->loadResult();
            if (!$id) {
                return;
            }
            
            // Fix separator links
            $db->setQuery("UPDATE `#__menu` SET `link` = '#' WHERE `type` = 'component' AND `img` = 'separator' AND `component_id` = '{$id}'");
            $db->query();
        }
    }
    
	public function install($installer)
	{
	    $db =& JFactory::getDBO();
	
	    // Set the wrapper extension default parameters
	    $db->setQuery("SELECT `id` FROM `#__sefexts` WHERE `file` = 'com_wrapper.xml' LIMIT 1");
	    $id = $db->loadResult();
	    if (empty($id)) {
	        $opts = '{"ignoreSource":"0","itemid":"1","overrideId":""}';
	        $db->setQuery("INSERT INTO `#__sefexts` (`file`, `params`) VALUES ('com_wrapper.xml', " . $db->quote($opts) . ")");
	        $res = $db->query();
	        if (!$res) {
	            JError::raiseWarning(100, JText::_('COM_SEF_ERROR_WRAPPER_DEFAULTS'));
	        }
	    }
	
        // Set the content extension default parameters
        $defaultFilters = '+^[0-9]*$=limit,limitstart,start,month,year\n+^[a-zA-Z]+$=task,type,view\n+^[0-9]+(:[a-zA-Z0-9._-]+)?$=catid,id,sectionid';
        $defaultVars = '{"acceptVars":"view; id; catid; sectionid; type; year; month; filter; limit; limitstart; start; task"}';
        $db->setQuery("SELECT `id` FROM `#__sefexts` WHERE `file` = 'com_content.xml' LIMIT 1");
        $id = $db->loadResult();
        if (empty($id)) {
            $db->setQuery("INSERT INTO `#__sefexts` (`file`, `filters`, `params`) VALUES ('com_content.xml', '{$defaultFilters}', '{$defaultVars}')");
            $res = $db->query();
            if (!$res) {
                JError::raiseWarning(100, JText::_('COM_SEF_ERROR_CONTENT_VARS_DEFAULTS'));
            }
        }
        
        // Create the default 404 page if it doesn't already exist
        $db->setQuery("SELECT `id` FROM `#__content` WHERE `title` = '404'");
        $id = $db->loadResult();
        if (empty($id)) {
            $introtext = "<h1>404: Not Found</h1>\n<h2>Sorry, but the content you requested could not be found</h2>";
            $sql = 'INSERT INTO #__content (title, alias, introtext, `fulltext`, state, mask, catid, created, created_by, created_by_alias, modified, modified_by, publish_up, publish_down, images, urls, attribs, version, parentid, ordering, metakey, metadesc, access, hits) '.
            'VALUES ("404", "404", "'.$introtext.'", "", "1", "0", "0", "2001-01-01 00:00:00", "42", "", "0000-00-00 00:00:00", "0", "2001-01-01 00:00:00", "0000-00-00 00:00:00", "", "", "menu_image=-1\nitem_title=0\npageclass_sfx=\nback_button=\nrating=0\nauthor=0\ncreatedate=0\nmodifydate=0\npdf=0\nprint=0\nemail=0", "1", "0", "0", "", "", "1", "0");';
            $db->setQuery($sql);
            $res = $db->query();
            if (!$res) {
                JError::raiseWarning(100, JText::_('COM_SEF_ERROR_DEFAULT_404_PAGE'));
            }
        }

	    // Install JoomSEF plugin
	    $src = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_sef'.DS.'plugin'.DS;
	    $dest = JPATH_ROOT.DS.'plugins'.DS.'system'.DS.'joomsef'.DS;
	
	    $res = JFolder::create($dest);
	    $res = $res && JFile::copy($src.'joomsef.php', $dest.'joomsef.php');
	    $res = $res && JFile::copy($src.'joomsef.xml', $dest.'joomsef.xml');
	
        // Get the lowest ordering
        $db->setQuery("SELECT MIN(`ordering`) FROM `#__extensions` WHERE `type` = 'plugin' AND `folder` = 'system'");
        $min = $db->loadResult();
        $min -= 10;
    
	    $db->setQuery("INSERT INTO `#__extensions`
		               (name, type, element, folder, client_id, enabled, access, protected, manifest_cache, params, custom_data, system_data, checked_out, checked_out_time, ordering, state)
		               VALUES ('System - ARTIO JoomSEF', 'plugin', 'joomsef', 'system', 0, 1, 1, 0, '', '{}', '', '', 0, '0000-00-00 00:00:00', '{$min}', 0)");
	    $res = $res && $db->query();
	
	    if (!$res) {
	        JError::raiseWarning(100, JText::_('COM_SEF_WARNING_PLUGIN_NOT_INSTALLED').': '.$src);
	    } else {
	        JFolder::delete($src);
	    }
	
	    // Install content elements if JoomFish is present
	    $file = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_joomfish'.DS.'joomfish.php';
	
	    if( JFile::exists($file) ) {
	        $src = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_sef'.DS.'contentelements';
	        $dest = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_joomfish'.DS.'contentelements';
	
	        $files = JFolder::files($src);
	
	        $res = true;
	        foreach($files as $file) {
	            $res = $res && JFile::copy($src.DS.$file, $dest.DS.$file);
	        }
	
	        if( !$res ) {
	            JError::raiseWarning(100, JText::_('COM_SEF_ERROR_CONTENT_ELEMENTS').': '.$src);
	        } else {
	            JFolder::delete($src);
	        }
	    }
	    
	    // Install the extension installer adapter if possible
	    $adapterSrc = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_sef'.DS.'adapters'.DS.'sef_ext.php';
	    $adapterDest = JPATH_LIBRARIES.DS.'joomla'.DS.'installer'.DS.'adapters'.DS.'sef_ext.php';
	    $adapterInstalled = false;
	    if( is_writable(dirname($adapterDest)) ) {
	        if( @copy($adapterSrc, $adapterDest) ) {
	            $adapterInstalled = true;
	        }
	    }
	
	    // Check former AceSEF and sh404SEF installations
	    $formerSEF = false;
	
	    $query = "SELECT * FROM `#__acesef_urls` LIMIT 1";
	    $db->setQuery($query);
	    $row = $db->loadObject();
	    if( !is_null($row) ) {
	        $formerSEF = true;
	    }
	
	    if( !$formerSEF ) {
	        $query = "SELECT * FROM `#__redirection` LIMIT 1";
	        $db->setQuery($query);
	        $row = $db->loadObject();
	        if( !is_null($row) ) {
	            if( isset($row->oldurl) && isset($row->newurl) ) {
	                $formerSEF = true;
	            }
	        }
	    }
	
	    ob_start();
	
	    echo '<div class="quote" style="text-align: center;">';
	    echo '<h1>ARTIO JoomSEF installed succesfully!</h1>';
	    
	    if( $formerSEF ) {
	        echo '<h3>JoomSEF detected former installation of another SEF component. You can automatically import SEF URLs from it <a href="index.php?option=com_sef&amp;controller=sefurls&amp;task=showimport">here</a>.</h3><br />';
	    }
	    
	    if( !$adapterInstalled ) {
	        ?>
	        <p class="message">
	        The JoomSEF extension installer adapter could not be installed, because the destination directory is not writable.
	        If you want to be able to install JoomSEF extensions directly from the Joomla Installer, please manually copy this file:
	        <br />
	        <?php echo str_replace(JPATH_ROOT, '', $adapterSrc); ?>
	        <br />
	        to this directory:
	        <br />
	        <?php echo str_replace(JPATH_ROOT, '', dirname($adapterDest)); ?>
	        </p>
	        <?php
	    }
	    
	    // Check the host and set handling to redirect to www if needed
	    $uri =& JURI::getInstance();
	    $host = $uri->getHost();
	    if (substr($host, 0, 4) == 'www.') {
	        // Import the SEF config file
	        include(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_sef'.DS.'classes'.DS.'config.php');
	        if (class_exists('SEFConfig')) {
	            $sefConfig =& SEFConfig::getConfig();
	            $sefConfig->wwwHandling = _COM_SEF_WWW_USE_WWW;
	            $sefConfig->saveConfig();
	        }
	    }
	    
	    echo '<h3>You must first edit the configuration, enable it and save before it will become active.</h3>';
	    $readdocs = '<p class="message">Please read the <a href="index.php?option=com_sef&amp;controller=info&amp;task=doc">documentation</a>.<br/>There is still extra configuration that you need to complete for ';
	    if (!(strpos($_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS') === false)) {
	        echo $readdocs.'IIS.</p>';
	    }
	    else {
	        // Get the correct rewrite base
	        $base = JURI::root(true);
	        if( $base == '' ) {
	            $base = '/';
	        }
	
	        // Create htaccess content
            $htaccess = '
DirectoryIndex index.php
RewriteEngine On
RewriteBase ' . $base . '

########## Begin - Rewrite rules to block out some common exploits
## If you experience problems on your site block out the operations listed below
## This attempts to block the most common type of exploit `attempts` to Joomla!
#
## Deny access to extension xml files (uncomment out to activate)
#<Files ~ "\.xml$">
#Order allow,deny
#Deny from all
#Satisfy all
#</Files>
## End of deny access to extension xml files
# Block out any script trying to set a mosConfig value through the URL
RewriteCond %{QUERY_STRING} mosConfig_[a-zA-Z_]{1,21}(=|\%3D) [OR]
# Block out any script trying to base64_encode crap to send via URL
RewriteCond %{QUERY_STRING} base64_encode.*\(.*\) [OR]
# Block out any script that includes a <script> tag in URL
RewriteCond %{QUERY_STRING} (\<|%3C).*script.*(\>|%3E) [NC,OR]
# Block out any script trying to set a PHP GLOBALS variable via URL
RewriteCond %{QUERY_STRING} GLOBALS(=|\[|\%[0-9A-Z]{0,2}) [OR]
# Block out any script trying to modify a _REQUEST variable via URL
RewriteCond %{QUERY_STRING} _REQUEST(=|\[|\%[0-9A-Z]{0,2})
# Send all blocked request to homepage with 403 Forbidden error!
RewriteRule ^(.*)$ index.php [F,L]
#
########## End - Rewrite rules to block out some common exploits

RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteCond %{REQUEST_URI} !^/index.php
RewriteCond %{REQUEST_URI} (/|\.php|\.html|\.htm|\.feed|\.pdf|\.raw|/[^.]*)$  [NC]
RewriteRule (.*) index.php
RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization},L]
';
	        
	        //if (substr(PHP_OS, 0, 3) == 'WIN') {
	        //	echo '<p class="error">Found apache on windows, .htaccess is an illegal filename for this system.<br/>You must complete the rest of the configuration manually.</p>';
	        //	echo $readdocs."the apache .htaccess file.</p>";
	        //}
	        //else{
	        echo '<p style="text-align: center;">Checking for .htaccess in Joomla! root...<br />';
	        $file = JPATH_ROOT.DS.'.htaccess';
	        if( !JFile::exists($file) ) {
	            echo 'not found.</p>';
	
	            if( !JFile::write($file, $htaccess) ) {
	                echo '<p style="text-align: center;" class="error">Unable to create .htaccess file in your Joomla! root. Please create this file yourself and add the following lines:<br/><pre>'.htmlspecialchars(nl2br($htaccess)).'</pre>';
	            }
	            else{
	                echo "Successfully created .htaccess file in your Joomla! root with the following content:<br/><pre>".htmlspecialchars($htaccess)."</pre>";
	            }
	            echo "Please check that the RewriteBase directive path is set correctly and matches your configuration.";
	        }
	        else {
	            echo '<span class="error">Found existing .htaccess in Joomla! root.</span></p>';
	            echo $readdocs.'the apache .htaccess file</p>';
	        }
	        echo '</div>';
	    }
	    
	    ?>
        <h2 style="color: #A1B754">Start using JoomSEF</h2>
        <div id="cpanel" class="icons">
            <div class="icon">
                <a href="index.php?option=com_sef" title="The main JoomSEF administration area">
                <img src="components/com_sef/assets/images/icon-48-artio.png" alt="" width="48" height="48" border="0"/>
                <span><?php echo JText::_('COM_SEF_CONTROL_PANEL'); ?></span>
                </a>
            </div>
            <div class="icon">
                <a href="index.php?option=com_sef&amp;controller=info&amp;task=doc" title="View ARTIO JoomSEF Documentation">
                    <img src="components/com_sef/assets/images/icon-48-docs.png" alt="" width="48" height="48" align="middle" border="0"/>
                    <span><?php echo JText::_('COM_SEF_DOCUMENTATION'); ?></span>
                </a>
            </div>
            <div class="icon">
                <a href="index.php?option=com_sef&amp;controller=info&amp;task=changelog" title="View ARTIO JoomSEF Changelog">
                    <img src="components/com_sef/assets/images/icon-48-info.png" alt="" width="48" height="48" align="middle" border="0"/>
                    <span><?php echo JText::_('COM_SEF_CHANGELOG'); ?></span>
                </a>
            </div>
            <div class="icon">
                <a href="index.php?option=com_sef&amp;controller=info&amp;task=help" title="Need help with ARTIO JoomSEF?">
                    <img src="components/com_sef/assets/images/icon-48-help.png" alt="" width="48" height="48" align="middle" border="0"/>
                    <span><?php echo JText::_('COM_SEF_SUPPORT'); ?></span>
                </a>
            </div>
        </div>
        
        <?php
    
	    $output = ob_get_contents();
	    ob_end_clean();
	
	    echo $output;
	    
		return true;
	}
	
	public function uninstall($installer)
	{
	    // uninstall JoomSEF plugin
	    $path = JPATH_ROOT.DS.'plugins'.DS.'system'.DS.'joomsef';
	    
	    $res = JFolder::delete($path);
	    
	    $db =& JFactory::getDBO();
	    $db->setQuery("DELETE FROM `#__extensions` WHERE `type` = 'plugin' AND `folder` = 'system' AND `element` = 'joomsef' LIMIT 1");
	    $res = $res && $db->query();
	    
	    if (!$res) {
	        JError::raiseWarning(100, JText::_('COM_SEF_WARNING_PLUGIN_NOT_UNINSTALLED'));
	    }
	    
	    // uninstall JoomSEF extension installer adapter
	    $path = JPATH_LIBRARIES.DS.'joomla'.DS.'installer'.DS.'adapters'.DS.'sef_ext.php';
	    if( JFile::exists($path) ) {
	        JFile::delete($path);
	    }
	
	    echo '<h3>ARTIO JoomSEF succesfully uninstalled.</h3>';
	    
		return true;
	}
}
?>