<?php
/**
 * Content SEF extension for Joomla!
 *
 * @author      $Author: David Jozefov $
 * @copyright   ARTIO s.r.o., http://www.artio.cz
 * @package     JoomSEF
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access.');

define( '_COM_SEF_PRIORITY_CONTENT_ARTICLE_ITEMID',         15 );
define( '_COM_SEF_PRIORITY_CONTENT_ARTICLE',                20 );
define( '_COM_SEF_PRIORITY_CONTENT_SECTIONLIST_ITEMID',     25 );
define( '_COM_SEF_PRIORITY_CONTENT_SECTIONLIST',            30 );
define( '_COM_SEF_PRIORITY_CONTENT_CATEGORYLIST_ITEMID',    35 );
define( '_COM_SEF_PRIORITY_CONTENT_CATEGORYLIST',           40 );
define( '_COM_SEF_PRIORITY_CONTENT_SECTIONBLOG_ITEMID',     45 );
define( '_COM_SEF_PRIORITY_CONTENT_SECTIONBLOG',            50 );
define( '_COM_SEF_PRIORITY_CONTENT_CATEGORYBLOG_ITEMID',    55 );
define( '_COM_SEF_PRIORITY_CONTENT_CATEGORYBLOG',           60 );

class SefExt_com_content extends SefExt
{
    public function getNonSefVars(&$uri)
    {
        $this->_createNonSefVars($uri);

        return array($this->nonSefVars, $this->ignoreVars);
    }

    protected function _createNonSefVars(&$uri)
    {
        if (!isset($this->nonSefVars) && !isset($this->ignoreVars)) {
            $this->nonSefVars = array();
        	$this->ignoreVars = array();
        }

        $this->params =& SEFTools::GetExtParams('com_content');
        $sefConfig =& SEFConfig::getConfig();

        if ($sefConfig->appendNonSef && ($this->params->get('pagination', '0') != '0')) {

            if (!is_null($uri->getVar('limit'))) {
                $this->nonSefVars['limit'] = $uri->getVar('limit');
            }
            if (!is_null($uri->getVar('limitstart'))) {
                $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
            }
        }
        if (!is_null($uri->getVar('filter'))) {
            $this->nonSefVars['filter'] = $uri->getVar('filter');
        }
    }

    protected function _getCategoryPath($id)
    {
        $db =& JFactory::getDBO();
        $sefConfig =& SEFConfig::getConfig();
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';

    	$field = 'title';
        if (SEFTools::UseAlias($this->params, 'category_alias')) {
            $field = 'alias';
        }

        $addId = (bool) $this->params->get('categoryid', '0');

        $path = array();
        $id = intval($id);
        $db->setQuery("SELECT `lft`, `rgt` FROM `#__categories` WHERE `id` = '{$id}'");
        $idx = $db->loadObject();
        if (!$idx) {
        	return false;
        }

        $db->setQuery("SELECT `title`, `alias`, `description`, `metakey`, `metadesc`, `parent_id`{$jfTranslate} FROM `#__categories` WHERE `lft` <= '{$idx->lft}' AND `rgt` >= '{$idx->rgt}' ORDER BY `lft` DESC");
        $cats = $db->loadObjectList();

        $result = null;

        // We don't want the root category added
        foreach ($cats as $cat) {
            if (is_null($result)) {
                $result = new stdClass();
                $result->cat_desc = $cat->description;
                $result->metakey = $cat->metakey;
                $result->metadesc = $cat->metadesc;
            }

        	$name = ($addId ? $id.'-'.$cat->$field : $cat->$field);
        	array_unshift($path, $name);
        	if (empty($this->cat_desc)) {
        		$this->cat_desc = $cat->description;
        	}
        	$id = $cat->parent_id;

        	if ($id <= 1) {
        		break;
        	}
        }

        if (is_null($result)) {
            $result = new stdClass();
        }
        $result->path = $path;

        return $result;
    }

    protected function _getArticle($id)
    {
        $db =& JFactory::getDBO();
        $sefConfig =& SEFConfig::getConfig();
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';

    	$field = 'title';
        if (SEFTools::UseAlias($this->params, 'title_alias')) {
            $field = 'alias';
        }

        $addId = (bool) $this->params->get('articleid', '0');

        $id = intval($id);
        $db->setQuery("SELECT `title`, `alias`, `introtext`, `fulltext`, `metakey`, `metadesc`, `catid`{$jfTranslate} FROM `#__content` WHERE `id` = '{$id}'");
        $row = $db->loadObject();
        if (!$row) {
        	return false;
        }

        $this->item_desc = $row->introtext;
        $name = $addId ? $id.'-'.$row->$field : $row->$field;

        $article = new stdClass();
        $article->title = $name;
        $article->catid = $row->catid;
        $article->item_desc = $row->introtext;
        $article->fulltext = $row->fulltext;
        $article->metakey = $row->metakey;
        $article->metadesc = $row->metadesc;

        return $article;
    }

    /**
     * Get SEF titles of content items.
     *
     * @param  string $task
     * @param  int $id
     * @return string
     */
    protected function _getContentTitles($view, $id)
    {
        $db =& JFactory::getDBO();
        $sefConfig =& SEFConfig::getConfig();

        $title = array();

        // JF translate extension.
        $jfTranslate = $sefConfig->translateNames ? ', `id`' : '';

        // Fields
        $title_field = 'title';
        if( SEFTools::UseAlias($this->params, 'title_alias') ) {
            $title_field = 'alias';
        }

        $categories = $this->params->get('categories', '2');
        $addCatToTitle = $this->params->get('meta_titlecat', '0');

        $descField = null;
        $metakeySource = null;

        switch ($view) {
            case 'categories':
            case 'category':
            	if (isset($id)) {
                	$cats = $this->_getCategoryPath($id);
                	if ($cats !== false) {
                	    $path = $cats->path;
	                	if ($categories == '2') {
	                		$title = $path;
	                	}
	                	else {
	                		$title[] = $path[count($path) - 1];
	                	}
                	}
                    $row = $cats;
                }
                if ($view == 'categories') {
                	$title[] = JText::_('COM_SEF_CATEGORIES');
                }
                $descField = 'cat_desc';
                $metakeySource = 'cat_desc';
                break;
            case 'article':
                if (isset($id)) {
                	$article = $this->_getArticle($id);
                	if ($article !== false) {
                		if ($categories != '0') {
                			$cats = $this->_getCategoryPath($article->catid);
		                	if ($cats !== false) {
		                	    $path = $cats->path;
			                	if ($categories == '2') {
			                		$title = $path;
			                	}
			                	else {
			                		$title[] = $path[count($path) - 1];
			                	}
		                	}
                		}
                		$title[] = $article->title;
                	}
                    $descField = 'item_desc';
                    $metakeySource = 'fulltext';
                    $row = $article;
                }
                break;
        }

        if (isset($row))
        {
            if (isset($row->$descField)) $this->metadesc = $row->$descField;
            if (isset($row->$metakeySource))  $this->metakeySource = $row->$metakeySource;
            if (isset($row->metakey))  $this->origmetakey  = $row->metakey;
            if (isset($row->metadesc)) $this->origmetadesc = $row->metadesc;
        }

        return $title;
    }

    public function beforeCreate(&$uri)
    {
        $db =& JFactory::getDBO();

        $params = SEFTools::GetExtParams('com_content');

        // Compatibility mode
        $comp = $params->get('compatibility', '0');
        // Change task=view to view=article for old urls
        if( !is_null($uri->getVar('task')) && ($uri->getVar('task') == 'view') ) {
            if( $comp == '0' ) {
                $uri->delVar('task');
            }
            $uri->setVar('view', 'article');
        }

        // Add the task=view in compatibility mode
        if ($comp != '0') {
            if (is_null($uri->getVar('task')) && !is_null($uri->getVar('view')) && ($uri->getVar('view') == 'article')) {
                $uri->setVar('task', 'view');
            }
        }

        // remove the limitstart and limit variables if they point to the first page
        if (!is_null($uri->getVar('limitstart')) && ($uri->getVar('limitstart') == '0')) {
            $uri->delVar('limitstart');
            $uri->delVar('limit');
        }

        // Try to guess the correct Itemid if set to
        if ($params->get('guessId', '0') != '0') {
            if (!is_null($uri->getVar('Itemid')) && !is_null($uri->getVar('id'))) {
                $mainframe =& JFactory::getApplication();
                $i = $mainframe->getItemid($uri->getVar('id'));
                $uri->setVar('Itemid', $i);
            }
        }

        // Remove the part after ':' from variables
        if (!is_null($uri->getVar('id')))    SEFTools::fixVariable($uri, 'id');
        if (!is_null($uri->getVar('catid'))) SEFTools::fixVariable($uri, 'catid');

        // If catid not given, try to find it
        $catid = $uri->getVar('catid');
        if (!is_null($uri->getVar('view')) && ($uri->getVar('view') == 'article') && !is_null($uri->getVar('id')) && empty($catid)) {
            $id = $uri->getVar('id');
            $query = "SELECT `catid` FROM `#__content` WHERE `id` = '{$id}'";
            $db->setQuery($query);
            $catid = $db->loadResult();

            if (!empty($catid)) {
                $uri->setVar('catid', $catid);
            }
        }

        // add the view variable if it's not set
        if (is_null($uri->getVar('view'))) {
            $uri->setVar('view', 'categories');
        }

        // remove empty id in categories list
        if ($uri->getVar('view') == 'categories' && ! (int) $uri->getVar('id'))
        	$uri->delVar('id');

        return;
    }

    protected function GoogleNews($title, $id)
    {
        $db =& JFactory::getDBO();

        $num = '';
        $add = $this->params->get('googlenewsnum', '0');

        if ($add == '1' || $add == '3') {
            // Article ID
            $digits = trim($this->params->get('digits', '3'));
            if (!is_numeric($digits)) {
                $digits = '3';
            }

            $num1 = sprintf('%0'.$digits.'d', $id);
        }
        if ($add == '2' || $add == '3') {
            // Publish date
            $query = "SELECT `publish_up` FROM `#__content` WHERE `id` = '$id'";
            $db->setQuery($query);
            $time = $db->loadResult();

            $time = strtotime($time);

            $date = $this->params->get('dateformat', 'ddmm');

            $search = array('dd', 'd', 'mm', 'm', 'yyyy', 'yy');
            $replace = array(date('d', $time),
            date('j', $time),
            date('m', $time),
            date('n', $time),
            date('Y', $time),
            date('y', $time) );
            $num2 = str_replace($search, $replace, $date);
        }

        if ($add == '1') {
            $num = $num1;
        }
        else if ($add == '2') {
            $num = $num2;
        }
        else if ($add == '3') {
            $sep = $this->params->get('iddatesep', '');
            if ($this->params->get('iddateorder', '0') == '0') {
                $num = $num2.$sep.$num1;
            }
            else {
                $num = $num1.$sep.$num2;
            }
        }

        if (!empty($num)) {
            $onlyNum = ($this->params->get('title_alias', 'global') == 'googlenews');

            if ($onlyNum) {
                return $num;
            }

            $sefConfig =& SEFConfig::getConfig();
            $sep = $sefConfig->replacement;

            $where = $this->params->get('numberpos', '1');

            if( $where == '1' ) {
                $title = $title.$sep.$num;
            } else {
                $title = $num.$sep.$title;
            }
        }

        return $title;
    }

    public function create(&$uri)
    {
    	$this->metadesc = null;
    	$this->cat_desc = null;
    	$this->item_desc = null;

        $sefConfig =& SEFConfig::getConfig();

        $this->params =& SEFTools::GetExtParams('com_content');

        $vars = $uri->getQuery(true);
        extract($vars);

        // Do not SEF URLs with exturl variable
        //if( !empty($exturl) )   return $string;

        // Do not SEF edit urls
        if (isset($task) && ($task == 'edit')) {
            return $uri;
        }

        // Set title.
        $title = array();

        switch (@$view) {
            case 'new':
            case 'edit': {
                /*
                $title[] = getMenuTitle($option, $task, $Itemid, $string);
                $title[] = 'new' . $sefConfig->suffix;
                */
                break;
            }
            case 'archive': {

            	$menuTitle = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
                $title[] = $menuTitle ? $menuTitle : JText::_('COM_SEF_ARCHIVE');

                if( !empty($year) ) {
                    $title[] = $year;
                }
                if( !empty($month) ) {
                    $title[] = $month;
                }

                break;
            }
            /*case 'featured':
            	if (!is_null($uri->getVar('limit'))) {
                    $this->nonSefVars['limit'] = $uri->getVar('limit');
            	}
                if (!is_null($uri->getVar('limitstart'))) {
                    $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
                }
            	break;*/
            /*
            case 'archivecategory':
            case 'archivesection': {
            if (eregi($task.".*id=".$id, $_SERVER['REQUEST_URI'])) break;
            }
            */
            default: {
                if (isset($format)) {
                    if ($format == 'pdf') {
                        // wrong ID
                        if (intval($id) == 0) return $uri;

                        // create PDF
                        $title = $this->_getContentTitles(!empty($view) ? $view : 'article', $id);
                        if (count($title) === 0) $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);

                        // Add Google News number if set to
                        if ((@$view == 'article') && ($this->params->get('googlenewsnum', '0') != '0')) {
                            $i = count($title) - 1;
                            $title[$i] = $this->GoogleNews($title[$i], $id);
                        }

                        $title[] = JText::_('COM_SEF_PDF');
                    } elseif ($format == 'feed') {
                        // Create feed
                        if (@$view != 'frontpage') {
                            // wrong ID
                            if (intval(@$id) == 0) return $uri;

                            $title = $this->_getContentTitles(!empty($view) ? $view : 'article', $id);

                            // Add Google News number if set to
                            if ((@$view == 'article') && ($this->params->get('googlenewsnum', '0') != '0')) {
                                $i = count($title) - 1;
                                $title[$i] = $this->GoogleNews($title[$i], $id);
                            }
                        }
                        if ((count($title) === 0) && empty($type)) {
                            $title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
                        }

                        if (!empty($type)) $title[] = $type;
                    }
                } else {
                    $title = $this->_getContentTitles(@$view, @$id);
                    if (count($title) === 0 && $view!='featured') {
                    	$title[] = JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid);
                    	print_r($title);
                    }

                    // Add Google News number if set to
                    if ((@$view == 'article') && ($this->params->get('googlenewsnum', '0') != '0')) {
                        $i = count($title) - 1;
                        $title[$i] = $this->GoogleNews($title[$i], $id);
                    }

                    // Since 1.6.x only links visibled after user login - no SEF
                    // URL like index.php?option=com_content&a_id=10&task=article.edit&view=categories
                    // or index.php?option=com_content&a_id=17&catid=700&id=17&task=article.edit&view=article
                    // or index.php?option=com_content&a_id=17&id=700&task=article.edit&view=category
                    // or index.php?option=com_content&a_id=8&task=article.edit&view=categories
                    // or index.php?option=com_content&a_id=9&id=694&layout=blog&task=article.edit&view=category
                    if (isset($a_id)) {
                    	$nonSefVars = array();
                    	foreach ($uri->getQuery(true) as $name => $value)
                    		if ($name != 'option' && $name != 'Itemid')
                    			$nonSefVars[$name] = $value;
                    	return JoomSEF::_sefGetLocation($uri, ($title = array(JoomSEF::_getMenuTitle(@$option, @$task, @$Itemid))), null, null, null, @$lang, $nonSefVars);
                    }

                    // Layout
                    $addLayout = $this->params->get('add_layout', '2');
                    if (isset($layout) && !empty($layout) && ($addLayout != '0')) {
                        if ($addLayout == '2') {
                            $defLayout = $this->params->get('def_layout', 'default');
                            if ($layout != $defLayout) {
                                $title[] = $layout;
                            }
                        }
                        else {
                            $title[] = $layout;
                        }
                    }

                    if (isset($limitstart) && (!$sefConfig->appendNonSef || ($this->params->get('pagination', '0') == '0'))) {
                        if (@$view == 'article' ) {
                            // Multipage article
                            $page = $limitstart + 1;
                        }
                        else if (@$view == 'archive') {
                            // in archive, do not SEF pagination
                            if (!is_null($uri->getVar('limit')))
                                $this->nonSefVars['limit'] = $uri->getVar('limit');
                            if (!is_null($uri->getVar('limitstart')))
                                $this->nonSefVars['limitstart'] = $uri->getVar('limitstart');
                            if (!is_null($uri->getVar('filter')))
                                $this->nonSefVars['filter'] = $uri->getVar('filter');
                        }
                        else {
                            // Is limit set?
                            if( !isset($limit) ) {
                                // Try to get limit from menu parameters
                                $menu =& JSite::getMenu();

                                if( !isset($Itemid) ) {
                                    // We need to find Itemid first
                                    $active =& $menu->getActive();
                                    $Itemid = $active->id;
                                }

                                $menuParams =& $menu->getParams($Itemid);
                                $leading = $menuParams->get('num_leading_articles', 1);
                                $intro   = $menuParams->get('num_intro_articles', 4);
                                $links=$menuParams->get('num_links',4);
                                $limit = $leading + $intro+$links;
                            }
                            $page = intval($limitstart / $limit)  + 1;
                        }

                        $pagetext = strval($page);
                        if (($cnfPageText = $sefConfig->getPageText())) {
                            $pagetext = str_replace('%s', $page, $cnfPageText);
                        }
                        $title[] = $pagetext;
                    }

                    // show all
                    if (isset($showall) && ($showall == 1)) {
                        $title[] = JText::_('COM_SEF_ALL_PAGES');
                    }

                    // print article
                    if (isset($print) && ($print == 1)) {
                        $title[] = JText::_('COM_SEF_PRINT') . (!empty($page) ? '-'.($page+1) : '');
                    }
                }
            }
        }

        $newUri = $uri;
        if (count($title) > 0 || $vars["view"]=='featured') {
            // Generate meta tags
            $metatags = $this->getMetaTags();
            if (isset($this->metatitle)) {
                $metatags['metatitle'] = $this->metatitle;
            }

            $this->_createNonSefVars($uri);

            $priority = $this->getPriority($uri);
            $newUri = JoomSEF::_sefGetLocation($uri, $title, null, null, null, @$lang, $this->nonSefVars, null, $metatags, $priority, true);

        }

        return $newUri;
    }

    public function getPriority(&$uri)
    {
        $itemid = $uri->getVar('Itemid');
        $view = $uri->getVar('view');
        $layout = $uri->getVar('layout');

        switch($view)
        {
            case 'article':
                if( is_null($itemid) ) {
                    return _COM_SEF_PRIORITY_CONTENT_ARTICLE;
                } else {
                    return _COM_SEF_PRIORITY_CONTENT_ARTICLE_ITEMID;
                }
                break;

            case 'section':
                if( $layout == 'blog' ) {
                    if( is_null($itemid) ) {
                        return _COM_SEF_PRIORITY_CONTENT_SECTIONBLOG;
                    } else {
                        return _COM_SEF_PRIORITY_CONTENT_SECTIONBLOG_ITEMID;
                    }
                } else {
                    if( is_null($itemid) ) {
                        return _COM_SEF_PRIORITY_CONTENT_SECTIONLIST;
                    } else {
                        return _COM_SEF_PRIORITY_CONTENT_SECTIONLIST_ITEMID;
                    }
                }
                break;

            case 'category':
                if( $layout == 'blog' ) {
                    if( is_null($itemid) ) {
                        return _COM_SEF_PRIORITY_CONTENT_CATEGORYBLOG;
                    } else {
                        return _COM_SEF_PRIORITY_CONTENT_CATEGORYBLOG_ITEMID;
                    }
                } else {
                    if( is_null($itemid) ) {
                        return _COM_SEF_PRIORITY_CONTENT_CATEGORYLIST;
                    } else {
                        return _COM_SEF_PRIORITY_CONTENT_CATEGORYLIST_ITEMID;
                    }
                }
                break;

            default:
                return null;
                break;
        }
    }
}
?>
